<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnElencoFormalitaList_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean di risposta che riporta le formalità trovate in conservatoria per persona fisica/giuridica
 * @subpackage Structs
 */
class ReturnElencoFormalitaList_Type extends Session_Type
{
    /**
     * The formalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna elenco delle formalità
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Sisteract\StructType\Formalita_Type[]
     */
    public $formalita;
    /**
     * Constructor method for ReturnElencoFormalitaList_Type
     * @uses ReturnElencoFormalitaList_Type::setFormalita()
     * @param \Sisteract\StructType\Formalita_Type[] $formalita
     */
    public function __construct(array $formalita = array())
    {
        $this
            ->setFormalita($formalita);
    }
    /**
     * Get formalita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sisteract\StructType\Formalita_Type[]|null
     */
    public function getFormalita()
    {
        return isset($this->formalita) ? $this->formalita : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFormalita method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFormalita method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFormalitaForArrayConstraintsFromSetFormalita(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnElencoFormalitaList_TypeFormalitaItem) {
            // validation for constraint: itemType
            if (!$returnElencoFormalitaList_TypeFormalitaItem instanceof \Sisteract\StructType\Formalita_Type) {
                $invalidValues[] = is_object($returnElencoFormalitaList_TypeFormalitaItem) ? get_class($returnElencoFormalitaList_TypeFormalitaItem) : sprintf('%s(%s)', gettype($returnElencoFormalitaList_TypeFormalitaItem), var_export($returnElencoFormalitaList_TypeFormalitaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The formalita property can only contain items of type \Sisteract\StructType\Formalita_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set formalita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\Formalita_Type[] $formalita
     * @return \Sisteract\StructType\ReturnElencoFormalitaList_Type
     */
    public function setFormalita(array $formalita = array())
    {
        // validation for constraint: array
        if ('' !== ($formalitaArrayErrorMessage = self::validateFormalitaForArrayConstraintsFromSetFormalita($formalita))) {
            throw new \InvalidArgumentException($formalitaArrayErrorMessage, __LINE__);
        }
        if (is_null($formalita) || (is_array($formalita) && empty($formalita))) {
            unset($this->formalita);
        } else {
            $this->formalita = $formalita;
        }
        return $this;
    }
    /**
     * Add item to formalita value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\Formalita_Type $item
     * @return \Sisteract\StructType\ReturnElencoFormalitaList_Type
     */
    public function addToFormalita(\Sisteract\StructType\Formalita_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sisteract\StructType\Formalita_Type) {
            throw new \InvalidArgumentException(sprintf('The formalita property can only contain items of type \Sisteract\StructType\Formalita_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->formalita[] = $item;
        return $this;
    }
}
