<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PosizioneImmobiliVisura_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Identificazione geografica di un immobile in visura
 * @subpackage Structs
 */
class PosizioneImmobiliVisura_Type extends AbstractStructBase
{
    /**
     * The comuniImmobiliConConservatoria
     * Meta information extracted from the WSDL
     * - documentation: Ritorna comuni degli immobili in visura con relativa informazione di conservatoria
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sisteract\StructType\ComuneImmobileConConservatoria_Type[]
     */
    public $comuniImmobiliConConservatoria;
    /**
     * The provincia
     * Meta information extracted from the WSDL
     * - documentation: Ritorna provincia dove si trovano gli immobili in visura
     * @var string
     */
    public $provincia;
    /**
     * Constructor method for PosizioneImmobiliVisura_Type
     * @uses PosizioneImmobiliVisura_Type::setComuniImmobiliConConservatoria()
     * @uses PosizioneImmobiliVisura_Type::setProvincia()
     * @param \Sisteract\StructType\ComuneImmobileConConservatoria_Type[] $comuniImmobiliConConservatoria
     * @param string $provincia
     */
    public function __construct(array $comuniImmobiliConConservatoria = array(), $provincia = null)
    {
        $this
            ->setComuniImmobiliConConservatoria($comuniImmobiliConConservatoria)
            ->setProvincia($provincia);
    }
    /**
     * Get comuniImmobiliConConservatoria value
     * @return \Sisteract\StructType\ComuneImmobileConConservatoria_Type[]|null
     */
    public function getComuniImmobiliConConservatoria()
    {
        return $this->comuniImmobiliConConservatoria;
    }
    /**
     * This method is responsible for validating the values passed to the setComuniImmobiliConConservatoria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComuniImmobiliConConservatoria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComuniImmobiliConConservatoriaForArrayConstraintsFromSetComuniImmobiliConConservatoria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $posizioneImmobiliVisura_TypeComuniImmobiliConConservatoriaItem) {
            // validation for constraint: itemType
            if (!$posizioneImmobiliVisura_TypeComuniImmobiliConConservatoriaItem instanceof \Sisteract\StructType\ComuneImmobileConConservatoria_Type) {
                $invalidValues[] = is_object($posizioneImmobiliVisura_TypeComuniImmobiliConConservatoriaItem) ? get_class($posizioneImmobiliVisura_TypeComuniImmobiliConConservatoriaItem) : sprintf('%s(%s)', gettype($posizioneImmobiliVisura_TypeComuniImmobiliConConservatoriaItem), var_export($posizioneImmobiliVisura_TypeComuniImmobiliConConservatoriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The comuniImmobiliConConservatoria property can only contain items of type \Sisteract\StructType\ComuneImmobileConConservatoria_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set comuniImmobiliConConservatoria value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\ComuneImmobileConConservatoria_Type[] $comuniImmobiliConConservatoria
     * @return \Sisteract\StructType\PosizioneImmobiliVisura_Type
     */
    public function setComuniImmobiliConConservatoria(array $comuniImmobiliConConservatoria = array())
    {
        // validation for constraint: array
        if ('' !== ($comuniImmobiliConConservatoriaArrayErrorMessage = self::validateComuniImmobiliConConservatoriaForArrayConstraintsFromSetComuniImmobiliConConservatoria($comuniImmobiliConConservatoria))) {
            throw new \InvalidArgumentException($comuniImmobiliConConservatoriaArrayErrorMessage, __LINE__);
        }
        $this->comuniImmobiliConConservatoria = $comuniImmobiliConConservatoria;
        return $this;
    }
    /**
     * Add item to comuniImmobiliConConservatoria value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\ComuneImmobileConConservatoria_Type $item
     * @return \Sisteract\StructType\PosizioneImmobiliVisura_Type
     */
    public function addToComuniImmobiliConConservatoria(\Sisteract\StructType\ComuneImmobileConConservatoria_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sisteract\StructType\ComuneImmobileConConservatoria_Type) {
            throw new \InvalidArgumentException(sprintf('The comuniImmobiliConConservatoria property can only contain items of type \Sisteract\StructType\ComuneImmobileConConservatoria_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->comuniImmobiliConConservatoria[] = $item;
        return $this;
    }
    /**
     * Get provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->provincia;
    }
    /**
     * Set provincia value
     * @param string $provincia
     * @return \Sisteract\StructType\PosizioneImmobiliVisura_Type
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        $this->provincia = $provincia;
        return $this;
    }
}
