<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRestrizioneFormalita_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Restrizione sulle formalità
 * @subpackage Structs
 */
class ParametriRestrizioneFormalita_Type extends AbstractStructBase
{
    /**
     * The annotazioni
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono includere annotazioni immobile
     * @var bool
     */
    public $annotazioni;
    /**
     * The annotazioniContro
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono includere annotazioni contro
     * @var bool
     */
    public $annotazioniContro;
    /**
     * The annotazioniFavore
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono includere annotazioni a favore
     * @var bool
     */
    public $annotazioniFavore;
    /**
     * The dataA
     * Meta information extracted from the WSDL
     * - documentation: Ritorna data di arrivo per estrazione
     * - nillable: true
     * @var string
     */
    public $dataA;
    /**
     * The dataDa
     * Meta information extracted from the WSDL
     * - documentation: Ritorna data di partenza per estrazione
     * - nillable: true
     * @var string
     */
    public $dataDa;
    /**
     * The escludiIpotecheNonRinnovateOCancellate
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono escludere ipoteche non rinnovate o cancellate
     * @var bool
     */
    public $escludiIpotecheNonRinnovateOCancellate;
    /**
     * The escludiTrascrizioniNonRinnovate
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono escludere trascrizioni non rinnovate
     * @var bool
     */
    public $escludiTrascrizioniNonRinnovate;
    /**
     * The iscrizioni
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono includere Iscrizioni immobile
     * @var bool
     */
    public $iscrizioni;
    /**
     * The iscrizioniContro
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono includere iscrizioni contro
     * @var bool
     */
    public $iscrizioniContro;
    /**
     * The iscrizioniFavore
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono includere iscrizioni a favore
     * @var bool
     */
    public $iscrizioniFavore;
    /**
     * The listaCodiciAttoConservatoria
     * Meta information extracted from the WSDL
     * - documentation: Ritorna lista di codici atto su cui restringere per la lista formalità
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $listaCodiciAttoConservatoria;
    /**
     * The specieRestrizioneConservatoria
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica restrizione sulla specie di atto nella lista formalità
     * - nillable: true
     * @var string
     */
    public $specieRestrizioneConservatoria;
    /**
     * The tipoIspezioneConservatoria
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica restrizione sul tipo di ispezione nella lista formalità
     * - nillable: true
     * @var string
     */
    public $tipoIspezioneConservatoria;
    /**
     * The trascrizioni
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono includere Trascrizioni immobile
     * @var bool
     */
    public $trascrizioni;
    /**
     * The trascrizioniContro
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono includere trascrizioni contro
     * @var bool
     */
    public $trascrizioniContro;
    /**
     * The trascrizioniFavore
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si vogliono includere trascrizioni a favore
     * @var bool
     */
    public $trascrizioniFavore;
    /**
     * Constructor method for ParametriRestrizioneFormalita_Type
     * @uses ParametriRestrizioneFormalita_Type::setAnnotazioni()
     * @uses ParametriRestrizioneFormalita_Type::setAnnotazioniContro()
     * @uses ParametriRestrizioneFormalita_Type::setAnnotazioniFavore()
     * @uses ParametriRestrizioneFormalita_Type::setDataA()
     * @uses ParametriRestrizioneFormalita_Type::setDataDa()
     * @uses ParametriRestrizioneFormalita_Type::setEscludiIpotecheNonRinnovateOCancellate()
     * @uses ParametriRestrizioneFormalita_Type::setEscludiTrascrizioniNonRinnovate()
     * @uses ParametriRestrizioneFormalita_Type::setIscrizioni()
     * @uses ParametriRestrizioneFormalita_Type::setIscrizioniContro()
     * @uses ParametriRestrizioneFormalita_Type::setIscrizioniFavore()
     * @uses ParametriRestrizioneFormalita_Type::setListaCodiciAttoConservatoria()
     * @uses ParametriRestrizioneFormalita_Type::setSpecieRestrizioneConservatoria()
     * @uses ParametriRestrizioneFormalita_Type::setTipoIspezioneConservatoria()
     * @uses ParametriRestrizioneFormalita_Type::setTrascrizioni()
     * @uses ParametriRestrizioneFormalita_Type::setTrascrizioniContro()
     * @uses ParametriRestrizioneFormalita_Type::setTrascrizioniFavore()
     * @param bool $annotazioni
     * @param bool $annotazioniContro
     * @param bool $annotazioniFavore
     * @param string $dataA
     * @param string $dataDa
     * @param bool $escludiIpotecheNonRinnovateOCancellate
     * @param bool $escludiTrascrizioniNonRinnovate
     * @param bool $iscrizioni
     * @param bool $iscrizioniContro
     * @param bool $iscrizioniFavore
     * @param string[] $listaCodiciAttoConservatoria
     * @param string $specieRestrizioneConservatoria
     * @param string $tipoIspezioneConservatoria
     * @param bool $trascrizioni
     * @param bool $trascrizioniContro
     * @param bool $trascrizioniFavore
     */
    public function __construct($annotazioni = null, $annotazioniContro = null, $annotazioniFavore = null, $dataA = null, $dataDa = null, $escludiIpotecheNonRinnovateOCancellate = null, $escludiTrascrizioniNonRinnovate = null, $iscrizioni = null, $iscrizioniContro = null, $iscrizioniFavore = null, array $listaCodiciAttoConservatoria = array(), $specieRestrizioneConservatoria = null, $tipoIspezioneConservatoria = null, $trascrizioni = null, $trascrizioniContro = null, $trascrizioniFavore = null)
    {
        $this
            ->setAnnotazioni($annotazioni)
            ->setAnnotazioniContro($annotazioniContro)
            ->setAnnotazioniFavore($annotazioniFavore)
            ->setDataA($dataA)
            ->setDataDa($dataDa)
            ->setEscludiIpotecheNonRinnovateOCancellate($escludiIpotecheNonRinnovateOCancellate)
            ->setEscludiTrascrizioniNonRinnovate($escludiTrascrizioniNonRinnovate)
            ->setIscrizioni($iscrizioni)
            ->setIscrizioniContro($iscrizioniContro)
            ->setIscrizioniFavore($iscrizioniFavore)
            ->setListaCodiciAttoConservatoria($listaCodiciAttoConservatoria)
            ->setSpecieRestrizioneConservatoria($specieRestrizioneConservatoria)
            ->setTipoIspezioneConservatoria($tipoIspezioneConservatoria)
            ->setTrascrizioni($trascrizioni)
            ->setTrascrizioniContro($trascrizioniContro)
            ->setTrascrizioniFavore($trascrizioniFavore);
    }
    /**
     * Get annotazioni value
     * @return bool|null
     */
    public function getAnnotazioni()
    {
        return $this->annotazioni;
    }
    /**
     * Set annotazioni value
     * @param bool $annotazioni
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setAnnotazioni($annotazioni = null)
    {
        // validation for constraint: boolean
        if (!is_null($annotazioni) && !is_bool($annotazioni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($annotazioni, true), gettype($annotazioni)), __LINE__);
        }
        $this->annotazioni = $annotazioni;
        return $this;
    }
    /**
     * Get annotazioniContro value
     * @return bool|null
     */
    public function getAnnotazioniContro()
    {
        return $this->annotazioniContro;
    }
    /**
     * Set annotazioniContro value
     * @param bool $annotazioniContro
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setAnnotazioniContro($annotazioniContro = null)
    {
        // validation for constraint: boolean
        if (!is_null($annotazioniContro) && !is_bool($annotazioniContro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($annotazioniContro, true), gettype($annotazioniContro)), __LINE__);
        }
        $this->annotazioniContro = $annotazioniContro;
        return $this;
    }
    /**
     * Get annotazioniFavore value
     * @return bool|null
     */
    public function getAnnotazioniFavore()
    {
        return $this->annotazioniFavore;
    }
    /**
     * Set annotazioniFavore value
     * @param bool $annotazioniFavore
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setAnnotazioniFavore($annotazioniFavore = null)
    {
        // validation for constraint: boolean
        if (!is_null($annotazioniFavore) && !is_bool($annotazioniFavore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($annotazioniFavore, true), gettype($annotazioniFavore)), __LINE__);
        }
        $this->annotazioniFavore = $annotazioniFavore;
        return $this;
    }
    /**
     * Get dataA value
     * @return string|null
     */
    public function getDataA()
    {
        return $this->dataA;
    }
    /**
     * Set dataA value
     * @param string $dataA
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setDataA($dataA = null)
    {
        // validation for constraint: string
        if (!is_null($dataA) && !is_string($dataA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataA, true), gettype($dataA)), __LINE__);
        }
        $this->dataA = $dataA;
        return $this;
    }
    /**
     * Get dataDa value
     * @return string|null
     */
    public function getDataDa()
    {
        return $this->dataDa;
    }
    /**
     * Set dataDa value
     * @param string $dataDa
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setDataDa($dataDa = null)
    {
        // validation for constraint: string
        if (!is_null($dataDa) && !is_string($dataDa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataDa, true), gettype($dataDa)), __LINE__);
        }
        $this->dataDa = $dataDa;
        return $this;
    }
    /**
     * Get escludiIpotecheNonRinnovateOCancellate value
     * @return bool|null
     */
    public function getEscludiIpotecheNonRinnovateOCancellate()
    {
        return $this->escludiIpotecheNonRinnovateOCancellate;
    }
    /**
     * Set escludiIpotecheNonRinnovateOCancellate value
     * @param bool $escludiIpotecheNonRinnovateOCancellate
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setEscludiIpotecheNonRinnovateOCancellate($escludiIpotecheNonRinnovateOCancellate = null)
    {
        // validation for constraint: boolean
        if (!is_null($escludiIpotecheNonRinnovateOCancellate) && !is_bool($escludiIpotecheNonRinnovateOCancellate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($escludiIpotecheNonRinnovateOCancellate, true), gettype($escludiIpotecheNonRinnovateOCancellate)), __LINE__);
        }
        $this->escludiIpotecheNonRinnovateOCancellate = $escludiIpotecheNonRinnovateOCancellate;
        return $this;
    }
    /**
     * Get escludiTrascrizioniNonRinnovate value
     * @return bool|null
     */
    public function getEscludiTrascrizioniNonRinnovate()
    {
        return $this->escludiTrascrizioniNonRinnovate;
    }
    /**
     * Set escludiTrascrizioniNonRinnovate value
     * @param bool $escludiTrascrizioniNonRinnovate
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setEscludiTrascrizioniNonRinnovate($escludiTrascrizioniNonRinnovate = null)
    {
        // validation for constraint: boolean
        if (!is_null($escludiTrascrizioniNonRinnovate) && !is_bool($escludiTrascrizioniNonRinnovate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($escludiTrascrizioniNonRinnovate, true), gettype($escludiTrascrizioniNonRinnovate)), __LINE__);
        }
        $this->escludiTrascrizioniNonRinnovate = $escludiTrascrizioniNonRinnovate;
        return $this;
    }
    /**
     * Get iscrizioni value
     * @return bool|null
     */
    public function getIscrizioni()
    {
        return $this->iscrizioni;
    }
    /**
     * Set iscrizioni value
     * @param bool $iscrizioni
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setIscrizioni($iscrizioni = null)
    {
        // validation for constraint: boolean
        if (!is_null($iscrizioni) && !is_bool($iscrizioni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iscrizioni, true), gettype($iscrizioni)), __LINE__);
        }
        $this->iscrizioni = $iscrizioni;
        return $this;
    }
    /**
     * Get iscrizioniContro value
     * @return bool|null
     */
    public function getIscrizioniContro()
    {
        return $this->iscrizioniContro;
    }
    /**
     * Set iscrizioniContro value
     * @param bool $iscrizioniContro
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setIscrizioniContro($iscrizioniContro = null)
    {
        // validation for constraint: boolean
        if (!is_null($iscrizioniContro) && !is_bool($iscrizioniContro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iscrizioniContro, true), gettype($iscrizioniContro)), __LINE__);
        }
        $this->iscrizioniContro = $iscrizioniContro;
        return $this;
    }
    /**
     * Get iscrizioniFavore value
     * @return bool|null
     */
    public function getIscrizioniFavore()
    {
        return $this->iscrizioniFavore;
    }
    /**
     * Set iscrizioniFavore value
     * @param bool $iscrizioniFavore
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setIscrizioniFavore($iscrizioniFavore = null)
    {
        // validation for constraint: boolean
        if (!is_null($iscrizioniFavore) && !is_bool($iscrizioniFavore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iscrizioniFavore, true), gettype($iscrizioniFavore)), __LINE__);
        }
        $this->iscrizioniFavore = $iscrizioniFavore;
        return $this;
    }
    /**
     * Get listaCodiciAttoConservatoria value
     * @return string[]|null
     */
    public function getListaCodiciAttoConservatoria()
    {
        return $this->listaCodiciAttoConservatoria;
    }
    /**
     * This method is responsible for validating the values passed to the setListaCodiciAttoConservatoria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListaCodiciAttoConservatoria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListaCodiciAttoConservatoriaForArrayConstraintsFromSetListaCodiciAttoConservatoria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parametriRestrizioneFormalita_TypeListaCodiciAttoConservatoriaItem) {
            // validation for constraint: enumeration
            if (!\Sisteract\EnumType\CodiceAttoConservatoria_Type::valueIsValid($parametriRestrizioneFormalita_TypeListaCodiciAttoConservatoriaItem)) {
                $invalidValues[] = is_object($parametriRestrizioneFormalita_TypeListaCodiciAttoConservatoriaItem) ? get_class($parametriRestrizioneFormalita_TypeListaCodiciAttoConservatoriaItem) : sprintf('%s(%s)', gettype($parametriRestrizioneFormalita_TypeListaCodiciAttoConservatoriaItem), var_export($parametriRestrizioneFormalita_TypeListaCodiciAttoConservatoriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\CodiceAttoConservatoria_Type', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \Sisteract\EnumType\CodiceAttoConservatoria_Type::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listaCodiciAttoConservatoria value
     * @uses \Sisteract\EnumType\CodiceAttoConservatoria_Type::valueIsValid()
     * @uses \Sisteract\EnumType\CodiceAttoConservatoria_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $listaCodiciAttoConservatoria
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setListaCodiciAttoConservatoria(array $listaCodiciAttoConservatoria = array())
    {
        // validation for constraint: array
        if ('' !== ($listaCodiciAttoConservatoriaArrayErrorMessage = self::validateListaCodiciAttoConservatoriaForArrayConstraintsFromSetListaCodiciAttoConservatoria($listaCodiciAttoConservatoria))) {
            throw new \InvalidArgumentException($listaCodiciAttoConservatoriaArrayErrorMessage, __LINE__);
        }
        $this->listaCodiciAttoConservatoria = $listaCodiciAttoConservatoria;
        return $this;
    }
    /**
     * Add item to listaCodiciAttoConservatoria value
     * @uses \Sisteract\EnumType\CodiceAttoConservatoria_Type::valueIsValid()
     * @uses \Sisteract\EnumType\CodiceAttoConservatoria_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function addToListaCodiciAttoConservatoria($item)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\CodiceAttoConservatoria_Type::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\CodiceAttoConservatoria_Type', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \Sisteract\EnumType\CodiceAttoConservatoria_Type::getValidValues())), __LINE__);
        }
        $this->listaCodiciAttoConservatoria[] = $item;
        return $this;
    }
    /**
     * Get specieRestrizioneConservatoria value
     * @return string|null
     */
    public function getSpecieRestrizioneConservatoria()
    {
        return $this->specieRestrizioneConservatoria;
    }
    /**
     * Set specieRestrizioneConservatoria value
     * @uses \Sisteract\EnumType\SpecieRestrizioneConservatoria_Type::valueIsValid()
     * @uses \Sisteract\EnumType\SpecieRestrizioneConservatoria_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $specieRestrizioneConservatoria
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setSpecieRestrizioneConservatoria($specieRestrizioneConservatoria = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\SpecieRestrizioneConservatoria_Type::valueIsValid($specieRestrizioneConservatoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\SpecieRestrizioneConservatoria_Type', is_array($specieRestrizioneConservatoria) ? implode(', ', $specieRestrizioneConservatoria) : var_export($specieRestrizioneConservatoria, true), implode(', ', \Sisteract\EnumType\SpecieRestrizioneConservatoria_Type::getValidValues())), __LINE__);
        }
        $this->specieRestrizioneConservatoria = $specieRestrizioneConservatoria;
        return $this;
    }
    /**
     * Get tipoIspezioneConservatoria value
     * @return string|null
     */
    public function getTipoIspezioneConservatoria()
    {
        return $this->tipoIspezioneConservatoria;
    }
    /**
     * Set tipoIspezioneConservatoria value
     * @uses \Sisteract\EnumType\TipoIspezioneConservatoria_Type::valueIsValid()
     * @uses \Sisteract\EnumType\TipoIspezioneConservatoria_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoIspezioneConservatoria
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setTipoIspezioneConservatoria($tipoIspezioneConservatoria = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\TipoIspezioneConservatoria_Type::valueIsValid($tipoIspezioneConservatoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\TipoIspezioneConservatoria_Type', is_array($tipoIspezioneConservatoria) ? implode(', ', $tipoIspezioneConservatoria) : var_export($tipoIspezioneConservatoria, true), implode(', ', \Sisteract\EnumType\TipoIspezioneConservatoria_Type::getValidValues())), __LINE__);
        }
        $this->tipoIspezioneConservatoria = $tipoIspezioneConservatoria;
        return $this;
    }
    /**
     * Get trascrizioni value
     * @return bool|null
     */
    public function getTrascrizioni()
    {
        return $this->trascrizioni;
    }
    /**
     * Set trascrizioni value
     * @param bool $trascrizioni
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setTrascrizioni($trascrizioni = null)
    {
        // validation for constraint: boolean
        if (!is_null($trascrizioni) && !is_bool($trascrizioni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trascrizioni, true), gettype($trascrizioni)), __LINE__);
        }
        $this->trascrizioni = $trascrizioni;
        return $this;
    }
    /**
     * Get trascrizioniContro value
     * @return bool|null
     */
    public function getTrascrizioniContro()
    {
        return $this->trascrizioniContro;
    }
    /**
     * Set trascrizioniContro value
     * @param bool $trascrizioniContro
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setTrascrizioniContro($trascrizioniContro = null)
    {
        // validation for constraint: boolean
        if (!is_null($trascrizioniContro) && !is_bool($trascrizioniContro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trascrizioniContro, true), gettype($trascrizioniContro)), __LINE__);
        }
        $this->trascrizioniContro = $trascrizioniContro;
        return $this;
    }
    /**
     * Get trascrizioniFavore value
     * @return bool|null
     */
    public function getTrascrizioniFavore()
    {
        return $this->trascrizioniFavore;
    }
    /**
     * Set trascrizioniFavore value
     * @param bool $trascrizioniFavore
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public function setTrascrizioniFavore($trascrizioniFavore = null)
    {
        // validation for constraint: boolean
        if (!is_null($trascrizioniFavore) && !is_bool($trascrizioniFavore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trascrizioniFavore, true), gettype($trascrizioniFavore)), __LINE__);
        }
        $this->trascrizioniFavore = $trascrizioniFavore;
        return $this;
    }
}
