<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IndirizziBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean che contiene i dati degli indirizzi recuperatiall'interno di uno specifico comune
 * @subpackage Structs
 */
class IndirizziBean_Type extends AbstractStructBase
{
    /**
     * The codiceComune
     * Meta information extracted from the WSDL
     * - documentation: Codice catastale del comune su cui e' stato trovato l'indirizzo
     * - nillable: true
     * @var string
     */
    public $codiceComune;
    /**
     * The codiceIndirizzo
     * Meta information extracted from the WSDL
     * - documentation: Codice catastale dell'indirizzo trovato
     * - nillable: true
     * @var string
     */
    public $codiceIndirizzo;
    /**
     * The indirizzo
     * Meta information extracted from the WSDL
     * - documentation: Denominazione dell'indirizzo trovato
     * - nillable: true
     * @var string
     */
    public $indirizzo;
    /**
     * Constructor method for IndirizziBean_Type
     * @uses IndirizziBean_Type::setCodiceComune()
     * @uses IndirizziBean_Type::setCodiceIndirizzo()
     * @uses IndirizziBean_Type::setIndirizzo()
     * @param string $codiceComune
     * @param string $codiceIndirizzo
     * @param string $indirizzo
     */
    public function __construct($codiceComune = null, $codiceIndirizzo = null, $indirizzo = null)
    {
        $this
            ->setCodiceComune($codiceComune)
            ->setCodiceIndirizzo($codiceIndirizzo)
            ->setIndirizzo($indirizzo);
    }
    /**
     * Get codiceComune value
     * @return string|null
     */
    public function getCodiceComune()
    {
        return $this->codiceComune;
    }
    /**
     * Set codiceComune value
     * @param string $codiceComune
     * @return \Sisteract\StructType\IndirizziBean_Type
     */
    public function setCodiceComune($codiceComune = null)
    {
        // validation for constraint: string
        if (!is_null($codiceComune) && !is_string($codiceComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceComune, true), gettype($codiceComune)), __LINE__);
        }
        $this->codiceComune = $codiceComune;
        return $this;
    }
    /**
     * Get codiceIndirizzo value
     * @return string|null
     */
    public function getCodiceIndirizzo()
    {
        return $this->codiceIndirizzo;
    }
    /**
     * Set codiceIndirizzo value
     * @param string $codiceIndirizzo
     * @return \Sisteract\StructType\IndirizziBean_Type
     */
    public function setCodiceIndirizzo($codiceIndirizzo = null)
    {
        // validation for constraint: string
        if (!is_null($codiceIndirizzo) && !is_string($codiceIndirizzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceIndirizzo, true), gettype($codiceIndirizzo)), __LINE__);
        }
        $this->codiceIndirizzo = $codiceIndirizzo;
        return $this;
    }
    /**
     * Get indirizzo value
     * @return string|null
     */
    public function getIndirizzo()
    {
        return $this->indirizzo;
    }
    /**
     * Set indirizzo value
     * @param string $indirizzo
     * @return \Sisteract\StructType\IndirizziBean_Type
     */
    public function setIndirizzo($indirizzo = null)
    {
        // validation for constraint: string
        if (!is_null($indirizzo) && !is_string($indirizzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indirizzo, true), gettype($indirizzo)), __LINE__);
        }
        $this->indirizzo = $indirizzo;
        return $this;
    }
}
