<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentificativoCatastaleBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean di identificazione di un bene immobile, su un comune.Questo bean ritorna i dati trovati in una delle ricerche per immobile
 * @subpackage Structs
 */
class IdentificativoCatastaleBean_Type extends AbstractStructBase
{
    /**
     * The classe
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $classe;
    /**
     * The comune
     * Meta information extracted from the WSDL
     * - documentation: Decodifica del comune su cui l'immobile si trova
     * - nillable: true
     * @var string
     */
    public $comune;
    /**
     * The consistenza
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consistenza;
    /**
     * The foglio
     * Meta information extracted from the WSDL
     * - documentation: Porzione di territorio comunale che il catasto rappresenta nelleproprie mappe cartografiche.
     * - nillable: true
     * @var string
     */
    public $foglio;
    /**
     * The idComune
     * Meta information extracted from the WSDL
     * - documentation: Codice catastale del comune
     * - nillable: true
     * @var string
     */
    public $idComune;
    /**
     * The idImmobile
     * Meta information extracted from the WSDL
     * - documentation: Il codice che il catasto assegna all'immobile, tale codice è automaticoe viene assegnato a run-time, per cui lo stesso immobile può avere un codice diversoad ogni richiesta
     * - nillable: true
     * @var string
     */
    public $idImmobile;
    /**
     * The idIndirizzoPassato
     * Meta information extracted from the WSDL
     * - documentation: Id dell'indirizzo passato per la ricerca dell'immobileL'id è un codice catastale che identivica un'indirizzo o porzione di essoall'interno di un comunneViene ricavato, leggendo i dati ritorno della chiamata:
     * getRicercaImmobiliIndirizzoNoToponimo
     * - nillable: true
     * @var string
     */
    public $idIndirizzoPassato;
    /**
     * The identificativoCatastaleTerreni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sisteract\StructType\IdentificativoCatastaleTerreniBean_Type
     */
    public $identificativoCatastaleTerreni;
    /**
     * The indirizzoPassato
     * Meta information extracted from the WSDL
     * - documentation: Denominazione dell'indirizzo passato, all'interno del comuneViene ricavato, leggendo i dati ritorno della chiamata: getRicercaImmobiliIndirizzoNoToponimo
     * - nillable: true
     * @var string
     */
    public $indirizzoPassato;
    /**
     * The indirizzoTrovato
     * Meta information extracted from the WSDL
     * - documentation: Denominazione dell'indirizzo trovato (rispetto all'indirizzo passato)su cui l'immobile e' sito
     * - nillable: true
     * @var string
     */
    public $indirizzoTrovato;
    /**
     * The particella
     * Meta information extracted from the WSDL
     * - documentation: La particella catastale è costituita da una porzione continua di terreno o fabbricatoappartenente allo stesso possessore, purchè sia della medesima qualità o classe,e possieda la stessa destinazione d’uso.E' detta anche mappale
     * o numero di mappa.parametro mandatario
     * - nillable: true
     * @var string
     */
    public $particella;
    /**
     * The partita
     * Meta information extracted from the WSDL
     * - documentation: Documento in cui sono elencate in Catasto tutte le unità immobiliari possedute dalla stessa "ditta catastale" (cittadino, società, eccetera).parametro mandatario
     * - nillable: true
     * @var string
     */
    public $partita;
    /**
     * The provincia
     * Meta information extracted from the WSDL
     * - documentation: Provincia di apparatenza del comune / immobile
     * - nillable: true
     * @var string
     */
    public $provincia;
    /**
     * The rendita
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $rendita;
    /**
     * The sub
     * Meta information extracted from the WSDL
     * - documentation: Utilizzato principalmente nel catasto urbano, (nel catasto terreni si usa per individuarei fabbricati di tipo rurale) dove presente,identifica la singola unità immobiliare esistente su una particella.L'unità immobiliare urbana è
     * l'elemento minimo inventariabile che haautonomia reddituale e funzionale. parametro mandatario
     * - nillable: true
     * @var string
     */
    public $sub;
    /**
     * The tipoCategoria
     * Meta information extracted from the WSDL
     * - documentation: Puo' avere due valori, ed identifica il tipo di categoria.T=TerreniF=Fabbricati parametro mandatario
     * - nillable: true
     * @var string
     */
    public $tipoCategoria;
    /**
     * The zona
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $zona;
    /**
     * Constructor method for IdentificativoCatastaleBean_Type
     * @uses IdentificativoCatastaleBean_Type::setClasse()
     * @uses IdentificativoCatastaleBean_Type::setComune()
     * @uses IdentificativoCatastaleBean_Type::setConsistenza()
     * @uses IdentificativoCatastaleBean_Type::setFoglio()
     * @uses IdentificativoCatastaleBean_Type::setIdComune()
     * @uses IdentificativoCatastaleBean_Type::setIdImmobile()
     * @uses IdentificativoCatastaleBean_Type::setIdIndirizzoPassato()
     * @uses IdentificativoCatastaleBean_Type::setIdentificativoCatastaleTerreni()
     * @uses IdentificativoCatastaleBean_Type::setIndirizzoPassato()
     * @uses IdentificativoCatastaleBean_Type::setIndirizzoTrovato()
     * @uses IdentificativoCatastaleBean_Type::setParticella()
     * @uses IdentificativoCatastaleBean_Type::setPartita()
     * @uses IdentificativoCatastaleBean_Type::setProvincia()
     * @uses IdentificativoCatastaleBean_Type::setRendita()
     * @uses IdentificativoCatastaleBean_Type::setSub()
     * @uses IdentificativoCatastaleBean_Type::setTipoCategoria()
     * @uses IdentificativoCatastaleBean_Type::setZona()
     * @param string $classe
     * @param string $comune
     * @param string $consistenza
     * @param string $foglio
     * @param string $idComune
     * @param string $idImmobile
     * @param string $idIndirizzoPassato
     * @param \Sisteract\StructType\IdentificativoCatastaleTerreniBean_Type $identificativoCatastaleTerreni
     * @param string $indirizzoPassato
     * @param string $indirizzoTrovato
     * @param string $particella
     * @param string $partita
     * @param string $provincia
     * @param string $rendita
     * @param string $sub
     * @param string $tipoCategoria
     * @param string $zona
     */
    public function __construct($classe = null, $comune = null, $consistenza = null, $foglio = null, $idComune = null, $idImmobile = null, $idIndirizzoPassato = null, \Sisteract\StructType\IdentificativoCatastaleTerreniBean_Type $identificativoCatastaleTerreni = null, $indirizzoPassato = null, $indirizzoTrovato = null, $particella = null, $partita = null, $provincia = null, $rendita = null, $sub = null, $tipoCategoria = null, $zona = null)
    {
        $this
            ->setClasse($classe)
            ->setComune($comune)
            ->setConsistenza($consistenza)
            ->setFoglio($foglio)
            ->setIdComune($idComune)
            ->setIdImmobile($idImmobile)
            ->setIdIndirizzoPassato($idIndirizzoPassato)
            ->setIdentificativoCatastaleTerreni($identificativoCatastaleTerreni)
            ->setIndirizzoPassato($indirizzoPassato)
            ->setIndirizzoTrovato($indirizzoTrovato)
            ->setParticella($particella)
            ->setPartita($partita)
            ->setProvincia($provincia)
            ->setRendita($rendita)
            ->setSub($sub)
            ->setTipoCategoria($tipoCategoria)
            ->setZona($zona);
    }
    /**
     * Get classe value
     * @return string|null
     */
    public function getClasse()
    {
        return $this->classe;
    }
    /**
     * Set classe value
     * @param string $classe
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setClasse($classe = null)
    {
        // validation for constraint: string
        if (!is_null($classe) && !is_string($classe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classe, true), gettype($classe)), __LINE__);
        }
        $this->classe = $classe;
        return $this;
    }
    /**
     * Get comune value
     * @return string|null
     */
    public function getComune()
    {
        return $this->comune;
    }
    /**
     * Set comune value
     * @param string $comune
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setComune($comune = null)
    {
        // validation for constraint: string
        if (!is_null($comune) && !is_string($comune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comune, true), gettype($comune)), __LINE__);
        }
        $this->comune = $comune;
        return $this;
    }
    /**
     * Get consistenza value
     * @return string|null
     */
    public function getConsistenza()
    {
        return $this->consistenza;
    }
    /**
     * Set consistenza value
     * @param string $consistenza
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setConsistenza($consistenza = null)
    {
        // validation for constraint: string
        if (!is_null($consistenza) && !is_string($consistenza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consistenza, true), gettype($consistenza)), __LINE__);
        }
        $this->consistenza = $consistenza;
        return $this;
    }
    /**
     * Get foglio value
     * @return string|null
     */
    public function getFoglio()
    {
        return $this->foglio;
    }
    /**
     * Set foglio value
     * @param string $foglio
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setFoglio($foglio = null)
    {
        // validation for constraint: string
        if (!is_null($foglio) && !is_string($foglio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foglio, true), gettype($foglio)), __LINE__);
        }
        $this->foglio = $foglio;
        return $this;
    }
    /**
     * Get idComune value
     * @return string|null
     */
    public function getIdComune()
    {
        return $this->idComune;
    }
    /**
     * Set idComune value
     * @param string $idComune
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setIdComune($idComune = null)
    {
        // validation for constraint: string
        if (!is_null($idComune) && !is_string($idComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idComune, true), gettype($idComune)), __LINE__);
        }
        $this->idComune = $idComune;
        return $this;
    }
    /**
     * Get idImmobile value
     * @return string|null
     */
    public function getIdImmobile()
    {
        return $this->idImmobile;
    }
    /**
     * Set idImmobile value
     * @param string $idImmobile
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setIdImmobile($idImmobile = null)
    {
        // validation for constraint: string
        if (!is_null($idImmobile) && !is_string($idImmobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idImmobile, true), gettype($idImmobile)), __LINE__);
        }
        $this->idImmobile = $idImmobile;
        return $this;
    }
    /**
     * Get idIndirizzoPassato value
     * @return string|null
     */
    public function getIdIndirizzoPassato()
    {
        return $this->idIndirizzoPassato;
    }
    /**
     * Set idIndirizzoPassato value
     * @param string $idIndirizzoPassato
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setIdIndirizzoPassato($idIndirizzoPassato = null)
    {
        // validation for constraint: string
        if (!is_null($idIndirizzoPassato) && !is_string($idIndirizzoPassato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idIndirizzoPassato, true), gettype($idIndirizzoPassato)), __LINE__);
        }
        $this->idIndirizzoPassato = $idIndirizzoPassato;
        return $this;
    }
    /**
     * Get identificativoCatastaleTerreni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sisteract\StructType\IdentificativoCatastaleTerreniBean_Type|null
     */
    public function getIdentificativoCatastaleTerreni()
    {
        return isset($this->identificativoCatastaleTerreni) ? $this->identificativoCatastaleTerreni : null;
    }
    /**
     * Set identificativoCatastaleTerreni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sisteract\StructType\IdentificativoCatastaleTerreniBean_Type $identificativoCatastaleTerreni
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setIdentificativoCatastaleTerreni(\Sisteract\StructType\IdentificativoCatastaleTerreniBean_Type $identificativoCatastaleTerreni = null)
    {
        if (is_null($identificativoCatastaleTerreni) || (is_array($identificativoCatastaleTerreni) && empty($identificativoCatastaleTerreni))) {
            unset($this->identificativoCatastaleTerreni);
        } else {
            $this->identificativoCatastaleTerreni = $identificativoCatastaleTerreni;
        }
        return $this;
    }
    /**
     * Get indirizzoPassato value
     * @return string|null
     */
    public function getIndirizzoPassato()
    {
        return $this->indirizzoPassato;
    }
    /**
     * Set indirizzoPassato value
     * @param string $indirizzoPassato
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setIndirizzoPassato($indirizzoPassato = null)
    {
        // validation for constraint: string
        if (!is_null($indirizzoPassato) && !is_string($indirizzoPassato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indirizzoPassato, true), gettype($indirizzoPassato)), __LINE__);
        }
        $this->indirizzoPassato = $indirizzoPassato;
        return $this;
    }
    /**
     * Get indirizzoTrovato value
     * @return string|null
     */
    public function getIndirizzoTrovato()
    {
        return $this->indirizzoTrovato;
    }
    /**
     * Set indirizzoTrovato value
     * @param string $indirizzoTrovato
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setIndirizzoTrovato($indirizzoTrovato = null)
    {
        // validation for constraint: string
        if (!is_null($indirizzoTrovato) && !is_string($indirizzoTrovato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indirizzoTrovato, true), gettype($indirizzoTrovato)), __LINE__);
        }
        $this->indirizzoTrovato = $indirizzoTrovato;
        return $this;
    }
    /**
     * Get particella value
     * @return string|null
     */
    public function getParticella()
    {
        return $this->particella;
    }
    /**
     * Set particella value
     * @param string $particella
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setParticella($particella = null)
    {
        // validation for constraint: string
        if (!is_null($particella) && !is_string($particella)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($particella, true), gettype($particella)), __LINE__);
        }
        $this->particella = $particella;
        return $this;
    }
    /**
     * Get partita value
     * @return string|null
     */
    public function getPartita()
    {
        return $this->partita;
    }
    /**
     * Set partita value
     * @param string $partita
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setPartita($partita = null)
    {
        // validation for constraint: string
        if (!is_null($partita) && !is_string($partita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partita, true), gettype($partita)), __LINE__);
        }
        $this->partita = $partita;
        return $this;
    }
    /**
     * Get provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->provincia;
    }
    /**
     * Set provincia value
     * @param string $provincia
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        $this->provincia = $provincia;
        return $this;
    }
    /**
     * Get rendita value
     * @return string|null
     */
    public function getRendita()
    {
        return $this->rendita;
    }
    /**
     * Set rendita value
     * @param string $rendita
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setRendita($rendita = null)
    {
        // validation for constraint: string
        if (!is_null($rendita) && !is_string($rendita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rendita, true), gettype($rendita)), __LINE__);
        }
        $this->rendita = $rendita;
        return $this;
    }
    /**
     * Get sub value
     * @return string|null
     */
    public function getSub()
    {
        return $this->sub;
    }
    /**
     * Set sub value
     * @param string $sub
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setSub($sub = null)
    {
        // validation for constraint: string
        if (!is_null($sub) && !is_string($sub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sub, true), gettype($sub)), __LINE__);
        }
        $this->sub = $sub;
        return $this;
    }
    /**
     * Get tipoCategoria value
     * @return string|null
     */
    public function getTipoCategoria()
    {
        return $this->tipoCategoria;
    }
    /**
     * Set tipoCategoria value
     * @param string $tipoCategoria
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setTipoCategoria($tipoCategoria = null)
    {
        // validation for constraint: string
        if (!is_null($tipoCategoria) && !is_string($tipoCategoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoCategoria, true), gettype($tipoCategoria)), __LINE__);
        }
        $this->tipoCategoria = $tipoCategoria;
        return $this;
    }
    /**
     * Get zona value
     * @return string|null
     */
    public function getZona()
    {
        return $this->zona;
    }
    /**
     * Set zona value
     * @param string $zona
     * @return \Sisteract\StructType\IdentificativoCatastaleBean_Type
     */
    public function setZona($zona = null)
    {
        // validation for constraint: string
        if (!is_null($zona) && !is_string($zona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zona, true), gettype($zona)), __LINE__);
        }
        $this->zona = $zona;
        return $this;
    }
}
