<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConservatoriaBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Rappresenta una conservatoria
 * @subpackage Structs
 */
class ConservatoriaBean_Type extends AbstractStructBase
{
    /**
     * The codice
     * Meta information extracted from the WSDL
     * - documentation: Ritorna codice della conservatoria
     * @var string
     */
    public $codice;
    /**
     * The descrizione
     * Meta information extracted from the WSDL
     * - documentation: Ritorna descrizione della conservatoria
     * @var string
     */
    public $descrizione;
    /**
     * Constructor method for ConservatoriaBean_Type
     * @uses ConservatoriaBean_Type::setCodice()
     * @uses ConservatoriaBean_Type::setDescrizione()
     * @param string $codice
     * @param string $descrizione
     */
    public function __construct($codice = null, $descrizione = null)
    {
        $this
            ->setCodice($codice)
            ->setDescrizione($descrizione);
    }
    /**
     * Get codice value
     * @return string|null
     */
    public function getCodice()
    {
        return $this->codice;
    }
    /**
     * Set codice value
     * @param string $codice
     * @return \Sisteract\StructType\ConservatoriaBean_Type
     */
    public function setCodice($codice = null)
    {
        // validation for constraint: string
        if (!is_null($codice) && !is_string($codice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codice, true), gettype($codice)), __LINE__);
        }
        $this->codice = $codice;
        return $this;
    }
    /**
     * Get descrizione value
     * @return string|null
     */
    public function getDescrizione()
    {
        return $this->descrizione;
    }
    /**
     * Set descrizione value
     * @param string $descrizione
     * @return \Sisteract\StructType\ConservatoriaBean_Type
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        $this->descrizione = $descrizione;
        return $this;
    }
}
