<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComuneImmobileConConservatoria_Type StructType
 * @subpackage Structs
 */
class ComuneImmobileConConservatoria_Type extends AbstractStructBase
{
    /**
     * The codiceComune
     * Meta information extracted from the WSDL
     * - documentation: Ritorna codice del comune dove si trova un bene
     * @var string
     */
    public $codiceComune;
    /**
     * The descrizioneComune
     * Meta information extracted from the WSDL
     * - documentation: Ritorna descrizione del comune dove si trova un bene
     * @var string
     */
    public $descrizioneComune;
    /**
     * The descrizioneConservatoria
     * Meta information extracted from the WSDL
     * - documentation: Ritorna descrizione della conservatoria di pertinenza per il comune del bene
     * - nillable: true
     * @var string
     */
    public $descrizioneConservatoria;
    /**
     * The fabbricato
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato si tratta di un fabbricato, altrimenti di un terreno
     * @var bool
     */
    public $fabbricato;
    /**
     * Constructor method for ComuneImmobileConConservatoria_Type
     * @uses ComuneImmobileConConservatoria_Type::setCodiceComune()
     * @uses ComuneImmobileConConservatoria_Type::setDescrizioneComune()
     * @uses ComuneImmobileConConservatoria_Type::setDescrizioneConservatoria()
     * @uses ComuneImmobileConConservatoria_Type::setFabbricato()
     * @param string $codiceComune
     * @param string $descrizioneComune
     * @param string $descrizioneConservatoria
     * @param bool $fabbricato
     */
    public function __construct($codiceComune = null, $descrizioneComune = null, $descrizioneConservatoria = null, $fabbricato = null)
    {
        $this
            ->setCodiceComune($codiceComune)
            ->setDescrizioneComune($descrizioneComune)
            ->setDescrizioneConservatoria($descrizioneConservatoria)
            ->setFabbricato($fabbricato);
    }
    /**
     * Get codiceComune value
     * @return string|null
     */
    public function getCodiceComune()
    {
        return $this->codiceComune;
    }
    /**
     * Set codiceComune value
     * @param string $codiceComune
     * @return \Sisteract\StructType\ComuneImmobileConConservatoria_Type
     */
    public function setCodiceComune($codiceComune = null)
    {
        // validation for constraint: string
        if (!is_null($codiceComune) && !is_string($codiceComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceComune, true), gettype($codiceComune)), __LINE__);
        }
        $this->codiceComune = $codiceComune;
        return $this;
    }
    /**
     * Get descrizioneComune value
     * @return string|null
     */
    public function getDescrizioneComune()
    {
        return $this->descrizioneComune;
    }
    /**
     * Set descrizioneComune value
     * @param string $descrizioneComune
     * @return \Sisteract\StructType\ComuneImmobileConConservatoria_Type
     */
    public function setDescrizioneComune($descrizioneComune = null)
    {
        // validation for constraint: string
        if (!is_null($descrizioneComune) && !is_string($descrizioneComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizioneComune, true), gettype($descrizioneComune)), __LINE__);
        }
        $this->descrizioneComune = $descrizioneComune;
        return $this;
    }
    /**
     * Get descrizioneConservatoria value
     * @return string|null
     */
    public function getDescrizioneConservatoria()
    {
        return $this->descrizioneConservatoria;
    }
    /**
     * Set descrizioneConservatoria value
     * @param string $descrizioneConservatoria
     * @return \Sisteract\StructType\ComuneImmobileConConservatoria_Type
     */
    public function setDescrizioneConservatoria($descrizioneConservatoria = null)
    {
        // validation for constraint: string
        if (!is_null($descrizioneConservatoria) && !is_string($descrizioneConservatoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizioneConservatoria, true), gettype($descrizioneConservatoria)), __LINE__);
        }
        $this->descrizioneConservatoria = $descrizioneConservatoria;
        return $this;
    }
    /**
     * Get fabbricato value
     * @return bool|null
     */
    public function getFabbricato()
    {
        return $this->fabbricato;
    }
    /**
     * Set fabbricato value
     * @param bool $fabbricato
     * @return \Sisteract\StructType\ComuneImmobileConConservatoria_Type
     */
    public function setFabbricato($fabbricato = null)
    {
        // validation for constraint: boolean
        if (!is_null($fabbricato) && !is_bool($fabbricato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fabbricato, true), gettype($fabbricato)), __LINE__);
        }
        $this->fabbricato = $fabbricato;
        return $this;
    }
}
