<?php

namespace Sisteract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Memorizza ServiceType
 * @subpackage Services
 */
class Memorizza extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named memorizzaUtenteSister
     * Meta information extracted from the WSDL
     * - documentation: Inserisce nel sistema una nuova password sister. Tale password entrerà a far parte della modalità "gestita".Nota che è considerato un errore inserire lo stesso utente per la stessa azienda più di una volta.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\MemorizzaUtenteSisterIn_Type $part1
     * @return \Sisteract\StructType\MemorizzaUtenteSisterOut_Type|bool
     */
    public function memorizzaUtenteSister(\Sisteract\StructType\MemorizzaUtenteSisterIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->memorizzaUtenteSister($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sisteract\StructType\MemorizzaUtenteSisterOut_Type
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
