<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettaAvvertimentoBudgetIn_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Ingresso all'operazione 'SettaAvvertimentoBudget'
 * @subpackage Structs
 */
class SettaAvvertimentoBudgetIn_Type extends SisterRead2Input_Type
{
    /**
     * The _
     * @var \Sisteract\StructType\SisterRead2Input_Type
     */
    public $_;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Mail che devono essere avvertite allo sforamento del budget. Si possono inserire mail multiple separando gli indirizzi con ,
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The importoAvvertimento
     * Meta information extracted from the WSDL
     * - documentation: Importo minimo sotto al quale si vuole essere avvertiti
     * @var float
     */
    public $importoAvvertimento;
    /**
     * Constructor method for SettaAvvertimentoBudgetIn_Type
     * @uses SettaAvvertimentoBudgetIn_Type::set_()
     * @uses SettaAvvertimentoBudgetIn_Type::setEmail()
     * @uses SettaAvvertimentoBudgetIn_Type::setImportoAvvertimento()
     * @param \Sisteract\StructType\SisterRead2Input_Type $_
     * @param string $email
     * @param float $importoAvvertimento
     */
    public function __construct(\Sisteract\StructType\SisterRead2Input_Type $_ = null, $email = null, $importoAvvertimento = null)
    {
        $this
            ->set_($_)
            ->setEmail($email)
            ->setImportoAvvertimento($importoAvvertimento);
    }
    /**
     * Get _ value
     * @return \Sisteract\StructType\SisterRead2Input_Type|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \Sisteract\StructType\SisterRead2Input_Type $_
     * @return \Sisteract\StructType\SettaAvvertimentoBudgetIn_Type
     */
    public function set_(\Sisteract\StructType\SisterRead2Input_Type $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \Sisteract\StructType\SettaAvvertimentoBudgetIn_Type
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get importoAvvertimento value
     * @return float|null
     */
    public function getImportoAvvertimento()
    {
        return $this->importoAvvertimento;
    }
    /**
     * Set importoAvvertimento value
     * @param float $importoAvvertimento
     * @return \Sisteract\StructType\SettaAvvertimentoBudgetIn_Type
     */
    public function setImportoAvvertimento($importoAvvertimento = null)
    {
        // validation for constraint: float
        if (!is_null($importoAvvertimento) && !(is_float($importoAvvertimento) || is_numeric($importoAvvertimento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importoAvvertimento, true), gettype($importoAvvertimento)), __LINE__);
        }
        $this->importoAvvertimento = $importoAvvertimento;
        return $this;
    }
}
