<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnDownloadVisuraImmobili_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean di ritorno, per l'elaborazione della visura per ImmobileQuesto bean contiene i dati dell'elaborazione della visura trovata
 * @subpackage Structs
 */
class ReturnDownloadVisuraImmobili_Type extends AbstractStructBase
{
    /**
     * The binFile
     * Meta information extracted from the WSDL
     * - documentation: Il file binario (generalmente pdf) che torna dal fornitore (Sister), così come e'.
     * - nillable: true
     * @var string
     */
    public $binFile;
    /**
     * The differita
     * Meta information extracted from the WSDL
     * - documentation: Definisce se la visura è stata immessa in differitaTRUE=In differita (da recuperare con la chiamata: getVisuraByTicket)FALSE=la visura e' dentro i campi binFile e xml
     * @var bool
     */
    public $differita;
    /**
     * The mimeType
     * Meta information extracted from the WSDL
     * - documentation: Tipo di mime Type del dato binario ritornato
     * - nillable: true
     * @var string
     */
    public $mimeType;
    /**
     * The nomeFile
     * Meta information extracted from the WSDL
     * - documentation: Nome del file, che è stato assegnato al dato binario
     * - nillable: true
     * @var string
     */
    public $nomeFile;
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - documentation: Ticket della chiamata, questo ticket viene sempre rilasciatoe server per recuperare la visura con la chiamata: getVisuraByTicket
     * - nillable: true
     * @var string
     */
    public $ticket;
    /**
     * The xml
     * Meta information extracted from the WSDL
     * - documentation: Il file Xml della visura per soggetto, ricavato dal file binarioNota: per la documentazione di tale struttura di rimanda alla lettura del relativo capitolo
     * - nillable: true
     * @var string
     */
    public $xml;
    /**
     * Constructor method for ReturnDownloadVisuraImmobili_Type
     * @uses ReturnDownloadVisuraImmobili_Type::setBinFile()
     * @uses ReturnDownloadVisuraImmobili_Type::setDifferita()
     * @uses ReturnDownloadVisuraImmobili_Type::setMimeType()
     * @uses ReturnDownloadVisuraImmobili_Type::setNomeFile()
     * @uses ReturnDownloadVisuraImmobili_Type::setTicket()
     * @uses ReturnDownloadVisuraImmobili_Type::setXml()
     * @param string $binFile
     * @param bool $differita
     * @param string $mimeType
     * @param string $nomeFile
     * @param string $ticket
     * @param string $xml
     */
    public function __construct($binFile = null, $differita = null, $mimeType = null, $nomeFile = null, $ticket = null, $xml = null)
    {
        $this
            ->setBinFile($binFile)
            ->setDifferita($differita)
            ->setMimeType($mimeType)
            ->setNomeFile($nomeFile)
            ->setTicket($ticket)
            ->setXml($xml);
    }
    /**
     * Get binFile value
     * @return string|null
     */
    public function getBinFile()
    {
        return $this->binFile;
    }
    /**
     * Set binFile value
     * @param string $binFile
     * @return \Sisteract\StructType\ReturnDownloadVisuraImmobili_Type
     */
    public function setBinFile($binFile = null)
    {
        // validation for constraint: string
        if (!is_null($binFile) && !is_string($binFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binFile, true), gettype($binFile)), __LINE__);
        }
        $this->binFile = $binFile;
        return $this;
    }
    /**
     * Get differita value
     * @return bool|null
     */
    public function getDifferita()
    {
        return $this->differita;
    }
    /**
     * Set differita value
     * @param bool $differita
     * @return \Sisteract\StructType\ReturnDownloadVisuraImmobili_Type
     */
    public function setDifferita($differita = null)
    {
        // validation for constraint: boolean
        if (!is_null($differita) && !is_bool($differita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($differita, true), gettype($differita)), __LINE__);
        }
        $this->differita = $differita;
        return $this;
    }
    /**
     * Get mimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * Set mimeType value
     * @param string $mimeType
     * @return \Sisteract\StructType\ReturnDownloadVisuraImmobili_Type
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        $this->mimeType = $mimeType;
        return $this;
    }
    /**
     * Get nomeFile value
     * @return string|null
     */
    public function getNomeFile()
    {
        return $this->nomeFile;
    }
    /**
     * Set nomeFile value
     * @param string $nomeFile
     * @return \Sisteract\StructType\ReturnDownloadVisuraImmobili_Type
     */
    public function setNomeFile($nomeFile = null)
    {
        // validation for constraint: string
        if (!is_null($nomeFile) && !is_string($nomeFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeFile, true), gettype($nomeFile)), __LINE__);
        }
        $this->nomeFile = $nomeFile;
        return $this;
    }
    /**
     * Get ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param string $ticket
     * @return \Sisteract\StructType\ReturnDownloadVisuraImmobili_Type
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
    /**
     * Get xml value
     * @return string|null
     */
    public function getXml()
    {
        return $this->xml;
    }
    /**
     * Set xml value
     * @param string $xml
     * @return \Sisteract\StructType\ReturnDownloadVisuraImmobili_Type
     */
    public function setXml($xml = null)
    {
        // validation for constraint: string
        if (!is_null($xml) && !is_string($xml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xml, true), gettype($xml)), __LINE__);
        }
        $this->xml = $xml;
        return $this;
    }
}
