<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrizioneImmobileBean_Type StructType
 * @subpackage Structs
 */
class RestrizioneImmobileBean_Type extends AbstractStructBase
{
    /**
     * The codiceComune
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $codiceComune;
    /**
     * The descrizioneComune
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $descrizioneComune;
    /**
     * The foglio
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $foglio;
    /**
     * The particella
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $particella;
    /**
     * The restrizioneCatasto
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $restrizioneCatasto;
    /**
     * The sezioneUrbana
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sezioneUrbana;
    /**
     * The subalterno
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $subalterno;
    /**
     * Constructor method for RestrizioneImmobileBean_Type
     * @uses RestrizioneImmobileBean_Type::setCodiceComune()
     * @uses RestrizioneImmobileBean_Type::setDescrizioneComune()
     * @uses RestrizioneImmobileBean_Type::setFoglio()
     * @uses RestrizioneImmobileBean_Type::setParticella()
     * @uses RestrizioneImmobileBean_Type::setRestrizioneCatasto()
     * @uses RestrizioneImmobileBean_Type::setSezioneUrbana()
     * @uses RestrizioneImmobileBean_Type::setSubalterno()
     * @param string $codiceComune
     * @param string $descrizioneComune
     * @param string $foglio
     * @param string $particella
     * @param string $restrizioneCatasto
     * @param string $sezioneUrbana
     * @param string $subalterno
     */
    public function __construct($codiceComune = null, $descrizioneComune = null, $foglio = null, $particella = null, $restrizioneCatasto = null, $sezioneUrbana = null, $subalterno = null)
    {
        $this
            ->setCodiceComune($codiceComune)
            ->setDescrizioneComune($descrizioneComune)
            ->setFoglio($foglio)
            ->setParticella($particella)
            ->setRestrizioneCatasto($restrizioneCatasto)
            ->setSezioneUrbana($sezioneUrbana)
            ->setSubalterno($subalterno);
    }
    /**
     * Get codiceComune value
     * @return string|null
     */
    public function getCodiceComune()
    {
        return $this->codiceComune;
    }
    /**
     * Set codiceComune value
     * @param string $codiceComune
     * @return \Sisteract\StructType\RestrizioneImmobileBean_Type
     */
    public function setCodiceComune($codiceComune = null)
    {
        // validation for constraint: string
        if (!is_null($codiceComune) && !is_string($codiceComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceComune, true), gettype($codiceComune)), __LINE__);
        }
        $this->codiceComune = $codiceComune;
        return $this;
    }
    /**
     * Get descrizioneComune value
     * @return string|null
     */
    public function getDescrizioneComune()
    {
        return $this->descrizioneComune;
    }
    /**
     * Set descrizioneComune value
     * @param string $descrizioneComune
     * @return \Sisteract\StructType\RestrizioneImmobileBean_Type
     */
    public function setDescrizioneComune($descrizioneComune = null)
    {
        // validation for constraint: string
        if (!is_null($descrizioneComune) && !is_string($descrizioneComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizioneComune, true), gettype($descrizioneComune)), __LINE__);
        }
        $this->descrizioneComune = $descrizioneComune;
        return $this;
    }
    /**
     * Get foglio value
     * @return string|null
     */
    public function getFoglio()
    {
        return $this->foglio;
    }
    /**
     * Set foglio value
     * @param string $foglio
     * @return \Sisteract\StructType\RestrizioneImmobileBean_Type
     */
    public function setFoglio($foglio = null)
    {
        // validation for constraint: string
        if (!is_null($foglio) && !is_string($foglio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foglio, true), gettype($foglio)), __LINE__);
        }
        $this->foglio = $foglio;
        return $this;
    }
    /**
     * Get particella value
     * @return string|null
     */
    public function getParticella()
    {
        return $this->particella;
    }
    /**
     * Set particella value
     * @param string $particella
     * @return \Sisteract\StructType\RestrizioneImmobileBean_Type
     */
    public function setParticella($particella = null)
    {
        // validation for constraint: string
        if (!is_null($particella) && !is_string($particella)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($particella, true), gettype($particella)), __LINE__);
        }
        $this->particella = $particella;
        return $this;
    }
    /**
     * Get restrizioneCatasto value
     * @return string|null
     */
    public function getRestrizioneCatasto()
    {
        return $this->restrizioneCatasto;
    }
    /**
     * Set restrizioneCatasto value
     * @uses \Sisteract\EnumType\RestrizioneCatastoImmobile_Type::valueIsValid()
     * @uses \Sisteract\EnumType\RestrizioneCatastoImmobile_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrizioneCatasto
     * @return \Sisteract\StructType\RestrizioneImmobileBean_Type
     */
    public function setRestrizioneCatasto($restrizioneCatasto = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\RestrizioneCatastoImmobile_Type::valueIsValid($restrizioneCatasto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\RestrizioneCatastoImmobile_Type', is_array($restrizioneCatasto) ? implode(', ', $restrizioneCatasto) : var_export($restrizioneCatasto, true), implode(', ', \Sisteract\EnumType\RestrizioneCatastoImmobile_Type::getValidValues())), __LINE__);
        }
        $this->restrizioneCatasto = $restrizioneCatasto;
        return $this;
    }
    /**
     * Get sezioneUrbana value
     * @return string|null
     */
    public function getSezioneUrbana()
    {
        return $this->sezioneUrbana;
    }
    /**
     * Set sezioneUrbana value
     * @param string $sezioneUrbana
     * @return \Sisteract\StructType\RestrizioneImmobileBean_Type
     */
    public function setSezioneUrbana($sezioneUrbana = null)
    {
        // validation for constraint: string
        if (!is_null($sezioneUrbana) && !is_string($sezioneUrbana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sezioneUrbana, true), gettype($sezioneUrbana)), __LINE__);
        }
        $this->sezioneUrbana = $sezioneUrbana;
        return $this;
    }
    /**
     * Get subalterno value
     * @return string|null
     */
    public function getSubalterno()
    {
        return $this->subalterno;
    }
    /**
     * Set subalterno value
     * @param string $subalterno
     * @return \Sisteract\StructType\RestrizioneImmobileBean_Type
     */
    public function setSubalterno($subalterno = null)
    {
        // validation for constraint: string
        if (!is_null($subalterno) && !is_string($subalterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subalterno, true), gettype($subalterno)), __LINE__);
        }
        $this->subalterno = $subalterno;
        return $this;
    }
}
