<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProvincieBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean che riporta tutte le provicnie, queste sono estratti giornalmente dal sistema centralee riportano la data di aggiornamento dell'agenzia del territorio di competenza
 * @subpackage Structs
 */
class ProvincieBean_Type extends AbstractStructBase
{
    /**
     * The dataAggiornamento
     * Meta information extracted from the WSDL
     * - documentation: Data di aggiornamento dei dati catastali dell'agenzia del territorio dell provincia.
     * - nillable: true
     * @var string
     */
    public $dataAggiornamento;
    /**
     * The dbHost
     * Meta information extracted from the WSDL
     * - documentation: Host Db, su dove si devono effettuare le interrogazioniNota: Questo valore deve eessere ripassato in maniera trasparente
     * - nillable: true
     * @var string
     */
    public $dbHost;
    /**
     * The descrizione
     * Meta information extracted from the WSDL
     * - documentation: Descrizione della provincia
     * - nillable: true
     * @var string
     */
    public $descrizione;
    /**
     * The provincia
     * Meta information extracted from the WSDL
     * - documentation: Sigla della provincia
     * - nillable: true
     * @var string
     */
    public $provincia;
    /**
     * Constructor method for ProvincieBean_Type
     * @uses ProvincieBean_Type::setDataAggiornamento()
     * @uses ProvincieBean_Type::setDbHost()
     * @uses ProvincieBean_Type::setDescrizione()
     * @uses ProvincieBean_Type::setProvincia()
     * @param string $dataAggiornamento
     * @param string $dbHost
     * @param string $descrizione
     * @param string $provincia
     */
    public function __construct($dataAggiornamento = null, $dbHost = null, $descrizione = null, $provincia = null)
    {
        $this
            ->setDataAggiornamento($dataAggiornamento)
            ->setDbHost($dbHost)
            ->setDescrizione($descrizione)
            ->setProvincia($provincia);
    }
    /**
     * Get dataAggiornamento value
     * @return string|null
     */
    public function getDataAggiornamento()
    {
        return $this->dataAggiornamento;
    }
    /**
     * Set dataAggiornamento value
     * @param string $dataAggiornamento
     * @return \Sisteract\StructType\ProvincieBean_Type
     */
    public function setDataAggiornamento($dataAggiornamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataAggiornamento) && !is_string($dataAggiornamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAggiornamento, true), gettype($dataAggiornamento)), __LINE__);
        }
        $this->dataAggiornamento = $dataAggiornamento;
        return $this;
    }
    /**
     * Get dbHost value
     * @return string|null
     */
    public function getDbHost()
    {
        return $this->dbHost;
    }
    /**
     * Set dbHost value
     * @param string $dbHost
     * @return \Sisteract\StructType\ProvincieBean_Type
     */
    public function setDbHost($dbHost = null)
    {
        // validation for constraint: string
        if (!is_null($dbHost) && !is_string($dbHost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dbHost, true), gettype($dbHost)), __LINE__);
        }
        $this->dbHost = $dbHost;
        return $this;
    }
    /**
     * Get descrizione value
     * @return string|null
     */
    public function getDescrizione()
    {
        return $this->descrizione;
    }
    /**
     * Set descrizione value
     * @param string $descrizione
     * @return \Sisteract\StructType\ProvincieBean_Type
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        $this->descrizione = $descrizione;
        return $this;
    }
    /**
     * Get provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->provincia;
    }
    /**
     * Set provincia value
     * @param string $provincia
     * @return \Sisteract\StructType\ProvincieBean_Type
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        $this->provincia = $provincia;
        return $this;
    }
}
