<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProvinciaTerreniFabbricatiBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean che rappresenta un singolo comune (provincia) dove sono ubicati i terreni e fabbricati di una persona fisica / giuridica
 * @subpackage Structs
 */
class ProvinciaTerreniFabbricatiBean_Type extends AbstractStructBase
{
    /**
     * The comuni
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sisteract\StructType\ComuniBean_Type[]
     */
    public $comuni;
    /**
     * The dataAggiornamento
     * Meta information extracted from the WSDL
     * - documentation: data di aggiornamento della provincia del catastosu cui e' ubicato il bene.E' importante per sapere se i dati sono allineati o no.
     * - nillable: true
     * @var string
     */
    public $dataAggiornamento;
    /**
     * The descrizioneProvincia
     * Meta information extracted from the WSDL
     * - documentation: Descrizione della provincia su cui e' ubicato il bene
     * - nillable: true
     * @var string
     */
    public $descrizioneProvincia;
    /**
     * The fabbricati
     * Meta information extracted from the WSDL
     * - documentation: Numero di fabbricati che la persona cercata ha nel comune
     * @var int
     */
    public $fabbricati;
    /**
     * The provincia
     * Meta information extracted from the WSDL
     * - documentation: Sigla della provincia su cui e' ubicato il bene
     * - nillable: true
     * @var string
     */
    public $provincia;
    /**
     * The terreni
     * Meta information extracted from the WSDL
     * - documentation: Numero di terreni che la persona cercata ha nel comune
     * @var int
     */
    public $terreni;
    /**
     * Constructor method for ProvinciaTerreniFabbricatiBean_Type
     * @uses ProvinciaTerreniFabbricatiBean_Type::setComuni()
     * @uses ProvinciaTerreniFabbricatiBean_Type::setDataAggiornamento()
     * @uses ProvinciaTerreniFabbricatiBean_Type::setDescrizioneProvincia()
     * @uses ProvinciaTerreniFabbricatiBean_Type::setFabbricati()
     * @uses ProvinciaTerreniFabbricatiBean_Type::setProvincia()
     * @uses ProvinciaTerreniFabbricatiBean_Type::setTerreni()
     * @param \Sisteract\StructType\ComuniBean_Type[] $comuni
     * @param string $dataAggiornamento
     * @param string $descrizioneProvincia
     * @param int $fabbricati
     * @param string $provincia
     * @param int $terreni
     */
    public function __construct(array $comuni = array(), $dataAggiornamento = null, $descrizioneProvincia = null, $fabbricati = null, $provincia = null, $terreni = null)
    {
        $this
            ->setComuni($comuni)
            ->setDataAggiornamento($dataAggiornamento)
            ->setDescrizioneProvincia($descrizioneProvincia)
            ->setFabbricati($fabbricati)
            ->setProvincia($provincia)
            ->setTerreni($terreni);
    }
    /**
     * Get comuni value
     * @return \Sisteract\StructType\ComuniBean_Type[]|null
     */
    public function getComuni()
    {
        return $this->comuni;
    }
    /**
     * This method is responsible for validating the values passed to the setComuni method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComuni method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComuniForArrayConstraintsFromSetComuni(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $provinciaTerreniFabbricatiBean_TypeComuniItem) {
            // validation for constraint: itemType
            if (!$provinciaTerreniFabbricatiBean_TypeComuniItem instanceof \Sisteract\StructType\ComuniBean_Type) {
                $invalidValues[] = is_object($provinciaTerreniFabbricatiBean_TypeComuniItem) ? get_class($provinciaTerreniFabbricatiBean_TypeComuniItem) : sprintf('%s(%s)', gettype($provinciaTerreniFabbricatiBean_TypeComuniItem), var_export($provinciaTerreniFabbricatiBean_TypeComuniItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The comuni property can only contain items of type \Sisteract\StructType\ComuniBean_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set comuni value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\ComuniBean_Type[] $comuni
     * @return \Sisteract\StructType\ProvinciaTerreniFabbricatiBean_Type
     */
    public function setComuni(array $comuni = array())
    {
        // validation for constraint: array
        if ('' !== ($comuniArrayErrorMessage = self::validateComuniForArrayConstraintsFromSetComuni($comuni))) {
            throw new \InvalidArgumentException($comuniArrayErrorMessage, __LINE__);
        }
        $this->comuni = $comuni;
        return $this;
    }
    /**
     * Add item to comuni value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\ComuniBean_Type $item
     * @return \Sisteract\StructType\ProvinciaTerreniFabbricatiBean_Type
     */
    public function addToComuni(\Sisteract\StructType\ComuniBean_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sisteract\StructType\ComuniBean_Type) {
            throw new \InvalidArgumentException(sprintf('The comuni property can only contain items of type \Sisteract\StructType\ComuniBean_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->comuni[] = $item;
        return $this;
    }
    /**
     * Get dataAggiornamento value
     * @return string|null
     */
    public function getDataAggiornamento()
    {
        return $this->dataAggiornamento;
    }
    /**
     * Set dataAggiornamento value
     * @param string $dataAggiornamento
     * @return \Sisteract\StructType\ProvinciaTerreniFabbricatiBean_Type
     */
    public function setDataAggiornamento($dataAggiornamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataAggiornamento) && !is_string($dataAggiornamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAggiornamento, true), gettype($dataAggiornamento)), __LINE__);
        }
        $this->dataAggiornamento = $dataAggiornamento;
        return $this;
    }
    /**
     * Get descrizioneProvincia value
     * @return string|null
     */
    public function getDescrizioneProvincia()
    {
        return $this->descrizioneProvincia;
    }
    /**
     * Set descrizioneProvincia value
     * @param string $descrizioneProvincia
     * @return \Sisteract\StructType\ProvinciaTerreniFabbricatiBean_Type
     */
    public function setDescrizioneProvincia($descrizioneProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($descrizioneProvincia) && !is_string($descrizioneProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizioneProvincia, true), gettype($descrizioneProvincia)), __LINE__);
        }
        $this->descrizioneProvincia = $descrizioneProvincia;
        return $this;
    }
    /**
     * Get fabbricati value
     * @return int|null
     */
    public function getFabbricati()
    {
        return $this->fabbricati;
    }
    /**
     * Set fabbricati value
     * @param int $fabbricati
     * @return \Sisteract\StructType\ProvinciaTerreniFabbricatiBean_Type
     */
    public function setFabbricati($fabbricati = null)
    {
        // validation for constraint: int
        if (!is_null($fabbricati) && !(is_int($fabbricati) || ctype_digit($fabbricati))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fabbricati, true), gettype($fabbricati)), __LINE__);
        }
        $this->fabbricati = $fabbricati;
        return $this;
    }
    /**
     * Get provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->provincia;
    }
    /**
     * Set provincia value
     * @param string $provincia
     * @return \Sisteract\StructType\ProvinciaTerreniFabbricatiBean_Type
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        $this->provincia = $provincia;
        return $this;
    }
    /**
     * Get terreni value
     * @return int|null
     */
    public function getTerreni()
    {
        return $this->terreni;
    }
    /**
     * Set terreni value
     * @param int $terreni
     * @return \Sisteract\StructType\ProvinciaTerreniFabbricatiBean_Type
     */
    public function setTerreni($terreni = null)
    {
        // validation for constraint: int
        if (!is_null($terreni) && !(is_int($terreni) || ctype_digit($terreni))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terreni, true), gettype($terreni)), __LINE__);
        }
        $this->terreni = $terreni;
        return $this;
    }
}
