<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersoneFisicheBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean che rappresenta una persona fisica
 * @subpackage Structs
 */
class PersoneFisicheBean_Type extends AbstractStructBase
{
    /**
     * The codiceFiscale
     * Meta information extracted from the WSDL
     * - documentation: Codice fiscale della persona fisica
     * - nillable: true
     * @var string
     */
    public $codiceFiscale;
    /**
     * The cognome
     * Meta information extracted from the WSDL
     * - documentation: Cognome della persona fisica
     * - nillable: true
     * @var string
     */
    public $cognome;
    /**
     * The comuneNascita
     * Meta information extracted from the WSDL
     * - documentation: Comune di nascita della persona fisica
     * - nillable: true
     * @var string
     */
    public $comuneNascita;
    /**
     * The dataNascita
     * Meta information extracted from the WSDL
     * - documentation: Data di nascita della persona fisica (formato: yyyymmdd)
     * - nillable: true
     * @var string
     */
    public $dataNascita;
    /**
     * The idSoggetto
     * Meta information extracted from the WSDL
     * - documentation: Id del soggetto della persona fisica, l'Id e' assegnato dal sistema
     * - nillable: true
     * @var string
     */
    public $idSoggetto;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - documentation: Nome della persona fisica
     * - nillable: true
     * @var string
     */
    public $nome;
    /**
     * The provinciaNascita
     * Meta information extracted from the WSDL
     * - documentation: Provincia di nascita della persona fisica
     * - nillable: true
     * @var string
     */
    public $provinciaNascita;
    /**
     * The sesso
     * Meta information extracted from the WSDL
     * - documentation: Sesso della persona fisicaValori ammessi:M=MaschioF=Femmina
     * - nillable: true
     * @var string
     */
    public $sesso;
    /**
     * Constructor method for PersoneFisicheBean_Type
     * @uses PersoneFisicheBean_Type::setCodiceFiscale()
     * @uses PersoneFisicheBean_Type::setCognome()
     * @uses PersoneFisicheBean_Type::setComuneNascita()
     * @uses PersoneFisicheBean_Type::setDataNascita()
     * @uses PersoneFisicheBean_Type::setIdSoggetto()
     * @uses PersoneFisicheBean_Type::setNome()
     * @uses PersoneFisicheBean_Type::setProvinciaNascita()
     * @uses PersoneFisicheBean_Type::setSesso()
     * @param string $codiceFiscale
     * @param string $cognome
     * @param string $comuneNascita
     * @param string $dataNascita
     * @param string $idSoggetto
     * @param string $nome
     * @param string $provinciaNascita
     * @param string $sesso
     */
    public function __construct($codiceFiscale = null, $cognome = null, $comuneNascita = null, $dataNascita = null, $idSoggetto = null, $nome = null, $provinciaNascita = null, $sesso = null)
    {
        $this
            ->setCodiceFiscale($codiceFiscale)
            ->setCognome($cognome)
            ->setComuneNascita($comuneNascita)
            ->setDataNascita($dataNascita)
            ->setIdSoggetto($idSoggetto)
            ->setNome($nome)
            ->setProvinciaNascita($provinciaNascita)
            ->setSesso($sesso);
    }
    /**
     * Get codiceFiscale value
     * @return string|null
     */
    public function getCodiceFiscale()
    {
        return $this->codiceFiscale;
    }
    /**
     * Set codiceFiscale value
     * @param string $codiceFiscale
     * @return \Sisteract\StructType\PersoneFisicheBean_Type
     */
    public function setCodiceFiscale($codiceFiscale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscale) && !is_string($codiceFiscale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscale, true), gettype($codiceFiscale)), __LINE__);
        }
        $this->codiceFiscale = $codiceFiscale;
        return $this;
    }
    /**
     * Get cognome value
     * @return string|null
     */
    public function getCognome()
    {
        return $this->cognome;
    }
    /**
     * Set cognome value
     * @param string $cognome
     * @return \Sisteract\StructType\PersoneFisicheBean_Type
     */
    public function setCognome($cognome = null)
    {
        // validation for constraint: string
        if (!is_null($cognome) && !is_string($cognome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cognome, true), gettype($cognome)), __LINE__);
        }
        $this->cognome = $cognome;
        return $this;
    }
    /**
     * Get comuneNascita value
     * @return string|null
     */
    public function getComuneNascita()
    {
        return $this->comuneNascita;
    }
    /**
     * Set comuneNascita value
     * @param string $comuneNascita
     * @return \Sisteract\StructType\PersoneFisicheBean_Type
     */
    public function setComuneNascita($comuneNascita = null)
    {
        // validation for constraint: string
        if (!is_null($comuneNascita) && !is_string($comuneNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comuneNascita, true), gettype($comuneNascita)), __LINE__);
        }
        $this->comuneNascita = $comuneNascita;
        return $this;
    }
    /**
     * Get dataNascita value
     * @return string|null
     */
    public function getDataNascita()
    {
        return $this->dataNascita;
    }
    /**
     * Set dataNascita value
     * @param string $dataNascita
     * @return \Sisteract\StructType\PersoneFisicheBean_Type
     */
    public function setDataNascita($dataNascita = null)
    {
        // validation for constraint: string
        if (!is_null($dataNascita) && !is_string($dataNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataNascita, true), gettype($dataNascita)), __LINE__);
        }
        $this->dataNascita = $dataNascita;
        return $this;
    }
    /**
     * Get idSoggetto value
     * @return string|null
     */
    public function getIdSoggetto()
    {
        return $this->idSoggetto;
    }
    /**
     * Set idSoggetto value
     * @param string $idSoggetto
     * @return \Sisteract\StructType\PersoneFisicheBean_Type
     */
    public function setIdSoggetto($idSoggetto = null)
    {
        // validation for constraint: string
        if (!is_null($idSoggetto) && !is_string($idSoggetto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idSoggetto, true), gettype($idSoggetto)), __LINE__);
        }
        $this->idSoggetto = $idSoggetto;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \Sisteract\StructType\PersoneFisicheBean_Type
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get provinciaNascita value
     * @return string|null
     */
    public function getProvinciaNascita()
    {
        return $this->provinciaNascita;
    }
    /**
     * Set provinciaNascita value
     * @param string $provinciaNascita
     * @return \Sisteract\StructType\PersoneFisicheBean_Type
     */
    public function setProvinciaNascita($provinciaNascita = null)
    {
        // validation for constraint: string
        if (!is_null($provinciaNascita) && !is_string($provinciaNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinciaNascita, true), gettype($provinciaNascita)), __LINE__);
        }
        $this->provinciaNascita = $provinciaNascita;
        return $this;
    }
    /**
     * Get sesso value
     * @return string|null
     */
    public function getSesso()
    {
        return $this->sesso;
    }
    /**
     * Set sesso value
     * @param string $sesso
     * @return \Sisteract\StructType\PersoneFisicheBean_Type
     */
    public function setSesso($sesso = null)
    {
        // validation for constraint: string
        if (!is_null($sesso) && !is_string($sesso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sesso, true), gettype($sesso)), __LINE__);
        }
        $this->sesso = $sesso;
        return $this;
    }
}
