<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRichiestaVisuraSoggetto_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean dei parametri per ricevere le visure per Soggetto.questo bean, richiede la provincia su cui si vuole effettuale e ricevere la visura per soggetto La visura puo' essere richiesta in differita.
 * @subpackage Structs
 */
class ParametriRichiestaVisuraSoggetto_Type extends Session_Type
{
    /**
     * The differita
     * Meta information extracted from the WSDL
     * - documentation: Definisce se la visura deve essere richiesta in differitaTRUE=differitaFALSE=On line
     * @var bool
     */
    public $differita;
    /**
     * The provincia
     * Meta information extracted from the WSDL
     * - documentation: Sigla della provincia su cui fare la visura, il valore passato deve esserenella lista di quelli ritornati nell prcedente chiamata: getListaComuni
     * - nillable: true
     * @var string
     */
    public $provincia;
    /**
     * The tipoVisura
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tipoVisura;
    /**
     * Constructor method for ParametriRichiestaVisuraSoggetto_Type
     * @uses ParametriRichiestaVisuraSoggetto_Type::setDifferita()
     * @uses ParametriRichiestaVisuraSoggetto_Type::setProvincia()
     * @uses ParametriRichiestaVisuraSoggetto_Type::setTipoVisura()
     * @param bool $differita
     * @param string $provincia
     * @param string $tipoVisura
     */
    public function __construct($differita = null, $provincia = null, $tipoVisura = null)
    {
        $this
            ->setDifferita($differita)
            ->setProvincia($provincia)
            ->setTipoVisura($tipoVisura);
    }
    /**
     * Get differita value
     * @return bool|null
     */
    public function getDifferita()
    {
        return $this->differita;
    }
    /**
     * Set differita value
     * @param bool $differita
     * @return \Sisteract\StructType\ParametriRichiestaVisuraSoggetto_Type
     */
    public function setDifferita($differita = null)
    {
        // validation for constraint: boolean
        if (!is_null($differita) && !is_bool($differita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($differita, true), gettype($differita)), __LINE__);
        }
        $this->differita = $differita;
        return $this;
    }
    /**
     * Get provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->provincia;
    }
    /**
     * Set provincia value
     * @param string $provincia
     * @return \Sisteract\StructType\ParametriRichiestaVisuraSoggetto_Type
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        $this->provincia = $provincia;
        return $this;
    }
    /**
     * Get tipoVisura value
     * @return string|null
     */
    public function getTipoVisura()
    {
        return $this->tipoVisura;
    }
    /**
     * Set tipoVisura value
     * @uses \Sisteract\EnumType\EnumTipoVisura_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoVisura_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoVisura
     * @return \Sisteract\StructType\ParametriRichiestaVisuraSoggetto_Type
     */
    public function setTipoVisura($tipoVisura = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoVisura_Type::valueIsValid($tipoVisura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoVisura_Type', is_array($tipoVisura) ? implode(', ', $tipoVisura) : var_export($tipoVisura, true), implode(', ', \Sisteract\EnumType\EnumTipoVisura_Type::getValidValues())), __LINE__);
        }
        $this->tipoVisura = $tipoVisura;
        return $this;
    }
}
