<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRicercaPersonaGiuridicaBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean dei parametri per la ricerca di una persona giuridica su tutto il territorio nazionalela ricerca prevede l'uso dei dati anagrafici di denominazione.In alternativa o in aggiunta alla denominazione si puo' usare il codice
 * fiscale.Se si passa la provincia, la ricerca si limitera' sull'ufficio catastale della provincia.Se si passa il comune, la ricerca si limitera' al comune dell'ufficio catastale della provincia.Se non verranno passate ne provincia, ne comune la
 * ricerca verrà eseguita su pianta nazionaleil risultato sara' una lista di posizioni trovate, con sede e codice fiscale (ove presente)Nota:fare molta attenzione ad i parametri mandatari: omocodice e precisione ricerca. Per cio' si rimandala lettura
 * ad i parametri
 * @subpackage Structs
 */
class ParametriRicercaPersonaGiuridicaBean_Type extends Session_Type
{
    /**
     * The codiceComuneBeni
     * Meta information extracted from the WSDL
     * - documentation: codice catastale su cui cercare gli immobiliParametro esclusivo, rispetto alla provincia
     * - nillable: true
     * @var string
     */
    public $codiceComuneBeni;
    /**
     * The codiceFiscale
     * Meta information extracted from the WSDL
     * - documentation: Codice fiscale del soggetto giuridico che si vuole cercare
     * - nillable: true
     * @var string
     */
    public $codiceFiscale;
    /**
     * The denominazione
     * Meta information extracted from the WSDL
     * - documentation: Denominazione del soggetto giuridico che si vuole cercare
     * - nillable: true
     * @var string
     */
    public $denominazione;
    /**
     * The omoCodice
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per Omocodicevalori ammessi: RICERCA_OMOCODICEQuesta ricerca può essere applicata a tutti i soggetti per i quali e' stato fornito un codice fiscale.All'elenco degli omonimi ottenuto in seguito ad una ricerca ampliata oppure
     * ristretta vengono aggiunti anche tutti i soggetti il cui codice fiscale è uguale a quello di uno degli omonimi ottenuti dalla normale ricerca ristretta o ampliata.In tal modo è possibile reperire tutti quei soggetti per i quali è stato digitato
     * correttamente il codice fiscale, ma erroneamente il cognome e/o nome, oppure la denominazione.RICERCA_NO_OMOCODICENessun controllo su il risultato ottenutoparametro mandatario
     * @var string
     */
    public $omoCodice;
    /**
     * The precisioneRicerca
     * Meta information extracted from the WSDL
     * - documentation: Precisione della ricercavalori ammessi:RICERCA_AMPLIATA La ricerca ampliata per soggetto persona non fisica estrae tutti gli intestati la cui denominazione contenga in qualunque posizione (iniziale, finale o intermedia) la stringa
     * inserita nel campo denominazione della videata di ricerca. Nel caso il testo introdotto nella schermata di ricerca contenga più parole separate da spazi (al massimo 5 parole), per ciascuna parola si applica la modalità di ricerca suddetta. La
     * denominazione specificata nel campo denominazione della schermata di ricerca viene "ripulita" dalle parole non significative: vengono eliminate ad esempio sigle come SPA, Srl, lettere singole, DAI, DALLE, ecc.Esempi:Testo da ricercare: ROSSISoggetti
     * estratti:ROSSI LAVAGGILAVANDERIA ROSSINIROSSIROSSININon viene estratto invece il soggetto DEROSSI.Testo da ricercare: ROSSI VERDISoggetti estratti:VERDINO ROSSINIROSSI VERDIROSSINI LIVERDI OFFICINANon viene estratto invece il soggetto DEROSSI MAVERDI
     * *RICERCA_RISTRETTALa ricerca ristretta per soggetto persona non fisica estrae tutti gli intestati la cui denominazione (completa) oppure la prima parola della denominazione sia uguale stringa inserita nel campo denominazione della videata di
     * ricerca.parametro mandatario
     * @var string
     */
    public $precisioneRicerca;
    /**
     * The provinciaBeni
     * Meta information extracted from the WSDL
     * - documentation: provincia su cui cercare gli immobiliParametro esclusivo, rispetto al codice comune
     * - nillable: true
     * @var string
     */
    public $provinciaBeni;
    /**
     * The tipoRicerca
     * Meta information extracted from the WSDL
     * - documentation: Tipo di ricerca da effettualevalori ammessi: TIPO_RICERCA_TERRENI_FABBRICATI La ricerca viene fatta sia su il catasto terreni, che il catasto fabbricatiTIPO_RICERCA_FABBRICATI La ricerca viene fatta solo sul catasto
     * fabbricatiTIPO_RICERCA_TERRENI La ricerca viene fatta solo sul catasto terreni parametro mandatario
     * @var string
     */
    public $tipoRicerca;
    /**
     * The tipoRichiesta
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tipoRichiesta;
    /**
     * Constructor method for ParametriRicercaPersonaGiuridicaBean_Type
     * @uses ParametriRicercaPersonaGiuridicaBean_Type::setCodiceComuneBeni()
     * @uses ParametriRicercaPersonaGiuridicaBean_Type::setCodiceFiscale()
     * @uses ParametriRicercaPersonaGiuridicaBean_Type::setDenominazione()
     * @uses ParametriRicercaPersonaGiuridicaBean_Type::setOmoCodice()
     * @uses ParametriRicercaPersonaGiuridicaBean_Type::setPrecisioneRicerca()
     * @uses ParametriRicercaPersonaGiuridicaBean_Type::setProvinciaBeni()
     * @uses ParametriRicercaPersonaGiuridicaBean_Type::setTipoRicerca()
     * @uses ParametriRicercaPersonaGiuridicaBean_Type::setTipoRichiesta()
     * @param string $codiceComuneBeni
     * @param string $codiceFiscale
     * @param string $denominazione
     * @param string $omoCodice
     * @param string $precisioneRicerca
     * @param string $provinciaBeni
     * @param string $tipoRicerca
     * @param string $tipoRichiesta
     */
    public function __construct($codiceComuneBeni = null, $codiceFiscale = null, $denominazione = null, $omoCodice = null, $precisioneRicerca = null, $provinciaBeni = null, $tipoRicerca = null, $tipoRichiesta = null)
    {
        $this
            ->setCodiceComuneBeni($codiceComuneBeni)
            ->setCodiceFiscale($codiceFiscale)
            ->setDenominazione($denominazione)
            ->setOmoCodice($omoCodice)
            ->setPrecisioneRicerca($precisioneRicerca)
            ->setProvinciaBeni($provinciaBeni)
            ->setTipoRicerca($tipoRicerca)
            ->setTipoRichiesta($tipoRichiesta);
    }
    /**
     * Get codiceComuneBeni value
     * @return string|null
     */
    public function getCodiceComuneBeni()
    {
        return $this->codiceComuneBeni;
    }
    /**
     * Set codiceComuneBeni value
     * @param string $codiceComuneBeni
     * @return \Sisteract\StructType\ParametriRicercaPersonaGiuridicaBean_Type
     */
    public function setCodiceComuneBeni($codiceComuneBeni = null)
    {
        // validation for constraint: string
        if (!is_null($codiceComuneBeni) && !is_string($codiceComuneBeni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceComuneBeni, true), gettype($codiceComuneBeni)), __LINE__);
        }
        $this->codiceComuneBeni = $codiceComuneBeni;
        return $this;
    }
    /**
     * Get codiceFiscale value
     * @return string|null
     */
    public function getCodiceFiscale()
    {
        return $this->codiceFiscale;
    }
    /**
     * Set codiceFiscale value
     * @param string $codiceFiscale
     * @return \Sisteract\StructType\ParametriRicercaPersonaGiuridicaBean_Type
     */
    public function setCodiceFiscale($codiceFiscale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscale) && !is_string($codiceFiscale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscale, true), gettype($codiceFiscale)), __LINE__);
        }
        $this->codiceFiscale = $codiceFiscale;
        return $this;
    }
    /**
     * Get denominazione value
     * @return string|null
     */
    public function getDenominazione()
    {
        return $this->denominazione;
    }
    /**
     * Set denominazione value
     * @param string $denominazione
     * @return \Sisteract\StructType\ParametriRicercaPersonaGiuridicaBean_Type
     */
    public function setDenominazione($denominazione = null)
    {
        // validation for constraint: string
        if (!is_null($denominazione) && !is_string($denominazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($denominazione, true), gettype($denominazione)), __LINE__);
        }
        $this->denominazione = $denominazione;
        return $this;
    }
    /**
     * Get omoCodice value
     * @return string|null
     */
    public function getOmoCodice()
    {
        return $this->omoCodice;
    }
    /**
     * Set omoCodice value
     * @uses \Sisteract\EnumType\EnumOmocodice_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumOmocodice_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $omoCodice
     * @return \Sisteract\StructType\ParametriRicercaPersonaGiuridicaBean_Type
     */
    public function setOmoCodice($omoCodice = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumOmocodice_Type::valueIsValid($omoCodice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumOmocodice_Type', is_array($omoCodice) ? implode(', ', $omoCodice) : var_export($omoCodice, true), implode(', ', \Sisteract\EnumType\EnumOmocodice_Type::getValidValues())), __LINE__);
        }
        $this->omoCodice = $omoCodice;
        return $this;
    }
    /**
     * Get precisioneRicerca value
     * @return string|null
     */
    public function getPrecisioneRicerca()
    {
        return $this->precisioneRicerca;
    }
    /**
     * Set precisioneRicerca value
     * @uses \Sisteract\EnumType\EnumPrecisioneRicerca_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumPrecisioneRicerca_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $precisioneRicerca
     * @return \Sisteract\StructType\ParametriRicercaPersonaGiuridicaBean_Type
     */
    public function setPrecisioneRicerca($precisioneRicerca = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumPrecisioneRicerca_Type::valueIsValid($precisioneRicerca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumPrecisioneRicerca_Type', is_array($precisioneRicerca) ? implode(', ', $precisioneRicerca) : var_export($precisioneRicerca, true), implode(', ', \Sisteract\EnumType\EnumPrecisioneRicerca_Type::getValidValues())), __LINE__);
        }
        $this->precisioneRicerca = $precisioneRicerca;
        return $this;
    }
    /**
     * Get provinciaBeni value
     * @return string|null
     */
    public function getProvinciaBeni()
    {
        return $this->provinciaBeni;
    }
    /**
     * Set provinciaBeni value
     * @param string $provinciaBeni
     * @return \Sisteract\StructType\ParametriRicercaPersonaGiuridicaBean_Type
     */
    public function setProvinciaBeni($provinciaBeni = null)
    {
        // validation for constraint: string
        if (!is_null($provinciaBeni) && !is_string($provinciaBeni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinciaBeni, true), gettype($provinciaBeni)), __LINE__);
        }
        $this->provinciaBeni = $provinciaBeni;
        return $this;
    }
    /**
     * Get tipoRicerca value
     * @return string|null
     */
    public function getTipoRicerca()
    {
        return $this->tipoRicerca;
    }
    /**
     * Set tipoRicerca value
     * @uses \Sisteract\EnumType\EnumTipoRicerca_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoRicerca_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoRicerca
     * @return \Sisteract\StructType\ParametriRicercaPersonaGiuridicaBean_Type
     */
    public function setTipoRicerca($tipoRicerca = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoRicerca_Type::valueIsValid($tipoRicerca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoRicerca_Type', is_array($tipoRicerca) ? implode(', ', $tipoRicerca) : var_export($tipoRicerca, true), implode(', ', \Sisteract\EnumType\EnumTipoRicerca_Type::getValidValues())), __LINE__);
        }
        $this->tipoRicerca = $tipoRicerca;
        return $this;
    }
    /**
     * Get tipoRichiesta value
     * @return string|null
     */
    public function getTipoRichiesta()
    {
        return $this->tipoRichiesta;
    }
    /**
     * Set tipoRichiesta value
     * @uses \Sisteract\EnumType\EnumTipoRichiestaRicerca_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoRichiestaRicerca_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoRichiesta
     * @return \Sisteract\StructType\ParametriRicercaPersonaGiuridicaBean_Type
     */
    public function setTipoRichiesta($tipoRichiesta = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoRichiestaRicerca_Type::valueIsValid($tipoRichiesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoRichiestaRicerca_Type', is_array($tipoRichiesta) ? implode(', ', $tipoRichiesta) : var_export($tipoRichiesta, true), implode(', ', \Sisteract\EnumType\EnumTipoRichiestaRicerca_Type::getValidValues())), __LINE__);
        }
        $this->tipoRichiesta = $tipoRichiesta;
        return $this;
    }
}
