<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRicercaPersonaFisicaConservatoriaBean_Type
 * StructType
 * @subpackage Structs
 */
class ParametriRicercaPersonaFisicaConservatoriaBean_Type extends ParametriRicercaPersonaFisicaBean_Type
{
    /**
     * The conservatoria
     * Meta information extracted from the WSDL
     * - documentation: Ritorna conservatoria di interesse
     * @var string
     */
    public $conservatoria;
    /**
     * The costoMassimoAccettato
     * Meta information extracted from the WSDL
     * - documentation: Ritorna costo massimo che si è disposti ad accettare
     * @var float
     */
    public $costoMassimoAccettato;
    /**
     * The parametriRestrizioneFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna parametri per eventuali restrizioni sulle formalità
     * @var \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public $parametriRestrizioneFormalita;
    /**
     * Constructor method for ParametriRicercaPersonaFisicaConservatoriaBean_Type
     * @uses ParametriRicercaPersonaFisicaConservatoriaBean_Type::setConservatoria()
     * @uses ParametriRicercaPersonaFisicaConservatoriaBean_Type::setCostoMassimoAccettato()
     * @uses ParametriRicercaPersonaFisicaConservatoriaBean_Type::setParametriRestrizioneFormalita()
     * @param string $conservatoria
     * @param float $costoMassimoAccettato
     * @param \Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita
     */
    public function __construct($conservatoria = null, $costoMassimoAccettato = null, \Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita = null)
    {
        $this
            ->setConservatoria($conservatoria)
            ->setCostoMassimoAccettato($costoMassimoAccettato)
            ->setParametriRestrizioneFormalita($parametriRestrizioneFormalita);
    }
    /**
     * Get conservatoria value
     * @return string|null
     */
    public function getConservatoria()
    {
        return $this->conservatoria;
    }
    /**
     * Set conservatoria value
     * @param string $conservatoria
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaConservatoriaBean_Type
     */
    public function setConservatoria($conservatoria = null)
    {
        // validation for constraint: string
        if (!is_null($conservatoria) && !is_string($conservatoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conservatoria, true), gettype($conservatoria)), __LINE__);
        }
        $this->conservatoria = $conservatoria;
        return $this;
    }
    /**
     * Get costoMassimoAccettato value
     * @return float|null
     */
    public function getCostoMassimoAccettato()
    {
        return $this->costoMassimoAccettato;
    }
    /**
     * Set costoMassimoAccettato value
     * @param float $costoMassimoAccettato
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaConservatoriaBean_Type
     */
    public function setCostoMassimoAccettato($costoMassimoAccettato = null)
    {
        // validation for constraint: float
        if (!is_null($costoMassimoAccettato) && !(is_float($costoMassimoAccettato) || is_numeric($costoMassimoAccettato))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costoMassimoAccettato, true), gettype($costoMassimoAccettato)), __LINE__);
        }
        $this->costoMassimoAccettato = $costoMassimoAccettato;
        return $this;
    }
    /**
     * Get parametriRestrizioneFormalita value
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type|null
     */
    public function getParametriRestrizioneFormalita()
    {
        return $this->parametriRestrizioneFormalita;
    }
    /**
     * Set parametriRestrizioneFormalita value
     * @param \Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaConservatoriaBean_Type
     */
    public function setParametriRestrizioneFormalita(\Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita = null)
    {
        $this->parametriRestrizioneFormalita = $parametriRestrizioneFormalita;
        return $this;
    }
}
