<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRicercaImmobiliIndirizzo_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean dei parametri per la ottenere la listadegli immobili, partendo dal codice indirizzoottenuto dalla ricerca precedente (chiamata: getRicercaImmobiliIndirizzoNoToponimo)
 * @subpackage Structs
 */
class ParametriRicercaImmobiliIndirizzo_Type extends Session_Type
{
    /**
     * The codiceIndirizzo
     * Meta information extracted from the WSDL
     * - documentation: Codice indirizzo (codice interno al catasto), recuperato dalla ricerca senza toponimo
     * - nillable: true
     * @var string
     */
    public $codiceIndirizzo;
    /**
     * The numeroA
     * Meta information extracted from the WSDL
     * - documentation: Numero civico di arrivo per la ricerca
     * - nillable: true
     * @var string
     */
    public $numeroA;
    /**
     * The numeroDa
     * Meta information extracted from the WSDL
     * - documentation: Numero civico di partenza per la ricerca
     * - nillable: true
     * @var string
     */
    public $numeroDa;
    /**
     * Constructor method for ParametriRicercaImmobiliIndirizzo_Type
     * @uses ParametriRicercaImmobiliIndirizzo_Type::setCodiceIndirizzo()
     * @uses ParametriRicercaImmobiliIndirizzo_Type::setNumeroA()
     * @uses ParametriRicercaImmobiliIndirizzo_Type::setNumeroDa()
     * @param string $codiceIndirizzo
     * @param string $numeroA
     * @param string $numeroDa
     */
    public function __construct($codiceIndirizzo = null, $numeroA = null, $numeroDa = null)
    {
        $this
            ->setCodiceIndirizzo($codiceIndirizzo)
            ->setNumeroA($numeroA)
            ->setNumeroDa($numeroDa);
    }
    /**
     * Get codiceIndirizzo value
     * @return string|null
     */
    public function getCodiceIndirizzo()
    {
        return $this->codiceIndirizzo;
    }
    /**
     * Set codiceIndirizzo value
     * @param string $codiceIndirizzo
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIndirizzo_Type
     */
    public function setCodiceIndirizzo($codiceIndirizzo = null)
    {
        // validation for constraint: string
        if (!is_null($codiceIndirizzo) && !is_string($codiceIndirizzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceIndirizzo, true), gettype($codiceIndirizzo)), __LINE__);
        }
        $this->codiceIndirizzo = $codiceIndirizzo;
        return $this;
    }
    /**
     * Get numeroA value
     * @return string|null
     */
    public function getNumeroA()
    {
        return $this->numeroA;
    }
    /**
     * Set numeroA value
     * @param string $numeroA
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIndirizzo_Type
     */
    public function setNumeroA($numeroA = null)
    {
        // validation for constraint: string
        if (!is_null($numeroA) && !is_string($numeroA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroA, true), gettype($numeroA)), __LINE__);
        }
        $this->numeroA = $numeroA;
        return $this;
    }
    /**
     * Get numeroDa value
     * @return string|null
     */
    public function getNumeroDa()
    {
        return $this->numeroDa;
    }
    /**
     * Set numeroDa value
     * @param string $numeroDa
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIndirizzo_Type
     */
    public function setNumeroDa($numeroDa = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDa) && !is_string($numeroDa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDa, true), gettype($numeroDa)), __LINE__);
        }
        $this->numeroDa = $numeroDa;
        return $this;
    }
}
