<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriElencoFormalitaConservatoria_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Un soggetto per la richiesta dell'elenco formalità
 * @subpackage Structs
 */
class ParametriElencoFormalitaConservatoria_Type extends Session_Type
{
    /**
     * The costoMassimoAccettato
     * Meta information extracted from the WSDL
     * - documentation: Ritorna costo massimo che si è disposti ad impiegare per questa ricerca
     * @var float
     */
    public $costoMassimoAccettato;
    /**
     * The idSoggetto
     * Meta information extracted from the WSDL
     * - documentation: Ritorna identificativi dei soggetti di cui si vuole la lista formalità
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $idSoggetto;
    /**
     * The parametriRestrizioneFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica restrizioni sulle formalità da visualizzare in elenco
     * - nillable: true
     * @var \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public $parametriRestrizioneFormalita;
    /**
     * Constructor method for ParametriElencoFormalitaConservatoria_Type
     * @uses ParametriElencoFormalitaConservatoria_Type::setCostoMassimoAccettato()
     * @uses ParametriElencoFormalitaConservatoria_Type::setIdSoggetto()
     * @uses ParametriElencoFormalitaConservatoria_Type::setParametriRestrizioneFormalita()
     * @param float $costoMassimoAccettato
     * @param string[] $idSoggetto
     * @param \Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita
     */
    public function __construct($costoMassimoAccettato = null, array $idSoggetto = array(), \Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita = null)
    {
        $this
            ->setCostoMassimoAccettato($costoMassimoAccettato)
            ->setIdSoggetto($idSoggetto)
            ->setParametriRestrizioneFormalita($parametriRestrizioneFormalita);
    }
    /**
     * Get costoMassimoAccettato value
     * @return float|null
     */
    public function getCostoMassimoAccettato()
    {
        return $this->costoMassimoAccettato;
    }
    /**
     * Set costoMassimoAccettato value
     * @param float $costoMassimoAccettato
     * @return \Sisteract\StructType\ParametriElencoFormalitaConservatoria_Type
     */
    public function setCostoMassimoAccettato($costoMassimoAccettato = null)
    {
        // validation for constraint: float
        if (!is_null($costoMassimoAccettato) && !(is_float($costoMassimoAccettato) || is_numeric($costoMassimoAccettato))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costoMassimoAccettato, true), gettype($costoMassimoAccettato)), __LINE__);
        }
        $this->costoMassimoAccettato = $costoMassimoAccettato;
        return $this;
    }
    /**
     * Get idSoggetto value
     * @return string[]|null
     */
    public function getIdSoggetto()
    {
        return $this->idSoggetto;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSoggetto method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSoggetto method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSoggettoForArrayConstraintsFromSetIdSoggetto(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parametriElencoFormalitaConservatoria_TypeIdSoggettoItem) {
            // validation for constraint: itemType
            if (!is_string($parametriElencoFormalitaConservatoria_TypeIdSoggettoItem)) {
                $invalidValues[] = is_object($parametriElencoFormalitaConservatoria_TypeIdSoggettoItem) ? get_class($parametriElencoFormalitaConservatoria_TypeIdSoggettoItem) : sprintf('%s(%s)', gettype($parametriElencoFormalitaConservatoria_TypeIdSoggettoItem), var_export($parametriElencoFormalitaConservatoria_TypeIdSoggettoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSoggetto property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSoggetto value
     * @throws \InvalidArgumentException
     * @param string[] $idSoggetto
     * @return \Sisteract\StructType\ParametriElencoFormalitaConservatoria_Type
     */
    public function setIdSoggetto(array $idSoggetto = array())
    {
        // validation for constraint: array
        if ('' !== ($idSoggettoArrayErrorMessage = self::validateIdSoggettoForArrayConstraintsFromSetIdSoggetto($idSoggetto))) {
            throw new \InvalidArgumentException($idSoggettoArrayErrorMessage, __LINE__);
        }
        $this->idSoggetto = $idSoggetto;
        return $this;
    }
    /**
     * Add item to idSoggetto value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sisteract\StructType\ParametriElencoFormalitaConservatoria_Type
     */
    public function addToIdSoggetto($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The idSoggetto property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSoggetto[] = $item;
        return $this;
    }
    /**
     * Get parametriRestrizioneFormalita value
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type|null
     */
    public function getParametriRestrizioneFormalita()
    {
        return $this->parametriRestrizioneFormalita;
    }
    /**
     * Set parametriRestrizioneFormalita value
     * @param \Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita
     * @return \Sisteract\StructType\ParametriElencoFormalitaConservatoria_Type
     */
    public function setParametriRestrizioneFormalita(\Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita = null)
    {
        $this->parametriRestrizioneFormalita = $parametriRestrizioneFormalita;
        return $this;
    }
}
