<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImmobileDaElencoBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Rappresenta i dati di un immobile che si ottengono da una chiamata di "elenco immobili"
 * @subpackage Structs
 */
class ImmobileDaElencoBean_Type extends AbstractStructBase
{
    /**
     * The classamento
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $classamento;
    /**
     * The classe
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $classe;
    /**
     * The consis
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consis;
    /**
     * The foglioOTipo
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il foglio o tipo dell'immobile
     * - nillable: true
     * @var string
     */
    public $foglioOTipo;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $key;
    /**
     * The particellaONumero
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la particella o il numero dell'immobile
     * - nillable: true
     * @var string
     */
    public $particellaONumero;
    /**
     * The partita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la partita dell'immobile.
     * - nillable: true
     * @var string
     */
    public $partita;
    /**
     * The rendita
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $rendita;
    /**
     * The subOAnno
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il sub o l'anno dell'immobile.
     * - nillable: true
     * @var string
     */
    public $subOAnno;
    /**
     * The tipoCatasto
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il tipo del catasto dove è censito l'immobile.
     * @var string
     */
    public $tipoCatasto;
    /**
     * The titolarita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna l'indicazione della titolarità dell'immobile(es. Proprietà per 1/2)
     * - nillable: true
     * @var string
     */
    public $titolarita;
    /**
     * The ubicazione
     * Meta information extracted from the WSDL
     * - documentation: Ritorna l'ubicazione dell'immobile
     * - nillable: true
     * @var string
     */
    public $ubicazione;
    /**
     * Constructor method for ImmobileDaElencoBean_Type
     * @uses ImmobileDaElencoBean_Type::setClassamento()
     * @uses ImmobileDaElencoBean_Type::setClasse()
     * @uses ImmobileDaElencoBean_Type::setConsis()
     * @uses ImmobileDaElencoBean_Type::setFoglioOTipo()
     * @uses ImmobileDaElencoBean_Type::setKey()
     * @uses ImmobileDaElencoBean_Type::setParticellaONumero()
     * @uses ImmobileDaElencoBean_Type::setPartita()
     * @uses ImmobileDaElencoBean_Type::setRendita()
     * @uses ImmobileDaElencoBean_Type::setSubOAnno()
     * @uses ImmobileDaElencoBean_Type::setTipoCatasto()
     * @uses ImmobileDaElencoBean_Type::setTitolarita()
     * @uses ImmobileDaElencoBean_Type::setUbicazione()
     * @param string $classamento
     * @param string $classe
     * @param string $consis
     * @param string $foglioOTipo
     * @param string $key
     * @param string $particellaONumero
     * @param string $partita
     * @param string $rendita
     * @param string $subOAnno
     * @param string $tipoCatasto
     * @param string $titolarita
     * @param string $ubicazione
     */
    public function __construct($classamento = null, $classe = null, $consis = null, $foglioOTipo = null, $key = null, $particellaONumero = null, $partita = null, $rendita = null, $subOAnno = null, $tipoCatasto = null, $titolarita = null, $ubicazione = null)
    {
        $this
            ->setClassamento($classamento)
            ->setClasse($classe)
            ->setConsis($consis)
            ->setFoglioOTipo($foglioOTipo)
            ->setKey($key)
            ->setParticellaONumero($particellaONumero)
            ->setPartita($partita)
            ->setRendita($rendita)
            ->setSubOAnno($subOAnno)
            ->setTipoCatasto($tipoCatasto)
            ->setTitolarita($titolarita)
            ->setUbicazione($ubicazione);
    }
    /**
     * Get classamento value
     * @return string|null
     */
    public function getClassamento()
    {
        return $this->classamento;
    }
    /**
     * Set classamento value
     * @param string $classamento
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setClassamento($classamento = null)
    {
        // validation for constraint: string
        if (!is_null($classamento) && !is_string($classamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classamento, true), gettype($classamento)), __LINE__);
        }
        $this->classamento = $classamento;
        return $this;
    }
    /**
     * Get classe value
     * @return string|null
     */
    public function getClasse()
    {
        return $this->classe;
    }
    /**
     * Set classe value
     * @param string $classe
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setClasse($classe = null)
    {
        // validation for constraint: string
        if (!is_null($classe) && !is_string($classe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classe, true), gettype($classe)), __LINE__);
        }
        $this->classe = $classe;
        return $this;
    }
    /**
     * Get consis value
     * @return string|null
     */
    public function getConsis()
    {
        return $this->consis;
    }
    /**
     * Set consis value
     * @param string $consis
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setConsis($consis = null)
    {
        // validation for constraint: string
        if (!is_null($consis) && !is_string($consis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consis, true), gettype($consis)), __LINE__);
        }
        $this->consis = $consis;
        return $this;
    }
    /**
     * Get foglioOTipo value
     * @return string|null
     */
    public function getFoglioOTipo()
    {
        return $this->foglioOTipo;
    }
    /**
     * Set foglioOTipo value
     * @param string $foglioOTipo
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setFoglioOTipo($foglioOTipo = null)
    {
        // validation for constraint: string
        if (!is_null($foglioOTipo) && !is_string($foglioOTipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foglioOTipo, true), gettype($foglioOTipo)), __LINE__);
        }
        $this->foglioOTipo = $foglioOTipo;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get particellaONumero value
     * @return string|null
     */
    public function getParticellaONumero()
    {
        return $this->particellaONumero;
    }
    /**
     * Set particellaONumero value
     * @param string $particellaONumero
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setParticellaONumero($particellaONumero = null)
    {
        // validation for constraint: string
        if (!is_null($particellaONumero) && !is_string($particellaONumero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($particellaONumero, true), gettype($particellaONumero)), __LINE__);
        }
        $this->particellaONumero = $particellaONumero;
        return $this;
    }
    /**
     * Get partita value
     * @return string|null
     */
    public function getPartita()
    {
        return $this->partita;
    }
    /**
     * Set partita value
     * @param string $partita
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setPartita($partita = null)
    {
        // validation for constraint: string
        if (!is_null($partita) && !is_string($partita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partita, true), gettype($partita)), __LINE__);
        }
        $this->partita = $partita;
        return $this;
    }
    /**
     * Get rendita value
     * @return string|null
     */
    public function getRendita()
    {
        return $this->rendita;
    }
    /**
     * Set rendita value
     * @param string $rendita
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setRendita($rendita = null)
    {
        // validation for constraint: string
        if (!is_null($rendita) && !is_string($rendita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rendita, true), gettype($rendita)), __LINE__);
        }
        $this->rendita = $rendita;
        return $this;
    }
    /**
     * Get subOAnno value
     * @return string|null
     */
    public function getSubOAnno()
    {
        return $this->subOAnno;
    }
    /**
     * Set subOAnno value
     * @param string $subOAnno
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setSubOAnno($subOAnno = null)
    {
        // validation for constraint: string
        if (!is_null($subOAnno) && !is_string($subOAnno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subOAnno, true), gettype($subOAnno)), __LINE__);
        }
        $this->subOAnno = $subOAnno;
        return $this;
    }
    /**
     * Get tipoCatasto value
     * @return string|null
     */
    public function getTipoCatasto()
    {
        return $this->tipoCatasto;
    }
    /**
     * Set tipoCatasto value
     * @uses \Sisteract\EnumType\TipoCatasto_Type::valueIsValid()
     * @uses \Sisteract\EnumType\TipoCatasto_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoCatasto
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setTipoCatasto($tipoCatasto = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\TipoCatasto_Type::valueIsValid($tipoCatasto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\TipoCatasto_Type', is_array($tipoCatasto) ? implode(', ', $tipoCatasto) : var_export($tipoCatasto, true), implode(', ', \Sisteract\EnumType\TipoCatasto_Type::getValidValues())), __LINE__);
        }
        $this->tipoCatasto = $tipoCatasto;
        return $this;
    }
    /**
     * Get titolarita value
     * @return string|null
     */
    public function getTitolarita()
    {
        return $this->titolarita;
    }
    /**
     * Set titolarita value
     * @param string $titolarita
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setTitolarita($titolarita = null)
    {
        // validation for constraint: string
        if (!is_null($titolarita) && !is_string($titolarita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titolarita, true), gettype($titolarita)), __LINE__);
        }
        $this->titolarita = $titolarita;
        return $this;
    }
    /**
     * Get ubicazione value
     * @return string|null
     */
    public function getUbicazione()
    {
        return $this->ubicazione;
    }
    /**
     * Set ubicazione value
     * @param string $ubicazione
     * @return \Sisteract\StructType\ImmobileDaElencoBean_Type
     */
    public function setUbicazione($ubicazione = null)
    {
        // validation for constraint: string
        if (!is_null($ubicazione) && !is_string($ubicazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ubicazione, true), gettype($ubicazione)), __LINE__);
        }
        $this->ubicazione = $ubicazione;
        return $this;
    }
}
