<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComuniBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean che riporta tutti i comuni, questi sono estratti giornalmente dal sistema centralee riportano la data di aggiornamento della provincia
 * @subpackage Structs
 */
class ComuniBean_Type extends AbstractStructBase
{
    /**
     * The codice
     * Meta information extracted from the WSDL
     * - documentation: Codice catastale del comune
     * - nillable: true
     * @var string
     */
    public $codice;
    /**
     * The dataAggiornamento
     * Meta information extracted from the WSDL
     * - documentation: data di aggiornamento dei dati catastali del comune.Nota: Deriva dalla provincia di appartenenza
     * - nillable: true
     * @var string
     */
    public $dataAggiornamento;
    /**
     * The dbHost
     * Meta information extracted from the WSDL
     * - documentation: Host Db, su dove si devono effettuare le interrogazioniNota: Questo valore deve eessere ripassato in maniera trasparente
     * - nillable: true
     * @var string
     */
    public $dbHost;
    /**
     * The descrizione
     * Meta information extracted from the WSDL
     * - documentation: Descrizione del comune
     * - nillable: true
     * @var string
     */
    public $descrizione;
    /**
     * The descrizioneConservatoria
     * Meta information extracted from the WSDL
     * - documentation: Ritorna descrizione della conservatoria di pertinenza
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $descrizioneConservatoria;
    /**
     * The provincia
     * Meta information extracted from the WSDL
     * - documentation: Provincia di appartenenza del comune
     * - nillable: true
     * @var string
     */
    public $provincia;
    /**
     * Constructor method for ComuniBean_Type
     * @uses ComuniBean_Type::setCodice()
     * @uses ComuniBean_Type::setDataAggiornamento()
     * @uses ComuniBean_Type::setDbHost()
     * @uses ComuniBean_Type::setDescrizione()
     * @uses ComuniBean_Type::setDescrizioneConservatoria()
     * @uses ComuniBean_Type::setProvincia()
     * @param string $codice
     * @param string $dataAggiornamento
     * @param string $dbHost
     * @param string $descrizione
     * @param string $descrizioneConservatoria
     * @param string $provincia
     */
    public function __construct($codice = null, $dataAggiornamento = null, $dbHost = null, $descrizione = null, $descrizioneConservatoria = null, $provincia = null)
    {
        $this
            ->setCodice($codice)
            ->setDataAggiornamento($dataAggiornamento)
            ->setDbHost($dbHost)
            ->setDescrizione($descrizione)
            ->setDescrizioneConservatoria($descrizioneConservatoria)
            ->setProvincia($provincia);
    }
    /**
     * Get codice value
     * @return string|null
     */
    public function getCodice()
    {
        return $this->codice;
    }
    /**
     * Set codice value
     * @param string $codice
     * @return \Sisteract\StructType\ComuniBean_Type
     */
    public function setCodice($codice = null)
    {
        // validation for constraint: string
        if (!is_null($codice) && !is_string($codice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codice, true), gettype($codice)), __LINE__);
        }
        $this->codice = $codice;
        return $this;
    }
    /**
     * Get dataAggiornamento value
     * @return string|null
     */
    public function getDataAggiornamento()
    {
        return $this->dataAggiornamento;
    }
    /**
     * Set dataAggiornamento value
     * @param string $dataAggiornamento
     * @return \Sisteract\StructType\ComuniBean_Type
     */
    public function setDataAggiornamento($dataAggiornamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataAggiornamento) && !is_string($dataAggiornamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAggiornamento, true), gettype($dataAggiornamento)), __LINE__);
        }
        $this->dataAggiornamento = $dataAggiornamento;
        return $this;
    }
    /**
     * Get dbHost value
     * @return string|null
     */
    public function getDbHost()
    {
        return $this->dbHost;
    }
    /**
     * Set dbHost value
     * @param string $dbHost
     * @return \Sisteract\StructType\ComuniBean_Type
     */
    public function setDbHost($dbHost = null)
    {
        // validation for constraint: string
        if (!is_null($dbHost) && !is_string($dbHost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dbHost, true), gettype($dbHost)), __LINE__);
        }
        $this->dbHost = $dbHost;
        return $this;
    }
    /**
     * Get descrizione value
     * @return string|null
     */
    public function getDescrizione()
    {
        return $this->descrizione;
    }
    /**
     * Set descrizione value
     * @param string $descrizione
     * @return \Sisteract\StructType\ComuniBean_Type
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        $this->descrizione = $descrizione;
        return $this;
    }
    /**
     * Get descrizioneConservatoria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizioneConservatoria()
    {
        return isset($this->descrizioneConservatoria) ? $this->descrizioneConservatoria : null;
    }
    /**
     * Set descrizioneConservatoria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizioneConservatoria
     * @return \Sisteract\StructType\ComuniBean_Type
     */
    public function setDescrizioneConservatoria($descrizioneConservatoria = null)
    {
        // validation for constraint: string
        if (!is_null($descrizioneConservatoria) && !is_string($descrizioneConservatoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizioneConservatoria, true), gettype($descrizioneConservatoria)), __LINE__);
        }
        if (is_null($descrizioneConservatoria) || (is_array($descrizioneConservatoria) && empty($descrizioneConservatoria))) {
            unset($this->descrizioneConservatoria);
        } else {
            $this->descrizioneConservatoria = $descrizioneConservatoria;
        }
        return $this;
    }
    /**
     * Get provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->provincia;
    }
    /**
     * Set provincia value
     * @param string $provincia
     * @return \Sisteract\StructType\ComuniBean_Type
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        $this->provincia = $provincia;
        return $this;
    }
}
