<?php

namespace Sisteract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Setta ServiceType
 * @subpackage Services
 */
class Setta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named settaAvvertimentoBudget
     * Meta information extracted from the WSDL
     * - documentation: Setta sul sistema i limiti di avvertimento per un azienda.Il sistema provvederà a spedire una mail a tutti gli indirizzi passati al momento in cui il budgetsul sister va sotto al limite impostato.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\SettaAvvertimentoBudgetIn_Type $part1
     * @return \Sisteract\StructType\SettaAvvertimentoBudgetOut_Type|bool
     */
    public function settaAvvertimentoBudget(\Sisteract\StructType\SettaAvvertimentoBudgetIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->settaAvvertimentoBudget($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sisteract\StructType\SettaAvvertimentoBudgetOut_Type
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
