<?php

namespace Sisteract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Apri ServiceType
 * @subpackage Services
 */
class Apri extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named apriSessione
     * Meta information extracted from the WSDL
     * - documentation: Apre una sessione di lavoro abilitando la modalità batch.A cose normali il sistema cerca di ottimizzare la gestione delle password per garantire che una unica password,fatte salve le normali limitazioni del Sister, possa servire
     * richieste provenienti da client diversi. Questo è il tipicocaso di utilizzo dei web service, in cui non è garantito che una richiesta venga dallo stesso client della richiestaprecedente.Questo comporta un aggravio prestazionale, in quanto non
     * sapendo a che punto siamo arrivati con la navigazione al momento precedente,il sistema per ogni richiesta è costretto a ripetere tutte le richieste fatte dall'inizio per ogni richiesta che arriva.Ci sono però casi, tipicamente lavorazioni batch di
     * grossi lotti di richieste, in cui le richieste arrivano tutte dallo stesso client. Inquesti casi si desidera la massima prestazionalità, per questo è stata introdotta questa modalità.Per sfruttare il nuovo sistema si dovrà quindi effettuare
     * questa chiamata per "aprire una sessione" verso il sister. Da notare che,una volta aperta, la sessione rimarrà inutilizzabile per altre richieste e sarà riservata al client che ha effettuato questa chiamata.Esiziale rilasciare la sessione tramite
     * la chiudiSessione al termine dei lavori, altrimenti la sessione rimarrà riservata sul sistema enon sarà possibile riutilizzarla fino alla prossima chiamata alla chiudiSessione o apriSessione.Da notare che, per le password con sessione aperta, non
     * sarà possibile effettuare il controllo delle richieste in differita finchè la password sarà in sessione.Tale controllo riprenderà nel momento in cui si uscirà dalla sessione.Si ricorda che, una volta aperta la sessione sarà necessario passare a
     * tutte le chiamate successive il sessionID rilasciato daquesta chiamata.E' possibile aprire la sessione solo in modalità gestita, ovvero se la password che si intende riservare è memorizzata sul sistema.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\ApriSessioneIn_Type $part1
     * @return \Sisteract\StructType\ApriSessioneOut_Type|bool
     */
    public function apriSessione(\Sisteract\StructType\ApriSessioneIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->apriSessione($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sisteract\StructType\ApriSessioneOut_Type
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
