<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerificationResult StructType
 * @subpackage Structs
 */
class VerificationResult extends AbstractStructBase
{
    /**
     * The SigningDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SigningDate;
    /**
     * The IsVerified
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsVerified;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * Constructor method for VerificationResult
     * @uses VerificationResult::setSigningDate()
     * @uses VerificationResult::setIsVerified()
     * @uses VerificationResult::setData()
     * @param string $signingDate
     * @param bool $isVerified
     * @param string $data
     */
    public function __construct($signingDate = null, $isVerified = null, $data = null)
    {
        $this
            ->setSigningDate($signingDate)
            ->setIsVerified($isVerified)
            ->setData($data);
    }
    /**
     * Get SigningDate value
     * @return string
     */
    public function getSigningDate()
    {
        return $this->SigningDate;
    }
    /**
     * Set SigningDate value
     * @param string $signingDate
     * @return \Novadan\Uyumsoft\StructType\VerificationResult
     */
    public function setSigningDate($signingDate = null)
    {
        // validation for constraint: string
        if (!is_null($signingDate) && !is_string($signingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signingDate, true), gettype($signingDate)), __LINE__);
        }
        $this->SigningDate = $signingDate;
        return $this;
    }
    /**
     * Get IsVerified value
     * @return bool
     */
    public function getIsVerified()
    {
        return $this->IsVerified;
    }
    /**
     * Set IsVerified value
     * @param bool $isVerified
     * @return \Novadan\Uyumsoft\StructType\VerificationResult
     */
    public function setIsVerified($isVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerified) && !is_bool($isVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerified, true), gettype($isVerified)), __LINE__);
        }
        $this->IsVerified = $isVerified;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \Novadan\Uyumsoft\StructType\VerificationResult
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
}
