<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StowageType StructType
 * @subpackage Structs
 */
class StowageType extends AbstractStructBase
{
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q203:LocationID
     * @var \Novadan\Uyumsoft\StructType\LocationIDType
     */
    public $LocationID;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q204:Location
     * @var \Novadan\Uyumsoft\StructType\LocationType[]
     */
    public $Location;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for StowageType
     * @uses StowageType::setLocationID()
     * @uses StowageType::setLocation()
     * @uses StowageType::setMeasurementDimension()
     * @param \Novadan\Uyumsoft\StructType\LocationIDType $locationID
     * @param \Novadan\Uyumsoft\StructType\LocationType[] $location
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Novadan\Uyumsoft\StructType\LocationIDType $locationID = null, array $location = array(), array $measurementDimension = array())
    {
        $this
            ->setLocationID($locationID)
            ->setLocation($location)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get LocationID value
     * @return \Novadan\Uyumsoft\StructType\LocationIDType|null
     */
    public function getLocationID()
    {
        return $this->LocationID;
    }
    /**
     * Set LocationID value
     * @param \Novadan\Uyumsoft\StructType\LocationIDType $locationID
     * @return \Novadan\Uyumsoft\StructType\StowageType
     */
    public function setLocationID(\Novadan\Uyumsoft\StructType\LocationIDType $locationID = null)
    {
        $this->LocationID = $locationID;
        return $this;
    }
    /**
     * Get Location value
     * @return \Novadan\Uyumsoft\StructType\LocationType[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stowageTypeLocationItem) {
            // validation for constraint: itemType
            if (!$stowageTypeLocationItem instanceof \Novadan\Uyumsoft\StructType\LocationType) {
                $invalidValues[] = is_object($stowageTypeLocationItem) ? get_class($stowageTypeLocationItem) : sprintf('%s(%s)', gettype($stowageTypeLocationItem), var_export($stowageTypeLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location property can only contain items of type \Novadan\Uyumsoft\StructType\LocationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\LocationType[] $location
     * @return \Novadan\Uyumsoft\StructType\StowageType
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\LocationType $item
     * @return \Novadan\Uyumsoft\StructType\StowageType
     */
    public function addToLocation(\Novadan\Uyumsoft\StructType\LocationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\LocationType) {
            throw new \InvalidArgumentException(sprintf('The Location property can only contain items of type \Novadan\Uyumsoft\StructType\LocationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Novadan\Uyumsoft\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stowageTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$stowageTypeMeasurementDimensionItem instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
                $invalidValues[] = is_object($stowageTypeMeasurementDimensionItem) ? get_class($stowageTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($stowageTypeMeasurementDimensionItem), var_export($stowageTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     * @return \Novadan\Uyumsoft\StructType\StowageType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType $item
     * @return \Novadan\Uyumsoft\StructType\StowageType
     */
    public function addToMeasurementDimension(\Novadan\Uyumsoft\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
