<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueInvoiceNotificationRequest StructType
 * @subpackage Structs
 */
class QueueInvoiceNotificationRequest extends AbstractStructBase
{
    /**
     * The Mailing
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\MailingInformation[]
     */
    public $Mailing;
    /**
     * The Messaging
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\SmsMessageInformation[]
     */
    public $Messaging;
    /**
     * The DocumentId
     * @var string
     */
    public $DocumentId;
    /**
     * Constructor method for QueueInvoiceNotificationRequest
     * @uses QueueInvoiceNotificationRequest::setMailing()
     * @uses QueueInvoiceNotificationRequest::setMessaging()
     * @uses QueueInvoiceNotificationRequest::setDocumentId()
     * @param \Novadan\Uyumsoft\StructType\MailingInformation[] $mailing
     * @param \Novadan\Uyumsoft\StructType\SmsMessageInformation[] $messaging
     * @param string $documentId
     */
    public function __construct(array $mailing = array(), array $messaging = array(), $documentId = null)
    {
        $this
            ->setMailing($mailing)
            ->setMessaging($messaging)
            ->setDocumentId($documentId);
    }
    /**
     * Get Mailing value
     * @return \Novadan\Uyumsoft\StructType\MailingInformation[]|null
     */
    public function getMailing()
    {
        return $this->Mailing;
    }
    /**
     * This method is responsible for validating the values passed to the setMailing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMailing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMailingForArrayConstraintsFromSetMailing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $queueInvoiceNotificationRequestMailingItem) {
            // validation for constraint: itemType
            if (!$queueInvoiceNotificationRequestMailingItem instanceof \Novadan\Uyumsoft\StructType\MailingInformation) {
                $invalidValues[] = is_object($queueInvoiceNotificationRequestMailingItem) ? get_class($queueInvoiceNotificationRequestMailingItem) : sprintf('%s(%s)', gettype($queueInvoiceNotificationRequestMailingItem), var_export($queueInvoiceNotificationRequestMailingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mailing property can only contain items of type \Novadan\Uyumsoft\StructType\MailingInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mailing value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\MailingInformation[] $mailing
     * @return \Novadan\Uyumsoft\StructType\QueueInvoiceNotificationRequest
     */
    public function setMailing(array $mailing = array())
    {
        // validation for constraint: array
        if ('' !== ($mailingArrayErrorMessage = self::validateMailingForArrayConstraintsFromSetMailing($mailing))) {
            throw new \InvalidArgumentException($mailingArrayErrorMessage, __LINE__);
        }
        $this->Mailing = $mailing;
        return $this;
    }
    /**
     * Add item to Mailing value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\MailingInformation $item
     * @return \Novadan\Uyumsoft\StructType\QueueInvoiceNotificationRequest
     */
    public function addToMailing(\Novadan\Uyumsoft\StructType\MailingInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\MailingInformation) {
            throw new \InvalidArgumentException(sprintf('The Mailing property can only contain items of type \Novadan\Uyumsoft\StructType\MailingInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mailing[] = $item;
        return $this;
    }
    /**
     * Get Messaging value
     * @return \Novadan\Uyumsoft\StructType\SmsMessageInformation[]|null
     */
    public function getMessaging()
    {
        return $this->Messaging;
    }
    /**
     * This method is responsible for validating the values passed to the setMessaging method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessaging method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessagingForArrayConstraintsFromSetMessaging(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $queueInvoiceNotificationRequestMessagingItem) {
            // validation for constraint: itemType
            if (!$queueInvoiceNotificationRequestMessagingItem instanceof \Novadan\Uyumsoft\StructType\SmsMessageInformation) {
                $invalidValues[] = is_object($queueInvoiceNotificationRequestMessagingItem) ? get_class($queueInvoiceNotificationRequestMessagingItem) : sprintf('%s(%s)', gettype($queueInvoiceNotificationRequestMessagingItem), var_export($queueInvoiceNotificationRequestMessagingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Messaging property can only contain items of type \Novadan\Uyumsoft\StructType\SmsMessageInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Messaging value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SmsMessageInformation[] $messaging
     * @return \Novadan\Uyumsoft\StructType\QueueInvoiceNotificationRequest
     */
    public function setMessaging(array $messaging = array())
    {
        // validation for constraint: array
        if ('' !== ($messagingArrayErrorMessage = self::validateMessagingForArrayConstraintsFromSetMessaging($messaging))) {
            throw new \InvalidArgumentException($messagingArrayErrorMessage, __LINE__);
        }
        $this->Messaging = $messaging;
        return $this;
    }
    /**
     * Add item to Messaging value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SmsMessageInformation $item
     * @return \Novadan\Uyumsoft\StructType\QueueInvoiceNotificationRequest
     */
    public function addToMessaging(\Novadan\Uyumsoft\StructType\SmsMessageInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\SmsMessageInformation) {
            throw new \InvalidArgumentException(sprintf('The Messaging property can only contain items of type \Novadan\Uyumsoft\StructType\SmsMessageInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Messaging[] = $item;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \Novadan\Uyumsoft\StructType\QueueInvoiceNotificationRequest
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }
}
