<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutboxInvoiceListItem StructType
 * @subpackage Structs
 */
class OutboxInvoiceListItem extends InvoiceListItemBase
{
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Scenario;
    /**
     * The ScenarioCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ScenarioCode;
    /**
     * The LocalDocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalDocumentId;
    /**
     * The ExtraInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtraInformation;
    /**
     * Constructor method for OutboxInvoiceListItem
     * @uses OutboxInvoiceListItem::setScenario()
     * @uses OutboxInvoiceListItem::setScenarioCode()
     * @uses OutboxInvoiceListItem::setLocalDocumentId()
     * @uses OutboxInvoiceListItem::setExtraInformation()
     * @param string $scenario
     * @param int $scenarioCode
     * @param string $localDocumentId
     * @param string $extraInformation
     */
    public function __construct($scenario = null, $scenarioCode = null, $localDocumentId = null, $extraInformation = null)
    {
        $this
            ->setScenario($scenario)
            ->setScenarioCode($scenarioCode)
            ->setLocalDocumentId($localDocumentId)
            ->setExtraInformation($extraInformation);
    }
    /**
     * Get Scenario value
     * @return string
     */
    public function getScenario()
    {
        return $this->Scenario;
    }
    /**
     * Set Scenario value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceScenarioType::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceScenarioType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scenario
     * @return \Novadan\Uyumsoft\StructType\OutboxInvoiceListItem
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\InvoiceScenarioType::valueIsValid($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceScenarioType', is_array($scenario) ? implode(', ', $scenario) : var_export($scenario, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceScenarioType::getValidValues())), __LINE__);
        }
        $this->Scenario = $scenario;
        return $this;
    }
    /**
     * Get ScenarioCode value
     * @return int
     */
    public function getScenarioCode()
    {
        return $this->ScenarioCode;
    }
    /**
     * Set ScenarioCode value
     * @param int $scenarioCode
     * @return \Novadan\Uyumsoft\StructType\OutboxInvoiceListItem
     */
    public function setScenarioCode($scenarioCode = null)
    {
        // validation for constraint: int
        if (!is_null($scenarioCode) && !(is_int($scenarioCode) || ctype_digit($scenarioCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scenarioCode, true), gettype($scenarioCode)), __LINE__);
        }
        $this->ScenarioCode = $scenarioCode;
        return $this;
    }
    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }
    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return \Novadan\Uyumsoft\StructType\OutboxInvoiceListItem
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($localDocumentId) && !is_string($localDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDocumentId, true), gettype($localDocumentId)), __LINE__);
        }
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }
    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return \Novadan\Uyumsoft\StructType\OutboxInvoiceListItem
     */
    public function setExtraInformation($extraInformation = null)
    {
        // validation for constraint: string
        if (!is_null($extraInformation) && !is_string($extraInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInformation, true), gettype($extraInformation)), __LINE__);
        }
        $this->ExtraInformation = $extraInformation;
        return $this;
    }
}
