<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationInformation StructType
 * @subpackage Structs
 */
class NotificationInformation extends AbstractStructBase
{
    /**
     * The Mailing
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\MailingInformation[]
     */
    public $Mailing;
    /**
     * The Messaging
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\SmsMessageInformation[]
     */
    public $Messaging;
    /**
     * Constructor method for NotificationInformation
     * @uses NotificationInformation::setMailing()
     * @uses NotificationInformation::setMessaging()
     * @param \Novadan\Uyumsoft\StructType\MailingInformation[] $mailing
     * @param \Novadan\Uyumsoft\StructType\SmsMessageInformation[] $messaging
     */
    public function __construct(array $mailing = array(), array $messaging = array())
    {
        $this
            ->setMailing($mailing)
            ->setMessaging($messaging);
    }
    /**
     * Get Mailing value
     * @return \Novadan\Uyumsoft\StructType\MailingInformation[]|null
     */
    public function getMailing()
    {
        return $this->Mailing;
    }
    /**
     * This method is responsible for validating the values passed to the setMailing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMailing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMailingForArrayConstraintsFromSetMailing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $notificationInformationMailingItem) {
            // validation for constraint: itemType
            if (!$notificationInformationMailingItem instanceof \Novadan\Uyumsoft\StructType\MailingInformation) {
                $invalidValues[] = is_object($notificationInformationMailingItem) ? get_class($notificationInformationMailingItem) : sprintf('%s(%s)', gettype($notificationInformationMailingItem), var_export($notificationInformationMailingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mailing property can only contain items of type \Novadan\Uyumsoft\StructType\MailingInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mailing value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\MailingInformation[] $mailing
     * @return \Novadan\Uyumsoft\StructType\NotificationInformation
     */
    public function setMailing(array $mailing = array())
    {
        // validation for constraint: array
        if ('' !== ($mailingArrayErrorMessage = self::validateMailingForArrayConstraintsFromSetMailing($mailing))) {
            throw new \InvalidArgumentException($mailingArrayErrorMessage, __LINE__);
        }
        $this->Mailing = $mailing;
        return $this;
    }
    /**
     * Add item to Mailing value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\MailingInformation $item
     * @return \Novadan\Uyumsoft\StructType\NotificationInformation
     */
    public function addToMailing(\Novadan\Uyumsoft\StructType\MailingInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\MailingInformation) {
            throw new \InvalidArgumentException(sprintf('The Mailing property can only contain items of type \Novadan\Uyumsoft\StructType\MailingInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mailing[] = $item;
        return $this;
    }
    /**
     * Get Messaging value
     * @return \Novadan\Uyumsoft\StructType\SmsMessageInformation[]|null
     */
    public function getMessaging()
    {
        return $this->Messaging;
    }
    /**
     * This method is responsible for validating the values passed to the setMessaging method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessaging method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessagingForArrayConstraintsFromSetMessaging(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $notificationInformationMessagingItem) {
            // validation for constraint: itemType
            if (!$notificationInformationMessagingItem instanceof \Novadan\Uyumsoft\StructType\SmsMessageInformation) {
                $invalidValues[] = is_object($notificationInformationMessagingItem) ? get_class($notificationInformationMessagingItem) : sprintf('%s(%s)', gettype($notificationInformationMessagingItem), var_export($notificationInformationMessagingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Messaging property can only contain items of type \Novadan\Uyumsoft\StructType\SmsMessageInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Messaging value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SmsMessageInformation[] $messaging
     * @return \Novadan\Uyumsoft\StructType\NotificationInformation
     */
    public function setMessaging(array $messaging = array())
    {
        // validation for constraint: array
        if ('' !== ($messagingArrayErrorMessage = self::validateMessagingForArrayConstraintsFromSetMessaging($messaging))) {
            throw new \InvalidArgumentException($messagingArrayErrorMessage, __LINE__);
        }
        $this->Messaging = $messaging;
        return $this;
    }
    /**
     * Add item to Messaging value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SmsMessageInformation $item
     * @return \Novadan\Uyumsoft\StructType\NotificationInformation
     */
    public function addToMessaging(\Novadan\Uyumsoft\StructType\SmsMessageInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\SmsMessageInformation) {
            throw new \InvalidArgumentException(sprintf('The Messaging property can only contain items of type \Novadan\Uyumsoft\StructType\SmsMessageInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Messaging[] = $item;
        return $this;
    }
}
