<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaritimeTransportType StructType
 * @subpackage Structs
 */
class MaritimeTransportType extends AbstractStructBase
{
    /**
     * The VesselID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q209:VesselID
     * @var \Novadan\Uyumsoft\StructType\VesselIDType
     */
    public $VesselID;
    /**
     * The VesselName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q210:VesselName
     * @var \Novadan\Uyumsoft\StructType\VesselNameType
     */
    public $VesselName;
    /**
     * The RadioCallSignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q211:RadioCallSignID
     * @var \Novadan\Uyumsoft\StructType\RadioCallSignIDType
     */
    public $RadioCallSignID;
    /**
     * The ShipsRequirements
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q212:ShipsRequirements
     * @var \Novadan\Uyumsoft\StructType\ShipsRequirementsType[]
     */
    public $ShipsRequirements;
    /**
     * The GrossTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q213:GrossTonnageMeasure
     * @var \Novadan\Uyumsoft\StructType\GrossTonnageMeasureType
     */
    public $GrossTonnageMeasure;
    /**
     * The NetTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q214:NetTonnageMeasure
     * @var \Novadan\Uyumsoft\StructType\NetTonnageMeasureType
     */
    public $NetTonnageMeasure;
    /**
     * The RegistryCertificateDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public $RegistryCertificateDocumentReference;
    /**
     * The RegistryPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\LocationType
     */
    public $RegistryPortLocation;
    /**
     * Constructor method for MaritimeTransportType
     * @uses MaritimeTransportType::setVesselID()
     * @uses MaritimeTransportType::setVesselName()
     * @uses MaritimeTransportType::setRadioCallSignID()
     * @uses MaritimeTransportType::setShipsRequirements()
     * @uses MaritimeTransportType::setGrossTonnageMeasure()
     * @uses MaritimeTransportType::setNetTonnageMeasure()
     * @uses MaritimeTransportType::setRegistryCertificateDocumentReference()
     * @uses MaritimeTransportType::setRegistryPortLocation()
     * @param \Novadan\Uyumsoft\StructType\VesselIDType $vesselID
     * @param \Novadan\Uyumsoft\StructType\VesselNameType $vesselName
     * @param \Novadan\Uyumsoft\StructType\RadioCallSignIDType $radioCallSignID
     * @param \Novadan\Uyumsoft\StructType\ShipsRequirementsType[] $shipsRequirements
     * @param \Novadan\Uyumsoft\StructType\GrossTonnageMeasureType $grossTonnageMeasure
     * @param \Novadan\Uyumsoft\StructType\NetTonnageMeasureType $netTonnageMeasure
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType $registryCertificateDocumentReference
     * @param \Novadan\Uyumsoft\StructType\LocationType $registryPortLocation
     */
    public function __construct(\Novadan\Uyumsoft\StructType\VesselIDType $vesselID = null, \Novadan\Uyumsoft\StructType\VesselNameType $vesselName = null, \Novadan\Uyumsoft\StructType\RadioCallSignIDType $radioCallSignID = null, array $shipsRequirements = array(), \Novadan\Uyumsoft\StructType\GrossTonnageMeasureType $grossTonnageMeasure = null, \Novadan\Uyumsoft\StructType\NetTonnageMeasureType $netTonnageMeasure = null, \Novadan\Uyumsoft\StructType\DocumentReferenceType $registryCertificateDocumentReference = null, \Novadan\Uyumsoft\StructType\LocationType $registryPortLocation = null)
    {
        $this
            ->setVesselID($vesselID)
            ->setVesselName($vesselName)
            ->setRadioCallSignID($radioCallSignID)
            ->setShipsRequirements($shipsRequirements)
            ->setGrossTonnageMeasure($grossTonnageMeasure)
            ->setNetTonnageMeasure($netTonnageMeasure)
            ->setRegistryCertificateDocumentReference($registryCertificateDocumentReference)
            ->setRegistryPortLocation($registryPortLocation);
    }
    /**
     * Get VesselID value
     * @return \Novadan\Uyumsoft\StructType\VesselIDType|null
     */
    public function getVesselID()
    {
        return $this->VesselID;
    }
    /**
     * Set VesselID value
     * @param \Novadan\Uyumsoft\StructType\VesselIDType $vesselID
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public function setVesselID(\Novadan\Uyumsoft\StructType\VesselIDType $vesselID = null)
    {
        $this->VesselID = $vesselID;
        return $this;
    }
    /**
     * Get VesselName value
     * @return \Novadan\Uyumsoft\StructType\VesselNameType|null
     */
    public function getVesselName()
    {
        return $this->VesselName;
    }
    /**
     * Set VesselName value
     * @param \Novadan\Uyumsoft\StructType\VesselNameType $vesselName
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public function setVesselName(\Novadan\Uyumsoft\StructType\VesselNameType $vesselName = null)
    {
        $this->VesselName = $vesselName;
        return $this;
    }
    /**
     * Get RadioCallSignID value
     * @return \Novadan\Uyumsoft\StructType\RadioCallSignIDType|null
     */
    public function getRadioCallSignID()
    {
        return $this->RadioCallSignID;
    }
    /**
     * Set RadioCallSignID value
     * @param \Novadan\Uyumsoft\StructType\RadioCallSignIDType $radioCallSignID
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public function setRadioCallSignID(\Novadan\Uyumsoft\StructType\RadioCallSignIDType $radioCallSignID = null)
    {
        $this->RadioCallSignID = $radioCallSignID;
        return $this;
    }
    /**
     * Get ShipsRequirements value
     * @return \Novadan\Uyumsoft\StructType\ShipsRequirementsType[]|null
     */
    public function getShipsRequirements()
    {
        return $this->ShipsRequirements;
    }
    /**
     * This method is responsible for validating the values passed to the setShipsRequirements method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipsRequirements method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipsRequirementsForArrayConstraintsFromSetShipsRequirements(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $maritimeTransportTypeShipsRequirementsItem) {
            // validation for constraint: itemType
            if (!$maritimeTransportTypeShipsRequirementsItem instanceof \Novadan\Uyumsoft\StructType\ShipsRequirementsType) {
                $invalidValues[] = is_object($maritimeTransportTypeShipsRequirementsItem) ? get_class($maritimeTransportTypeShipsRequirementsItem) : sprintf('%s(%s)', gettype($maritimeTransportTypeShipsRequirementsItem), var_export($maritimeTransportTypeShipsRequirementsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipsRequirements property can only contain items of type \Novadan\Uyumsoft\StructType\ShipsRequirementsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipsRequirements value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ShipsRequirementsType[] $shipsRequirements
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public function setShipsRequirements(array $shipsRequirements = array())
    {
        // validation for constraint: array
        if ('' !== ($shipsRequirementsArrayErrorMessage = self::validateShipsRequirementsForArrayConstraintsFromSetShipsRequirements($shipsRequirements))) {
            throw new \InvalidArgumentException($shipsRequirementsArrayErrorMessage, __LINE__);
        }
        $this->ShipsRequirements = $shipsRequirements;
        return $this;
    }
    /**
     * Add item to ShipsRequirements value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ShipsRequirementsType $item
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public function addToShipsRequirements(\Novadan\Uyumsoft\StructType\ShipsRequirementsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\ShipsRequirementsType) {
            throw new \InvalidArgumentException(sprintf('The ShipsRequirements property can only contain items of type \Novadan\Uyumsoft\StructType\ShipsRequirementsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipsRequirements[] = $item;
        return $this;
    }
    /**
     * Get GrossTonnageMeasure value
     * @return \Novadan\Uyumsoft\StructType\GrossTonnageMeasureType|null
     */
    public function getGrossTonnageMeasure()
    {
        return $this->GrossTonnageMeasure;
    }
    /**
     * Set GrossTonnageMeasure value
     * @param \Novadan\Uyumsoft\StructType\GrossTonnageMeasureType $grossTonnageMeasure
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public function setGrossTonnageMeasure(\Novadan\Uyumsoft\StructType\GrossTonnageMeasureType $grossTonnageMeasure = null)
    {
        $this->GrossTonnageMeasure = $grossTonnageMeasure;
        return $this;
    }
    /**
     * Get NetTonnageMeasure value
     * @return \Novadan\Uyumsoft\StructType\NetTonnageMeasureType|null
     */
    public function getNetTonnageMeasure()
    {
        return $this->NetTonnageMeasure;
    }
    /**
     * Set NetTonnageMeasure value
     * @param \Novadan\Uyumsoft\StructType\NetTonnageMeasureType $netTonnageMeasure
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public function setNetTonnageMeasure(\Novadan\Uyumsoft\StructType\NetTonnageMeasureType $netTonnageMeasure = null)
    {
        $this->NetTonnageMeasure = $netTonnageMeasure;
        return $this;
    }
    /**
     * Get RegistryCertificateDocumentReference value
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType|null
     */
    public function getRegistryCertificateDocumentReference()
    {
        return $this->RegistryCertificateDocumentReference;
    }
    /**
     * Set RegistryCertificateDocumentReference value
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType $registryCertificateDocumentReference
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public function setRegistryCertificateDocumentReference(\Novadan\Uyumsoft\StructType\DocumentReferenceType $registryCertificateDocumentReference = null)
    {
        $this->RegistryCertificateDocumentReference = $registryCertificateDocumentReference;
        return $this;
    }
    /**
     * Get RegistryPortLocation value
     * @return \Novadan\Uyumsoft\StructType\LocationType|null
     */
    public function getRegistryPortLocation()
    {
        return $this->RegistryPortLocation;
    }
    /**
     * Set RegistryPortLocation value
     * @param \Novadan\Uyumsoft\StructType\LocationType $registryPortLocation
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public function setRegistryPortLocation(\Novadan\Uyumsoft\StructType\LocationType $registryPortLocation = null)
    {
        $this->RegistryPortLocation = $registryPortLocation;
        return $this;
    }
}
