<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceType StructType
 * @subpackage Structs
 */
class InvoiceType extends AbstractStructBase
{
    /**
     * The UBLExtensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q1:UBLExtensions
     * @var \Novadan\Uyumsoft\ArrayType\ArrayOfUBLExtensionType
     */
    public $UBLExtensions;
    /**
     * The UBLVersionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q2:UBLVersionID
     * @var \Novadan\Uyumsoft\StructType\UBLVersionIDType
     */
    public $UBLVersionID;
    /**
     * The CustomizationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q3:CustomizationID
     * @var \Novadan\Uyumsoft\StructType\CustomizationIDType
     */
    public $CustomizationID;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q4:ProfileID
     * @var \Novadan\Uyumsoft\StructType\ProfileIDType
     */
    public $ProfileID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q5:ID
     * @var \Novadan\Uyumsoft\StructType\IDType
     */
    public $ID;
    /**
     * The CopyIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q6:CopyIndicator
     * @var \Novadan\Uyumsoft\StructType\CopyIndicatorType
     */
    public $CopyIndicator;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q7:UUID
     * @var \Novadan\Uyumsoft\StructType\UUIDType
     */
    public $UUID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q8:IssueDate
     * @var \Novadan\Uyumsoft\StructType\IssueDateType
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q9:IssueTime
     * @var \Novadan\Uyumsoft\StructType\IssueTime
     */
    public $IssueTime;
    /**
     * The InvoiceTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q10:InvoiceTypeCode
     * @var \Novadan\Uyumsoft\StructType\InvoiceTypeCodeType
     */
    public $InvoiceTypeCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q11:Note
     * @var \Novadan\Uyumsoft\StructType\NoteType[]
     */
    public $Note;
    /**
     * The DocumentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q12:DocumentCurrencyCode
     * @var \Novadan\Uyumsoft\StructType\DocumentCurrencyCodeType
     */
    public $DocumentCurrencyCode;
    /**
     * The TaxCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q13:TaxCurrencyCode
     * @var \Novadan\Uyumsoft\StructType\TaxCurrencyCodeType
     */
    public $TaxCurrencyCode;
    /**
     * The PricingCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q14:PricingCurrencyCode
     * @var \Novadan\Uyumsoft\StructType\PricingCurrencyCodeType
     */
    public $PricingCurrencyCode;
    /**
     * The PaymentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q15:PaymentCurrencyCode
     * @var \Novadan\Uyumsoft\StructType\PaymentCurrencyCodeType
     */
    public $PaymentCurrencyCode;
    /**
     * The PaymentAlternativeCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q16:PaymentAlternativeCurrencyCode
     * @var \Novadan\Uyumsoft\StructType\PaymentAlternativeCurrencyCodeType
     */
    public $PaymentAlternativeCurrencyCode;
    /**
     * The AccountingCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q17:AccountingCost
     * @var \Novadan\Uyumsoft\StructType\AccountingCostType
     */
    public $AccountingCost;
    /**
     * The LineCountNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q18:LineCountNumeric
     * @var \Novadan\Uyumsoft\StructType\LineCountNumericType
     */
    public $LineCountNumeric;
    /**
     * The InvoicePeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q19:InvoicePeriod
     * @var \Novadan\Uyumsoft\StructType\PeriodType
     */
    public $InvoicePeriod;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q20:OrderReference
     * @var \Novadan\Uyumsoft\StructType\OrderReferenceType
     */
    public $OrderReference;
    /**
     * The BillingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q21:BillingReference
     * @var \Novadan\Uyumsoft\StructType\BillingReferenceType[]
     */
    public $BillingReference;
    /**
     * The DespatchDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q22:DespatchDocumentReference
     * @var \Novadan\Uyumsoft\StructType\DocumentReferenceType[]
     */
    public $DespatchDocumentReference;
    /**
     * The ReceiptDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q23:ReceiptDocumentReference
     * @var \Novadan\Uyumsoft\StructType\DocumentReferenceType[]
     */
    public $ReceiptDocumentReference;
    /**
     * The OriginatorDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q24:OriginatorDocumentReference
     * @var \Novadan\Uyumsoft\StructType\DocumentReferenceType[]
     */
    public $OriginatorDocumentReference;
    /**
     * The ContractDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q25:ContractDocumentReference
     * @var \Novadan\Uyumsoft\StructType\DocumentReferenceType[]
     */
    public $ContractDocumentReference;
    /**
     * The AdditionalDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q26:AdditionalDocumentReference
     * @var \Novadan\Uyumsoft\StructType\DocumentReferenceType[]
     */
    public $AdditionalDocumentReference;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q27:Signature
     * @var \Novadan\Uyumsoft\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The AccountingSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q28:AccountingSupplierParty
     * @var \Novadan\Uyumsoft\StructType\SupplierPartyType
     */
    public $AccountingSupplierParty;
    /**
     * The AccountingCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q29:AccountingCustomerParty
     * @var \Novadan\Uyumsoft\StructType\CustomerPartyType
     */
    public $AccountingCustomerParty;
    /**
     * The BuyerCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q30:BuyerCustomerParty
     * @var \Novadan\Uyumsoft\StructType\CustomerPartyType
     */
    public $BuyerCustomerParty;
    /**
     * The SellerSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q31:SellerSupplierParty
     * @var \Novadan\Uyumsoft\StructType\SupplierPartyType
     */
    public $SellerSupplierParty;
    /**
     * The TaxRepresentativeParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q32:TaxRepresentativeParty
     * @var \Novadan\Uyumsoft\StructType\PartyType
     */
    public $TaxRepresentativeParty;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q33:Delivery
     * @var \Novadan\Uyumsoft\StructType\DeliveryType[]
     */
    public $Delivery;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q34:PaymentMeans
     * @var \Novadan\Uyumsoft\StructType\PaymentMeansType[]
     */
    public $PaymentMeans;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q35:PaymentTerms
     * @var \Novadan\Uyumsoft\StructType\PaymentTermsType
     */
    public $PaymentTerms;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q36:AllowanceCharge
     * @var \Novadan\Uyumsoft\StructType\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q37:TaxExchangeRate
     * @var \Novadan\Uyumsoft\StructType\ExchangeRateType
     */
    public $TaxExchangeRate;
    /**
     * The PricingExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q38:PricingExchangeRate
     * @var \Novadan\Uyumsoft\StructType\ExchangeRateType
     */
    public $PricingExchangeRate;
    /**
     * The PaymentExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q39:PaymentExchangeRate
     * @var \Novadan\Uyumsoft\StructType\ExchangeRateType
     */
    public $PaymentExchangeRate;
    /**
     * The PaymentAlternativeExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q40:PaymentAlternativeExchangeRate
     * @var \Novadan\Uyumsoft\StructType\ExchangeRateType
     */
    public $PaymentAlternativeExchangeRate;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q41:TaxTotal
     * @var \Novadan\Uyumsoft\StructType\TaxTotalType[]
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q42:WithholdingTaxTotal
     * @var \Novadan\Uyumsoft\StructType\TaxTotalType[]
     */
    public $WithholdingTaxTotal;
    /**
     * The LegalMonetaryTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q43:LegalMonetaryTotal
     * @var \Novadan\Uyumsoft\StructType\MonetaryTotalType
     */
    public $LegalMonetaryTotal;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q44:InvoiceLine
     * @var \Novadan\Uyumsoft\StructType\InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The schemaLocation
     * @var string
     */
    public $schemaLocation;
    /**
     * Constructor method for InvoiceType
     * @uses InvoiceType::setUBLExtensions()
     * @uses InvoiceType::setUBLVersionID()
     * @uses InvoiceType::setCustomizationID()
     * @uses InvoiceType::setProfileID()
     * @uses InvoiceType::setID()
     * @uses InvoiceType::setCopyIndicator()
     * @uses InvoiceType::setUUID()
     * @uses InvoiceType::setIssueDate()
     * @uses InvoiceType::setIssueTime()
     * @uses InvoiceType::setInvoiceTypeCode()
     * @uses InvoiceType::setNote()
     * @uses InvoiceType::setDocumentCurrencyCode()
     * @uses InvoiceType::setTaxCurrencyCode()
     * @uses InvoiceType::setPricingCurrencyCode()
     * @uses InvoiceType::setPaymentCurrencyCode()
     * @uses InvoiceType::setPaymentAlternativeCurrencyCode()
     * @uses InvoiceType::setAccountingCost()
     * @uses InvoiceType::setLineCountNumeric()
     * @uses InvoiceType::setInvoicePeriod()
     * @uses InvoiceType::setOrderReference()
     * @uses InvoiceType::setBillingReference()
     * @uses InvoiceType::setDespatchDocumentReference()
     * @uses InvoiceType::setReceiptDocumentReference()
     * @uses InvoiceType::setOriginatorDocumentReference()
     * @uses InvoiceType::setContractDocumentReference()
     * @uses InvoiceType::setAdditionalDocumentReference()
     * @uses InvoiceType::setSignature()
     * @uses InvoiceType::setAccountingSupplierParty()
     * @uses InvoiceType::setAccountingCustomerParty()
     * @uses InvoiceType::setBuyerCustomerParty()
     * @uses InvoiceType::setSellerSupplierParty()
     * @uses InvoiceType::setTaxRepresentativeParty()
     * @uses InvoiceType::setDelivery()
     * @uses InvoiceType::setPaymentMeans()
     * @uses InvoiceType::setPaymentTerms()
     * @uses InvoiceType::setAllowanceCharge()
     * @uses InvoiceType::setTaxExchangeRate()
     * @uses InvoiceType::setPricingExchangeRate()
     * @uses InvoiceType::setPaymentExchangeRate()
     * @uses InvoiceType::setPaymentAlternativeExchangeRate()
     * @uses InvoiceType::setTaxTotal()
     * @uses InvoiceType::setWithholdingTaxTotal()
     * @uses InvoiceType::setLegalMonetaryTotal()
     * @uses InvoiceType::setInvoiceLine()
     * @uses InvoiceType::setSchemaLocation()
     * @param \Novadan\Uyumsoft\ArrayType\ArrayOfUBLExtensionType $uBLExtensions
     * @param \Novadan\Uyumsoft\StructType\UBLVersionIDType $uBLVersionID
     * @param \Novadan\Uyumsoft\StructType\CustomizationIDType $customizationID
     * @param \Novadan\Uyumsoft\StructType\ProfileIDType $profileID
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @param \Novadan\Uyumsoft\StructType\CopyIndicatorType $copyIndicator
     * @param \Novadan\Uyumsoft\StructType\UUIDType $uUID
     * @param \Novadan\Uyumsoft\StructType\IssueDateType $issueDate
     * @param \Novadan\Uyumsoft\StructType\IssueTime $issueTime
     * @param \Novadan\Uyumsoft\StructType\InvoiceTypeCodeType $invoiceTypeCode
     * @param \Novadan\Uyumsoft\StructType\NoteType[] $note
     * @param \Novadan\Uyumsoft\StructType\DocumentCurrencyCodeType $documentCurrencyCode
     * @param \Novadan\Uyumsoft\StructType\TaxCurrencyCodeType $taxCurrencyCode
     * @param \Novadan\Uyumsoft\StructType\PricingCurrencyCodeType $pricingCurrencyCode
     * @param \Novadan\Uyumsoft\StructType\PaymentCurrencyCodeType $paymentCurrencyCode
     * @param \Novadan\Uyumsoft\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @param \Novadan\Uyumsoft\StructType\AccountingCostType $accountingCost
     * @param \Novadan\Uyumsoft\StructType\LineCountNumericType $lineCountNumeric
     * @param \Novadan\Uyumsoft\StructType\PeriodType $invoicePeriod
     * @param \Novadan\Uyumsoft\StructType\OrderReferenceType $orderReference
     * @param \Novadan\Uyumsoft\StructType\BillingReferenceType[] $billingReference
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $despatchDocumentReference
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $receiptDocumentReference
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $originatorDocumentReference
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $contractDocumentReference
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $additionalDocumentReference
     * @param \Novadan\Uyumsoft\StructType\SignatureType[] $signature
     * @param \Novadan\Uyumsoft\StructType\SupplierPartyType $accountingSupplierParty
     * @param \Novadan\Uyumsoft\StructType\CustomerPartyType $accountingCustomerParty
     * @param \Novadan\Uyumsoft\StructType\CustomerPartyType $buyerCustomerParty
     * @param \Novadan\Uyumsoft\StructType\SupplierPartyType $sellerSupplierParty
     * @param \Novadan\Uyumsoft\StructType\PartyType $taxRepresentativeParty
     * @param \Novadan\Uyumsoft\StructType\DeliveryType[] $delivery
     * @param \Novadan\Uyumsoft\StructType\PaymentMeansType[] $paymentMeans
     * @param \Novadan\Uyumsoft\StructType\PaymentTermsType $paymentTerms
     * @param \Novadan\Uyumsoft\StructType\AllowanceChargeType[] $allowanceCharge
     * @param \Novadan\Uyumsoft\StructType\ExchangeRateType $taxExchangeRate
     * @param \Novadan\Uyumsoft\StructType\ExchangeRateType $pricingExchangeRate
     * @param \Novadan\Uyumsoft\StructType\ExchangeRateType $paymentExchangeRate
     * @param \Novadan\Uyumsoft\StructType\ExchangeRateType $paymentAlternativeExchangeRate
     * @param \Novadan\Uyumsoft\StructType\TaxTotalType[] $taxTotal
     * @param \Novadan\Uyumsoft\StructType\TaxTotalType[] $withholdingTaxTotal
     * @param \Novadan\Uyumsoft\StructType\MonetaryTotalType $legalMonetaryTotal
     * @param \Novadan\Uyumsoft\StructType\InvoiceLineType[] $invoiceLine
     * @param string $schemaLocation
     */
    public function __construct(\Novadan\Uyumsoft\ArrayType\ArrayOfUBLExtensionType $uBLExtensions = null, \Novadan\Uyumsoft\StructType\UBLVersionIDType $uBLVersionID = null, \Novadan\Uyumsoft\StructType\CustomizationIDType $customizationID = null, \Novadan\Uyumsoft\StructType\ProfileIDType $profileID = null, \Novadan\Uyumsoft\StructType\IDType $iD = null, \Novadan\Uyumsoft\StructType\CopyIndicatorType $copyIndicator = null, \Novadan\Uyumsoft\StructType\UUIDType $uUID = null, \Novadan\Uyumsoft\StructType\IssueDateType $issueDate = null, \Novadan\Uyumsoft\StructType\IssueTime $issueTime = null, \Novadan\Uyumsoft\StructType\InvoiceTypeCodeType $invoiceTypeCode = null, array $note = array(), \Novadan\Uyumsoft\StructType\DocumentCurrencyCodeType $documentCurrencyCode = null, \Novadan\Uyumsoft\StructType\TaxCurrencyCodeType $taxCurrencyCode = null, \Novadan\Uyumsoft\StructType\PricingCurrencyCodeType $pricingCurrencyCode = null, \Novadan\Uyumsoft\StructType\PaymentCurrencyCodeType $paymentCurrencyCode = null, \Novadan\Uyumsoft\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null, \Novadan\Uyumsoft\StructType\AccountingCostType $accountingCost = null, \Novadan\Uyumsoft\StructType\LineCountNumericType $lineCountNumeric = null, \Novadan\Uyumsoft\StructType\PeriodType $invoicePeriod = null, \Novadan\Uyumsoft\StructType\OrderReferenceType $orderReference = null, array $billingReference = array(), array $despatchDocumentReference = array(), array $receiptDocumentReference = array(), array $originatorDocumentReference = array(), array $contractDocumentReference = array(), array $additionalDocumentReference = array(), array $signature = array(), \Novadan\Uyumsoft\StructType\SupplierPartyType $accountingSupplierParty = null, \Novadan\Uyumsoft\StructType\CustomerPartyType $accountingCustomerParty = null, \Novadan\Uyumsoft\StructType\CustomerPartyType $buyerCustomerParty = null, \Novadan\Uyumsoft\StructType\SupplierPartyType $sellerSupplierParty = null, \Novadan\Uyumsoft\StructType\PartyType $taxRepresentativeParty = null, array $delivery = array(), array $paymentMeans = array(), \Novadan\Uyumsoft\StructType\PaymentTermsType $paymentTerms = null, array $allowanceCharge = array(), \Novadan\Uyumsoft\StructType\ExchangeRateType $taxExchangeRate = null, \Novadan\Uyumsoft\StructType\ExchangeRateType $pricingExchangeRate = null, \Novadan\Uyumsoft\StructType\ExchangeRateType $paymentExchangeRate = null, \Novadan\Uyumsoft\StructType\ExchangeRateType $paymentAlternativeExchangeRate = null, array $taxTotal = array(), array $withholdingTaxTotal = array(), \Novadan\Uyumsoft\StructType\MonetaryTotalType $legalMonetaryTotal = null, array $invoiceLine = array(), $schemaLocation = null)
    {
        $this
            ->setUBLExtensions($uBLExtensions)
            ->setUBLVersionID($uBLVersionID)
            ->setCustomizationID($customizationID)
            ->setProfileID($profileID)
            ->setID($iD)
            ->setCopyIndicator($copyIndicator)
            ->setUUID($uUID)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setInvoiceTypeCode($invoiceTypeCode)
            ->setNote($note)
            ->setDocumentCurrencyCode($documentCurrencyCode)
            ->setTaxCurrencyCode($taxCurrencyCode)
            ->setPricingCurrencyCode($pricingCurrencyCode)
            ->setPaymentCurrencyCode($paymentCurrencyCode)
            ->setPaymentAlternativeCurrencyCode($paymentAlternativeCurrencyCode)
            ->setAccountingCost($accountingCost)
            ->setLineCountNumeric($lineCountNumeric)
            ->setInvoicePeriod($invoicePeriod)
            ->setOrderReference($orderReference)
            ->setBillingReference($billingReference)
            ->setDespatchDocumentReference($despatchDocumentReference)
            ->setReceiptDocumentReference($receiptDocumentReference)
            ->setOriginatorDocumentReference($originatorDocumentReference)
            ->setContractDocumentReference($contractDocumentReference)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setSignature($signature)
            ->setAccountingSupplierParty($accountingSupplierParty)
            ->setAccountingCustomerParty($accountingCustomerParty)
            ->setBuyerCustomerParty($buyerCustomerParty)
            ->setSellerSupplierParty($sellerSupplierParty)
            ->setTaxRepresentativeParty($taxRepresentativeParty)
            ->setDelivery($delivery)
            ->setPaymentMeans($paymentMeans)
            ->setPaymentTerms($paymentTerms)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxExchangeRate($taxExchangeRate)
            ->setPricingExchangeRate($pricingExchangeRate)
            ->setPaymentExchangeRate($paymentExchangeRate)
            ->setPaymentAlternativeExchangeRate($paymentAlternativeExchangeRate)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setLegalMonetaryTotal($legalMonetaryTotal)
            ->setInvoiceLine($invoiceLine)
            ->setSchemaLocation($schemaLocation);
    }
    /**
     * Get UBLExtensions value
     * @return \Novadan\Uyumsoft\ArrayType\ArrayOfUBLExtensionType|null
     */
    public function getUBLExtensions()
    {
        return $this->UBLExtensions;
    }
    /**
     * Set UBLExtensions value
     * @param \Novadan\Uyumsoft\ArrayType\ArrayOfUBLExtensionType $uBLExtensions
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setUBLExtensions(\Novadan\Uyumsoft\ArrayType\ArrayOfUBLExtensionType $uBLExtensions = null)
    {
        $this->UBLExtensions = $uBLExtensions;
        return $this;
    }
    /**
     * Get UBLVersionID value
     * @return \Novadan\Uyumsoft\StructType\UBLVersionIDType|null
     */
    public function getUBLVersionID()
    {
        return $this->UBLVersionID;
    }
    /**
     * Set UBLVersionID value
     * @param \Novadan\Uyumsoft\StructType\UBLVersionIDType $uBLVersionID
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setUBLVersionID(\Novadan\Uyumsoft\StructType\UBLVersionIDType $uBLVersionID = null)
    {
        $this->UBLVersionID = $uBLVersionID;
        return $this;
    }
    /**
     * Get CustomizationID value
     * @return \Novadan\Uyumsoft\StructType\CustomizationIDType|null
     */
    public function getCustomizationID()
    {
        return $this->CustomizationID;
    }
    /**
     * Set CustomizationID value
     * @param \Novadan\Uyumsoft\StructType\CustomizationIDType $customizationID
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setCustomizationID(\Novadan\Uyumsoft\StructType\CustomizationIDType $customizationID = null)
    {
        $this->CustomizationID = $customizationID;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return \Novadan\Uyumsoft\StructType\ProfileIDType|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param \Novadan\Uyumsoft\StructType\ProfileIDType $profileID
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setProfileID(\Novadan\Uyumsoft\StructType\ProfileIDType $profileID = null)
    {
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get ID value
     * @return \Novadan\Uyumsoft\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setID(\Novadan\Uyumsoft\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CopyIndicator value
     * @return \Novadan\Uyumsoft\StructType\CopyIndicatorType|null
     */
    public function getCopyIndicator()
    {
        return $this->CopyIndicator;
    }
    /**
     * Set CopyIndicator value
     * @param \Novadan\Uyumsoft\StructType\CopyIndicatorType $copyIndicator
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setCopyIndicator(\Novadan\Uyumsoft\StructType\CopyIndicatorType $copyIndicator = null)
    {
        $this->CopyIndicator = $copyIndicator;
        return $this;
    }
    /**
     * Get UUID value
     * @return \Novadan\Uyumsoft\StructType\UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \Novadan\Uyumsoft\StructType\UUIDType $uUID
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setUUID(\Novadan\Uyumsoft\StructType\UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Novadan\Uyumsoft\StructType\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Novadan\Uyumsoft\StructType\IssueDateType $issueDate
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setIssueDate(\Novadan\Uyumsoft\StructType\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return \Novadan\Uyumsoft\StructType\IssueTime|null
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param \Novadan\Uyumsoft\StructType\IssueTime $issueTime
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setIssueTime(\Novadan\Uyumsoft\StructType\IssueTime $issueTime = null)
    {
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get InvoiceTypeCode value
     * @return \Novadan\Uyumsoft\StructType\InvoiceTypeCodeType|null
     */
    public function getInvoiceTypeCode()
    {
        return $this->InvoiceTypeCode;
    }
    /**
     * Set InvoiceTypeCode value
     * @param \Novadan\Uyumsoft\StructType\InvoiceTypeCodeType $invoiceTypeCode
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setInvoiceTypeCode(\Novadan\Uyumsoft\StructType\InvoiceTypeCodeType $invoiceTypeCode = null)
    {
        $this->InvoiceTypeCode = $invoiceTypeCode;
        return $this;
    }
    /**
     * Get Note value
     * @return \Novadan\Uyumsoft\StructType\NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * This method is responsible for validating the values passed to the setNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoteForArrayConstraintsFromSetNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeNoteItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeNoteItem instanceof \Novadan\Uyumsoft\StructType\NoteType) {
                $invalidValues[] = is_object($invoiceTypeNoteItem) ? get_class($invoiceTypeNoteItem) : sprintf('%s(%s)', gettype($invoiceTypeNoteItem), var_export($invoiceTypeNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Note property can only contain items of type \Novadan\Uyumsoft\StructType\NoteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\NoteType[] $note
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: array
        if ('' !== ($noteArrayErrorMessage = self::validateNoteForArrayConstraintsFromSetNote($note))) {
            throw new \InvalidArgumentException($noteArrayErrorMessage, __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\NoteType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToNote(\Novadan\Uyumsoft\StructType\NoteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\NoteType) {
            throw new \InvalidArgumentException(sprintf('The Note property can only contain items of type \Novadan\Uyumsoft\StructType\NoteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get DocumentCurrencyCode value
     * @return \Novadan\Uyumsoft\StructType\DocumentCurrencyCodeType|null
     */
    public function getDocumentCurrencyCode()
    {
        return $this->DocumentCurrencyCode;
    }
    /**
     * Set DocumentCurrencyCode value
     * @param \Novadan\Uyumsoft\StructType\DocumentCurrencyCodeType $documentCurrencyCode
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setDocumentCurrencyCode(\Novadan\Uyumsoft\StructType\DocumentCurrencyCodeType $documentCurrencyCode = null)
    {
        $this->DocumentCurrencyCode = $documentCurrencyCode;
        return $this;
    }
    /**
     * Get TaxCurrencyCode value
     * @return \Novadan\Uyumsoft\StructType\TaxCurrencyCodeType|null
     */
    public function getTaxCurrencyCode()
    {
        return $this->TaxCurrencyCode;
    }
    /**
     * Set TaxCurrencyCode value
     * @param \Novadan\Uyumsoft\StructType\TaxCurrencyCodeType $taxCurrencyCode
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setTaxCurrencyCode(\Novadan\Uyumsoft\StructType\TaxCurrencyCodeType $taxCurrencyCode = null)
    {
        $this->TaxCurrencyCode = $taxCurrencyCode;
        return $this;
    }
    /**
     * Get PricingCurrencyCode value
     * @return \Novadan\Uyumsoft\StructType\PricingCurrencyCodeType|null
     */
    public function getPricingCurrencyCode()
    {
        return $this->PricingCurrencyCode;
    }
    /**
     * Set PricingCurrencyCode value
     * @param \Novadan\Uyumsoft\StructType\PricingCurrencyCodeType $pricingCurrencyCode
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setPricingCurrencyCode(\Novadan\Uyumsoft\StructType\PricingCurrencyCodeType $pricingCurrencyCode = null)
    {
        $this->PricingCurrencyCode = $pricingCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentCurrencyCode value
     * @return \Novadan\Uyumsoft\StructType\PaymentCurrencyCodeType|null
     */
    public function getPaymentCurrencyCode()
    {
        return $this->PaymentCurrencyCode;
    }
    /**
     * Set PaymentCurrencyCode value
     * @param \Novadan\Uyumsoft\StructType\PaymentCurrencyCodeType $paymentCurrencyCode
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setPaymentCurrencyCode(\Novadan\Uyumsoft\StructType\PaymentCurrencyCodeType $paymentCurrencyCode = null)
    {
        $this->PaymentCurrencyCode = $paymentCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentAlternativeCurrencyCode value
     * @return \Novadan\Uyumsoft\StructType\PaymentAlternativeCurrencyCodeType|null
     */
    public function getPaymentAlternativeCurrencyCode()
    {
        return $this->PaymentAlternativeCurrencyCode;
    }
    /**
     * Set PaymentAlternativeCurrencyCode value
     * @param \Novadan\Uyumsoft\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setPaymentAlternativeCurrencyCode(\Novadan\Uyumsoft\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null)
    {
        $this->PaymentAlternativeCurrencyCode = $paymentAlternativeCurrencyCode;
        return $this;
    }
    /**
     * Get AccountingCost value
     * @return \Novadan\Uyumsoft\StructType\AccountingCostType|null
     */
    public function getAccountingCost()
    {
        return $this->AccountingCost;
    }
    /**
     * Set AccountingCost value
     * @param \Novadan\Uyumsoft\StructType\AccountingCostType $accountingCost
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setAccountingCost(\Novadan\Uyumsoft\StructType\AccountingCostType $accountingCost = null)
    {
        $this->AccountingCost = $accountingCost;
        return $this;
    }
    /**
     * Get LineCountNumeric value
     * @return \Novadan\Uyumsoft\StructType\LineCountNumericType|null
     */
    public function getLineCountNumeric()
    {
        return $this->LineCountNumeric;
    }
    /**
     * Set LineCountNumeric value
     * @param \Novadan\Uyumsoft\StructType\LineCountNumericType $lineCountNumeric
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setLineCountNumeric(\Novadan\Uyumsoft\StructType\LineCountNumericType $lineCountNumeric = null)
    {
        $this->LineCountNumeric = $lineCountNumeric;
        return $this;
    }
    /**
     * Get InvoicePeriod value
     * @return \Novadan\Uyumsoft\StructType\PeriodType|null
     */
    public function getInvoicePeriod()
    {
        return $this->InvoicePeriod;
    }
    /**
     * Set InvoicePeriod value
     * @param \Novadan\Uyumsoft\StructType\PeriodType $invoicePeriod
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setInvoicePeriod(\Novadan\Uyumsoft\StructType\PeriodType $invoicePeriod = null)
    {
        $this->InvoicePeriod = $invoicePeriod;
        return $this;
    }
    /**
     * Get OrderReference value
     * @return \Novadan\Uyumsoft\StructType\OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }
    /**
     * Set OrderReference value
     * @param \Novadan\Uyumsoft\StructType\OrderReferenceType $orderReference
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setOrderReference(\Novadan\Uyumsoft\StructType\OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }
    /**
     * Get BillingReference value
     * @return \Novadan\Uyumsoft\StructType\BillingReferenceType[]|null
     */
    public function getBillingReference()
    {
        return $this->BillingReference;
    }
    /**
     * This method is responsible for validating the values passed to the setBillingReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingReferenceForArrayConstraintsFromSetBillingReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeBillingReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeBillingReferenceItem instanceof \Novadan\Uyumsoft\StructType\BillingReferenceType) {
                $invalidValues[] = is_object($invoiceTypeBillingReferenceItem) ? get_class($invoiceTypeBillingReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeBillingReferenceItem), var_export($invoiceTypeBillingReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillingReference property can only contain items of type \Novadan\Uyumsoft\StructType\BillingReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillingReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\BillingReferenceType[] $billingReference
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setBillingReference(array $billingReference = array())
    {
        // validation for constraint: array
        if ('' !== ($billingReferenceArrayErrorMessage = self::validateBillingReferenceForArrayConstraintsFromSetBillingReference($billingReference))) {
            throw new \InvalidArgumentException($billingReferenceArrayErrorMessage, __LINE__);
        }
        $this->BillingReference = $billingReference;
        return $this;
    }
    /**
     * Add item to BillingReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\BillingReferenceType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToBillingReference(\Novadan\Uyumsoft\StructType\BillingReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\BillingReferenceType) {
            throw new \InvalidArgumentException(sprintf('The BillingReference property can only contain items of type \Novadan\Uyumsoft\StructType\BillingReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillingReference[] = $item;
        return $this;
    }
    /**
     * Get DespatchDocumentReference value
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType[]|null
     */
    public function getDespatchDocumentReference()
    {
        return $this->DespatchDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setDespatchDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDespatchDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDespatchDocumentReferenceForArrayConstraintsFromSetDespatchDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeDespatchDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeDespatchDocumentReferenceItem instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeDespatchDocumentReferenceItem) ? get_class($invoiceTypeDespatchDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeDespatchDocumentReferenceItem), var_export($invoiceTypeDespatchDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DespatchDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DespatchDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $despatchDocumentReference
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setDespatchDocumentReference(array $despatchDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($despatchDocumentReferenceArrayErrorMessage = self::validateDespatchDocumentReferenceForArrayConstraintsFromSetDespatchDocumentReference($despatchDocumentReference))) {
            throw new \InvalidArgumentException($despatchDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->DespatchDocumentReference = $despatchDocumentReference;
        return $this;
    }
    /**
     * Add item to DespatchDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToDespatchDocumentReference(\Novadan\Uyumsoft\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The DespatchDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DespatchDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ReceiptDocumentReference value
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType[]|null
     */
    public function getReceiptDocumentReference()
    {
        return $this->ReceiptDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceiptDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiptDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptDocumentReferenceForArrayConstraintsFromSetReceiptDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeReceiptDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeReceiptDocumentReferenceItem instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeReceiptDocumentReferenceItem) ? get_class($invoiceTypeReceiptDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeReceiptDocumentReferenceItem), var_export($invoiceTypeReceiptDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiptDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReceiptDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $receiptDocumentReference
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setReceiptDocumentReference(array $receiptDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptDocumentReferenceArrayErrorMessage = self::validateReceiptDocumentReferenceForArrayConstraintsFromSetReceiptDocumentReference($receiptDocumentReference))) {
            throw new \InvalidArgumentException($receiptDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ReceiptDocumentReference = $receiptDocumentReference;
        return $this;
    }
    /**
     * Add item to ReceiptDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToReceiptDocumentReference(\Novadan\Uyumsoft\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ReceiptDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiptDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get OriginatorDocumentReference value
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType[]|null
     */
    public function getOriginatorDocumentReference()
    {
        return $this->OriginatorDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginatorDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginatorDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginatorDocumentReferenceForArrayConstraintsFromSetOriginatorDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeOriginatorDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeOriginatorDocumentReferenceItem instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeOriginatorDocumentReferenceItem) ? get_class($invoiceTypeOriginatorDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeOriginatorDocumentReferenceItem), var_export($invoiceTypeOriginatorDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginatorDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginatorDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $originatorDocumentReference
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setOriginatorDocumentReference(array $originatorDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($originatorDocumentReferenceArrayErrorMessage = self::validateOriginatorDocumentReferenceForArrayConstraintsFromSetOriginatorDocumentReference($originatorDocumentReference))) {
            throw new \InvalidArgumentException($originatorDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->OriginatorDocumentReference = $originatorDocumentReference;
        return $this;
    }
    /**
     * Add item to OriginatorDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToOriginatorDocumentReference(\Novadan\Uyumsoft\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The OriginatorDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OriginatorDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ContractDocumentReference value
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType[]|null
     */
    public function getContractDocumentReference()
    {
        return $this->ContractDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setContractDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContractDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractDocumentReferenceForArrayConstraintsFromSetContractDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeContractDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeContractDocumentReferenceItem instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeContractDocumentReferenceItem) ? get_class($invoiceTypeContractDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeContractDocumentReferenceItem), var_export($invoiceTypeContractDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContractDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContractDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $contractDocumentReference
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setContractDocumentReference(array $contractDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($contractDocumentReferenceArrayErrorMessage = self::validateContractDocumentReferenceForArrayConstraintsFromSetContractDocumentReference($contractDocumentReference))) {
            throw new \InvalidArgumentException($contractDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ContractDocumentReference = $contractDocumentReference;
        return $this;
    }
    /**
     * Add item to ContractDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToContractDocumentReference(\Novadan\Uyumsoft\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ContractDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContractDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get AdditionalDocumentReference value
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType[]|null
     */
    public function getAdditionalDocumentReference()
    {
        return $this->AdditionalDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalDocumentReferenceForArrayConstraintsFromSetAdditionalDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeAdditionalDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeAdditionalDocumentReferenceItem instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeAdditionalDocumentReferenceItem) ? get_class($invoiceTypeAdditionalDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeAdditionalDocumentReferenceItem), var_export($invoiceTypeAdditionalDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $additionalDocumentReference
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setAdditionalDocumentReference(array $additionalDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalDocumentReferenceArrayErrorMessage = self::validateAdditionalDocumentReferenceForArrayConstraintsFromSetAdditionalDocumentReference($additionalDocumentReference))) {
            throw new \InvalidArgumentException($additionalDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->AdditionalDocumentReference = $additionalDocumentReference;
        return $this;
    }
    /**
     * Add item to AdditionalDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToAdditionalDocumentReference(\Novadan\Uyumsoft\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \Novadan\Uyumsoft\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * This method is responsible for validating the values passed to the setSignature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignatureForArrayConstraintsFromSetSignature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeSignatureItem instanceof \Novadan\Uyumsoft\StructType\SignatureType) {
                $invalidValues[] = is_object($invoiceTypeSignatureItem) ? get_class($invoiceTypeSignatureItem) : sprintf('%s(%s)', gettype($invoiceTypeSignatureItem), var_export($invoiceTypeSignatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Signature property can only contain items of type \Novadan\Uyumsoft\StructType\SignatureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SignatureType[] $signature
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setSignature(array $signature = array())
    {
        // validation for constraint: array
        if ('' !== ($signatureArrayErrorMessage = self::validateSignatureForArrayConstraintsFromSetSignature($signature))) {
            throw new \InvalidArgumentException($signatureArrayErrorMessage, __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SignatureType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToSignature(\Novadan\Uyumsoft\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of type \Novadan\Uyumsoft\StructType\SignatureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get AccountingSupplierParty value
     * @return \Novadan\Uyumsoft\StructType\SupplierPartyType|null
     */
    public function getAccountingSupplierParty()
    {
        return $this->AccountingSupplierParty;
    }
    /**
     * Set AccountingSupplierParty value
     * @param \Novadan\Uyumsoft\StructType\SupplierPartyType $accountingSupplierParty
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setAccountingSupplierParty(\Novadan\Uyumsoft\StructType\SupplierPartyType $accountingSupplierParty = null)
    {
        $this->AccountingSupplierParty = $accountingSupplierParty;
        return $this;
    }
    /**
     * Get AccountingCustomerParty value
     * @return \Novadan\Uyumsoft\StructType\CustomerPartyType|null
     */
    public function getAccountingCustomerParty()
    {
        return $this->AccountingCustomerParty;
    }
    /**
     * Set AccountingCustomerParty value
     * @param \Novadan\Uyumsoft\StructType\CustomerPartyType $accountingCustomerParty
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setAccountingCustomerParty(\Novadan\Uyumsoft\StructType\CustomerPartyType $accountingCustomerParty = null)
    {
        $this->AccountingCustomerParty = $accountingCustomerParty;
        return $this;
    }
    /**
     * Get BuyerCustomerParty value
     * @return \Novadan\Uyumsoft\StructType\CustomerPartyType|null
     */
    public function getBuyerCustomerParty()
    {
        return $this->BuyerCustomerParty;
    }
    /**
     * Set BuyerCustomerParty value
     * @param \Novadan\Uyumsoft\StructType\CustomerPartyType $buyerCustomerParty
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setBuyerCustomerParty(\Novadan\Uyumsoft\StructType\CustomerPartyType $buyerCustomerParty = null)
    {
        $this->BuyerCustomerParty = $buyerCustomerParty;
        return $this;
    }
    /**
     * Get SellerSupplierParty value
     * @return \Novadan\Uyumsoft\StructType\SupplierPartyType|null
     */
    public function getSellerSupplierParty()
    {
        return $this->SellerSupplierParty;
    }
    /**
     * Set SellerSupplierParty value
     * @param \Novadan\Uyumsoft\StructType\SupplierPartyType $sellerSupplierParty
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setSellerSupplierParty(\Novadan\Uyumsoft\StructType\SupplierPartyType $sellerSupplierParty = null)
    {
        $this->SellerSupplierParty = $sellerSupplierParty;
        return $this;
    }
    /**
     * Get TaxRepresentativeParty value
     * @return \Novadan\Uyumsoft\StructType\PartyType|null
     */
    public function getTaxRepresentativeParty()
    {
        return $this->TaxRepresentativeParty;
    }
    /**
     * Set TaxRepresentativeParty value
     * @param \Novadan\Uyumsoft\StructType\PartyType $taxRepresentativeParty
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setTaxRepresentativeParty(\Novadan\Uyumsoft\StructType\PartyType $taxRepresentativeParty = null)
    {
        $this->TaxRepresentativeParty = $taxRepresentativeParty;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Novadan\Uyumsoft\StructType\DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * This method is responsible for validating the values passed to the setDelivery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryForArrayConstraintsFromSetDelivery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeDeliveryItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeDeliveryItem instanceof \Novadan\Uyumsoft\StructType\DeliveryType) {
                $invalidValues[] = is_object($invoiceTypeDeliveryItem) ? get_class($invoiceTypeDeliveryItem) : sprintf('%s(%s)', gettype($invoiceTypeDeliveryItem), var_export($invoiceTypeDeliveryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Delivery property can only contain items of type \Novadan\Uyumsoft\StructType\DeliveryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Delivery value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DeliveryType[] $delivery
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setDelivery(array $delivery = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryArrayErrorMessage = self::validateDeliveryForArrayConstraintsFromSetDelivery($delivery))) {
            throw new \InvalidArgumentException($deliveryArrayErrorMessage, __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DeliveryType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToDelivery(\Novadan\Uyumsoft\StructType\DeliveryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DeliveryType) {
            throw new \InvalidArgumentException(sprintf('The Delivery property can only contain items of type \Novadan\Uyumsoft\StructType\DeliveryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Get PaymentMeans value
     * @return \Novadan\Uyumsoft\StructType\PaymentMeansType[]|null
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMeans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMeans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMeansForArrayConstraintsFromSetPaymentMeans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypePaymentMeansItem) {
            // validation for constraint: itemType
            if (!$invoiceTypePaymentMeansItem instanceof \Novadan\Uyumsoft\StructType\PaymentMeansType) {
                $invalidValues[] = is_object($invoiceTypePaymentMeansItem) ? get_class($invoiceTypePaymentMeansItem) : sprintf('%s(%s)', gettype($invoiceTypePaymentMeansItem), var_export($invoiceTypePaymentMeansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentMeans property can only contain items of type \Novadan\Uyumsoft\StructType\PaymentMeansType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMeans value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PaymentMeansType[] $paymentMeans
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setPaymentMeans(array $paymentMeans = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMeansArrayErrorMessage = self::validatePaymentMeansForArrayConstraintsFromSetPaymentMeans($paymentMeans))) {
            throw new \InvalidArgumentException($paymentMeansArrayErrorMessage, __LINE__);
        }
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }
    /**
     * Add item to PaymentMeans value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PaymentMeansType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToPaymentMeans(\Novadan\Uyumsoft\StructType\PaymentMeansType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\PaymentMeansType) {
            throw new \InvalidArgumentException(sprintf('The PaymentMeans property can only contain items of type \Novadan\Uyumsoft\StructType\PaymentMeansType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentMeans[] = $item;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return \Novadan\Uyumsoft\StructType\PaymentTermsType|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * Set PaymentTerms value
     * @param \Novadan\Uyumsoft\StructType\PaymentTermsType $paymentTerms
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setPaymentTerms(\Novadan\Uyumsoft\StructType\PaymentTermsType $paymentTerms = null)
    {
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \Novadan\Uyumsoft\StructType\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeAllowanceChargeItem instanceof \Novadan\Uyumsoft\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($invoiceTypeAllowanceChargeItem) ? get_class($invoiceTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($invoiceTypeAllowanceChargeItem), var_export($invoiceTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \Novadan\Uyumsoft\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\AllowanceChargeType[] $allowanceCharge
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\AllowanceChargeType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToAllowanceCharge(\Novadan\Uyumsoft\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \Novadan\Uyumsoft\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get TaxExchangeRate value
     * @return \Novadan\Uyumsoft\StructType\ExchangeRateType|null
     */
    public function getTaxExchangeRate()
    {
        return $this->TaxExchangeRate;
    }
    /**
     * Set TaxExchangeRate value
     * @param \Novadan\Uyumsoft\StructType\ExchangeRateType $taxExchangeRate
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setTaxExchangeRate(\Novadan\Uyumsoft\StructType\ExchangeRateType $taxExchangeRate = null)
    {
        $this->TaxExchangeRate = $taxExchangeRate;
        return $this;
    }
    /**
     * Get PricingExchangeRate value
     * @return \Novadan\Uyumsoft\StructType\ExchangeRateType|null
     */
    public function getPricingExchangeRate()
    {
        return $this->PricingExchangeRate;
    }
    /**
     * Set PricingExchangeRate value
     * @param \Novadan\Uyumsoft\StructType\ExchangeRateType $pricingExchangeRate
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setPricingExchangeRate(\Novadan\Uyumsoft\StructType\ExchangeRateType $pricingExchangeRate = null)
    {
        $this->PricingExchangeRate = $pricingExchangeRate;
        return $this;
    }
    /**
     * Get PaymentExchangeRate value
     * @return \Novadan\Uyumsoft\StructType\ExchangeRateType|null
     */
    public function getPaymentExchangeRate()
    {
        return $this->PaymentExchangeRate;
    }
    /**
     * Set PaymentExchangeRate value
     * @param \Novadan\Uyumsoft\StructType\ExchangeRateType $paymentExchangeRate
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setPaymentExchangeRate(\Novadan\Uyumsoft\StructType\ExchangeRateType $paymentExchangeRate = null)
    {
        $this->PaymentExchangeRate = $paymentExchangeRate;
        return $this;
    }
    /**
     * Get PaymentAlternativeExchangeRate value
     * @return \Novadan\Uyumsoft\StructType\ExchangeRateType|null
     */
    public function getPaymentAlternativeExchangeRate()
    {
        return $this->PaymentAlternativeExchangeRate;
    }
    /**
     * Set PaymentAlternativeExchangeRate value
     * @param \Novadan\Uyumsoft\StructType\ExchangeRateType $paymentAlternativeExchangeRate
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setPaymentAlternativeExchangeRate(\Novadan\Uyumsoft\StructType\ExchangeRateType $paymentAlternativeExchangeRate = null)
    {
        $this->PaymentAlternativeExchangeRate = $paymentAlternativeExchangeRate;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \Novadan\Uyumsoft\StructType\TaxTotalType[]|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTotalForArrayConstraintsFromSetTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeTaxTotalItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeTaxTotalItem instanceof \Novadan\Uyumsoft\StructType\TaxTotalType) {
                $invalidValues[] = is_object($invoiceTypeTaxTotalItem) ? get_class($invoiceTypeTaxTotalItem) : sprintf('%s(%s)', gettype($invoiceTypeTaxTotalItem), var_export($invoiceTypeTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxTotal property can only contain items of type \Novadan\Uyumsoft\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxTotal value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TaxTotalType[] $taxTotal
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setTaxTotal(array $taxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTotalArrayErrorMessage = self::validateTaxTotalForArrayConstraintsFromSetTaxTotal($taxTotal))) {
            throw new \InvalidArgumentException($taxTotalArrayErrorMessage, __LINE__);
        }
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Add item to TaxTotal value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TaxTotalType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToTaxTotal(\Novadan\Uyumsoft\StructType\TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\TaxTotalType) {
            throw new \InvalidArgumentException(sprintf('The TaxTotal property can only contain items of type \Novadan\Uyumsoft\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxTotal[] = $item;
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * @return \Novadan\Uyumsoft\StructType\TaxTotalType[]|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }
    /**
     * This method is responsible for validating the values passed to the setWithholdingTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholdingTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeWithholdingTaxTotalItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeWithholdingTaxTotalItem instanceof \Novadan\Uyumsoft\StructType\TaxTotalType) {
                $invalidValues[] = is_object($invoiceTypeWithholdingTaxTotalItem) ? get_class($invoiceTypeWithholdingTaxTotalItem) : sprintf('%s(%s)', gettype($invoiceTypeWithholdingTaxTotalItem), var_export($invoiceTypeWithholdingTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithholdingTaxTotal property can only contain items of type \Novadan\Uyumsoft\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TaxTotalType[] $withholdingTaxTotal
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setWithholdingTaxTotal(array $withholdingTaxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($withholdingTaxTotalArrayErrorMessage = self::validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal($withholdingTaxTotal))) {
            throw new \InvalidArgumentException($withholdingTaxTotalArrayErrorMessage, __LINE__);
        }
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }
    /**
     * Add item to WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TaxTotalType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToWithholdingTaxTotal(\Novadan\Uyumsoft\StructType\TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\TaxTotalType) {
            throw new \InvalidArgumentException(sprintf('The WithholdingTaxTotal property can only contain items of type \Novadan\Uyumsoft\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithholdingTaxTotal[] = $item;
        return $this;
    }
    /**
     * Get LegalMonetaryTotal value
     * @return \Novadan\Uyumsoft\StructType\MonetaryTotalType|null
     */
    public function getLegalMonetaryTotal()
    {
        return $this->LegalMonetaryTotal;
    }
    /**
     * Set LegalMonetaryTotal value
     * @param \Novadan\Uyumsoft\StructType\MonetaryTotalType $legalMonetaryTotal
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setLegalMonetaryTotal(\Novadan\Uyumsoft\StructType\MonetaryTotalType $legalMonetaryTotal = null)
    {
        $this->LegalMonetaryTotal = $legalMonetaryTotal;
        return $this;
    }
    /**
     * Get InvoiceLine value
     * @return \Novadan\Uyumsoft\StructType\InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceLineForArrayConstraintsFromSetInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeInvoiceLineItem instanceof \Novadan\Uyumsoft\StructType\InvoiceLineType) {
                $invalidValues[] = is_object($invoiceTypeInvoiceLineItem) ? get_class($invoiceTypeInvoiceLineItem) : sprintf('%s(%s)', gettype($invoiceTypeInvoiceLineItem), var_export($invoiceTypeInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceLine property can only contain items of type \Novadan\Uyumsoft\StructType\InvoiceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\InvoiceLineType[] $invoiceLine
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceLineArrayErrorMessage = self::validateInvoiceLineForArrayConstraintsFromSetInvoiceLine($invoiceLine))) {
            throw new \InvalidArgumentException($invoiceLineArrayErrorMessage, __LINE__);
        }
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\InvoiceLineType $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function addToInvoiceLine(\Novadan\Uyumsoft\StructType\InvoiceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\InvoiceLineType) {
            throw new \InvalidArgumentException(sprintf('The InvoiceLine property can only contain items of type \Novadan\Uyumsoft\StructType\InvoiceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get schemaLocation value
     * @return string|null
     */
    public function getSchemaLocation()
    {
        return $this->schemaLocation;
    }
    /**
     * Set schemaLocation value
     * @param string $schemaLocation
     * @return \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public function setSchemaLocation($schemaLocation = null)
    {
        // validation for constraint: string
        if (!is_null($schemaLocation) && !is_string($schemaLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemaLocation, true), gettype($schemaLocation)), __LINE__);
        }
        $this->schemaLocation = $schemaLocation;
        return $this;
    }
}
