<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceQueryModel StructType
 * @subpackage Structs
 */
class InvoiceQueryModel extends PagedQueryContext
{
    /**
     * The ExecutionStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionStartDate;
    /**
     * The ExecutionEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionEndDate;
    /**
     * The InvoiceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $InvoiceIds;
    /**
     * The InvoiceNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $InvoiceNumbers;
    /**
     * Constructor method for InvoiceQueryModel
     * @uses InvoiceQueryModel::setExecutionStartDate()
     * @uses InvoiceQueryModel::setExecutionEndDate()
     * @uses InvoiceQueryModel::setInvoiceIds()
     * @uses InvoiceQueryModel::setInvoiceNumbers()
     * @param string $executionStartDate
     * @param string $executionEndDate
     * @param string[] $invoiceIds
     * @param string[] $invoiceNumbers
     */
    public function __construct($executionStartDate = null, $executionEndDate = null, array $invoiceIds = array(), array $invoiceNumbers = array())
    {
        $this
            ->setExecutionStartDate($executionStartDate)
            ->setExecutionEndDate($executionEndDate)
            ->setInvoiceIds($invoiceIds)
            ->setInvoiceNumbers($invoiceNumbers);
    }
    /**
     * Get ExecutionStartDate value
     * @return string
     */
    public function getExecutionStartDate()
    {
        return $this->ExecutionStartDate;
    }
    /**
     * Set ExecutionStartDate value
     * @param string $executionStartDate
     * @return \Novadan\Uyumsoft\StructType\InvoiceQueryModel
     */
    public function setExecutionStartDate($executionStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionStartDate) && !is_string($executionStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionStartDate, true), gettype($executionStartDate)), __LINE__);
        }
        $this->ExecutionStartDate = $executionStartDate;
        return $this;
    }
    /**
     * Get ExecutionEndDate value
     * @return string
     */
    public function getExecutionEndDate()
    {
        return $this->ExecutionEndDate;
    }
    /**
     * Set ExecutionEndDate value
     * @param string $executionEndDate
     * @return \Novadan\Uyumsoft\StructType\InvoiceQueryModel
     */
    public function setExecutionEndDate($executionEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionEndDate) && !is_string($executionEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionEndDate, true), gettype($executionEndDate)), __LINE__);
        }
        $this->ExecutionEndDate = $executionEndDate;
        return $this;
    }
    /**
     * Get InvoiceIds value
     * @return string[]|null
     */
    public function getInvoiceIds()
    {
        return $this->InvoiceIds;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceIdsForArrayConstraintsFromSetInvoiceIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceQueryModelInvoiceIdsItem) {
            // validation for constraint: itemType
            if (!is_string($invoiceQueryModelInvoiceIdsItem)) {
                $invalidValues[] = is_object($invoiceQueryModelInvoiceIdsItem) ? get_class($invoiceQueryModelInvoiceIdsItem) : sprintf('%s(%s)', gettype($invoiceQueryModelInvoiceIdsItem), var_export($invoiceQueryModelInvoiceIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceIds value
     * @throws \InvalidArgumentException
     * @param string[] $invoiceIds
     * @return \Novadan\Uyumsoft\StructType\InvoiceQueryModel
     */
    public function setInvoiceIds(array $invoiceIds = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceIdsArrayErrorMessage = self::validateInvoiceIdsForArrayConstraintsFromSetInvoiceIds($invoiceIds))) {
            throw new \InvalidArgumentException($invoiceIdsArrayErrorMessage, __LINE__);
        }
        $this->InvoiceIds = $invoiceIds;
        return $this;
    }
    /**
     * Add item to InvoiceIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceQueryModel
     */
    public function addToInvoiceIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The InvoiceIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceIds[] = $item;
        return $this;
    }
    /**
     * Get InvoiceNumbers value
     * @return string[]|null
     */
    public function getInvoiceNumbers()
    {
        return $this->InvoiceNumbers;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceNumbers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceNumbers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceNumbersForArrayConstraintsFromSetInvoiceNumbers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceQueryModelInvoiceNumbersItem) {
            // validation for constraint: itemType
            if (!is_string($invoiceQueryModelInvoiceNumbersItem)) {
                $invalidValues[] = is_object($invoiceQueryModelInvoiceNumbersItem) ? get_class($invoiceQueryModelInvoiceNumbersItem) : sprintf('%s(%s)', gettype($invoiceQueryModelInvoiceNumbersItem), var_export($invoiceQueryModelInvoiceNumbersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceNumbers property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceNumbers value
     * @throws \InvalidArgumentException
     * @param string[] $invoiceNumbers
     * @return \Novadan\Uyumsoft\StructType\InvoiceQueryModel
     */
    public function setInvoiceNumbers(array $invoiceNumbers = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceNumbersArrayErrorMessage = self::validateInvoiceNumbersForArrayConstraintsFromSetInvoiceNumbers($invoiceNumbers))) {
            throw new \InvalidArgumentException($invoiceNumbersArrayErrorMessage, __LINE__);
        }
        $this->InvoiceNumbers = $invoiceNumbers;
        return $this;
    }
    /**
     * Add item to InvoiceNumbers value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceQueryModel
     */
    public function addToInvoiceNumbers($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The InvoiceNumbers property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceNumbers[] = $item;
        return $this;
    }
}
