<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceListQueryModel StructType
 * @subpackage Structs
 */
class InvoiceListQueryModel extends PagedQueryContext
{
    /**
     * The ExecutionStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionStartDate;
    /**
     * The ExecutionEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionEndDate;
    /**
     * The CreateStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreateStartDate;
    /**
     * The CreateEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreateEndDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SortColumn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SortColumn;
    /**
     * The SortMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SortMode;
    /**
     * The IsArchived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsArchived;
    /**
     * The InvoiceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $InvoiceIds;
    /**
     * The InvoiceNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $InvoiceNumbers;
    /**
     * The StatusInList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $StatusInList;
    /**
     * The StatusNotInList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $StatusNotInList;
    /**
     * Constructor method for InvoiceListQueryModel
     * @uses InvoiceListQueryModel::setExecutionStartDate()
     * @uses InvoiceListQueryModel::setExecutionEndDate()
     * @uses InvoiceListQueryModel::setCreateStartDate()
     * @uses InvoiceListQueryModel::setCreateEndDate()
     * @uses InvoiceListQueryModel::setStatus()
     * @uses InvoiceListQueryModel::setSortColumn()
     * @uses InvoiceListQueryModel::setSortMode()
     * @uses InvoiceListQueryModel::setIsArchived()
     * @uses InvoiceListQueryModel::setInvoiceIds()
     * @uses InvoiceListQueryModel::setInvoiceNumbers()
     * @uses InvoiceListQueryModel::setStatusInList()
     * @uses InvoiceListQueryModel::setStatusNotInList()
     * @param string $executionStartDate
     * @param string $executionEndDate
     * @param string $createStartDate
     * @param string $createEndDate
     * @param string $status
     * @param string $sortColumn
     * @param string $sortMode
     * @param bool $isArchived
     * @param string[] $invoiceIds
     * @param string[] $invoiceNumbers
     * @param string[] $statusInList
     * @param string[] $statusNotInList
     */
    public function __construct($executionStartDate = null, $executionEndDate = null, $createStartDate = null, $createEndDate = null, $status = null, $sortColumn = null, $sortMode = null, $isArchived = null, array $invoiceIds = array(), array $invoiceNumbers = array(), array $statusInList = array(), array $statusNotInList = array())
    {
        $this
            ->setExecutionStartDate($executionStartDate)
            ->setExecutionEndDate($executionEndDate)
            ->setCreateStartDate($createStartDate)
            ->setCreateEndDate($createEndDate)
            ->setStatus($status)
            ->setSortColumn($sortColumn)
            ->setSortMode($sortMode)
            ->setIsArchived($isArchived)
            ->setInvoiceIds($invoiceIds)
            ->setInvoiceNumbers($invoiceNumbers)
            ->setStatusInList($statusInList)
            ->setStatusNotInList($statusNotInList);
    }
    /**
     * Get ExecutionStartDate value
     * @return string
     */
    public function getExecutionStartDate()
    {
        return $this->ExecutionStartDate;
    }
    /**
     * Set ExecutionStartDate value
     * @param string $executionStartDate
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setExecutionStartDate($executionStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionStartDate) && !is_string($executionStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionStartDate, true), gettype($executionStartDate)), __LINE__);
        }
        $this->ExecutionStartDate = $executionStartDate;
        return $this;
    }
    /**
     * Get ExecutionEndDate value
     * @return string
     */
    public function getExecutionEndDate()
    {
        return $this->ExecutionEndDate;
    }
    /**
     * Set ExecutionEndDate value
     * @param string $executionEndDate
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setExecutionEndDate($executionEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionEndDate) && !is_string($executionEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionEndDate, true), gettype($executionEndDate)), __LINE__);
        }
        $this->ExecutionEndDate = $executionEndDate;
        return $this;
    }
    /**
     * Get CreateStartDate value
     * @return string
     */
    public function getCreateStartDate()
    {
        return $this->CreateStartDate;
    }
    /**
     * Set CreateStartDate value
     * @param string $createStartDate
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setCreateStartDate($createStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($createStartDate) && !is_string($createStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createStartDate, true), gettype($createStartDate)), __LINE__);
        }
        $this->CreateStartDate = $createStartDate;
        return $this;
    }
    /**
     * Get CreateEndDate value
     * @return string
     */
    public function getCreateEndDate()
    {
        return $this->CreateEndDate;
    }
    /**
     * Set CreateEndDate value
     * @param string $createEndDate
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setCreateEndDate($createEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($createEndDate) && !is_string($createEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createEndDate, true), gettype($createEndDate)), __LINE__);
        }
        $this->CreateEndDate = $createEndDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SortColumn value
     * @return string
     */
    public function getSortColumn()
    {
        return $this->SortColumn;
    }
    /**
     * Set SortColumn value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceListSortingColumn::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceListSortingColumn::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortColumn
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setSortColumn($sortColumn = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\InvoiceListSortingColumn::valueIsValid($sortColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceListSortingColumn', is_array($sortColumn) ? implode(', ', $sortColumn) : var_export($sortColumn, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceListSortingColumn::getValidValues())), __LINE__);
        }
        $this->SortColumn = $sortColumn;
        return $this;
    }
    /**
     * Get SortMode value
     * @return string
     */
    public function getSortMode()
    {
        return $this->SortMode;
    }
    /**
     * Set SortMode value
     * @uses \Novadan\Uyumsoft\EnumType\QuerySortMode::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\QuerySortMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortMode
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setSortMode($sortMode = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\QuerySortMode::valueIsValid($sortMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\QuerySortMode', is_array($sortMode) ? implode(', ', $sortMode) : var_export($sortMode, true), implode(', ', \Novadan\Uyumsoft\EnumType\QuerySortMode::getValidValues())), __LINE__);
        }
        $this->SortMode = $sortMode;
        return $this;
    }
    /**
     * Get IsArchived value
     * @return bool
     */
    public function getIsArchived()
    {
        return $this->IsArchived;
    }
    /**
     * Set IsArchived value
     * @param bool $isArchived
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setIsArchived($isArchived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isArchived) && !is_bool($isArchived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isArchived, true), gettype($isArchived)), __LINE__);
        }
        $this->IsArchived = $isArchived;
        return $this;
    }
    /**
     * Get InvoiceIds value
     * @return string[]|null
     */
    public function getInvoiceIds()
    {
        return $this->InvoiceIds;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceIdsForArrayConstraintsFromSetInvoiceIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceListQueryModelInvoiceIdsItem) {
            // validation for constraint: itemType
            if (!is_string($invoiceListQueryModelInvoiceIdsItem)) {
                $invalidValues[] = is_object($invoiceListQueryModelInvoiceIdsItem) ? get_class($invoiceListQueryModelInvoiceIdsItem) : sprintf('%s(%s)', gettype($invoiceListQueryModelInvoiceIdsItem), var_export($invoiceListQueryModelInvoiceIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceIds value
     * @throws \InvalidArgumentException
     * @param string[] $invoiceIds
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setInvoiceIds(array $invoiceIds = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceIdsArrayErrorMessage = self::validateInvoiceIdsForArrayConstraintsFromSetInvoiceIds($invoiceIds))) {
            throw new \InvalidArgumentException($invoiceIdsArrayErrorMessage, __LINE__);
        }
        $this->InvoiceIds = $invoiceIds;
        return $this;
    }
    /**
     * Add item to InvoiceIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function addToInvoiceIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The InvoiceIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceIds[] = $item;
        return $this;
    }
    /**
     * Get InvoiceNumbers value
     * @return string[]|null
     */
    public function getInvoiceNumbers()
    {
        return $this->InvoiceNumbers;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceNumbers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceNumbers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceNumbersForArrayConstraintsFromSetInvoiceNumbers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceListQueryModelInvoiceNumbersItem) {
            // validation for constraint: itemType
            if (!is_string($invoiceListQueryModelInvoiceNumbersItem)) {
                $invalidValues[] = is_object($invoiceListQueryModelInvoiceNumbersItem) ? get_class($invoiceListQueryModelInvoiceNumbersItem) : sprintf('%s(%s)', gettype($invoiceListQueryModelInvoiceNumbersItem), var_export($invoiceListQueryModelInvoiceNumbersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceNumbers property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceNumbers value
     * @throws \InvalidArgumentException
     * @param string[] $invoiceNumbers
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setInvoiceNumbers(array $invoiceNumbers = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceNumbersArrayErrorMessage = self::validateInvoiceNumbersForArrayConstraintsFromSetInvoiceNumbers($invoiceNumbers))) {
            throw new \InvalidArgumentException($invoiceNumbersArrayErrorMessage, __LINE__);
        }
        $this->InvoiceNumbers = $invoiceNumbers;
        return $this;
    }
    /**
     * Add item to InvoiceNumbers value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function addToInvoiceNumbers($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The InvoiceNumbers property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceNumbers[] = $item;
        return $this;
    }
    /**
     * Get StatusInList value
     * @return string[]|null
     */
    public function getStatusInList()
    {
        return $this->StatusInList;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusInList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusInList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusInListForArrayConstraintsFromSetStatusInList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceListQueryModelStatusInListItem) {
            // validation for constraint: enumeration
            if (!\Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid($invoiceListQueryModelStatusInListItem)) {
                $invalidValues[] = is_object($invoiceListQueryModelStatusInListItem) ? get_class($invoiceListQueryModelStatusInListItem) : sprintf('%s(%s)', gettype($invoiceListQueryModelStatusInListItem), var_export($invoiceListQueryModelStatusInListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatusInList value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $statusInList
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setStatusInList(array $statusInList = array())
    {
        // validation for constraint: array
        if ('' !== ($statusInListArrayErrorMessage = self::validateStatusInListForArrayConstraintsFromSetStatusInList($statusInList))) {
            throw new \InvalidArgumentException($statusInListArrayErrorMessage, __LINE__);
        }
        $this->StatusInList = $statusInList;
        return $this;
    }
    /**
     * Add item to StatusInList value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function addToStatusInList($item)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceStatus', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues())), __LINE__);
        }
        $this->StatusInList[] = $item;
        return $this;
    }
    /**
     * Get StatusNotInList value
     * @return string[]|null
     */
    public function getStatusNotInList()
    {
        return $this->StatusNotInList;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusNotInList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusNotInList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusNotInListForArrayConstraintsFromSetStatusNotInList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceListQueryModelStatusNotInListItem) {
            // validation for constraint: enumeration
            if (!\Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid($invoiceListQueryModelStatusNotInListItem)) {
                $invalidValues[] = is_object($invoiceListQueryModelStatusNotInListItem) ? get_class($invoiceListQueryModelStatusNotInListItem) : sprintf('%s(%s)', gettype($invoiceListQueryModelStatusNotInListItem), var_export($invoiceListQueryModelStatusNotInListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatusNotInList value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $statusNotInList
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function setStatusNotInList(array $statusNotInList = array())
    {
        // validation for constraint: array
        if ('' !== ($statusNotInListArrayErrorMessage = self::validateStatusNotInListForArrayConstraintsFromSetStatusNotInList($statusNotInList))) {
            throw new \InvalidArgumentException($statusNotInListArrayErrorMessage, __LINE__);
        }
        $this->StatusNotInList = $statusNotInList;
        return $this;
    }
    /**
     * Add item to StatusNotInList value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceListQueryModel
     */
    public function addToStatusNotInList($item)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceStatus', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues())), __LINE__);
        }
        $this->StatusNotInList[] = $item;
        return $this;
    }
}
