<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazardousGoodsTransitType StructType
 * @subpackage Structs
 */
class HazardousGoodsTransitType extends AbstractStructBase
{
    /**
     * The TransportEmergencyCardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q233:TransportEmergencyCardCode
     * @var \Novadan\Uyumsoft\StructType\TransportEmergencyCardCodeType
     */
    public $TransportEmergencyCardCode;
    /**
     * The PackingCriteriaCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q234:PackingCriteriaCode
     * @var \Novadan\Uyumsoft\StructType\PackingCriteriaCodeType
     */
    public $PackingCriteriaCode;
    /**
     * The HazardousRegulationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q235:HazardousRegulationCode
     * @var \Novadan\Uyumsoft\StructType\HazardousRegulationCodeType
     */
    public $HazardousRegulationCode;
    /**
     * The InhalationToxicityZoneCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q236:InhalationToxicityZoneCode
     * @var \Novadan\Uyumsoft\StructType\InhalationToxicityZoneCodeType
     */
    public $InhalationToxicityZoneCode;
    /**
     * The TransportAuthorizationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q237:TransportAuthorizationCode
     * @var \Novadan\Uyumsoft\StructType\TransportAuthorizationCodeType
     */
    public $TransportAuthorizationCode;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * Constructor method for HazardousGoodsTransitType
     * @uses HazardousGoodsTransitType::setTransportEmergencyCardCode()
     * @uses HazardousGoodsTransitType::setPackingCriteriaCode()
     * @uses HazardousGoodsTransitType::setHazardousRegulationCode()
     * @uses HazardousGoodsTransitType::setInhalationToxicityZoneCode()
     * @uses HazardousGoodsTransitType::setTransportAuthorizationCode()
     * @uses HazardousGoodsTransitType::setMaximumTemperature()
     * @uses HazardousGoodsTransitType::setMinimumTemperature()
     * @param \Novadan\Uyumsoft\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @param \Novadan\Uyumsoft\StructType\PackingCriteriaCodeType $packingCriteriaCode
     * @param \Novadan\Uyumsoft\StructType\HazardousRegulationCodeType $hazardousRegulationCode
     * @param \Novadan\Uyumsoft\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @param \Novadan\Uyumsoft\StructType\TransportAuthorizationCodeType $transportAuthorizationCode
     * @param \Novadan\Uyumsoft\StructType\TemperatureType $maximumTemperature
     * @param \Novadan\Uyumsoft\StructType\TemperatureType $minimumTemperature
     */
    public function __construct(\Novadan\Uyumsoft\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode = null, \Novadan\Uyumsoft\StructType\PackingCriteriaCodeType $packingCriteriaCode = null, \Novadan\Uyumsoft\StructType\HazardousRegulationCodeType $hazardousRegulationCode = null, \Novadan\Uyumsoft\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null, \Novadan\Uyumsoft\StructType\TransportAuthorizationCodeType $transportAuthorizationCode = null, \Novadan\Uyumsoft\StructType\TemperatureType $maximumTemperature = null, \Novadan\Uyumsoft\StructType\TemperatureType $minimumTemperature = null)
    {
        $this
            ->setTransportEmergencyCardCode($transportEmergencyCardCode)
            ->setPackingCriteriaCode($packingCriteriaCode)
            ->setHazardousRegulationCode($hazardousRegulationCode)
            ->setInhalationToxicityZoneCode($inhalationToxicityZoneCode)
            ->setTransportAuthorizationCode($transportAuthorizationCode)
            ->setMaximumTemperature($maximumTemperature)
            ->setMinimumTemperature($minimumTemperature);
    }
    /**
     * Get TransportEmergencyCardCode value
     * @return \Novadan\Uyumsoft\StructType\TransportEmergencyCardCodeType|null
     */
    public function getTransportEmergencyCardCode()
    {
        return $this->TransportEmergencyCardCode;
    }
    /**
     * Set TransportEmergencyCardCode value
     * @param \Novadan\Uyumsoft\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @return \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType
     */
    public function setTransportEmergencyCardCode(\Novadan\Uyumsoft\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode = null)
    {
        $this->TransportEmergencyCardCode = $transportEmergencyCardCode;
        return $this;
    }
    /**
     * Get PackingCriteriaCode value
     * @return \Novadan\Uyumsoft\StructType\PackingCriteriaCodeType|null
     */
    public function getPackingCriteriaCode()
    {
        return $this->PackingCriteriaCode;
    }
    /**
     * Set PackingCriteriaCode value
     * @param \Novadan\Uyumsoft\StructType\PackingCriteriaCodeType $packingCriteriaCode
     * @return \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType
     */
    public function setPackingCriteriaCode(\Novadan\Uyumsoft\StructType\PackingCriteriaCodeType $packingCriteriaCode = null)
    {
        $this->PackingCriteriaCode = $packingCriteriaCode;
        return $this;
    }
    /**
     * Get HazardousRegulationCode value
     * @return \Novadan\Uyumsoft\StructType\HazardousRegulationCodeType|null
     */
    public function getHazardousRegulationCode()
    {
        return $this->HazardousRegulationCode;
    }
    /**
     * Set HazardousRegulationCode value
     * @param \Novadan\Uyumsoft\StructType\HazardousRegulationCodeType $hazardousRegulationCode
     * @return \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType
     */
    public function setHazardousRegulationCode(\Novadan\Uyumsoft\StructType\HazardousRegulationCodeType $hazardousRegulationCode = null)
    {
        $this->HazardousRegulationCode = $hazardousRegulationCode;
        return $this;
    }
    /**
     * Get InhalationToxicityZoneCode value
     * @return \Novadan\Uyumsoft\StructType\InhalationToxicityZoneCodeType|null
     */
    public function getInhalationToxicityZoneCode()
    {
        return $this->InhalationToxicityZoneCode;
    }
    /**
     * Set InhalationToxicityZoneCode value
     * @param \Novadan\Uyumsoft\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @return \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType
     */
    public function setInhalationToxicityZoneCode(\Novadan\Uyumsoft\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null)
    {
        $this->InhalationToxicityZoneCode = $inhalationToxicityZoneCode;
        return $this;
    }
    /**
     * Get TransportAuthorizationCode value
     * @return \Novadan\Uyumsoft\StructType\TransportAuthorizationCodeType|null
     */
    public function getTransportAuthorizationCode()
    {
        return $this->TransportAuthorizationCode;
    }
    /**
     * Set TransportAuthorizationCode value
     * @param \Novadan\Uyumsoft\StructType\TransportAuthorizationCodeType $transportAuthorizationCode
     * @return \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType
     */
    public function setTransportAuthorizationCode(\Novadan\Uyumsoft\StructType\TransportAuthorizationCodeType $transportAuthorizationCode = null)
    {
        $this->TransportAuthorizationCode = $transportAuthorizationCode;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \Novadan\Uyumsoft\StructType\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \Novadan\Uyumsoft\StructType\TemperatureType $maximumTemperature
     * @return \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType
     */
    public function setMaximumTemperature(\Novadan\Uyumsoft\StructType\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \Novadan\Uyumsoft\StructType\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \Novadan\Uyumsoft\StructType\TemperatureType $minimumTemperature
     * @return \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType
     */
    public function setMinimumTemperature(\Novadan\Uyumsoft\StructType\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
}
