<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnvelopeData StructType
 * @subpackage Structs
 */
class EnvelopeData extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The Envelope
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Envelope;
    /**
     * The EnvelopeIdentifier
     * @var string
     */
    public $EnvelopeIdentifier;
    /**
     * Constructor method for EnvelopeData
     * @uses EnvelopeData::setStatus()
     * @uses EnvelopeData::setStatusCode()
     * @uses EnvelopeData::setEnvelope()
     * @uses EnvelopeData::setEnvelopeIdentifier()
     * @param string $status
     * @param int $statusCode
     * @param string $envelope
     * @param string $envelopeIdentifier
     */
    public function __construct($status = null, $statusCode = null, $envelope = null, $envelopeIdentifier = null)
    {
        $this
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setEnvelope($envelope)
            ->setEnvelopeIdentifier($envelopeIdentifier);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \Novadan\Uyumsoft\EnumType\EnvelopeStatus::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\EnvelopeStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Novadan\Uyumsoft\StructType\EnvelopeData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\EnvelopeStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\EnvelopeStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \Novadan\Uyumsoft\EnumType\EnvelopeStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \Novadan\Uyumsoft\StructType\EnvelopeData
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Envelope value
     * @return string|null
     */
    public function getEnvelope()
    {
        return $this->Envelope;
    }
    /**
     * Set Envelope value
     * @param string $envelope
     * @return \Novadan\Uyumsoft\StructType\EnvelopeData
     */
    public function setEnvelope($envelope = null)
    {
        // validation for constraint: string
        if (!is_null($envelope) && !is_string($envelope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($envelope, true), gettype($envelope)), __LINE__);
        }
        $this->Envelope = $envelope;
        return $this;
    }
    /**
     * Get EnvelopeIdentifier value
     * @return string|null
     */
    public function getEnvelopeIdentifier()
    {
        return $this->EnvelopeIdentifier;
    }
    /**
     * Set EnvelopeIdentifier value
     * @param string $envelopeIdentifier
     * @return \Novadan\Uyumsoft\StructType\EnvelopeData
     */
    public function setEnvelopeIdentifier($envelopeIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($envelopeIdentifier) && !is_string($envelopeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($envelopeIdentifier, true), gettype($envelopeIdentifier)), __LINE__);
        }
        $this->EnvelopeIdentifier = $envelopeIdentifier;
        return $this;
    }
}
