<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentResponseInfo StructType
 * @subpackage Structs
 */
class DocumentResponseInfo extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResponseStatus;
    /**
     * The LineResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\ArrayType\ArrayOfLineResponseInfo
     */
    public $LineResponses;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for DocumentResponseInfo
     * @uses DocumentResponseInfo::setResponseStatus()
     * @uses DocumentResponseInfo::setLineResponses()
     * @uses DocumentResponseInfo::setInvoiceId()
     * @uses DocumentResponseInfo::setReason()
     * @param string $responseStatus
     * @param \Novadan\Uyumsoft\ArrayType\ArrayOfLineResponseInfo $lineResponses
     * @param string $invoiceId
     * @param string $reason
     */
    public function __construct($responseStatus = null, \Novadan\Uyumsoft\ArrayType\ArrayOfLineResponseInfo $lineResponses = null, $invoiceId = null, $reason = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setLineResponses($lineResponses)
            ->setInvoiceId($invoiceId)
            ->setReason($reason);
    }
    /**
     * Get ResponseStatus value
     * @return string
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @uses \Novadan\Uyumsoft\EnumType\DocumentResponseStatus::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\DocumentResponseStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $responseStatus
     * @return \Novadan\Uyumsoft\StructType\DocumentResponseInfo
     */
    public function setResponseStatus($responseStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\DocumentResponseStatus::valueIsValid($responseStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\DocumentResponseStatus', is_array($responseStatus) ? implode(', ', $responseStatus) : var_export($responseStatus, true), implode(', ', \Novadan\Uyumsoft\EnumType\DocumentResponseStatus::getValidValues())), __LINE__);
        }
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get LineResponses value
     * @return \Novadan\Uyumsoft\ArrayType\ArrayOfLineResponseInfo|null
     */
    public function getLineResponses()
    {
        return $this->LineResponses;
    }
    /**
     * Set LineResponses value
     * @param \Novadan\Uyumsoft\ArrayType\ArrayOfLineResponseInfo $lineResponses
     * @return \Novadan\Uyumsoft\StructType\DocumentResponseInfo
     */
    public function setLineResponses(\Novadan\Uyumsoft\ArrayType\ArrayOfLineResponseInfo $lineResponses = null)
    {
        $this->LineResponses = $lineResponses;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Novadan\Uyumsoft\StructType\DocumentResponseInfo
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \Novadan\Uyumsoft\StructType\DocumentResponseInfo
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
}
