<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClonedInvoiceInfo StructType
 * @subpackage Structs
 */
class ClonedInvoiceInfo extends AbstractStructBase
{
    /**
     * The SourceInvoiceId
     * @var string
     */
    public $SourceInvoiceId;
    /**
     * The ClonedInvoiceId
     * @var string
     */
    public $ClonedInvoiceId;
    /**
     * Constructor method for ClonedInvoiceInfo
     * @uses ClonedInvoiceInfo::setSourceInvoiceId()
     * @uses ClonedInvoiceInfo::setClonedInvoiceId()
     * @param string $sourceInvoiceId
     * @param string $clonedInvoiceId
     */
    public function __construct($sourceInvoiceId = null, $clonedInvoiceId = null)
    {
        $this
            ->setSourceInvoiceId($sourceInvoiceId)
            ->setClonedInvoiceId($clonedInvoiceId);
    }
    /**
     * Get SourceInvoiceId value
     * @return string|null
     */
    public function getSourceInvoiceId()
    {
        return $this->SourceInvoiceId;
    }
    /**
     * Set SourceInvoiceId value
     * @param string $sourceInvoiceId
     * @return \Novadan\Uyumsoft\StructType\ClonedInvoiceInfo
     */
    public function setSourceInvoiceId($sourceInvoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceInvoiceId) && !is_string($sourceInvoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceInvoiceId, true), gettype($sourceInvoiceId)), __LINE__);
        }
        $this->SourceInvoiceId = $sourceInvoiceId;
        return $this;
    }
    /**
     * Get ClonedInvoiceId value
     * @return string|null
     */
    public function getClonedInvoiceId()
    {
        return $this->ClonedInvoiceId;
    }
    /**
     * Set ClonedInvoiceId value
     * @param string $clonedInvoiceId
     * @return \Novadan\Uyumsoft\StructType\ClonedInvoiceInfo
     */
    public function setClonedInvoiceId($clonedInvoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($clonedInvoiceId) && !is_string($clonedInvoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clonedInvoiceId, true), gettype($clonedInvoiceId)), __LINE__);
        }
        $this->ClonedInvoiceId = $clonedInvoiceId;
        return $this;
    }
}
