<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validate ServiceType
 * @subpackage Services
 */
class Validate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValidateInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\ValidateInvoice $parameters
     * @return \Novadan\Uyumsoft\StructType\ValidateInvoiceResponse|bool
     */
    public function ValidateInvoice(\Novadan\Uyumsoft\StructType\ValidateInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\ValidateInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
