<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveAsDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\SaveAsDraft $parameters
     * @return \Novadan\Uyumsoft\StructType\SaveAsDraftResponse|bool
     */
    public function SaveAsDraft(\Novadan\Uyumsoft\StructType\SaveAsDraft $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveAsDraft($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\SaveAsDraftResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
