<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QueryInboxInvoiceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\QueryInboxInvoiceStatus $parameters
     * @return \Novadan\Uyumsoft\StructType\QueryInboxInvoiceStatusResponse|bool
     */
    public function QueryInboxInvoiceStatus(\Novadan\Uyumsoft\StructType\QueryInboxInvoiceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryInboxInvoiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryDocumentResponseStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\QueryDocumentResponseStatus $parameters
     * @return \Novadan\Uyumsoft\StructType\QueryDocumentResponseStatusResponse|bool
     */
    public function QueryDocumentResponseStatus(\Novadan\Uyumsoft\StructType\QueryDocumentResponseStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryDocumentResponseStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryOutboxInvoiceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\QueryOutboxInvoiceStatus $parameters
     * @return \Novadan\Uyumsoft\StructType\QueryOutboxInvoiceStatusResponse|bool
     */
    public function QueryOutboxInvoiceStatus(\Novadan\Uyumsoft\StructType\QueryOutboxInvoiceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryOutboxInvoiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryInvoiceGtbResponses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\QueryInvoiceGtbResponses $parameters
     * @return \Novadan\Uyumsoft\StructType\QueryInvoiceGtbResponsesResponse|bool
     */
    public function QueryInvoiceGtbResponses(\Novadan\Uyumsoft\StructType\QueryInvoiceGtbResponses $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryInvoiceGtbResponses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\QueryDocumentResponseStatusResponse|\Novadan\Uyumsoft\StructType\QueryInboxInvoiceStatusResponse|\Novadan\Uyumsoft\StructType\QueryInvoiceGtbResponsesResponse|\Novadan\Uyumsoft\StructType\QueryOutboxInvoiceStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
