<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\CancelDraft $parameters
     * @return \Novadan\Uyumsoft\StructType\CancelDraftResponse|bool
     */
    public function CancelDraft(\Novadan\Uyumsoft\StructType\CancelDraft $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelDraft($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelEArchiveInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\CancelEArchiveInvoice $parameters
     * @return \Novadan\Uyumsoft\StructType\CancelEArchiveInvoiceResponse|bool
     */
    public function CancelEArchiveInvoice(\Novadan\Uyumsoft\StructType\CancelEArchiveInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelEArchiveInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\CancelDraftResponse|\Novadan\Uyumsoft\StructType\CancelEArchiveInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
