<?php

namespace Novadan\Uyumsoft;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'SignatureType' => '\\Novadan\\Uyumsoft\\StructType\\SignatureType',
            'SignedInfoType' => '\\Novadan\\Uyumsoft\\StructType\\SignedInfoType',
            'CanonicalizationMethodType' => '\\Novadan\\Uyumsoft\\StructType\\CanonicalizationMethodType',
            'SignatureMethodType' => '\\Novadan\\Uyumsoft\\StructType\\SignatureMethodType',
            'ReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\ReferenceType',
            'ArrayOfTransformType' => '\\Novadan\\Uyumsoft\\ArrayType\\ArrayOfTransformType',
            'TransformType' => '\\Novadan\\Uyumsoft\\StructType\\TransformType',
            'DigestMethodType' => '\\Novadan\\Uyumsoft\\StructType\\DigestMethodType',
            'SignatureValueType' => '\\Novadan\\Uyumsoft\\StructType\\SignatureValueType',
            'KeyInfoType' => '\\Novadan\\Uyumsoft\\StructType\\KeyInfoType',
            'PGPDataType' => '\\Novadan\\Uyumsoft\\StructType\\PGPDataType',
            'RetrievalMethodType' => '\\Novadan\\Uyumsoft\\StructType\\RetrievalMethodType',
            'SPKIDataType' => '\\Novadan\\Uyumsoft\\StructType\\SPKIDataType',
            'X509DataType' => '\\Novadan\\Uyumsoft\\StructType\\X509DataType',
            'X509IssuerSerialType' => '\\Novadan\\Uyumsoft\\StructType\\X509IssuerSerialType',
            'KeyValueType' => '\\Novadan\\Uyumsoft\\StructType\\KeyValueType',
            'RSAKeyValueType' => '\\Novadan\\Uyumsoft\\StructType\\RSAKeyValueType',
            'DSAKeyValueType' => '\\Novadan\\Uyumsoft\\StructType\\DSAKeyValueType',
            'ObjectType' => '\\Novadan\\Uyumsoft\\StructType\\ObjectType',
            'IdentifierType' => '\\Novadan\\Uyumsoft\\StructType\\IdentifierType',
            'CodeType' => '\\Novadan\\Uyumsoft\\StructType\\CodeType',
            'TextType' => '\\Novadan\\Uyumsoft\\StructType\\TextType',
            'NumericType' => '\\Novadan\\Uyumsoft\\StructType\\NumericType',
            'MeasureType' => '\\Novadan\\Uyumsoft\\StructType\\MeasureType',
            'BinaryObjectType' => '\\Novadan\\Uyumsoft\\StructType\\BinaryObjectType',
            'AmountType' => '\\Novadan\\Uyumsoft\\StructType\\AmountType',
            'QuantityType' => '\\Novadan\\Uyumsoft\\StructType\\QuantityType',
            'IndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\IndicatorType',
            'DateType' => '\\Novadan\\Uyumsoft\\StructType\\DateType',
            'NameType' => '\\Novadan\\Uyumsoft\\StructType\\NameType',
            'RateType' => '\\Novadan\\Uyumsoft\\StructType\\RateType',
            'ValueType' => '\\Novadan\\Uyumsoft\\StructType\\ValueType',
            'PercentType' => '\\Novadan\\Uyumsoft\\StructType\\PercentType',
            'TimeType' => '\\Novadan\\Uyumsoft\\StructType\\TimeType',
            'SoundType' => '\\Novadan\\Uyumsoft\\StructType\\SoundType',
            'PictureType' => '\\Novadan\\Uyumsoft\\StructType\\PictureType',
            'VideoType' => '\\Novadan\\Uyumsoft\\StructType\\VideoType',
            'GraphicType' => '\\Novadan\\Uyumsoft\\StructType\\GraphicType',
            'ArrayOfUBLExtensionType' => '\\Novadan\\Uyumsoft\\ArrayType\\ArrayOfUBLExtensionType',
            'UBLExtensionType' => '\\Novadan\\Uyumsoft\\StructType\\UBLExtensionType',
            'ExtensionContentType' => '\\Novadan\\Uyumsoft\\StructType\\ExtensionContentType',
            'ExtensionAgencyURIType' => '\\Novadan\\Uyumsoft\\StructType\\ExtensionAgencyURIType',
            'ExtensionURIType' => '\\Novadan\\Uyumsoft\\StructType\\ExtensionURIType',
            'ExtensionVersionIDType' => '\\Novadan\\Uyumsoft\\StructType\\ExtensionVersionIDType',
            'ExtensionAgencyIDType' => '\\Novadan\\Uyumsoft\\StructType\\ExtensionAgencyIDType',
            'ExtensionReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ExtensionReasonCodeType',
            'ExtensionReasonType' => '\\Novadan\\Uyumsoft\\StructType\\ExtensionReasonType',
            'ExtensionAgencyNameType' => '\\Novadan\\Uyumsoft\\StructType\\ExtensionAgencyNameType',
            'UBLVersionIDType' => '\\Novadan\\Uyumsoft\\StructType\\UBLVersionIDType',
            'InstructionIDType' => '\\Novadan\\Uyumsoft\\StructType\\InstructionIDType',
            'InformationURIType' => '\\Novadan\\Uyumsoft\\StructType\\InformationURIType',
            'ImmobilizationCertificateIDType' => '\\Novadan\\Uyumsoft\\StructType\\ImmobilizationCertificateIDType',
            'IssuerIDType' => '\\Novadan\\Uyumsoft\\StructType\\IssuerIDType',
            'IssueNumberIDType' => '\\Novadan\\Uyumsoft\\StructType\\IssueNumberIDType',
            'ExchangeMarketIDType' => '\\Novadan\\Uyumsoft\\StructType\\ExchangeMarketIDType',
            'FreightForwarderAssignedIDType' => '\\Novadan\\Uyumsoft\\StructType\\FreightForwarderAssignedIDType',
            'ExtendedIDType' => '\\Novadan\\Uyumsoft\\StructType\\ExtendedIDType',
            'IdentificationIDType' => '\\Novadan\\Uyumsoft\\StructType\\IdentificationIDType',
            'IDType' => '\\Novadan\\Uyumsoft\\StructType\\IDType',
            'HazardClassIDType' => '\\Novadan\\Uyumsoft\\StructType\\HazardClassIDType',
            'SequenceNumberIDType' => '\\Novadan\\Uyumsoft\\StructType\\SequenceNumberIDType',
            'SerialIDType' => '\\Novadan\\Uyumsoft\\StructType\\SerialIDType',
            'ShippingOrderIDType' => '\\Novadan\\Uyumsoft\\StructType\\ShippingOrderIDType',
            'SecurityIDType' => '\\Novadan\\Uyumsoft\\StructType\\SecurityIDType',
            'SellerEventIDType' => '\\Novadan\\Uyumsoft\\StructType\\SellerEventIDType',
            'SequenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\SequenceIDType',
            'SignatureIDType' => '\\Novadan\\Uyumsoft\\StructType\\SignatureIDType',
            'SupplierAssignedAccountIDType' => '\\Novadan\\Uyumsoft\\StructType\\SupplierAssignedAccountIDType',
            'TenderEnvelopeIDType' => '\\Novadan\\Uyumsoft\\StructType\\TenderEnvelopeIDType',
            'TraceIDType' => '\\Novadan\\Uyumsoft\\StructType\\TraceIDType',
            'SpecificationIDType' => '\\Novadan\\Uyumsoft\\StructType\\SpecificationIDType',
            'SubscriberIDType' => '\\Novadan\\Uyumsoft\\StructType\\SubscriberIDType',
            'SuccessiveSequenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\SuccessiveSequenceIDType',
            'ReferencedConsignmentIDType' => '\\Novadan\\Uyumsoft\\StructType\\ReferencedConsignmentIDType',
            'RegistrationIDType' => '\\Novadan\\Uyumsoft\\StructType\\RegistrationIDType',
            'RegistrationNationalityIDType' => '\\Novadan\\Uyumsoft\\StructType\\RegistrationNationalityIDType',
            'RadioCallSignIDType' => '\\Novadan\\Uyumsoft\\StructType\\RadioCallSignIDType',
            'RailCarIDType' => '\\Novadan\\Uyumsoft\\StructType\\RailCarIDType',
            'ReferenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\ReferenceIDType',
            'ReleaseIDType' => '\\Novadan\\Uyumsoft\\StructType\\ReleaseIDType',
            'SalesOrderIDType' => '\\Novadan\\Uyumsoft\\StructType\\SalesOrderIDType',
            'SalesOrderLineIDType' => '\\Novadan\\Uyumsoft\\StructType\\SalesOrderLineIDType',
            'SchemeURIType' => '\\Novadan\\Uyumsoft\\StructType\\SchemeURIType',
            'RequestForQuotationLineIDType' => '\\Novadan\\Uyumsoft\\StructType\\RequestForQuotationLineIDType',
            'RequiredCustomsIDType' => '\\Novadan\\Uyumsoft\\StructType\\RequiredCustomsIDType',
            'RevisedForecastLineIDType' => '\\Novadan\\Uyumsoft\\StructType\\RevisedForecastLineIDType',
            'TrackingIDType' => '\\Novadan\\Uyumsoft\\StructType\\TrackingIDType',
            'EndpointIDType' => '\\Novadan\\Uyumsoft\\StructType\\EndpointIDType',
            'EconomicOperatorRegistryURIType' => '\\Novadan\\Uyumsoft\\StructType\\EconomicOperatorRegistryURIType',
            'DocumentIDType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentIDType',
            'ContractFolderIDType' => '\\Novadan\\Uyumsoft\\StructType\\ContractFolderIDType',
            'ConsumptionReportIDType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumptionReportIDType',
            'ConsumptionIDType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumptionIDType',
            'CustomizationIDType' => '\\Novadan\\Uyumsoft\\StructType\\CustomizationIDType',
            'CustomerAssignedAccountIDType' => '\\Novadan\\Uyumsoft\\StructType\\CustomerAssignedAccountIDType',
            'ContractedCarrierAssignedIDType' => '\\Novadan\\Uyumsoft\\StructType\\ContractedCarrierAssignedIDType',
            'URIType' => '\\Novadan\\Uyumsoft\\StructType\\URIType',
            'UUIDType' => '\\Novadan\\Uyumsoft\\StructType\\UUIDType',
            'TrainIDType' => '\\Novadan\\Uyumsoft\\StructType\\TrainIDType',
            'TransportExecutionPlanReferenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\TransportExecutionPlanReferenceIDType',
            'TransportationServiceDetailsURIType' => '\\Novadan\\Uyumsoft\\StructType\\TransportationServiceDetailsURIType',
            'UpperOrangeHazardPlacardIDType' => '\\Novadan\\Uyumsoft\\StructType\\UpperOrangeHazardPlacardIDType',
            'VesselIDType' => '\\Novadan\\Uyumsoft\\StructType\\VesselIDType',
            'WebsiteURIType' => '\\Novadan\\Uyumsoft\\StructType\\WebsiteURIType',
            'ValidatorIDType' => '\\Novadan\\Uyumsoft\\StructType\\ValidatorIDType',
            'VariantIDType' => '\\Novadan\\Uyumsoft\\StructType\\VariantIDType',
            'VersionIDType' => '\\Novadan\\Uyumsoft\\StructType\\VersionIDType',
            'BuyerProfileURIType' => '\\Novadan\\Uyumsoft\\StructType\\BuyerProfileURIType',
            'CV2IDType' => '\\Novadan\\Uyumsoft\\StructType\\CV2IDType',
            'CarrierAssignedIDType' => '\\Novadan\\Uyumsoft\\StructType\\CarrierAssignedIDType',
            'BusinessClassificationEvidenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\BusinessClassificationEvidenceIDType',
            'BusinessIdentityEvidenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\BusinessIdentityEvidenceIDType',
            'BuyerEventIDType' => '\\Novadan\\Uyumsoft\\StructType\\BuyerEventIDType',
            'ChipApplicationIDType' => '\\Novadan\\Uyumsoft\\StructType\\ChipApplicationIDType',
            'JourneyIDType' => '\\Novadan\\Uyumsoft\\StructType\\JourneyIDType',
            'LanguageIDType' => '\\Novadan\\Uyumsoft\\StructType\\LanguageIDType',
            'LicensePlateIDType' => '\\Novadan\\Uyumsoft\\StructType\\LicensePlateIDType',
            'CompanyIDType' => '\\Novadan\\Uyumsoft\\StructType\\CompanyIDType',
            'ConsigneeAssignedIDType' => '\\Novadan\\Uyumsoft\\StructType\\ConsigneeAssignedIDType',
            'ConsignorAssignedIDType' => '\\Novadan\\Uyumsoft\\StructType\\ConsignorAssignedIDType',
            'AccountIDType' => '\\Novadan\\Uyumsoft\\StructType\\AccountIDType',
            'AdditionalAccountIDType' => '\\Novadan\\Uyumsoft\\StructType\\AdditionalAccountIDType',
            'AgencyIDType' => '\\Novadan\\Uyumsoft\\StructType\\AgencyIDType',
            'AwardingCriterionIDType' => '\\Novadan\\Uyumsoft\\StructType\\AwardingCriterionIDType',
            'BarcodeSymbologyIDType' => '\\Novadan\\Uyumsoft\\StructType\\BarcodeSymbologyIDType',
            'BrokerAssignedIDType' => '\\Novadan\\Uyumsoft\\StructType\\BrokerAssignedIDType',
            'AircraftIDType' => '\\Novadan\\Uyumsoft\\StructType\\AircraftIDType',
            'AttributeIDType' => '\\Novadan\\Uyumsoft\\StructType\\AttributeIDType',
            'AuctionURIType' => '\\Novadan\\Uyumsoft\\StructType\\AuctionURIType',
            'LineIDType' => '\\Novadan\\Uyumsoft\\StructType\\LineIDType',
            'PaymentMeansIDType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentMeansIDType',
            'PaymentTermsDetailsURIType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentTermsDetailsURIType',
            'PerformingCarrierAssignedIDType' => '\\Novadan\\Uyumsoft\\StructType\\PerformingCarrierAssignedIDType',
            'ParentDocumentLineReferenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\ParentDocumentLineReferenceIDType',
            'ParentDocumentVersionIDType' => '\\Novadan\\Uyumsoft\\StructType\\ParentDocumentVersionIDType',
            'PaymentIDType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentIDType',
            'PrepaidPaymentReferenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\PrepaidPaymentReferenceIDType',
            'ProductTraceIDType' => '\\Novadan\\Uyumsoft\\StructType\\ProductTraceIDType',
            'ProfileExecutionIDType' => '\\Novadan\\Uyumsoft\\StructType\\ProfileExecutionIDType',
            'ProfileIDType' => '\\Novadan\\Uyumsoft\\StructType\\ProfileIDType',
            'PreviousJobIDType' => '\\Novadan\\Uyumsoft\\StructType\\PreviousJobIDType',
            'PreviousVersionIDType' => '\\Novadan\\Uyumsoft\\StructType\\PreviousVersionIDType',
            'PrimaryAccountNumberIDType' => '\\Novadan\\Uyumsoft\\StructType\\PrimaryAccountNumberIDType',
            'LowerOrangeHazardPlacardIDType' => '\\Novadan\\Uyumsoft\\StructType\\LowerOrangeHazardPlacardIDType',
            'MarkingIDType' => '\\Novadan\\Uyumsoft\\StructType\\MarkingIDType',
            'NationalityIDType' => '\\Novadan\\Uyumsoft\\StructType\\NationalityIDType',
            'LotNumberIDType' => '\\Novadan\\Uyumsoft\\StructType\\LotNumberIDType',
            'LoadingSequenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\LoadingSequenceIDType',
            'LocationIDType' => '\\Novadan\\Uyumsoft\\StructType\\LocationIDType',
            'LogoReferenceIDType' => '\\Novadan\\Uyumsoft\\StructType\\LogoReferenceIDType',
            'OriginalContractingSystemIDType' => '\\Novadan\\Uyumsoft\\StructType\\OriginalContractingSystemIDType',
            'OriginalJobIDType' => '\\Novadan\\Uyumsoft\\StructType\\OriginalJobIDType',
            'ParentDocumentIDType' => '\\Novadan\\Uyumsoft\\StructType\\ParentDocumentIDType',
            'OpenTenderIDType' => '\\Novadan\\Uyumsoft\\StructType\\OpenTenderIDType',
            'OntologyURIType' => '\\Novadan\\Uyumsoft\\StructType\\OntologyURIType',
            'NetworkIDType' => '\\Novadan\\Uyumsoft\\StructType\\NetworkIDType',
            'CopyIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\CopyIndicatorType',
            'BindingOnBuyerIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\BindingOnBuyerIndicatorType',
            'BulkCargoIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\BulkCargoIndicatorType',
            'BalanceBroughtForwardIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\BalanceBroughtForwardIndicatorType',
            'BasedOnConsensusIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\BasedOnConsensusIndicatorType',
            'CandidateReductionConstraintIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\CandidateReductionConstraintIndicatorType',
            'CompletionIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\CompletionIndicatorType',
            'AuctionConstraintIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\AuctionConstraintIndicatorType',
            'CatalogueIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\CatalogueIndicatorType',
            'ChargeIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\ChargeIndicatorType',
            'BackOrderAllowedIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\BackOrderAllowedIndicatorType',
            'AcceptedIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\AcceptedIndicatorType',
            'AnimalFoodIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\AnimalFoodIndicatorType',
            'ContainerizedIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\ContainerizedIndicatorType',
            'AdValoremIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\AdValoremIndicatorType',
            'AnimalFoodApprovedIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\AnimalFoodApprovedIndicatorType',
            'ReturnabilityIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\ReturnabilityIndicatorType',
            'RequiredCurriculaIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\RequiredCurriculaIndicatorType',
            'SoleProprietorshipIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\SoleProprietorshipIndicatorType',
            'ReturnableMaterialIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\ReturnableMaterialIndicatorType',
            'RefrigerationOnIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\RefrigerationOnIndicatorType',
            'PricingUpdateRequestIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\PricingUpdateRequestIndicatorType',
            'PrepaidIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\PrepaidIndicatorType',
            'PrizeIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\PrizeIndicatorType',
            'RefrigeratedIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\RefrigeratedIndicatorType',
            'PublishAwardIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\PublishAwardIndicatorType',
            'UnknownPriceIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\UnknownPriceIndicatorType',
            'ToOrderIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\ToOrderIndicatorType',
            'VariantConstraintIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\VariantConstraintIndicatorType',
            'CustomsImportClassifiedIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\CustomsImportClassifiedIndicatorType',
            'DangerousGoodsApprovedIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\DangerousGoodsApprovedIndicatorType',
            'ThirdPartyPayerIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\ThirdPartyPayerIndicatorType',
            'SplitConsignmentIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\SplitConsignmentIndicatorType',
            'SpecialSecurityIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\SpecialSecurityIndicatorType',
            'StatusAvailableIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\StatusAvailableIndicatorType',
            'TaxIncludedIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\TaxIncludedIndicatorType',
            'TaxEvidenceIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\TaxEvidenceIndicatorType',
            'PreCarriageIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\PreCarriageIndicatorType',
            'ItemUpdateRequestIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\ItemUpdateRequestIndicatorType',
            'LegalStatusIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\LegalStatusIndicatorType',
            'HumanFoodIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\HumanFoodIndicatorType',
            'IndicationIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\IndicationIndicatorType',
            'MarkCareIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\MarkCareIndicatorType',
            'OnCarriageIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\OnCarriageIndicatorType',
            'LivestockIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\LivestockIndicatorType',
            'MarkAttentionIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\MarkAttentionIndicatorType',
            'HumanFoodApprovedIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\HumanFoodApprovedIndicatorType',
            'FreeOfChargeIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\FreeOfChargeIndicatorType',
            'FrozenDocumentIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\FrozenDocumentIndicatorType',
            'ConsolidatableIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\ConsolidatableIndicatorType',
            'FollowupContractIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\FollowupContractIndicatorType',
            'GovernmentAgreementConstraintIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\GovernmentAgreementConstraintIndicatorType',
            'HazardousRiskIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\HazardousRiskIndicatorType',
            'FullyPaidSharesIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\FullyPaidSharesIndicatorType',
            'GeneralCargoIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\GeneralCargoIndicatorType',
            'OrderableIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\OrderableIndicatorType',
            'OtherConditionsIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\OtherConditionsIndicatorType',
            'PartialDeliveryIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\PartialDeliveryIndicatorType',
            'OptionalLineItemIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\OptionalLineItemIndicatorType',
            'PowerIndicatorType' => '\\Novadan\\Uyumsoft\\StructType\\PowerIndicatorType',
            'IssueDateType' => '\\Novadan\\Uyumsoft\\StructType\\IssueDateType',
            'ActualDeliveryDateType' => '\\Novadan\\Uyumsoft\\StructType\\ActualDeliveryDateType',
            'ResolutionDateType' => '\\Novadan\\Uyumsoft\\StructType\\ResolutionDateType',
            'ActualDespatchDateType' => '\\Novadan\\Uyumsoft\\StructType\\ActualDespatchDateType',
            'PaidDateType' => '\\Novadan\\Uyumsoft\\StructType\\PaidDateType',
            'OccurrenceDateType' => '\\Novadan\\Uyumsoft\\StructType\\OccurrenceDateType',
            'PlannedDateType' => '\\Novadan\\Uyumsoft\\StructType\\PlannedDateType',
            'PaymentDueDateType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentDueDateType',
            'LatestSecurityClearanceDateType' => '\\Novadan\\Uyumsoft\\StructType\\LatestSecurityClearanceDateType',
            'LatestProposalAcceptanceDateType' => '\\Novadan\\Uyumsoft\\StructType\\LatestProposalAcceptanceDateType',
            'NominationDateType' => '\\Novadan\\Uyumsoft\\StructType\\NominationDateType',
            'ManufactureDateType' => '\\Novadan\\Uyumsoft\\StructType\\ManufactureDateType',
            'RegistrationExpirationDateType' => '\\Novadan\\Uyumsoft\\StructType\\RegistrationExpirationDateType',
            'RegistrationDateType' => '\\Novadan\\Uyumsoft\\StructType\\RegistrationDateType',
            'RequestedDespatchDateType' => '\\Novadan\\Uyumsoft\\StructType\\RequestedDespatchDateType',
            'RequestedDeliveryDateType' => '\\Novadan\\Uyumsoft\\StructType\\RequestedDeliveryDateType',
            'ReceivedDateType' => '\\Novadan\\Uyumsoft\\StructType\\ReceivedDateType',
            'PreviousMeterReadingDateType' => '\\Novadan\\Uyumsoft\\StructType\\PreviousMeterReadingDateType',
            'RegisteredDateType' => '\\Novadan\\Uyumsoft\\StructType\\RegisteredDateType',
            'ReferenceDateType' => '\\Novadan\\Uyumsoft\\StructType\\ReferenceDateType',
            'LatestPickupDateType' => '\\Novadan\\Uyumsoft\\StructType\\LatestPickupDateType',
            'EndDateType' => '\\Novadan\\Uyumsoft\\StructType\\EndDateType',
            'EffectiveDateType' => '\\Novadan\\Uyumsoft\\StructType\\EffectiveDateType',
            'EstimatedDespatchDateType' => '\\Novadan\\Uyumsoft\\StructType\\EstimatedDespatchDateType',
            'EstimatedDeliveryDateType' => '\\Novadan\\Uyumsoft\\StructType\\EstimatedDeliveryDateType',
            'ComparisonForecastIssueDateType' => '\\Novadan\\Uyumsoft\\StructType\\ComparisonForecastIssueDateType',
            'EarliestPickupDateType' => '\\Novadan\\Uyumsoft\\StructType\\EarliestPickupDateType',
            'DueDateType' => '\\Novadan\\Uyumsoft\\StructType\\DueDateType',
            'LastRevisionDateType' => '\\Novadan\\Uyumsoft\\StructType\\LastRevisionDateType',
            'LatestMeterReadingDateType' => '\\Novadan\\Uyumsoft\\StructType\\LatestMeterReadingDateType',
            'LatestDeliveryDateType' => '\\Novadan\\Uyumsoft\\StructType\\LatestDeliveryDateType',
            'FirstShipmentAvailibilityDateType' => '\\Novadan\\Uyumsoft\\StructType\\FirstShipmentAvailibilityDateType',
            'ExpiryDateType' => '\\Novadan\\Uyumsoft\\StructType\\ExpiryDateType',
            'InstallmentDueDateType' => '\\Novadan\\Uyumsoft\\StructType\\InstallmentDueDateType',
            'GuaranteedDespatchDateType' => '\\Novadan\\Uyumsoft\\StructType\\GuaranteedDespatchDateType',
            'ValidityStartDateType' => '\\Novadan\\Uyumsoft\\StructType\\ValidityStartDateType',
            'BirthDateType' => '\\Novadan\\Uyumsoft\\StructType\\BirthDateType',
            'TaxPointDateType' => '\\Novadan\\Uyumsoft\\StructType\\TaxPointDateType',
            'ValidationDateType' => '\\Novadan\\Uyumsoft\\StructType\\ValidationDateType',
            'BestBeforeDateType' => '\\Novadan\\Uyumsoft\\StructType\\BestBeforeDateType',
            'ApprovalDateType' => '\\Novadan\\Uyumsoft\\StructType\\ApprovalDateType',
            'ActualPickupDateType' => '\\Novadan\\Uyumsoft\\StructType\\ActualPickupDateType',
            'AwardDateType' => '\\Novadan\\Uyumsoft\\StructType\\AwardDateType',
            'AvailabilityDateType' => '\\Novadan\\Uyumsoft\\StructType\\AvailabilityDateType',
            'ResponseDateType' => '\\Novadan\\Uyumsoft\\StructType\\ResponseDateType',
            'RevisionDateType' => '\\Novadan\\Uyumsoft\\StructType\\RevisionDateType',
            'SourceForecastIssueDateType' => '\\Novadan\\Uyumsoft\\StructType\\SourceForecastIssueDateType',
            'RequestedPublicationDateType' => '\\Novadan\\Uyumsoft\\StructType\\RequestedPublicationDateType',
            'RequiredDeliveryDateType' => '\\Novadan\\Uyumsoft\\StructType\\RequiredDeliveryDateType',
            'CallDateType' => '\\Novadan\\Uyumsoft\\StructType\\CallDateType',
            'StartDateType' => '\\Novadan\\Uyumsoft\\StructType\\StartDateType',
            'SubmissionDateType' => '\\Novadan\\Uyumsoft\\StructType\\SubmissionDateType',
            'SubmissionDueDateType' => '\\Novadan\\Uyumsoft\\StructType\\SubmissionDueDateType',
            'IssueTime' => '\\Novadan\\Uyumsoft\\StructType\\IssueTime',
            'InvoiceTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceTypeCodeType',
            'QuantityDiscrepancyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\QuantityDiscrepancyCodeType',
            'QualityControlCodeType' => '\\Novadan\\Uyumsoft\\StructType\\QualityControlCodeType',
            'PurposeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PurposeCodeType',
            'RejectActionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\RejectActionCodeType',
            'ReferenceEventCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ReferenceEventCodeType',
            'ReceiptAdviceTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ReceiptAdviceTypeCodeType',
            'ProviderTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ProviderTypeCodeType',
            'ProcurementSubTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ProcurementSubTypeCodeType',
            'ProcessReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ProcessReasonCodeType',
            'ProcedureCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ProcedureCodeType',
            'PromotionalEventTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PromotionalEventTypeCodeType',
            'ProfileStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ProfileStatusCodeType',
            'ProcurementTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ProcurementTypeCodeType',
            'RejectReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\RejectReasonCodeType',
            'SealStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SealStatusCodeType',
            'SealIssuerTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SealIssuerTypeCodeType',
            'RoleCodeType' => '\\Novadan\\Uyumsoft\\StructType\\RoleCodeType',
            'ServiceTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ServiceTypeCodeType',
            'ServiceInformationPreferenceCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ServiceInformationPreferenceCodeType',
            'SecurityClassificationCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SecurityClassificationCodeType',
            'RevisionStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\RevisionStatusCodeType',
            'ResidenceTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ResidenceTypeCodeType',
            'RequestedInvoiceCurrencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\RequestedInvoiceCurrencyCodeType',
            'ReminderTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ReminderTypeCodeType',
            'RetailEventStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\RetailEventStatusCodeType',
            'ResponseCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ResponseCodeType',
            'ResolutionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ResolutionCodeType',
            'PrivacyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PrivacyCodeType',
            'PackingCriteriaCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PackingCriteriaCodeType',
            'PackagingTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PackagingTypeCodeType',
            'PackageLevelCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PackageLevelCodeType',
            'PartyTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PartyTypeCodeType',
            'PartPresentationCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PartPresentationCodeType',
            'ParentDocumentTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ParentDocumentTypeCodeType',
            'PackLevelCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PackLevelCodeType',
            'OneTimeChargeTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\OneTimeChargeTypeCodeType',
            'NotificationTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\NotificationTypeCodeType',
            'NatureCodeType' => '\\Novadan\\Uyumsoft\\StructType\\NatureCodeType',
            'OwnerTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\OwnerTypeCodeType',
            'OrderTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\OrderTypeCodeType',
            'OrderResponseCodeType' => '\\Novadan\\Uyumsoft\\StructType\\OrderResponseCodeType',
            'PaymentAlternativeCurrencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentAlternativeCurrencyCodeType',
            'PreviousMeterReadingMethodCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PreviousMeterReadingMethodCodeType',
            'PreviousCancellationReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PreviousCancellationReasonCodeType',
            'PreferenceCriterionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PreferenceCriterionCodeType',
            'PricingCurrencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PricingCurrencyCodeType',
            'PriceTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PriceTypeCodeType',
            'PriceEvaluationCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PriceEvaluationCodeType',
            'PositionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PositionCodeType',
            'PaymentFrequencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentFrequencyCodeType',
            'PaymentCurrencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentCurrencyCodeType',
            'PaymentChannelCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentChannelCodeType',
            'PerformanceMetricTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PerformanceMetricTypeCodeType',
            'PaymentPurposeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentPurposeCodeType',
            'PaymentMeansCodeType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentMeansCodeType',
            'TransportEquipmentTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportEquipmentTypeCodeType',
            'TransportEmergencyCardCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportEmergencyCardCodeType',
            'TransportAuthorizationCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportAuthorizationCodeType',
            'TransportHandlingUnitTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportHandlingUnitTypeCodeType',
            'TransportExecutionStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportExecutionStatusCodeType',
            'TransportEventTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportEventTypeCodeType',
            'TransitDirectionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransitDirectionCodeType',
            'TimingComplaintCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TimingComplaintCodeType',
            'TimeFrequencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TimeFrequencyCodeType',
            'ThresholdValueComparisonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ThresholdValueComparisonCodeType',
            'TradeServiceCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TradeServiceCodeType',
            'TradeItemPackingLabelingTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TradeItemPackingLabelingTypeCodeType',
            'TrackingDeviceCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TrackingDeviceCodeType',
            'TransportMeansTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportMeansTypeCodeType',
            'WeightingAlgorithmCodeType' => '\\Novadan\\Uyumsoft\\StructType\\WeightingAlgorithmCodeType',
            'WeekDayCodeType' => '\\Novadan\\Uyumsoft\\StructType\\WeekDayCodeType',
            'ValidationResultCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ValidationResultCodeType',
            'WorkPhaseCodeType' => '\\Novadan\\Uyumsoft\\StructType\\WorkPhaseCodeType',
            'UtilityStatementTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\UtilityStatementTypeCodeType',
            'TransportationStatusTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportationStatusTypeCodeType',
            'TransportServiceCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportServiceCodeType',
            'TransportModeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TransportModeCodeType',
            'UrgencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\UrgencyCodeType',
            'UNDGCodeType' => '\\Novadan\\Uyumsoft\\StructType\\UNDGCodeType',
            'TypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TypeCodeType',
            'TendererRoleCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TendererRoleCodeType',
            'SubmissionMethodCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SubmissionMethodCodeType',
            'SubcontractingConditionsCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SubcontractingConditionsCodeType',
            'StatusReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\StatusReasonCodeType',
            'SupplyChainActivityTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SupplyChainActivityTypeCodeType',
            'SubstitutionStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SubstitutionStatusCodeType',
            'SubscriberTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SubscriberTypeCodeType',
            'StatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\StatusCodeType',
            'SizeTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SizeTypeCodeType',
            'ShortageActionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ShortageActionCodeType',
            'ShippingPriorityLevelCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ShippingPriorityLevelCodeType',
            'StatementTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\StatementTypeCodeType',
            'SpecificationTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SpecificationTypeCodeType',
            'SourceCurrencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\SourceCurrencyCodeType',
            'TargetCurrencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TargetCurrencyCodeType',
            'TenderEnvelopeTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TenderEnvelopeTypeCodeType',
            'TelecommunicationsSupplyTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TelecommunicationsSupplyTypeCodeType',
            'TelecommunicationsServiceCategoryCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TelecommunicationsServiceCategoryCodeType',
            'TendererRequirementTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TendererRequirementTypeCodeType',
            'TenderTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TenderTypeCodeType',
            'TenderResultCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TenderResultCodeType',
            'TelecommunicationsServiceCallCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TelecommunicationsServiceCallCodeType',
            'TaxCurrencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TaxCurrencyCodeType',
            'TariffCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TariffCodeType',
            'TariffClassCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TariffClassCodeType',
            'TaxTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TaxTypeCodeType',
            'TaxLevelCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TaxLevelCodeType',
            'TaxExemptionReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\TaxExemptionReasonCodeType',
            'ConsumersEnergyLevelCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumersEnergyLevelCodeType',
            'ConsumerIncentiveTacticTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumerIncentiveTacticTypeCodeType',
            'ConstitutionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ConstitutionCodeType',
            'ContractTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ContractTypeCodeType',
            'ConsumptionTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumptionTypeCodeType',
            'ConsumptionLevelCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumptionLevelCodeType',
            'ConditionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ConditionCodeType',
            'CompanyLegalFormCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CompanyLegalFormCodeType',
            'CommodityCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CommodityCodeType',
            'CollaborationPriorityCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CollaborationPriorityCodeType',
            'ComparisonDataSourceCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ComparisonDataSourceCodeType',
            'ComparisonDataCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ComparisonDataCodeType',
            'CompanyLiquidationStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CompanyLiquidationStatusCodeType',
            'ContractingSystemCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ContractingSystemCodeType',
            'DeclarationTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DeclarationTypeCodeType',
            'DataSourceCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DataSourceCodeType',
            'CustomsStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CustomsStatusCodeType',
            'DirectionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DirectionCodeType',
            'DespatchAdviceTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DespatchAdviceTypeCodeType',
            'DescriptionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DescriptionCodeType',
            'CurrentChargeTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CurrentChargeTypeCodeType',
            'CorrectionTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CorrectionTypeCodeType',
            'CorporateRegistrationTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CorporateRegistrationTypeCodeType',
            'CoordinateSystemCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CoordinateSystemCodeType',
            'CurrencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CurrencyCodeType',
            'CreditNoteTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CreditNoteTypeCodeType',
            'CountrySubentityCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CountrySubentityCodeType',
            'AddressFormatCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AddressFormatCodeType',
            'ActivityTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ActivityTypeCodeType',
            'ActionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ActionCodeType',
            'AdmissionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AdmissionCodeType',
            'AdjustmentReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AdjustmentReasonCodeType',
            'AddressTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AddressTypeCodeType',
            'AccountingCostCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AccountingCostCodeType',
            'AccountTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AccountTypeCodeType',
            'AccountFormatCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AccountFormatCodeType',
            'AllowanceChargeReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AllowanceChargeReasonCodeType',
            'CargoTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CargoTypeCodeType',
            'CardTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CardTypeCodeType',
            'CardChipCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CardChipCodeType',
            'CharacterSetCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CharacterSetCodeType',
            'ChannelCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ChannelCodeType',
            'CertificateTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CertificateTypeCodeType',
            'CapabilityTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CapabilityTypeCodeType',
            'AwardingCriterionTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AwardingCriterionTypeCodeType',
            'AvailabilityStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AvailabilityStatusCodeType',
            'ApplicationStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ApplicationStatusCodeType',
            'CalculationMethodCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CalculationMethodCodeType',
            'CalculationExpressionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\CalculationExpressionCodeType',
            'AwardingMethodTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\AwardingMethodTypeCodeType',
            'DisplayTacticTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DisplayTacticTypeCodeType',
            'InspectionMethodCodeType' => '\\Novadan\\Uyumsoft\\StructType\\InspectionMethodCodeType',
            'InhalationToxicityZoneCodeType' => '\\Novadan\\Uyumsoft\\StructType\\InhalationToxicityZoneCodeType',
            'LatitudeDirectionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\LatitudeDirectionCodeType',
            'LatestMeterReadingMethodCodeType' => '\\Novadan\\Uyumsoft\\StructType\\LatestMeterReadingMethodCodeType',
            'ItemClassificationCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ItemClassificationCodeType',
            'IndustryClassificationCodeType' => '\\Novadan\\Uyumsoft\\StructType\\IndustryClassificationCodeType',
            'HazardousRegulationCodeType' => '\\Novadan\\Uyumsoft\\StructType\\HazardousRegulationCodeType',
            'HazardousCategoryCodeType' => '\\Novadan\\Uyumsoft\\StructType\\HazardousCategoryCodeType',
            'HandlingCodeType' => '\\Novadan\\Uyumsoft\\StructType\\HandlingCodeType',
            'ImportanceCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ImportanceCodeType',
            'IdentificationCodeType' => '\\Novadan\\Uyumsoft\\StructType\\IdentificationCodeType',
            'HeatingTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\HeatingTypeCodeType',
            'LifeCycleStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\LifeCycleStatusCodeType',
            'MeterReadingTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\MeterReadingTypeCodeType',
            'MeterConstantCodeType' => '\\Novadan\\Uyumsoft\\StructType\\MeterConstantCodeType',
            'MedicalFirstAidGuideCodeType' => '\\Novadan\\Uyumsoft\\StructType\\MedicalFirstAidGuideCodeType',
            'NameCodeType' => '\\Novadan\\Uyumsoft\\StructType\\NameCodeType',
            'MiscellaneousEventTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\MiscellaneousEventTypeCodeType',
            'MimeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\MimeCodeType',
            'MathematicOperatorCodeType' => '\\Novadan\\Uyumsoft\\StructType\\MathematicOperatorCodeType',
            'LocationTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\LocationTypeCodeType',
            'LocaleCodeType' => '\\Novadan\\Uyumsoft\\StructType\\LocaleCodeType',
            'LineStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\LineStatusCodeType',
            'MandateTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\MandateTypeCodeType',
            'LossRiskResponsibilityCodeType' => '\\Novadan\\Uyumsoft\\StructType\\LossRiskResponsibilityCodeType',
            'LongitudeDirectionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\LongitudeDirectionCodeType',
            'EvaluationCriterionTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\EvaluationCriterionTypeCodeType',
            'EnvironmentalEmissionTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\EnvironmentalEmissionTypeCodeType',
            'EncodingCodeType' => '\\Novadan\\Uyumsoft\\StructType\\EncodingCodeType',
            'ExceptionStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ExceptionStatusCodeType',
            'ExceptionResolutionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ExceptionResolutionCodeType',
            'EvidenceTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\EvidenceTypeCodeType',
            'EmergencyProceduresCodeType' => '\\Novadan\\Uyumsoft\\StructType\\EmergencyProceduresCodeType',
            'DocumentStatusCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentStatusCodeType',
            'DocumentCurrencyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentCurrencyCodeType',
            'DispositionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DispositionCodeType',
            'DutyCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DutyCodeType',
            'DocumentTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentTypeCodeType',
            'DocumentStatusReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentStatusReasonCodeType',
            'ExecutionRequirementCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ExecutionRequirementCodeType',
            'FullnessIndicationCodeType' => '\\Novadan\\Uyumsoft\\StructType\\FullnessIndicationCodeType',
            'FreightRateClassCodeType' => '\\Novadan\\Uyumsoft\\StructType\\FreightRateClassCodeType',
            'FormatCodeType' => '\\Novadan\\Uyumsoft\\StructType\\FormatCodeType',
            'GuaranteeTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\GuaranteeTypeCodeType',
            'GenderCodeType' => '\\Novadan\\Uyumsoft\\StructType\\GenderCodeType',
            'FundingProgramCodeType' => '\\Novadan\\Uyumsoft\\StructType\\FundingProgramCodeType',
            'ForecastTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ForecastTypeCodeType',
            'ExpressionCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ExpressionCodeType',
            'ExpenseCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ExpenseCodeType',
            'ExemptionReasonCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ExemptionReasonCodeType',
            'ForecastPurposeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\ForecastPurposeCodeType',
            'FinancingInstrumentCodeType' => '\\Novadan\\Uyumsoft\\StructType\\FinancingInstrumentCodeType',
            'FeatureTacticTypeCodeType' => '\\Novadan\\Uyumsoft\\StructType\\FeatureTacticTypeCodeType',
            'NoteType' => '\\Novadan\\Uyumsoft\\StructType\\NoteType',
            'OtherNameType' => '\\Novadan\\Uyumsoft\\StructType\\OtherNameType',
            'TechnicalNameType' => '\\Novadan\\Uyumsoft\\StructType\\TechnicalNameType',
            'VesselNameType' => '\\Novadan\\Uyumsoft\\StructType\\VesselNameType',
            'StreetNameType' => '\\Novadan\\Uyumsoft\\StructType\\StreetNameType',
            'BuildingNameType' => '\\Novadan\\Uyumsoft\\StructType\\BuildingNameType',
            'BrandNameType' => '\\Novadan\\Uyumsoft\\StructType\\BrandNameType',
            'CategoryNameType' => '\\Novadan\\Uyumsoft\\StructType\\CategoryNameType',
            'CitySubdivisionNameType' => '\\Novadan\\Uyumsoft\\StructType\\CitySubdivisionNameType',
            'CityNameType' => '\\Novadan\\Uyumsoft\\StructType\\CityNameType',
            'BlockNameType' => '\\Novadan\\Uyumsoft\\StructType\\BlockNameType',
            'AliasNameType' => '\\Novadan\\Uyumsoft\\StructType\\AliasNameType',
            'AdditionalStreetNameType' => '\\Novadan\\Uyumsoft\\StructType\\AdditionalStreetNameType',
            'FamilyNameType' => '\\Novadan\\Uyumsoft\\StructType\\FamilyNameType',
            'RegistrationNameType' => '\\Novadan\\Uyumsoft\\StructType\\RegistrationNameType',
            'RetailEventNameType' => '\\Novadan\\Uyumsoft\\StructType\\RetailEventNameType',
            'ServiceNameType' => '\\Novadan\\Uyumsoft\\StructType\\ServiceNameType',
            'RoamingPartnerNameType' => '\\Novadan\\Uyumsoft\\StructType\\RoamingPartnerNameType',
            'HolderNameType' => '\\Novadan\\Uyumsoft\\StructType\\HolderNameType',
            'FirstNameType' => '\\Novadan\\Uyumsoft\\StructType\\FirstNameType',
            'FileNameType' => '\\Novadan\\Uyumsoft\\StructType\\FileNameType',
            'ModelNameType' => '\\Novadan\\Uyumsoft\\StructType\\ModelNameType',
            'MiddleNameType' => '\\Novadan\\Uyumsoft\\StructType\\MiddleNameType',
            'ShipsRequirementsType' => '\\Novadan\\Uyumsoft\\StructType\\ShipsRequirementsType',
            'ShippingMarksType' => '\\Novadan\\Uyumsoft\\StructType\\ShippingMarksType',
            'ServiceTypeType' => '\\Novadan\\Uyumsoft\\StructType\\ServiceTypeType',
            'SpecialServiceInstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\SpecialServiceInstructionsType',
            'SpecialInstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\SpecialInstructionsType',
            'RoleDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\RoleDescriptionType',
            'ResolutionType' => '\\Novadan\\Uyumsoft\\StructType\\ResolutionType',
            'ResidenceTypeType' => '\\Novadan\\Uyumsoft\\StructType\\ResidenceTypeType',
            'ServiceNumberCalledType' => '\\Novadan\\Uyumsoft\\StructType\\ServiceNumberCalledType',
            'SealingPartyTypeType' => '\\Novadan\\Uyumsoft\\StructType\\SealingPartyTypeType',
            'RoomType' => '\\Novadan\\Uyumsoft\\StructType\\RoomType',
            'TelecommunicationsServiceCallType' => '\\Novadan\\Uyumsoft\\StructType\\TelecommunicationsServiceCallType',
            'TechnicalCommitteeDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\TechnicalCommitteeDescriptionType',
            'TaxExemptionReasonType' => '\\Novadan\\Uyumsoft\\StructType\\TaxExemptionReasonType',
            'TelefaxType' => '\\Novadan\\Uyumsoft\\StructType\\TelefaxType',
            'TelecommunicationsSupplyTypeType' => '\\Novadan\\Uyumsoft\\StructType\\TelecommunicationsSupplyTypeType',
            'TelecommunicationsServiceCategoryType' => '\\Novadan\\Uyumsoft\\StructType\\TelecommunicationsServiceCategoryType',
            'StatusReasonType' => '\\Novadan\\Uyumsoft\\StructType\\StatusReasonType',
            'SpecialTransportRequirementsType' => '\\Novadan\\Uyumsoft\\StructType\\SpecialTransportRequirementsType',
            'SpecialTermsType' => '\\Novadan\\Uyumsoft\\StructType\\SpecialTermsType',
            'TariffDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\TariffDescriptionType',
            'SummaryDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\SummaryDescriptionType',
            'SubscriberTypeType' => '\\Novadan\\Uyumsoft\\StructType\\SubscriberTypeType',
            'ReplenishmentOwnerDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\ReplenishmentOwnerDescriptionType',
            'PriceRevisionFormulaDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\PriceRevisionFormulaDescriptionType',
            'PriceChangeReasonType' => '\\Novadan\\Uyumsoft\\StructType\\PriceChangeReasonType',
            'PreviousMeterReadingMethodType' => '\\Novadan\\Uyumsoft\\StructType\\PreviousMeterReadingMethodType',
            'PriorityType' => '\\Novadan\\Uyumsoft\\StructType\\PriorityType',
            'PrintQualifierType' => '\\Novadan\\Uyumsoft\\StructType\\PrintQualifierType',
            'PriceTypeType' => '\\Novadan\\Uyumsoft\\StructType\\PriceTypeType',
            'PlacardNotationType' => '\\Novadan\\Uyumsoft\\StructType\\PlacardNotationType',
            'PlacardEndorsementType' => '\\Novadan\\Uyumsoft\\StructType\\PlacardEndorsementType',
            'PhoneNumberType' => '\\Novadan\\Uyumsoft\\StructType\\PhoneNumberType',
            'PostboxType' => '\\Novadan\\Uyumsoft\\StructType\\PostboxType',
            'PostalZoneType' => '\\Novadan\\Uyumsoft\\StructType\\PostalZoneType',
            'PlotIdentificationType' => '\\Novadan\\Uyumsoft\\StructType\\PlotIdentificationType',
            'RegulatoryDomainType' => '\\Novadan\\Uyumsoft\\StructType\\RegulatoryDomainType',
            'RegistrationNationalityType' => '\\Novadan\\Uyumsoft\\StructType\\RegistrationNationalityType',
            'RegionType' => '\\Novadan\\Uyumsoft\\StructType\\RegionType',
            'RemarksType' => '\\Novadan\\Uyumsoft\\StructType\\RemarksType',
            'RejectionNoteType' => '\\Novadan\\Uyumsoft\\StructType\\RejectionNoteType',
            'RejectReasonType' => '\\Novadan\\Uyumsoft\\StructType\\RejectReasonType',
            'ProcessReasonType' => '\\Novadan\\Uyumsoft\\StructType\\ProcessReasonType',
            'ProcessDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\ProcessDescriptionType',
            'PrizeDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\PrizeDescriptionType',
            'RankType' => '\\Novadan\\Uyumsoft\\StructType\\RankType',
            'PurposeType' => '\\Novadan\\Uyumsoft\\StructType\\PurposeType',
            'TelephoneType' => '\\Novadan\\Uyumsoft\\StructType\\TelephoneType',
            'TransportServiceProviderRemarksType' => '\\Novadan\\Uyumsoft\\StructType\\TransportServiceProviderRemarksType',
            'TradingRestrictionsType' => '\\Novadan\\Uyumsoft\\StructType\\TradingRestrictionsType',
            'TitleType' => '\\Novadan\\Uyumsoft\\StructType\\TitleType',
            'TransportUserSpecialTermsType' => '\\Novadan\\Uyumsoft\\StructType\\TransportUserSpecialTermsType',
            'TransportUserRemarksType' => '\\Novadan\\Uyumsoft\\StructType\\TransportUserRemarksType',
            'TransportServiceProviderSpecialTermsType' => '\\Novadan\\Uyumsoft\\StructType\\TransportServiceProviderSpecialTermsType',
            'TierRangeType' => '\\Novadan\\Uyumsoft\\StructType\\TierRangeType',
            'TestMethodType' => '\\Novadan\\Uyumsoft\\StructType\\TestMethodType',
            'TimingComplaintType' => '\\Novadan\\Uyumsoft\\StructType\\TimingComplaintType',
            'TimezoneOffsetType' => '\\Novadan\\Uyumsoft\\StructType\\TimezoneOffsetType',
            'TimeAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TimeAmountType',
            'WorkPhaseType' => '\\Novadan\\Uyumsoft\\StructType\\WorkPhaseType',
            'WeightType' => '\\Novadan\\Uyumsoft\\StructType\\WeightType',
            'WarrantyInformationType' => '\\Novadan\\Uyumsoft\\StructType\\WarrantyInformationType',
            'XPathType' => '\\Novadan\\Uyumsoft\\StructType\\XPathType',
            'ValidateToolType' => '\\Novadan\\Uyumsoft\\StructType\\ValidateToolType',
            'ValidateProcessType' => '\\Novadan\\Uyumsoft\\StructType\\ValidateProcessType',
            'TransportationServiceDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\TransportationServiceDescriptionType',
            'ValueQualifierType' => '\\Novadan\\Uyumsoft\\StructType\\ValueQualifierType',
            'ValidateToolVersionType' => '\\Novadan\\Uyumsoft\\StructType\\ValidateToolVersionType',
            'PersonalSituationType' => '\\Novadan\\Uyumsoft\\StructType\\PersonalSituationType',
            'CorrectionTypeType' => '\\Novadan\\Uyumsoft\\StructType\\CorrectionTypeType',
            'ContractTypeType' => '\\Novadan\\Uyumsoft\\StructType\\ContractTypeType',
            'ContractSubdivisionType' => '\\Novadan\\Uyumsoft\\StructType\\ContractSubdivisionType',
            'CountrySubentityType' => '\\Novadan\\Uyumsoft\\StructType\\CountrySubentityType',
            'CustomsClearanceServiceInstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\CustomsClearanceServiceInstructionsType',
            'CustomerReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\CustomerReferenceType',
            'CurrentChargeTypeType' => '\\Novadan\\Uyumsoft\\StructType\\CurrentChargeTypeType',
            'ConsumersEnergyLevelType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumersEnergyLevelType',
            'ConditionsType' => '\\Novadan\\Uyumsoft\\StructType\\ConditionsType',
            'ConditionsDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\ConditionsDescriptionType',
            'ConsumptionLevelType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumptionLevelType',
            'ContractNameType' => '\\Novadan\\Uyumsoft\\StructType\\ContractNameType',
            'ContentType' => '\\Novadan\\Uyumsoft\\StructType\\ContentType',
            'ConsumptionTypeType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumptionTypeType',
            'DamageRemarksType' => '\\Novadan\\Uyumsoft\\StructType\\DamageRemarksType',
            'DocumentTypeType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentTypeType',
            'DocumentStatusReasonDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentStatusReasonDescriptionType',
            'DocumentHashType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentHashType',
            'DutyType' => '\\Novadan\\Uyumsoft\\StructType\\DutyType',
            'ExclusionReasonType' => '\\Novadan\\Uyumsoft\\StructType\\ExclusionReasonType',
            'ElectronicMailType' => '\\Novadan\\Uyumsoft\\StructType\\ElectronicMailType',
            'ElectronicDeviceDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\ElectronicDeviceDescriptionType',
            'DemurrageInstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\DemurrageInstructionsType',
            'DeliveryInstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\DeliveryInstructionsType',
            'DataSendingCapabilityType' => '\\Novadan\\Uyumsoft\\StructType\\DataSendingCapabilityType',
            'DepartmentType' => '\\Novadan\\Uyumsoft\\StructType\\DepartmentType',
            'DocumentDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentDescriptionType',
            'DistrictType' => '\\Novadan\\Uyumsoft\\StructType\\DistrictType',
            'DescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\DescriptionType',
            'ConditionType' => '\\Novadan\\Uyumsoft\\StructType\\ConditionType',
            'AgencyNameType' => '\\Novadan\\Uyumsoft\\StructType\\AgencyNameType',
            'AdditionalInformationType' => '\\Novadan\\Uyumsoft\\StructType\\AdditionalInformationType',
            'AdditionalConditionsType' => '\\Novadan\\Uyumsoft\\StructType\\AdditionalConditionsType',
            'AllowanceChargeReasonType' => '\\Novadan\\Uyumsoft\\StructType\\AllowanceChargeReasonType',
            'BackorderReasonType' => '\\Novadan\\Uyumsoft\\StructType\\BackorderReasonType',
            'AwardingCriterionDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\AwardingCriterionDescriptionType',
            'ApprovalStatusType' => '\\Novadan\\Uyumsoft\\StructType\\ApprovalStatusType',
            'ActivityTypeType' => '\\Novadan\\Uyumsoft\\StructType\\ActivityTypeType',
            'AccountingCostType' => '\\Novadan\\Uyumsoft\\StructType\\AccountingCostType',
            'AcceptedVariantsDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\AcceptedVariantsDescriptionType',
            'BirthplaceNameType' => '\\Novadan\\Uyumsoft\\StructType\\BirthplaceNameType',
            'ChannelType' => '\\Novadan\\Uyumsoft\\StructType\\ChannelType',
            'ChangeConditionsType' => '\\Novadan\\Uyumsoft\\StructType\\ChangeConditionsType',
            'CertificateTypeType' => '\\Novadan\\Uyumsoft\\StructType\\CertificateTypeType',
            'CharacteristicsType' => '\\Novadan\\Uyumsoft\\StructType\\CharacteristicsType',
            'CompanyLegalFormType' => '\\Novadan\\Uyumsoft\\StructType\\CompanyLegalFormType',
            'CommentType' => '\\Novadan\\Uyumsoft\\StructType\\CommentType',
            'CodeValueType' => '\\Novadan\\Uyumsoft\\StructType\\CodeValueType',
            'CalculationExpressionType' => '\\Novadan\\Uyumsoft\\StructType\\CalculationExpressionType',
            'BuyerReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\BuyerReferenceType',
            'BuildingNumberType' => '\\Novadan\\Uyumsoft\\StructType\\BuildingNumberType',
            'CancellationNoteType' => '\\Novadan\\Uyumsoft\\StructType\\CancellationNoteType',
            'CarrierServiceInstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\CarrierServiceInstructionsType',
            'CandidateStatementType' => '\\Novadan\\Uyumsoft\\StructType\\CandidateStatementType',
            'MinimumValueType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumValueType',
            'MinimumImprovementBidType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumImprovementBidType',
            'MeterReadingTypeType' => '\\Novadan\\Uyumsoft\\StructType\\MeterReadingTypeType',
            'MonetaryScopeType' => '\\Novadan\\Uyumsoft\\StructType\\MonetaryScopeType',
            'NegotiationDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\NegotiationDescriptionType',
            'NameSuffixType' => '\\Novadan\\Uyumsoft\\StructType\\NameSuffixType',
            'MovieTitleType' => '\\Novadan\\Uyumsoft\\StructType\\MovieTitleType',
            'MaximumValueType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumValueType',
            'MarkCareType' => '\\Novadan\\Uyumsoft\\StructType\\MarkCareType',
            'MarkAttentionType' => '\\Novadan\\Uyumsoft\\StructType\\MarkAttentionType',
            'MeterConstantType' => '\\Novadan\\Uyumsoft\\StructType\\MeterConstantType',
            'MeterReadingCommentsType' => '\\Novadan\\Uyumsoft\\StructType\\MeterReadingCommentsType',
            'MeterNumberType' => '\\Novadan\\Uyumsoft\\StructType\\MeterNumberType',
            'MeterNameType' => '\\Novadan\\Uyumsoft\\StructType\\MeterNameType',
            'PayPerViewType' => '\\Novadan\\Uyumsoft\\StructType\\PayPerViewType',
            'PasswordType' => '\\Novadan\\Uyumsoft\\StructType\\PasswordType',
            'PartyTypeType' => '\\Novadan\\Uyumsoft\\StructType\\PartyTypeType',
            'PayerReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\PayerReferenceType',
            'PaymentOrderReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentOrderReferenceType',
            'PaymentNoteType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentNoteType',
            'PaymentDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentDescriptionType',
            'OrderableUnitType' => '\\Novadan\\Uyumsoft\\StructType\\OrderableUnitType',
            'OptionsDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\OptionsDescriptionType',
            'OneTimeChargeTypeType' => '\\Novadan\\Uyumsoft\\StructType\\OneTimeChargeTypeType',
            'OrganizationDepartmentType' => '\\Novadan\\Uyumsoft\\StructType\\OrganizationDepartmentType',
            'PackingMaterialType' => '\\Novadan\\Uyumsoft\\StructType\\PackingMaterialType',
            'OutstandingReasonType' => '\\Novadan\\Uyumsoft\\StructType\\OutstandingReasonType',
            'OtherInstructionType' => '\\Novadan\\Uyumsoft\\StructType\\OtherInstructionType',
            'LowTendersDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\LowTendersDescriptionType',
            'HaulageInstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\HaulageInstructionsType',
            'HashAlgorithmMethodType' => '\\Novadan\\Uyumsoft\\StructType\\HashAlgorithmMethodType',
            'HandlingInstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\HandlingInstructionsType',
            'HeatingTypeType' => '\\Novadan\\Uyumsoft\\StructType\\HeatingTypeType',
            'InstructionNoteType' => '\\Novadan\\Uyumsoft\\StructType\\InstructionNoteType',
            'InhouseMailType' => '\\Novadan\\Uyumsoft\\StructType\\InhouseMailType',
            'InformationType' => '\\Novadan\\Uyumsoft\\StructType\\InformationType',
            'FundingProgramType' => '\\Novadan\\Uyumsoft\\StructType\\FundingProgramType',
            'ExtensionType' => '\\Novadan\\Uyumsoft\\StructType\\ExtensionType',
            'ExpressionType' => '\\Novadan\\Uyumsoft\\StructType\\ExpressionType',
            'ExemptionReasonType' => '\\Novadan\\Uyumsoft\\StructType\\ExemptionReasonType',
            'FeeDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\FeeDescriptionType',
            'FrequencyType' => '\\Novadan\\Uyumsoft\\StructType\\FrequencyType',
            'ForwarderServiceInstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\ForwarderServiceInstructionsType',
            'FloorType' => '\\Novadan\\Uyumsoft\\StructType\\FloorType',
            'LimitationDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\LimitationDescriptionType',
            'LegalReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\LegalReferenceType',
            'LatestMeterReadingMethodType' => '\\Novadan\\Uyumsoft\\StructType\\LatestMeterReadingMethodType',
            'LineType' => '\\Novadan\\Uyumsoft\\StructType\\LineType',
            'LoginType' => '\\Novadan\\Uyumsoft\\StructType\\LoginType',
            'LossRiskType' => '\\Novadan\\Uyumsoft\\StructType\\LossRiskType',
            'ListValueType' => '\\Novadan\\Uyumsoft\\StructType\\ListValueType',
            'InvoicingPartyReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\InvoicingPartyReferenceType',
            'InstructionsType' => '\\Novadan\\Uyumsoft\\StructType\\InstructionsType',
            'LocationType' => '\\Novadan\\Uyumsoft\\StructType\\LocationType',
            'JobTitleType' => '\\Novadan\\Uyumsoft\\StructType\\JobTitleType',
            'KeywordType' => '\\Novadan\\Uyumsoft\\StructType\\KeywordType',
            'JustificationType' => '\\Novadan\\Uyumsoft\\StructType\\JustificationType',
            'JustificationDescriptionType' => '\\Novadan\\Uyumsoft\\StructType\\JustificationDescriptionType',
            'LineCountNumericType' => '\\Novadan\\Uyumsoft\\StructType\\LineCountNumericType',
            'CalculationRateType' => '\\Novadan\\Uyumsoft\\StructType\\CalculationRateType',
            'TargetCurrencyBaseRateType' => '\\Novadan\\Uyumsoft\\StructType\\TargetCurrencyBaseRateType',
            'SourceCurrencyBaseRateType' => '\\Novadan\\Uyumsoft\\StructType\\SourceCurrencyBaseRateType',
            'AmountRateType' => '\\Novadan\\Uyumsoft\\StructType\\AmountRateType',
            'OrderableUnitFactorRateType' => '\\Novadan\\Uyumsoft\\StructType\\OrderableUnitFactorRateType',
            'ProgressPercentType' => '\\Novadan\\Uyumsoft\\StructType\\ProgressPercentType',
            'PenaltySurchargePercentType' => '\\Novadan\\Uyumsoft\\StructType\\PenaltySurchargePercentType',
            'ParticipationPercentType' => '\\Novadan\\Uyumsoft\\StructType\\ParticipationPercentType',
            'PaymentPercentType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentPercentType',
            'TargetServicePercentType' => '\\Novadan\\Uyumsoft\\StructType\\TargetServicePercentType',
            'TierRatePercentType' => '\\Novadan\\Uyumsoft\\StructType\\TierRatePercentType',
            'ReliabilityPercentType' => '\\Novadan\\Uyumsoft\\StructType\\ReliabilityPercentType',
            'SettlementDiscountPercentType' => '\\Novadan\\Uyumsoft\\StructType\\SettlementDiscountPercentType',
            'AirFlowPercentType' => '\\Novadan\\Uyumsoft\\StructType\\AirFlowPercentType',
            'MinimumPercentType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumPercentType',
            'PartecipationPercentType' => '\\Novadan\\Uyumsoft\\StructType\\PartecipationPercentType',
            'HumidityPercentType' => '\\Novadan\\Uyumsoft\\StructType\\HumidityPercentType',
            'MaximumPercentType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumPercentType',
            'FrozenPeriodDaysNumericType' => '\\Novadan\\Uyumsoft\\StructType\\FrozenPeriodDaysNumericType',
            'CalculationSequenceNumericType' => '\\Novadan\\Uyumsoft\\StructType\\CalculationSequenceNumericType',
            'MaximumCopiesNumericType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumCopiesNumericType',
            'LineNumberNumericType' => '\\Novadan\\Uyumsoft\\StructType\\LineNumberNumericType',
            'BudgetYearNumericType' => '\\Novadan\\Uyumsoft\\StructType\\BudgetYearNumericType',
            'MaximumNumberNumericType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumNumberNumericType',
            'ReminderSequenceNumericType' => '\\Novadan\\Uyumsoft\\StructType\\ReminderSequenceNumericType',
            'PackSizeNumericType' => '\\Novadan\\Uyumsoft\\StructType\\PackSizeNumericType',
            'ResidentOccupantsNumericType' => '\\Novadan\\Uyumsoft\\StructType\\ResidentOccupantsNumericType',
            'WeightNumericType' => '\\Novadan\\Uyumsoft\\StructType\\WeightNumericType',
            'SequenceNumericType' => '\\Novadan\\Uyumsoft\\StructType\\SequenceNumericType',
            'MinimumNumberNumericType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumNumberNumericType',
            'MaximumPaymentInstructionsNumericType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumPaymentInstructionsNumericType',
            'MultiplierFactorNumericType' => '\\Novadan\\Uyumsoft\\StructType\\MultiplierFactorNumericType',
            'OrderQuantityIncrementNumericType' => '\\Novadan\\Uyumsoft\\StructType\\OrderQuantityIncrementNumericType',
            'OrderIntervalDaysNumericType' => '\\Novadan\\Uyumsoft\\StructType\\OrderIntervalDaysNumericType',
            'StartTimeType' => '\\Novadan\\Uyumsoft\\StructType\\StartTimeType',
            'CallTimeType' => '\\Novadan\\Uyumsoft\\StructType\\CallTimeType',
            'ComparisonForecastIssueTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ComparisonForecastIssueTimeType',
            'AwardTimeType' => '\\Novadan\\Uyumsoft\\StructType\\AwardTimeType',
            'LastRevisionTimeType' => '\\Novadan\\Uyumsoft\\StructType\\LastRevisionTimeType',
            'LatestDeliveryTimeType' => '\\Novadan\\Uyumsoft\\StructType\\LatestDeliveryTimeType',
            'LatestPickupTimeType' => '\\Novadan\\Uyumsoft\\StructType\\LatestPickupTimeType',
            'OccurrenceTimeType' => '\\Novadan\\Uyumsoft\\StructType\\OccurrenceTimeType',
            'PaidTimeType' => '\\Novadan\\Uyumsoft\\StructType\\PaidTimeType',
            'NominationTimeType' => '\\Novadan\\Uyumsoft\\StructType\\NominationTimeType',
            'EarliestPickupTimeType' => '\\Novadan\\Uyumsoft\\StructType\\EarliestPickupTimeType',
            'ManufactureTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ManufactureTimeType',
            'GuaranteedDespatchTimeType' => '\\Novadan\\Uyumsoft\\StructType\\GuaranteedDespatchTimeType',
            'ExpiryTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ExpiryTimeType',
            'EstimatedDeliveryTimeType' => '\\Novadan\\Uyumsoft\\StructType\\EstimatedDeliveryTimeType',
            'EstimatedDespatchTimeType' => '\\Novadan\\Uyumsoft\\StructType\\EstimatedDespatchTimeType',
            'ActualDespatchTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ActualDespatchTimeType',
            'ActualPickupTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ActualPickupTimeType',
            'ActualDeliveryTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ActualDeliveryTimeType',
            'SourceForecastIssueTimeType' => '\\Novadan\\Uyumsoft\\StructType\\SourceForecastIssueTimeType',
            'RevisionTimeType' => '\\Novadan\\Uyumsoft\\StructType\\RevisionTimeType',
            'EndTimeType' => '\\Novadan\\Uyumsoft\\StructType\\EndTimeType',
            'EffectiveTimeType' => '\\Novadan\\Uyumsoft\\StructType\\EffectiveTimeType',
            'ValidationTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ValidationTimeType',
            'RequestedDespatchTimeType' => '\\Novadan\\Uyumsoft\\StructType\\RequestedDespatchTimeType',
            'RegisteredTimeType' => '\\Novadan\\Uyumsoft\\StructType\\RegisteredTimeType',
            'ReferenceTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ReferenceTimeType',
            'ResponseTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ResponseTimeType',
            'ResolutionTimeType' => '\\Novadan\\Uyumsoft\\StructType\\ResolutionTimeType',
            'RequiredDeliveryTimeType' => '\\Novadan\\Uyumsoft\\StructType\\RequiredDeliveryTimeType',
            'DurationMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\DurationMeasureType',
            'ChargeableWeightMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\ChargeableWeightMeasureType',
            'BaseUnitMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\BaseUnitMeasureType',
            'ComparedValueMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\ComparedValueMeasureType',
            'AltitudeMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\AltitudeMeasureType',
            'NetVolumeMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\NetVolumeMeasureType',
            'NetWeightMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\NetWeightMeasureType',
            'NetTonnageMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\NetTonnageMeasureType',
            'MinimumMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumMeasureType',
            'NetNetWeightMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\NetNetWeightMeasureType',
            'PostEventNotificationDurationMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\PostEventNotificationDurationMeasureType',
            'ValueMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\ValueMeasureType',
            'TareWeightMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\TareWeightMeasureType',
            'PreEventNotificationDurationMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\PreEventNotificationDurationMeasureType',
            'SourceValueMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\SourceValueMeasureType',
            'LatitudeDegreesMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\LatitudeDegreesMeasureType',
            'LatitudeMinutesMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\LatitudeMinutesMeasureType',
            'GrossWeightMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\GrossWeightMeasureType',
            'GrossTonnageMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\GrossTonnageMeasureType',
            'GrossVolumeMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\GrossVolumeMeasureType',
            'LeadTimeMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\LeadTimeMeasureType',
            'MaximumMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumMeasureType',
            'LongitudeMinutesMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\LongitudeMinutesMeasureType',
            'LoadingLengthMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\LoadingLengthMeasureType',
            'LongitudeDegreesMeasureType' => '\\Novadan\\Uyumsoft\\StructType\\LongitudeDegreesMeasureType',
            'EmbeddedDocumentBinaryObjectType' => '\\Novadan\\Uyumsoft\\StructType\\EmbeddedDocumentBinaryObjectType',
            'CorporateStockAmountType' => '\\Novadan\\Uyumsoft\\StructType\\CorporateStockAmountType',
            'LineExtensionAmountType' => '\\Novadan\\Uyumsoft\\StructType\\LineExtensionAmountType',
            'LowerTenderAmountType' => '\\Novadan\\Uyumsoft\\StructType\\LowerTenderAmountType',
            'MarketValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\MarketValueAmountType',
            'MaximumPaidAmountType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumPaidAmountType',
            'MaximumAmountType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumAmountType',
            'MaximumAdvertisementAmountType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumAdvertisementAmountType',
            'LiabilityAmountType' => '\\Novadan\\Uyumsoft\\StructType\\LiabilityAmountType',
            'HigherTenderAmountType' => '\\Novadan\\Uyumsoft\\StructType\\HigherTenderAmountType',
            'FreeOnBoardValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\FreeOnBoardValueAmountType',
            'FeeAmountType' => '\\Novadan\\Uyumsoft\\StructType\\FeeAmountType',
            'InventoryValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\InventoryValueAmountType',
            'InsuranceValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\InsuranceValueAmountType',
            'InsurancePremiumAmountType' => '\\Novadan\\Uyumsoft\\StructType\\InsurancePremiumAmountType',
            'MinimumAmountType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumAmountType',
            'RequiredFeeAmountType' => '\\Novadan\\Uyumsoft\\StructType\\RequiredFeeAmountType',
            'PriceAmountType' => '\\Novadan\\Uyumsoft\\StructType\\PriceAmountType',
            'PrepaidAmountType' => '\\Novadan\\Uyumsoft\\StructType\\PrepaidAmountType',
            'TaxAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TaxAmountType',
            'SettlementDiscountAmountType' => '\\Novadan\\Uyumsoft\\StructType\\SettlementDiscountAmountType',
            'RoundingAmountType' => '\\Novadan\\Uyumsoft\\StructType\\RoundingAmountType',
            'PerUnitAmountType' => '\\Novadan\\Uyumsoft\\StructType\\PerUnitAmountType',
            'PayableAlternativeAmountType' => '\\Novadan\\Uyumsoft\\StructType\\PayableAlternativeAmountType',
            'PartyCapacityAmountType' => '\\Novadan\\Uyumsoft\\StructType\\PartyCapacityAmountType',
            'PaidAmountType' => '\\Novadan\\Uyumsoft\\StructType\\PaidAmountType',
            'PenaltyAmountType' => '\\Novadan\\Uyumsoft\\StructType\\PenaltyAmountType',
            'PayableRoundingAmountType' => '\\Novadan\\Uyumsoft\\StructType\\PayableRoundingAmountType',
            'PayableAmountType' => '\\Novadan\\Uyumsoft\\StructType\\PayableAmountType',
            'FaceValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\FaceValueAmountType',
            'AverageAmountType' => '\\Novadan\\Uyumsoft\\StructType\\AverageAmountType',
            'AnnualAverageAmountType' => '\\Novadan\\Uyumsoft\\StructType\\AnnualAverageAmountType',
            'AverageSubsequentContractAmountType' => '\\Novadan\\Uyumsoft\\StructType\\AverageSubsequentContractAmountType',
            'CallBaseAmountType' => '\\Novadan\\Uyumsoft\\StructType\\CallBaseAmountType',
            'BaseAmountType' => '\\Novadan\\Uyumsoft\\StructType\\BaseAmountType',
            'BalanceAmountType' => '\\Novadan\\Uyumsoft\\StructType\\BalanceAmountType',
            'TaxInclusiveAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TaxInclusiveAmountType',
            'AllowanceTotalAmountType' => '\\Novadan\\Uyumsoft\\StructType\\AllowanceTotalAmountType',
            'AdvertisementAmountType' => '\\Novadan\\Uyumsoft\\StructType\\AdvertisementAmountType',
            'DeclaredForCarriageValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\DeclaredForCarriageValueAmountType',
            'DeclaredCustomsValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\DeclaredCustomsValueAmountType',
            'DeclaredCarriageValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\DeclaredCarriageValueAmountType',
            'DeclaredStatisticsValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\DeclaredStatisticsValueAmountType',
            'EstimatedOverallContractAmountType' => '\\Novadan\\Uyumsoft\\StructType\\EstimatedOverallContractAmountType',
            'EstimatedAmountType' => '\\Novadan\\Uyumsoft\\StructType\\EstimatedAmountType',
            'DocumentationFeeAmountType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentationFeeAmountType',
            'ChargeTotalAmountType' => '\\Novadan\\Uyumsoft\\StructType\\ChargeTotalAmountType',
            'CallExtensionAmountType' => '\\Novadan\\Uyumsoft\\StructType\\CallExtensionAmountType',
            'CorrectionAmountType' => '\\Novadan\\Uyumsoft\\StructType\\CorrectionAmountType',
            'DebitLineAmountType' => '\\Novadan\\Uyumsoft\\StructType\\DebitLineAmountType',
            'CreditLineAmountType' => '\\Novadan\\Uyumsoft\\StructType\\CreditLineAmountType',
            'CorrectionUnitAmountType' => '\\Novadan\\Uyumsoft\\StructType\\CorrectionUnitAmountType',
            'TotalPaymentAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TotalPaymentAmountType',
            'TotalTaskAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TotalTaskAmountType',
            'TotalDebitAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TotalDebitAmountType',
            'TotalInvoiceAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TotalInvoiceAmountType',
            'ValueAmountType' => '\\Novadan\\Uyumsoft\\StructType\\ValueAmountType',
            'TotalTaxAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TotalTaxAmountType',
            'TransactionCurrencyTaxAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TransactionCurrencyTaxAmountType',
            'TotalCreditAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TotalCreditAmountType',
            'TaxEnergyOnAccountAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TaxEnergyOnAccountAmountType',
            'TaxExclusiveAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TaxExclusiveAmountType',
            'TaxEnergyAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TaxEnergyAmountType',
            'TaxEnergyBalanceAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TaxEnergyBalanceAmountType',
            'TotalAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TotalAmountType',
            'TotalBalanceAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TotalBalanceAmountType',
            'TaxableAmountType' => '\\Novadan\\Uyumsoft\\StructType\\TaxableAmountType',
            'ThresholdAmountType' => '\\Novadan\\Uyumsoft\\StructType\\ThresholdAmountType',
            'ContentUnitQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ContentUnitQuantityType',
            'CreditedQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\CreditedQuantityType',
            'CrewQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\CrewQuantityType',
            'ConsumerUnitQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumerUnitQuantityType',
            'ConsumptionEnergyQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumptionEnergyQuantityType',
            'ConsumptionWaterQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ConsumptionWaterQuantityType',
            'DifferenceTemperatureReductionQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\DifferenceTemperatureReductionQuantityType',
            'EmployeeQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\EmployeeQuantityType',
            'EstimatedConsumedQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\EstimatedConsumedQuantityType',
            'CustomsTariffQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\CustomsTariffQuantityType',
            'DebitedQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\DebitedQuantityType',
            'DeliveredQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\DeliveredQuantityType',
            'ActualTemperatureReductionQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ActualTemperatureReductionQuantityType',
            'BackorderQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\BackorderQuantityType',
            'ChargeableQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ChargeableQuantityType',
            'ChildConsignmentQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ChildConsignmentQuantityType',
            'ConsignmentQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ConsignmentQuantityType',
            'BaseQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\BaseQuantityType',
            'BasicConsumedQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\BasicConsumedQuantityType',
            'BatchQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\BatchQuantityType',
            'EstimatedOverallContractQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\EstimatedOverallContractQuantityType',
            'SharesNumberQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\SharesNumberQuantityType',
            'ReturnableQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ReturnableQuantityType',
            'ShortQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ShortQuantityType',
            'ThresholdQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ThresholdQuantityType',
            'TargetInventoryQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\TargetInventoryQuantityType',
            'RejectedQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\RejectedQuantityType',
            'ReceivedElectronicTenderQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ReceivedElectronicTenderQuantityType',
            'ReceivedForeignTenderQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ReceivedForeignTenderQuantityType',
            'ReceivedTenderQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ReceivedTenderQuantityType',
            'ReceivedQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ReceivedQuantityType',
            'TotalTransportHandlingUnitQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\TotalTransportHandlingUnitQuantityType',
            'TotalPackagesQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\TotalPackagesQuantityType',
            'ValueQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ValueQuantityType',
            'VarianceQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\VarianceQuantityType',
            'TotalPackageQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\TotalPackageQuantityType',
            'TotalConsumedQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\TotalConsumedQuantityType',
            'TimeDeltaDaysQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\TimeDeltaDaysQuantityType',
            'TotalDeliveredQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\TotalDeliveredQuantityType',
            'TotalMeteredQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\TotalMeteredQuantityType',
            'TotalGoodsItemQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\TotalGoodsItemQuantityType',
            'PreviousMeterQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\PreviousMeterQuantityType',
            'MaximumVariantQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumVariantQuantityType',
            'MaximumQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumQuantityType',
            'MaximumOrderQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumOrderQuantityType',
            'MinimumOrderQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumOrderQuantityType',
            'MinimumInventoryQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumInventoryQuantityType',
            'MinimumBackorderQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumBackorderQuantityType',
            'MaximumOperatorQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumOperatorQuantityType',
            'GasPressureQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\GasPressureQuantityType',
            'ExpectedQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ExpectedQuantityType',
            'ExpectedOperatorQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\ExpectedOperatorQuantityType',
            'MaximumBackorderQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MaximumBackorderQuantityType',
            'LatestMeterQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\LatestMeterQuantityType',
            'InvoicedQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\InvoicedQuantityType',
            'MinimumQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MinimumQuantityType',
            'PerformanceValueQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\PerformanceValueQuantityType',
            'OutstandingQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\OutstandingQuantityType',
            'OperatingYearsQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\OperatingYearsQuantityType',
            'PackQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\PackQuantityType',
            'OversupplyQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\OversupplyQuantityType',
            'PassengerQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\PassengerQuantityType',
            'MultipleOrderQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\MultipleOrderQuantityType',
            'NormalTemperatureReductionQuantityType' => '\\Novadan\\Uyumsoft\\StructType\\NormalTemperatureReductionQuantityType',
            'PeriodType' => '\\Novadan\\Uyumsoft\\StructType\\PeriodType',
            'OrderReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\OrderReferenceType',
            'DocumentReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\DocumentReferenceType',
            'AttachmentType' => '\\Novadan\\Uyumsoft\\StructType\\AttachmentType',
            'ExternalReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\ExternalReferenceType',
            'PartyType' => '\\Novadan\\Uyumsoft\\StructType\\PartyType',
            'PartyIdentificationType' => '\\Novadan\\Uyumsoft\\StructType\\PartyIdentificationType',
            'PartyNameType' => '\\Novadan\\Uyumsoft\\StructType\\PartyNameType',
            'AddressType' => '\\Novadan\\Uyumsoft\\StructType\\AddressType',
            'CountryType' => '\\Novadan\\Uyumsoft\\StructType\\CountryType',
            'PartyTaxSchemeType' => '\\Novadan\\Uyumsoft\\StructType\\PartyTaxSchemeType',
            'TaxSchemeType' => '\\Novadan\\Uyumsoft\\StructType\\TaxSchemeType',
            'PartyLegalEntityType' => '\\Novadan\\Uyumsoft\\StructType\\PartyLegalEntityType',
            'CorporateRegistrationSchemeType' => '\\Novadan\\Uyumsoft\\StructType\\CorporateRegistrationSchemeType',
            'ContactType' => '\\Novadan\\Uyumsoft\\StructType\\ContactType',
            'CommunicationType' => '\\Novadan\\Uyumsoft\\StructType\\CommunicationType',
            'PersonType' => '\\Novadan\\Uyumsoft\\StructType\\PersonType',
            'FinancialAccountType' => '\\Novadan\\Uyumsoft\\StructType\\FinancialAccountType',
            'BranchType' => '\\Novadan\\Uyumsoft\\StructType\\BranchType',
            'FinancialInstitutionType' => '\\Novadan\\Uyumsoft\\StructType\\FinancialInstitutionType',
            'BillingReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\BillingReferenceType',
            'BillingReferenceLineType' => '\\Novadan\\Uyumsoft\\StructType\\BillingReferenceLineType',
            'AllowanceChargeType' => '\\Novadan\\Uyumsoft\\StructType\\AllowanceChargeType',
            'SupplierPartyType' => '\\Novadan\\Uyumsoft\\StructType\\SupplierPartyType',
            'CustomerPartyType' => '\\Novadan\\Uyumsoft\\StructType\\CustomerPartyType',
            'DeliveryType' => '\\Novadan\\Uyumsoft\\StructType\\DeliveryType',
            'DespatchType' => '\\Novadan\\Uyumsoft\\StructType\\DespatchType',
            'DeliveryTermsType' => '\\Novadan\\Uyumsoft\\StructType\\DeliveryTermsType',
            'ShipmentType' => '\\Novadan\\Uyumsoft\\StructType\\ShipmentType',
            'GoodsItemType' => '\\Novadan\\Uyumsoft\\StructType\\GoodsItemType',
            'ItemType' => '\\Novadan\\Uyumsoft\\StructType\\ItemType',
            'ItemIdentificationType' => '\\Novadan\\Uyumsoft\\StructType\\ItemIdentificationType',
            'CommodityClassificationType' => '\\Novadan\\Uyumsoft\\StructType\\CommodityClassificationType',
            'ItemInstanceType' => '\\Novadan\\Uyumsoft\\StructType\\ItemInstanceType',
            'ItemPropertyType' => '\\Novadan\\Uyumsoft\\StructType\\ItemPropertyType',
            'ItemPropertyGroupType' => '\\Novadan\\Uyumsoft\\StructType\\ItemPropertyGroupType',
            'DimensionType' => '\\Novadan\\Uyumsoft\\StructType\\DimensionType',
            'ItemPropertyRangeType' => '\\Novadan\\Uyumsoft\\StructType\\ItemPropertyRangeType',
            'LotIdentificationType' => '\\Novadan\\Uyumsoft\\StructType\\LotIdentificationType',
            'InvoiceLineType' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceLineType',
            'OrderLineReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\OrderLineReferenceType',
            'LineReferenceType' => '\\Novadan\\Uyumsoft\\StructType\\LineReferenceType',
            'TaxTotalType' => '\\Novadan\\Uyumsoft\\StructType\\TaxTotalType',
            'TaxSubtotalType' => '\\Novadan\\Uyumsoft\\StructType\\TaxSubtotalType',
            'TaxCategoryType' => '\\Novadan\\Uyumsoft\\StructType\\TaxCategoryType',
            'PriceType' => '\\Novadan\\Uyumsoft\\StructType\\PriceType',
            'TemperatureType' => '\\Novadan\\Uyumsoft\\StructType\\TemperatureType',
            'ShipmentStageType' => '\\Novadan\\Uyumsoft\\StructType\\ShipmentStageType',
            'TransportMeansType' => '\\Novadan\\Uyumsoft\\StructType\\TransportMeansType',
            'StowageType' => '\\Novadan\\Uyumsoft\\StructType\\StowageType',
            'AirTransportType' => '\\Novadan\\Uyumsoft\\StructType\\AirTransportType',
            'RoadTransportType' => '\\Novadan\\Uyumsoft\\StructType\\RoadTransportType',
            'RailTransportType' => '\\Novadan\\Uyumsoft\\StructType\\RailTransportType',
            'MaritimeTransportType' => '\\Novadan\\Uyumsoft\\StructType\\MaritimeTransportType',
            'TransportHandlingUnitType' => '\\Novadan\\Uyumsoft\\StructType\\TransportHandlingUnitType',
            'PackageType' => '\\Novadan\\Uyumsoft\\StructType\\PackageType',
            'TransportEquipmentType' => '\\Novadan\\Uyumsoft\\StructType\\TransportEquipmentType',
            'HazardousGoodsTransitType' => '\\Novadan\\Uyumsoft\\StructType\\HazardousGoodsTransitType',
            'CustomsDeclarationType' => '\\Novadan\\Uyumsoft\\StructType\\CustomsDeclarationType',
            'PaymentMeansType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentMeansType',
            'PaymentTermsType' => '\\Novadan\\Uyumsoft\\StructType\\PaymentTermsType',
            'ExchangeRateType' => '\\Novadan\\Uyumsoft\\StructType\\ExchangeRateType',
            'MonetaryTotalType' => '\\Novadan\\Uyumsoft\\StructType\\MonetaryTotalType',
            'InvoiceType' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceType',
            'GetSystemDate' => '\\Novadan\\Uyumsoft\\StructType\\GetSystemDate',
            'UserInformation' => '\\Novadan\\Uyumsoft\\StructType\\UserInformation',
            'GetSystemDateResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetSystemDateResponse',
            'DateResponse' => '\\Novadan\\Uyumsoft\\StructType\\DateResponse',
            'Response' => '\\Novadan\\Uyumsoft\\StructType\\Response',
            'GetSystemDateWithFormat' => '\\Novadan\\Uyumsoft\\StructType\\GetSystemDateWithFormat',
            'GetSystemDateWithFormatResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetSystemDateWithFormatResponse',
            'StringResponse' => '\\Novadan\\Uyumsoft\\StructType\\StringResponse',
            'IsEInvoiceUser' => '\\Novadan\\Uyumsoft\\StructType\\IsEInvoiceUser',
            'IsEInvoiceUserResponse' => '\\Novadan\\Uyumsoft\\StructType\\IsEInvoiceUserResponse',
            'FlagResponse' => '\\Novadan\\Uyumsoft\\StructType\\FlagResponse',
            'GetEInvoiceUsers' => '\\Novadan\\Uyumsoft\\StructType\\GetEInvoiceUsers',
            'PagedQueryContext' => '\\Novadan\\Uyumsoft\\StructType\\PagedQueryContext',
            'GetEInvoiceUsersResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetEInvoiceUsersResponse',
            'SystemUsersResponse' => '\\Novadan\\Uyumsoft\\StructType\\SystemUsersResponse',
            'PagedResponseOfSystemUser' => '\\Novadan\\Uyumsoft\\StructType\\PagedResponseOfSystemUser',
            'SystemUser' => '\\Novadan\\Uyumsoft\\StructType\\SystemUser',
            'EntityUpdatedHistory' => '\\Novadan\\Uyumsoft\\StructType\\EntityUpdatedHistory',
            'EntityCreateHistory' => '\\Novadan\\Uyumsoft\\StructType\\EntityCreateHistory',
            'EntityBaseInt' => '\\Novadan\\Uyumsoft\\StructType\\EntityBaseInt',
            'EntityBase' => '\\Novadan\\Uyumsoft\\StructType\\EntityBase',
            'FilterEInvoiceUsers' => '\\Novadan\\Uyumsoft\\StructType\\FilterEInvoiceUsers',
            'SystemUserFilterContext' => '\\Novadan\\Uyumsoft\\StructType\\SystemUserFilterContext',
            'FilterablePagedQueryContext' => '\\Novadan\\Uyumsoft\\StructType\\FilterablePagedQueryContext',
            'FilterEInvoiceUsersResponse' => '\\Novadan\\Uyumsoft\\StructType\\FilterEInvoiceUsersResponse',
            'GetUserAliasses' => '\\Novadan\\Uyumsoft\\StructType\\GetUserAliasses',
            'GetUserAliassesResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetUserAliassesResponse',
            'UserAliassesResponse' => '\\Novadan\\Uyumsoft\\StructType\\UserAliassesResponse',
            'SystemUserWithAlias' => '\\Novadan\\Uyumsoft\\StructType\\SystemUserWithAlias',
            'SystemUserDefinition' => '\\Novadan\\Uyumsoft\\StructType\\SystemUserDefinition',
            'SystemUserAlias' => '\\Novadan\\Uyumsoft\\StructType\\SystemUserAlias',
            'SetXsltView' => '\\Novadan\\Uyumsoft\\StructType\\SetXsltView',
            'SetXsltViewResponse' => '\\Novadan\\Uyumsoft\\StructType\\SetXsltViewResponse',
            'GetXsltView' => '\\Novadan\\Uyumsoft\\StructType\\GetXsltView',
            'GetXsltViewResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetXsltViewResponse',
            'StringElementResponse' => '\\Novadan\\Uyumsoft\\StructType\\StringElementResponse',
            'ValidateInvoice' => '\\Novadan\\Uyumsoft\\StructType\\ValidateInvoice',
            'ValidateInvoiceResponse' => '\\Novadan\\Uyumsoft\\StructType\\ValidateInvoiceResponse',
            'GetInboxInvoices' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoices',
            'InboxInvoiceQueryModel' => '\\Novadan\\Uyumsoft\\StructType\\InboxInvoiceQueryModel',
            'InvoiceQueryModel' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceQueryModel',
            'GetInboxInvoicesResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoicesResponse',
            'InvoicesResponse' => '\\Novadan\\Uyumsoft\\StructType\\InvoicesResponse',
            'PagedResponseOfInvoiceInfo' => '\\Novadan\\Uyumsoft\\StructType\\PagedResponseOfInvoiceInfo',
            'InvoiceInfo' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceInfo',
            'CustomerInfo' => '\\Novadan\\Uyumsoft\\StructType\\CustomerInfo',
            'EArchiveInvoiceInformation' => '\\Novadan\\Uyumsoft\\StructType\\EArchiveInvoiceInformation',
            'NewGenerationPaymentRecorderInformation' => '\\Novadan\\Uyumsoft\\StructType\\NewGenerationPaymentRecorderInformation',
            'InternetSalesInformation' => '\\Novadan\\Uyumsoft\\StructType\\InternetSalesInformation',
            'ShipmentInformation' => '\\Novadan\\Uyumsoft\\StructType\\ShipmentInformation',
            'ShipmentCarier' => '\\Novadan\\Uyumsoft\\StructType\\ShipmentCarier',
            'EArchiveWithHoldingInformation' => '\\Novadan\\Uyumsoft\\StructType\\EArchiveWithHoldingInformation',
            'NotificationInformation' => '\\Novadan\\Uyumsoft\\StructType\\NotificationInformation',
            'MailingInformation' => '\\Novadan\\Uyumsoft\\StructType\\MailingInformation',
            'MailAttachmentInformation' => '\\Novadan\\Uyumsoft\\StructType\\MailAttachmentInformation',
            'SmsMessageInformation' => '\\Novadan\\Uyumsoft\\StructType\\SmsMessageInformation',
            'GetInboxInvoiceList' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoiceList',
            'InboxInvoiceListQueryModel' => '\\Novadan\\Uyumsoft\\StructType\\InboxInvoiceListQueryModel',
            'InvoiceListQueryModel' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceListQueryModel',
            'GetInboxInvoiceListResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoiceListResponse',
            'InboxInvoiceListResponse' => '\\Novadan\\Uyumsoft\\StructType\\InboxInvoiceListResponse',
            'PagedResponseOfInboxInvoiceListItem' => '\\Novadan\\Uyumsoft\\StructType\\PagedResponseOfInboxInvoiceListItem',
            'InboxInvoiceListItem' => '\\Novadan\\Uyumsoft\\StructType\\InboxInvoiceListItem',
            'InvoiceListItemBase' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceListItemBase',
            'GetInboxInvoice' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoice',
            'GetInboxInvoiceResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoiceResponse',
            'InvoiceResponse' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceResponse',
            'QueryInboxInvoiceStatus' => '\\Novadan\\Uyumsoft\\StructType\\QueryInboxInvoiceStatus',
            'ArrayOfString' => '\\Novadan\\Uyumsoft\\ArrayType\\ArrayOfString',
            'QueryInboxInvoiceStatusResponse' => '\\Novadan\\Uyumsoft\\StructType\\QueryInboxInvoiceStatusResponse',
            'InvoiceStatusResponse' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceStatusResponse',
            'InvoiceStatusInfo' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceStatusInfo',
            'SetInvoicesTaken' => '\\Novadan\\Uyumsoft\\StructType\\SetInvoicesTaken',
            'SetInvoicesTakenResponse' => '\\Novadan\\Uyumsoft\\StructType\\SetInvoicesTakenResponse',
            'SendDocumentResponse' => '\\Novadan\\Uyumsoft\\StructType\\SendDocumentResponse',
            'ArrayOfDocumentResponseInfo' => '\\Novadan\\Uyumsoft\\ArrayType\\ArrayOfDocumentResponseInfo',
            'DocumentResponseInfo' => '\\Novadan\\Uyumsoft\\StructType\\DocumentResponseInfo',
            'ArrayOfLineResponseInfo' => '\\Novadan\\Uyumsoft\\ArrayType\\ArrayOfLineResponseInfo',
            'LineResponseInfo' => '\\Novadan\\Uyumsoft\\StructType\\LineResponseInfo',
            'SendDocumentResponseResponse' => '\\Novadan\\Uyumsoft\\StructType\\SendDocumentResponseResponse',
            'QueryDocumentResponseStatus' => '\\Novadan\\Uyumsoft\\StructType\\QueryDocumentResponseStatus',
            'QueryDocumentResponseStatusResponse' => '\\Novadan\\Uyumsoft\\StructType\\QueryDocumentResponseStatusResponse',
            'DocumentResponseStatusResponse' => '\\Novadan\\Uyumsoft\\StructType\\DocumentResponseStatusResponse',
            'DocumentResponseStatusInfo' => '\\Novadan\\Uyumsoft\\StructType\\DocumentResponseStatusInfo',
            'GetOutboxInvoices' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoices',
            'GetOutboxInvoicesResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoicesResponse',
            'GetOutboxInvoiceList' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceList',
            'OutboxInvoiceListQueryModel' => '\\Novadan\\Uyumsoft\\StructType\\OutboxInvoiceListQueryModel',
            'GetOutboxInvoiceListResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceListResponse',
            'OutboxInvoiceListResponse' => '\\Novadan\\Uyumsoft\\StructType\\OutboxInvoiceListResponse',
            'PagedResponseOfOutboxInvoiceListItem' => '\\Novadan\\Uyumsoft\\StructType\\PagedResponseOfOutboxInvoiceListItem',
            'OutboxInvoiceListItem' => '\\Novadan\\Uyumsoft\\StructType\\OutboxInvoiceListItem',
            'GetOutboxInvoice' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoice',
            'GetOutboxInvoiceResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceResponse',
            'GetOutboxInvoicesData' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoicesData',
            'GetOutboxInvoicesDataResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoicesDataResponse',
            'InvoicesDataResponse' => '\\Novadan\\Uyumsoft\\StructType\\InvoicesDataResponse',
            'PagedResponseOfInvoiceData' => '\\Novadan\\Uyumsoft\\StructType\\PagedResponseOfInvoiceData',
            'InvoiceData' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceData',
            'GetOutboxInvoiceData' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceData',
            'GetOutboxInvoiceDataResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceDataResponse',
            'InvoiceDataResponse' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceDataResponse',
            'GetInboxInvoicesData' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoicesData',
            'GetInboxInvoicesDataResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoicesDataResponse',
            'GetInboxInvoiceData' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoiceData',
            'GetInboxInvoiceDataResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoiceDataResponse',
            'QueryOutboxInvoiceStatus' => '\\Novadan\\Uyumsoft\\StructType\\QueryOutboxInvoiceStatus',
            'QueryOutboxInvoiceStatusResponse' => '\\Novadan\\Uyumsoft\\StructType\\QueryOutboxInvoiceStatusResponse',
            'QueryInvoiceGtbResponses' => '\\Novadan\\Uyumsoft\\StructType\\QueryInvoiceGtbResponses',
            'QueryInvoiceGtbResponsesResponse' => '\\Novadan\\Uyumsoft\\StructType\\QueryInvoiceGtbResponsesResponse',
            'InvoiceGtbInfoResponse' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceGtbInfoResponse',
            'InvoiceExportGtbInformation' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceExportGtbInformation',
            'SaveAsDraft' => '\\Novadan\\Uyumsoft\\StructType\\SaveAsDraft',
            'ArrayOfInvoiceInfo' => '\\Novadan\\Uyumsoft\\ArrayType\\ArrayOfInvoiceInfo',
            'SaveAsDraftResponse' => '\\Novadan\\Uyumsoft\\StructType\\SaveAsDraftResponse',
            'InvoiceIdentitiesResponse' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceIdentitiesResponse',
            'InvoiceIdentity' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceIdentity',
            'SendInvoice' => '\\Novadan\\Uyumsoft\\StructType\\SendInvoice',
            'SendInvoiceResponse' => '\\Novadan\\Uyumsoft\\StructType\\SendInvoiceResponse',
            'CompressedSaveAsDraft' => '\\Novadan\\Uyumsoft\\StructType\\CompressedSaveAsDraft',
            'BinaryRequestData' => '\\Novadan\\Uyumsoft\\StructType\\BinaryRequestData',
            'CompressedSaveAsDraftResponse' => '\\Novadan\\Uyumsoft\\StructType\\CompressedSaveAsDraftResponse',
            'CompressedSendInvoice' => '\\Novadan\\Uyumsoft\\StructType\\CompressedSendInvoice',
            'CompressedSendInvoiceResponse' => '\\Novadan\\Uyumsoft\\StructType\\CompressedSendInvoiceResponse',
            'SendDraft' => '\\Novadan\\Uyumsoft\\StructType\\SendDraft',
            'SendDraftResponse' => '\\Novadan\\Uyumsoft\\StructType\\SendDraftResponse',
            'CancelDraft' => '\\Novadan\\Uyumsoft\\StructType\\CancelDraft',
            'CancelDraftResponse' => '\\Novadan\\Uyumsoft\\StructType\\CancelDraftResponse',
            'GetInboxInvoiceView' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoiceView',
            'GetInboxInvoiceViewResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoiceViewResponse',
            'InvoiceViewResponse' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceViewResponse',
            'ViewResult' => '\\Novadan\\Uyumsoft\\StructType\\ViewResult',
            'VerificationResult' => '\\Novadan\\Uyumsoft\\StructType\\VerificationResult',
            'GetOutboxInvoiceView' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceView',
            'GetOutboxInvoiceViewResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceViewResponse',
            'GetOutboxInvoiceResponseView' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceResponseView',
            'GetOutboxInvoiceResponseViewResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceResponseViewResponse',
            'GetInboxInvoiceStatusWithLogs' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoiceStatusWithLogs',
            'GetInboxInvoiceStatusWithLogsResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoiceStatusWithLogsResponse',
            'InvoiceStatusWithLogResponse' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceStatusWithLogResponse',
            'InvoiceStatusWithLogInfo' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceStatusWithLogInfo',
            'InvoiceLogItem' => '\\Novadan\\Uyumsoft\\StructType\\InvoiceLogItem',
            'LogRecordItem' => '\\Novadan\\Uyumsoft\\StructType\\LogRecordItem',
            'GetOutboxInvoiceStatusWithLogs' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceStatusWithLogs',
            'GetOutboxInvoiceStatusWithLogsResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoiceStatusWithLogsResponse',
            'RetrySendInvoices' => '\\Novadan\\Uyumsoft\\StructType\\RetrySendInvoices',
            'RetrySendInvoicesResponse' => '\\Novadan\\Uyumsoft\\StructType\\RetrySendInvoicesResponse',
            'CloneInvoices' => '\\Novadan\\Uyumsoft\\StructType\\CloneInvoices',
            'CloneInvoicesResponse' => '\\Novadan\\Uyumsoft\\StructType\\CloneInvoicesResponse',
            'CloneInvoiceServiceResponse' => '\\Novadan\\Uyumsoft\\StructType\\CloneInvoiceServiceResponse',
            'ClonedInvoiceInfo' => '\\Novadan\\Uyumsoft\\StructType\\ClonedInvoiceInfo',
            'CancelEArchiveInvoice' => '\\Novadan\\Uyumsoft\\StructType\\CancelEArchiveInvoice',
            'EArchiveCancelInvoiceContext' => '\\Novadan\\Uyumsoft\\StructType\\EArchiveCancelInvoiceContext',
            'CancelEArchiveInvoiceResponse' => '\\Novadan\\Uyumsoft\\StructType\\CancelEArchiveInvoiceResponse',
            'GetInboxInvoicePdf' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoicePdf',
            'GetInboxInvoicePdfResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetInboxInvoicePdfResponse',
            'GetOutboxInvoicePdf' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoicePdf',
            'GetOutboxInvoicePdfResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetOutboxInvoicePdfResponse',
            'ChangeInvoiceArchiveStatus' => '\\Novadan\\Uyumsoft\\StructType\\ChangeInvoiceArchiveStatus',
            'ChangeInvoiceArchiveStatusResponse' => '\\Novadan\\Uyumsoft\\StructType\\ChangeInvoiceArchiveStatusResponse',
            'GetSystemUsersCompressedList' => '\\Novadan\\Uyumsoft\\StructType\\GetSystemUsersCompressedList',
            'GetSystemUsersCompressedListResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetSystemUsersCompressedListResponse',
            'ByteArrayResponse' => '\\Novadan\\Uyumsoft\\StructType\\ByteArrayResponse',
            'GetSystemUsersCompressedListOld' => '\\Novadan\\Uyumsoft\\StructType\\GetSystemUsersCompressedListOld',
            'GetSystemUsersCompressedListOldResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetSystemUsersCompressedListOldResponse',
            'ImportExistingInvoice' => '\\Novadan\\Uyumsoft\\StructType\\ImportExistingInvoice',
            'FileUploadRequest' => '\\Novadan\\Uyumsoft\\StructType\\FileUploadRequest',
            'ImportExistingInvoiceResponse' => '\\Novadan\\Uyumsoft\\StructType\\ImportExistingInvoiceResponse',
            'QueueInvoiceNotification' => '\\Novadan\\Uyumsoft\\StructType\\QueueInvoiceNotification',
            'QueueInvoiceNotificationRequest' => '\\Novadan\\Uyumsoft\\StructType\\QueueInvoiceNotificationRequest',
            'QueueInvoiceNotificationResponse' => '\\Novadan\\Uyumsoft\\StructType\\QueueInvoiceNotificationResponse',
            'GetInvoiceEnvelope' => '\\Novadan\\Uyumsoft\\StructType\\GetInvoiceEnvelope',
            'GetInvoiceEnvelopeResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetInvoiceEnvelopeResponse',
            'EnvelopeResponse' => '\\Novadan\\Uyumsoft\\StructType\\EnvelopeResponse',
            'ResponseOfEnvelopeData' => '\\Novadan\\Uyumsoft\\StructType\\ResponseOfEnvelopeData',
            'EnvelopeData' => '\\Novadan\\Uyumsoft\\StructType\\EnvelopeData',
            'TestConnection' => '\\Novadan\\Uyumsoft\\StructType\\TestConnection',
            'TestConnectionResponse' => '\\Novadan\\Uyumsoft\\StructType\\TestConnectionResponse',
            'GetSummaryReport' => '\\Novadan\\Uyumsoft\\StructType\\GetSummaryReport',
            'GetSummaryReportResponse' => '\\Novadan\\Uyumsoft\\StructType\\GetSummaryReportResponse',
            'SummaryReportResponse' => '\\Novadan\\Uyumsoft\\StructType\\SummaryReportResponse',
            'CustomerSummaryUsageReport' => '\\Novadan\\Uyumsoft\\StructType\\CustomerSummaryUsageReport',
            'Last10DaysReport' => '\\Novadan\\Uyumsoft\\StructType\\Last10DaysReport',
            'MonthlyReportItem' => '\\Novadan\\Uyumsoft\\StructType\\MonthlyReportItem',
            'WhoAmI' => '\\Novadan\\Uyumsoft\\StructType\\WhoAmI',
            'WhoAmIResponse' => '\\Novadan\\Uyumsoft\\StructType\\WhoAmIResponse',
            'ResponseOfWhoAmIInfo' => '\\Novadan\\Uyumsoft\\StructType\\ResponseOfWhoAmIInfo',
            'WhoAmIInfo' => '\\Novadan\\Uyumsoft\\StructType\\WhoAmIInfo',
            'UserShortInfo' => '\\Novadan\\Uyumsoft\\StructType\\UserShortInfo',
            'CustomerWithoutServiceInformation' => '\\Novadan\\Uyumsoft\\StructType\\CustomerWithoutServiceInformation',
            'CompanyBaseEntity' => '\\Novadan\\Uyumsoft\\StructType\\CompanyBaseEntity',
            'CustomerServiceInformation' => '\\Novadan\\Uyumsoft\\StructType\\CustomerServiceInformation',
            'MoveToDraftStatus' => '\\Novadan\\Uyumsoft\\StructType\\MoveToDraftStatus',
            'MoveToDraftStatusResponse' => '\\Novadan\\Uyumsoft\\StructType\\MoveToDraftStatusResponse',
            'TransferInboxInvoiceToAnotherBranch' => '\\Novadan\\Uyumsoft\\StructType\\TransferInboxInvoiceToAnotherBranch',
            'TransferInboxInvoiceToAnotherBranchResponse' => '\\Novadan\\Uyumsoft\\StructType\\TransferInboxInvoiceToAnotherBranchResponse',
            'ReferencedSignatureIDType' => '\\Novadan\\Uyumsoft\\StructType\\ReferencedSignatureIDType',
        );
    }
}
