<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WhoAmIInfo StructType
 * @subpackage Structs
 */
class WhoAmIInfo extends AbstractStructBase
{
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\UserShortInfo
     */
    public $User;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\CustomerWithoutServiceInformation
     */
    public $Customer;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public $Company;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\CustomerServiceInformation
     */
    public $Services;
    /**
     * Constructor method for WhoAmIInfo
     * @uses WhoAmIInfo::setUser()
     * @uses WhoAmIInfo::setCustomer()
     * @uses WhoAmIInfo::setCompany()
     * @uses WhoAmIInfo::setServices()
     * @param \Novadan\Uyumsoft\StructType\UserShortInfo $user
     * @param \Novadan\Uyumsoft\StructType\CustomerWithoutServiceInformation $customer
     * @param \Novadan\Uyumsoft\StructType\CompanyBaseEntity $company
     * @param \Novadan\Uyumsoft\StructType\CustomerServiceInformation $services
     */
    public function __construct(\Novadan\Uyumsoft\StructType\UserShortInfo $user = null, \Novadan\Uyumsoft\StructType\CustomerWithoutServiceInformation $customer = null, \Novadan\Uyumsoft\StructType\CompanyBaseEntity $company = null, \Novadan\Uyumsoft\StructType\CustomerServiceInformation $services = null)
    {
        $this
            ->setUser($user)
            ->setCustomer($customer)
            ->setCompany($company)
            ->setServices($services);
    }
    /**
     * Get User value
     * @return \Novadan\Uyumsoft\StructType\UserShortInfo|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \Novadan\Uyumsoft\StructType\UserShortInfo $user
     * @return \Novadan\Uyumsoft\StructType\WhoAmIInfo
     */
    public function setUser(\Novadan\Uyumsoft\StructType\UserShortInfo $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Novadan\Uyumsoft\StructType\CustomerWithoutServiceInformation|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Novadan\Uyumsoft\StructType\CustomerWithoutServiceInformation $customer
     * @return \Novadan\Uyumsoft\StructType\WhoAmIInfo
     */
    public function setCustomer(\Novadan\Uyumsoft\StructType\CustomerWithoutServiceInformation $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Company value
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param \Novadan\Uyumsoft\StructType\CompanyBaseEntity $company
     * @return \Novadan\Uyumsoft\StructType\WhoAmIInfo
     */
    public function setCompany(\Novadan\Uyumsoft\StructType\CompanyBaseEntity $company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Services value
     * @return \Novadan\Uyumsoft\StructType\CustomerServiceInformation|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \Novadan\Uyumsoft\StructType\CustomerServiceInformation $services
     * @return \Novadan\Uyumsoft\StructType\WhoAmIInfo
     */
    public function setServices(\Novadan\Uyumsoft\StructType\CustomerServiceInformation $services = null)
    {
        $this->Services = $services;
        return $this;
    }
}
