<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportMeansType StructType
 * @subpackage Structs
 */
class TransportMeansType extends AbstractStructBase
{
    /**
     * The JourneyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q197:JourneyID
     * @var \Novadan\Uyumsoft\StructType\JourneyIDType
     */
    public $JourneyID;
    /**
     * The RegistrationNationalityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q198:RegistrationNationalityID
     * @var \Novadan\Uyumsoft\StructType\RegistrationNationalityIDType
     */
    public $RegistrationNationalityID;
    /**
     * The RegistrationNationality
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q199:RegistrationNationality
     * @var \Novadan\Uyumsoft\StructType\RegistrationNationalityType[]
     */
    public $RegistrationNationality;
    /**
     * The DirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q200:DirectionCode
     * @var \Novadan\Uyumsoft\StructType\DirectionCodeType
     */
    public $DirectionCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q201:TransportMeansTypeCode
     * @var \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TradeServiceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q202:TradeServiceCode
     * @var \Novadan\Uyumsoft\StructType\TradeServiceCodeType
     */
    public $TradeServiceCode;
    /**
     * The Stowage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\StowageType
     */
    public $Stowage;
    /**
     * The AirTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\AirTransportType
     */
    public $AirTransport;
    /**
     * The RoadTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\RoadTransportType
     */
    public $RoadTransport;
    /**
     * The RailTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\RailTransportType
     */
    public $RailTransport;
    /**
     * The MaritimeTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\MaritimeTransportType
     */
    public $MaritimeTransport;
    /**
     * The OwnerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PartyType
     */
    public $OwnerParty;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for TransportMeansType
     * @uses TransportMeansType::setJourneyID()
     * @uses TransportMeansType::setRegistrationNationalityID()
     * @uses TransportMeansType::setRegistrationNationality()
     * @uses TransportMeansType::setDirectionCode()
     * @uses TransportMeansType::setTransportMeansTypeCode()
     * @uses TransportMeansType::setTradeServiceCode()
     * @uses TransportMeansType::setStowage()
     * @uses TransportMeansType::setAirTransport()
     * @uses TransportMeansType::setRoadTransport()
     * @uses TransportMeansType::setRailTransport()
     * @uses TransportMeansType::setMaritimeTransport()
     * @uses TransportMeansType::setOwnerParty()
     * @uses TransportMeansType::setMeasurementDimension()
     * @param \Novadan\Uyumsoft\StructType\JourneyIDType $journeyID
     * @param \Novadan\Uyumsoft\StructType\RegistrationNationalityIDType $registrationNationalityID
     * @param \Novadan\Uyumsoft\StructType\RegistrationNationalityType[] $registrationNationality
     * @param \Novadan\Uyumsoft\StructType\DirectionCodeType $directionCode
     * @param \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @param \Novadan\Uyumsoft\StructType\TradeServiceCodeType $tradeServiceCode
     * @param \Novadan\Uyumsoft\StructType\StowageType $stowage
     * @param \Novadan\Uyumsoft\StructType\AirTransportType $airTransport
     * @param \Novadan\Uyumsoft\StructType\RoadTransportType $roadTransport
     * @param \Novadan\Uyumsoft\StructType\RailTransportType $railTransport
     * @param \Novadan\Uyumsoft\StructType\MaritimeTransportType $maritimeTransport
     * @param \Novadan\Uyumsoft\StructType\PartyType $ownerParty
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Novadan\Uyumsoft\StructType\JourneyIDType $journeyID = null, \Novadan\Uyumsoft\StructType\RegistrationNationalityIDType $registrationNationalityID = null, array $registrationNationality = array(), \Novadan\Uyumsoft\StructType\DirectionCodeType $directionCode = null, \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null, \Novadan\Uyumsoft\StructType\TradeServiceCodeType $tradeServiceCode = null, \Novadan\Uyumsoft\StructType\StowageType $stowage = null, \Novadan\Uyumsoft\StructType\AirTransportType $airTransport = null, \Novadan\Uyumsoft\StructType\RoadTransportType $roadTransport = null, \Novadan\Uyumsoft\StructType\RailTransportType $railTransport = null, \Novadan\Uyumsoft\StructType\MaritimeTransportType $maritimeTransport = null, \Novadan\Uyumsoft\StructType\PartyType $ownerParty = null, array $measurementDimension = array())
    {
        $this
            ->setJourneyID($journeyID)
            ->setRegistrationNationalityID($registrationNationalityID)
            ->setRegistrationNationality($registrationNationality)
            ->setDirectionCode($directionCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTradeServiceCode($tradeServiceCode)
            ->setStowage($stowage)
            ->setAirTransport($airTransport)
            ->setRoadTransport($roadTransport)
            ->setRailTransport($railTransport)
            ->setMaritimeTransport($maritimeTransport)
            ->setOwnerParty($ownerParty)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get JourneyID value
     * @return \Novadan\Uyumsoft\StructType\JourneyIDType|null
     */
    public function getJourneyID()
    {
        return $this->JourneyID;
    }
    /**
     * Set JourneyID value
     * @param \Novadan\Uyumsoft\StructType\JourneyIDType $journeyID
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setJourneyID(\Novadan\Uyumsoft\StructType\JourneyIDType $journeyID = null)
    {
        $this->JourneyID = $journeyID;
        return $this;
    }
    /**
     * Get RegistrationNationalityID value
     * @return \Novadan\Uyumsoft\StructType\RegistrationNationalityIDType|null
     */
    public function getRegistrationNationalityID()
    {
        return $this->RegistrationNationalityID;
    }
    /**
     * Set RegistrationNationalityID value
     * @param \Novadan\Uyumsoft\StructType\RegistrationNationalityIDType $registrationNationalityID
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setRegistrationNationalityID(\Novadan\Uyumsoft\StructType\RegistrationNationalityIDType $registrationNationalityID = null)
    {
        $this->RegistrationNationalityID = $registrationNationalityID;
        return $this;
    }
    /**
     * Get RegistrationNationality value
     * @return \Novadan\Uyumsoft\StructType\RegistrationNationalityType[]|null
     */
    public function getRegistrationNationality()
    {
        return $this->RegistrationNationality;
    }
    /**
     * This method is responsible for validating the values passed to the setRegistrationNationality method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegistrationNationality method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegistrationNationalityForArrayConstraintsFromSetRegistrationNationality(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportMeansTypeRegistrationNationalityItem) {
            // validation for constraint: itemType
            if (!$transportMeansTypeRegistrationNationalityItem instanceof \Novadan\Uyumsoft\StructType\RegistrationNationalityType) {
                $invalidValues[] = is_object($transportMeansTypeRegistrationNationalityItem) ? get_class($transportMeansTypeRegistrationNationalityItem) : sprintf('%s(%s)', gettype($transportMeansTypeRegistrationNationalityItem), var_export($transportMeansTypeRegistrationNationalityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RegistrationNationality property can only contain items of type \Novadan\Uyumsoft\StructType\RegistrationNationalityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RegistrationNationality value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\RegistrationNationalityType[] $registrationNationality
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setRegistrationNationality(array $registrationNationality = array())
    {
        // validation for constraint: array
        if ('' !== ($registrationNationalityArrayErrorMessage = self::validateRegistrationNationalityForArrayConstraintsFromSetRegistrationNationality($registrationNationality))) {
            throw new \InvalidArgumentException($registrationNationalityArrayErrorMessage, __LINE__);
        }
        $this->RegistrationNationality = $registrationNationality;
        return $this;
    }
    /**
     * Add item to RegistrationNationality value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\RegistrationNationalityType $item
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function addToRegistrationNationality(\Novadan\Uyumsoft\StructType\RegistrationNationalityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\RegistrationNationalityType) {
            throw new \InvalidArgumentException(sprintf('The RegistrationNationality property can only contain items of type \Novadan\Uyumsoft\StructType\RegistrationNationalityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RegistrationNationality[] = $item;
        return $this;
    }
    /**
     * Get DirectionCode value
     * @return \Novadan\Uyumsoft\StructType\DirectionCodeType|null
     */
    public function getDirectionCode()
    {
        return $this->DirectionCode;
    }
    /**
     * Set DirectionCode value
     * @param \Novadan\Uyumsoft\StructType\DirectionCodeType $directionCode
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setDirectionCode(\Novadan\Uyumsoft\StructType\DirectionCodeType $directionCode = null)
    {
        $this->DirectionCode = $directionCode;
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * @return \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }
    /**
     * Set TransportMeansTypeCode value
     * @param \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setTransportMeansTypeCode(\Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }
    /**
     * Get TradeServiceCode value
     * @return \Novadan\Uyumsoft\StructType\TradeServiceCodeType|null
     */
    public function getTradeServiceCode()
    {
        return $this->TradeServiceCode;
    }
    /**
     * Set TradeServiceCode value
     * @param \Novadan\Uyumsoft\StructType\TradeServiceCodeType $tradeServiceCode
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setTradeServiceCode(\Novadan\Uyumsoft\StructType\TradeServiceCodeType $tradeServiceCode = null)
    {
        $this->TradeServiceCode = $tradeServiceCode;
        return $this;
    }
    /**
     * Get Stowage value
     * @return \Novadan\Uyumsoft\StructType\StowageType|null
     */
    public function getStowage()
    {
        return $this->Stowage;
    }
    /**
     * Set Stowage value
     * @param \Novadan\Uyumsoft\StructType\StowageType $stowage
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setStowage(\Novadan\Uyumsoft\StructType\StowageType $stowage = null)
    {
        $this->Stowage = $stowage;
        return $this;
    }
    /**
     * Get AirTransport value
     * @return \Novadan\Uyumsoft\StructType\AirTransportType|null
     */
    public function getAirTransport()
    {
        return $this->AirTransport;
    }
    /**
     * Set AirTransport value
     * @param \Novadan\Uyumsoft\StructType\AirTransportType $airTransport
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setAirTransport(\Novadan\Uyumsoft\StructType\AirTransportType $airTransport = null)
    {
        $this->AirTransport = $airTransport;
        return $this;
    }
    /**
     * Get RoadTransport value
     * @return \Novadan\Uyumsoft\StructType\RoadTransportType|null
     */
    public function getRoadTransport()
    {
        return $this->RoadTransport;
    }
    /**
     * Set RoadTransport value
     * @param \Novadan\Uyumsoft\StructType\RoadTransportType $roadTransport
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setRoadTransport(\Novadan\Uyumsoft\StructType\RoadTransportType $roadTransport = null)
    {
        $this->RoadTransport = $roadTransport;
        return $this;
    }
    /**
     * Get RailTransport value
     * @return \Novadan\Uyumsoft\StructType\RailTransportType|null
     */
    public function getRailTransport()
    {
        return $this->RailTransport;
    }
    /**
     * Set RailTransport value
     * @param \Novadan\Uyumsoft\StructType\RailTransportType $railTransport
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setRailTransport(\Novadan\Uyumsoft\StructType\RailTransportType $railTransport = null)
    {
        $this->RailTransport = $railTransport;
        return $this;
    }
    /**
     * Get MaritimeTransport value
     * @return \Novadan\Uyumsoft\StructType\MaritimeTransportType|null
     */
    public function getMaritimeTransport()
    {
        return $this->MaritimeTransport;
    }
    /**
     * Set MaritimeTransport value
     * @param \Novadan\Uyumsoft\StructType\MaritimeTransportType $maritimeTransport
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setMaritimeTransport(\Novadan\Uyumsoft\StructType\MaritimeTransportType $maritimeTransport = null)
    {
        $this->MaritimeTransport = $maritimeTransport;
        return $this;
    }
    /**
     * Get OwnerParty value
     * @return \Novadan\Uyumsoft\StructType\PartyType|null
     */
    public function getOwnerParty()
    {
        return $this->OwnerParty;
    }
    /**
     * Set OwnerParty value
     * @param \Novadan\Uyumsoft\StructType\PartyType $ownerParty
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setOwnerParty(\Novadan\Uyumsoft\StructType\PartyType $ownerParty = null)
    {
        $this->OwnerParty = $ownerParty;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Novadan\Uyumsoft\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportMeansTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$transportMeansTypeMeasurementDimensionItem instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
                $invalidValues[] = is_object($transportMeansTypeMeasurementDimensionItem) ? get_class($transportMeansTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($transportMeansTypeMeasurementDimensionItem), var_export($transportMeansTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType $item
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public function addToMeasurementDimension(\Novadan\Uyumsoft\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
