<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportHandlingUnitType StructType
 * @subpackage Structs
 */
class TransportHandlingUnitType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q215:ID
     * @var \Novadan\Uyumsoft\StructType\IDType
     */
    public $ID;
    /**
     * The TransportHandlingUnitTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q216:TransportHandlingUnitTypeCode
     * @var \Novadan\Uyumsoft\StructType\TransportHandlingUnitTypeCodeType
     */
    public $TransportHandlingUnitTypeCode;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q217:HandlingCode
     * @var \Novadan\Uyumsoft\StructType\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q218:HandlingInstructions
     * @var \Novadan\Uyumsoft\StructType\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q219:HazardousRiskIndicator
     * @var \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q220:TotalGoodsItemQuantity
     * @var \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalPackageQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q221:TotalPackageQuantity
     * @var \Novadan\Uyumsoft\StructType\TotalPackageQuantityType
     */
    public $TotalPackageQuantity;
    /**
     * The DamageRemarks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q222:DamageRemarks
     * @var \Novadan\Uyumsoft\StructType\DamageRemarksType[]
     */
    public $DamageRemarks;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q223:TraceID
     * @var \Novadan\Uyumsoft\StructType\TraceIDType
     */
    public $TraceID;
    /**
     * The ActualPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PackageType[]
     */
    public $ActualPackage;
    /**
     * The TransportEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\TransportEquipmentType[]
     */
    public $TransportEquipment;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\TransportMeansType[]
     */
    public $TransportMeans;
    /**
     * The HazardousGoodsTransit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType[]
     */
    public $HazardousGoodsTransit;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The FloorSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DimensionType
     */
    public $FloorSpaceMeasurementDimension;
    /**
     * The PalletSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DimensionType
     */
    public $PalletSpaceMeasurementDimension;
    /**
     * The ShipmentDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DocumentReferenceType[]
     */
    public $ShipmentDocumentReference;
    /**
     * The CustomsDeclaration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\CustomsDeclarationType[]
     */
    public $CustomsDeclaration;
    /**
     * Constructor method for TransportHandlingUnitType
     * @uses TransportHandlingUnitType::setID()
     * @uses TransportHandlingUnitType::setTransportHandlingUnitTypeCode()
     * @uses TransportHandlingUnitType::setHandlingCode()
     * @uses TransportHandlingUnitType::setHandlingInstructions()
     * @uses TransportHandlingUnitType::setHazardousRiskIndicator()
     * @uses TransportHandlingUnitType::setTotalGoodsItemQuantity()
     * @uses TransportHandlingUnitType::setTotalPackageQuantity()
     * @uses TransportHandlingUnitType::setDamageRemarks()
     * @uses TransportHandlingUnitType::setTraceID()
     * @uses TransportHandlingUnitType::setActualPackage()
     * @uses TransportHandlingUnitType::setTransportEquipment()
     * @uses TransportHandlingUnitType::setTransportMeans()
     * @uses TransportHandlingUnitType::setHazardousGoodsTransit()
     * @uses TransportHandlingUnitType::setMeasurementDimension()
     * @uses TransportHandlingUnitType::setMinimumTemperature()
     * @uses TransportHandlingUnitType::setMaximumTemperature()
     * @uses TransportHandlingUnitType::setFloorSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setPalletSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setShipmentDocumentReference()
     * @uses TransportHandlingUnitType::setCustomsDeclaration()
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @param \Novadan\Uyumsoft\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @param \Novadan\Uyumsoft\StructType\HandlingCodeType $handlingCode
     * @param \Novadan\Uyumsoft\StructType\HandlingInstructionsType $handlingInstructions
     * @param \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \Novadan\Uyumsoft\StructType\TotalPackageQuantityType $totalPackageQuantity
     * @param \Novadan\Uyumsoft\StructType\DamageRemarksType[] $damageRemarks
     * @param \Novadan\Uyumsoft\StructType\TraceIDType $traceID
     * @param \Novadan\Uyumsoft\StructType\PackageType[] $actualPackage
     * @param \Novadan\Uyumsoft\StructType\TransportEquipmentType[] $transportEquipment
     * @param \Novadan\Uyumsoft\StructType\TransportMeansType[] $transportMeans
     * @param \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     * @param \Novadan\Uyumsoft\StructType\TemperatureType $minimumTemperature
     * @param \Novadan\Uyumsoft\StructType\TemperatureType $maximumTemperature
     * @param \Novadan\Uyumsoft\StructType\DimensionType $floorSpaceMeasurementDimension
     * @param \Novadan\Uyumsoft\StructType\DimensionType $palletSpaceMeasurementDimension
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $shipmentDocumentReference
     * @param \Novadan\Uyumsoft\StructType\CustomsDeclarationType[] $customsDeclaration
     */
    public function __construct(\Novadan\Uyumsoft\StructType\IDType $iD = null, \Novadan\Uyumsoft\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null, \Novadan\Uyumsoft\StructType\HandlingCodeType $handlingCode = null, \Novadan\Uyumsoft\StructType\HandlingInstructionsType $handlingInstructions = null, \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \Novadan\Uyumsoft\StructType\TotalPackageQuantityType $totalPackageQuantity = null, array $damageRemarks = array(), \Novadan\Uyumsoft\StructType\TraceIDType $traceID = null, array $actualPackage = array(), array $transportEquipment = array(), array $transportMeans = array(), array $hazardousGoodsTransit = array(), array $measurementDimension = array(), \Novadan\Uyumsoft\StructType\TemperatureType $minimumTemperature = null, \Novadan\Uyumsoft\StructType\TemperatureType $maximumTemperature = null, \Novadan\Uyumsoft\StructType\DimensionType $floorSpaceMeasurementDimension = null, \Novadan\Uyumsoft\StructType\DimensionType $palletSpaceMeasurementDimension = null, array $shipmentDocumentReference = array(), array $customsDeclaration = array())
    {
        $this
            ->setID($iD)
            ->setTransportHandlingUnitTypeCode($transportHandlingUnitTypeCode)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalPackageQuantity($totalPackageQuantity)
            ->setDamageRemarks($damageRemarks)
            ->setTraceID($traceID)
            ->setActualPackage($actualPackage)
            ->setTransportEquipment($transportEquipment)
            ->setTransportMeans($transportMeans)
            ->setHazardousGoodsTransit($hazardousGoodsTransit)
            ->setMeasurementDimension($measurementDimension)
            ->setMinimumTemperature($minimumTemperature)
            ->setMaximumTemperature($maximumTemperature)
            ->setFloorSpaceMeasurementDimension($floorSpaceMeasurementDimension)
            ->setPalletSpaceMeasurementDimension($palletSpaceMeasurementDimension)
            ->setShipmentDocumentReference($shipmentDocumentReference)
            ->setCustomsDeclaration($customsDeclaration);
    }
    /**
     * Get ID value
     * @return \Novadan\Uyumsoft\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setID(\Novadan\Uyumsoft\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportHandlingUnitTypeCode value
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitTypeCodeType|null
     */
    public function getTransportHandlingUnitTypeCode()
    {
        return $this->TransportHandlingUnitTypeCode;
    }
    /**
     * Set TransportHandlingUnitTypeCode value
     * @param \Novadan\Uyumsoft\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setTransportHandlingUnitTypeCode(\Novadan\Uyumsoft\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null)
    {
        $this->TransportHandlingUnitTypeCode = $transportHandlingUnitTypeCode;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \Novadan\Uyumsoft\StructType\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \Novadan\Uyumsoft\StructType\HandlingCodeType $handlingCode
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setHandlingCode(\Novadan\Uyumsoft\StructType\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \Novadan\Uyumsoft\StructType\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \Novadan\Uyumsoft\StructType\HandlingInstructionsType $handlingInstructions
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setHandlingInstructions(\Novadan\Uyumsoft\StructType\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setHazardousRiskIndicator(\Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setTotalGoodsItemQuantity(\Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalPackageQuantity value
     * @return \Novadan\Uyumsoft\StructType\TotalPackageQuantityType|null
     */
    public function getTotalPackageQuantity()
    {
        return $this->TotalPackageQuantity;
    }
    /**
     * Set TotalPackageQuantity value
     * @param \Novadan\Uyumsoft\StructType\TotalPackageQuantityType $totalPackageQuantity
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setTotalPackageQuantity(\Novadan\Uyumsoft\StructType\TotalPackageQuantityType $totalPackageQuantity = null)
    {
        $this->TotalPackageQuantity = $totalPackageQuantity;
        return $this;
    }
    /**
     * Get DamageRemarks value
     * @return \Novadan\Uyumsoft\StructType\DamageRemarksType[]|null
     */
    public function getDamageRemarks()
    {
        return $this->DamageRemarks;
    }
    /**
     * This method is responsible for validating the values passed to the setDamageRemarks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDamageRemarks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDamageRemarksForArrayConstraintsFromSetDamageRemarks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeDamageRemarksItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeDamageRemarksItem instanceof \Novadan\Uyumsoft\StructType\DamageRemarksType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeDamageRemarksItem) ? get_class($transportHandlingUnitTypeDamageRemarksItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeDamageRemarksItem), var_export($transportHandlingUnitTypeDamageRemarksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DamageRemarks property can only contain items of type \Novadan\Uyumsoft\StructType\DamageRemarksType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DamageRemarks value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DamageRemarksType[] $damageRemarks
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setDamageRemarks(array $damageRemarks = array())
    {
        // validation for constraint: array
        if ('' !== ($damageRemarksArrayErrorMessage = self::validateDamageRemarksForArrayConstraintsFromSetDamageRemarks($damageRemarks))) {
            throw new \InvalidArgumentException($damageRemarksArrayErrorMessage, __LINE__);
        }
        $this->DamageRemarks = $damageRemarks;
        return $this;
    }
    /**
     * Add item to DamageRemarks value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DamageRemarksType $item
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function addToDamageRemarks(\Novadan\Uyumsoft\StructType\DamageRemarksType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DamageRemarksType) {
            throw new \InvalidArgumentException(sprintf('The DamageRemarks property can only contain items of type \Novadan\Uyumsoft\StructType\DamageRemarksType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DamageRemarks[] = $item;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \Novadan\Uyumsoft\StructType\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \Novadan\Uyumsoft\StructType\TraceIDType $traceID
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setTraceID(\Novadan\Uyumsoft\StructType\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get ActualPackage value
     * @return \Novadan\Uyumsoft\StructType\PackageType[]|null
     */
    public function getActualPackage()
    {
        return $this->ActualPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setActualPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActualPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActualPackageForArrayConstraintsFromSetActualPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeActualPackageItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeActualPackageItem instanceof \Novadan\Uyumsoft\StructType\PackageType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeActualPackageItem) ? get_class($transportHandlingUnitTypeActualPackageItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeActualPackageItem), var_export($transportHandlingUnitTypeActualPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActualPackage property can only contain items of type \Novadan\Uyumsoft\StructType\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActualPackage value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PackageType[] $actualPackage
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setActualPackage(array $actualPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($actualPackageArrayErrorMessage = self::validateActualPackageForArrayConstraintsFromSetActualPackage($actualPackage))) {
            throw new \InvalidArgumentException($actualPackageArrayErrorMessage, __LINE__);
        }
        $this->ActualPackage = $actualPackage;
        return $this;
    }
    /**
     * Add item to ActualPackage value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PackageType $item
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function addToActualPackage(\Novadan\Uyumsoft\StructType\PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\PackageType) {
            throw new \InvalidArgumentException(sprintf('The ActualPackage property can only contain items of type \Novadan\Uyumsoft\StructType\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActualPackage[] = $item;
        return $this;
    }
    /**
     * Get TransportEquipment value
     * @return \Novadan\Uyumsoft\StructType\TransportEquipmentType[]|null
     */
    public function getTransportEquipment()
    {
        return $this->TransportEquipment;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportEquipmentForArrayConstraintsFromSetTransportEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeTransportEquipmentItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeTransportEquipmentItem instanceof \Novadan\Uyumsoft\StructType\TransportEquipmentType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeTransportEquipmentItem) ? get_class($transportHandlingUnitTypeTransportEquipmentItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeTransportEquipmentItem), var_export($transportHandlingUnitTypeTransportEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportEquipment property can only contain items of type \Novadan\Uyumsoft\StructType\TransportEquipmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportEquipment value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TransportEquipmentType[] $transportEquipment
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setTransportEquipment(array $transportEquipment = array())
    {
        // validation for constraint: array
        if ('' !== ($transportEquipmentArrayErrorMessage = self::validateTransportEquipmentForArrayConstraintsFromSetTransportEquipment($transportEquipment))) {
            throw new \InvalidArgumentException($transportEquipmentArrayErrorMessage, __LINE__);
        }
        $this->TransportEquipment = $transportEquipment;
        return $this;
    }
    /**
     * Add item to TransportEquipment value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TransportEquipmentType $item
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function addToTransportEquipment(\Novadan\Uyumsoft\StructType\TransportEquipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\TransportEquipmentType) {
            throw new \InvalidArgumentException(sprintf('The TransportEquipment property can only contain items of type \Novadan\Uyumsoft\StructType\TransportEquipmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportEquipment[] = $item;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType[]|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportMeans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportMeans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportMeansForArrayConstraintsFromSetTransportMeans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeTransportMeansItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeTransportMeansItem instanceof \Novadan\Uyumsoft\StructType\TransportMeansType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeTransportMeansItem) ? get_class($transportHandlingUnitTypeTransportMeansItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeTransportMeansItem), var_export($transportHandlingUnitTypeTransportMeansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportMeans property can only contain items of type \Novadan\Uyumsoft\StructType\TransportMeansType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportMeans value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TransportMeansType[] $transportMeans
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setTransportMeans(array $transportMeans = array())
    {
        // validation for constraint: array
        if ('' !== ($transportMeansArrayErrorMessage = self::validateTransportMeansForArrayConstraintsFromSetTransportMeans($transportMeans))) {
            throw new \InvalidArgumentException($transportMeansArrayErrorMessage, __LINE__);
        }
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Add item to TransportMeans value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TransportMeansType $item
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function addToTransportMeans(\Novadan\Uyumsoft\StructType\TransportMeansType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\TransportMeansType) {
            throw new \InvalidArgumentException(sprintf('The TransportMeans property can only contain items of type \Novadan\Uyumsoft\StructType\TransportMeansType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportMeans[] = $item;
        return $this;
    }
    /**
     * Get HazardousGoodsTransit value
     * @return \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType[]|null
     */
    public function getHazardousGoodsTransit()
    {
        return $this->HazardousGoodsTransit;
    }
    /**
     * This method is responsible for validating the values passed to the setHazardousGoodsTransit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazardousGoodsTransit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazardousGoodsTransitForArrayConstraintsFromSetHazardousGoodsTransit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeHazardousGoodsTransitItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeHazardousGoodsTransitItem instanceof \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeHazardousGoodsTransitItem) ? get_class($transportHandlingUnitTypeHazardousGoodsTransitItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeHazardousGoodsTransitItem), var_export($transportHandlingUnitTypeHazardousGoodsTransitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HazardousGoodsTransit property can only contain items of type \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HazardousGoodsTransit value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setHazardousGoodsTransit(array $hazardousGoodsTransit = array())
    {
        // validation for constraint: array
        if ('' !== ($hazardousGoodsTransitArrayErrorMessage = self::validateHazardousGoodsTransitForArrayConstraintsFromSetHazardousGoodsTransit($hazardousGoodsTransit))) {
            throw new \InvalidArgumentException($hazardousGoodsTransitArrayErrorMessage, __LINE__);
        }
        $this->HazardousGoodsTransit = $hazardousGoodsTransit;
        return $this;
    }
    /**
     * Add item to HazardousGoodsTransit value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType $item
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function addToHazardousGoodsTransit(\Novadan\Uyumsoft\StructType\HazardousGoodsTransitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType) {
            throw new \InvalidArgumentException(sprintf('The HazardousGoodsTransit property can only contain items of type \Novadan\Uyumsoft\StructType\HazardousGoodsTransitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HazardousGoodsTransit[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Novadan\Uyumsoft\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeMeasurementDimensionItem instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeMeasurementDimensionItem) ? get_class($transportHandlingUnitTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeMeasurementDimensionItem), var_export($transportHandlingUnitTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType $item
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function addToMeasurementDimension(\Novadan\Uyumsoft\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \Novadan\Uyumsoft\StructType\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \Novadan\Uyumsoft\StructType\TemperatureType $minimumTemperature
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setMinimumTemperature(\Novadan\Uyumsoft\StructType\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \Novadan\Uyumsoft\StructType\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \Novadan\Uyumsoft\StructType\TemperatureType $maximumTemperature
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setMaximumTemperature(\Novadan\Uyumsoft\StructType\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get FloorSpaceMeasurementDimension value
     * @return \Novadan\Uyumsoft\StructType\DimensionType|null
     */
    public function getFloorSpaceMeasurementDimension()
    {
        return $this->FloorSpaceMeasurementDimension;
    }
    /**
     * Set FloorSpaceMeasurementDimension value
     * @param \Novadan\Uyumsoft\StructType\DimensionType $floorSpaceMeasurementDimension
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setFloorSpaceMeasurementDimension(\Novadan\Uyumsoft\StructType\DimensionType $floorSpaceMeasurementDimension = null)
    {
        $this->FloorSpaceMeasurementDimension = $floorSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get PalletSpaceMeasurementDimension value
     * @return \Novadan\Uyumsoft\StructType\DimensionType|null
     */
    public function getPalletSpaceMeasurementDimension()
    {
        return $this->PalletSpaceMeasurementDimension;
    }
    /**
     * Set PalletSpaceMeasurementDimension value
     * @param \Novadan\Uyumsoft\StructType\DimensionType $palletSpaceMeasurementDimension
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setPalletSpaceMeasurementDimension(\Novadan\Uyumsoft\StructType\DimensionType $palletSpaceMeasurementDimension = null)
    {
        $this->PalletSpaceMeasurementDimension = $palletSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get ShipmentDocumentReference value
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType[]|null
     */
    public function getShipmentDocumentReference()
    {
        return $this->ShipmentDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentDocumentReferenceForArrayConstraintsFromSetShipmentDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeShipmentDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeShipmentDocumentReferenceItem instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeShipmentDocumentReferenceItem) ? get_class($transportHandlingUnitTypeShipmentDocumentReferenceItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeShipmentDocumentReferenceItem), var_export($transportHandlingUnitTypeShipmentDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType[] $shipmentDocumentReference
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setShipmentDocumentReference(array $shipmentDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentDocumentReferenceArrayErrorMessage = self::validateShipmentDocumentReferenceForArrayConstraintsFromSetShipmentDocumentReference($shipmentDocumentReference))) {
            throw new \InvalidArgumentException($shipmentDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ShipmentDocumentReference = $shipmentDocumentReference;
        return $this;
    }
    /**
     * Add item to ShipmentDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentReferenceType $item
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function addToShipmentDocumentReference(\Novadan\Uyumsoft\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDocumentReference property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get CustomsDeclaration value
     * @return \Novadan\Uyumsoft\StructType\CustomsDeclarationType[]|null
     */
    public function getCustomsDeclaration()
    {
        return $this->CustomsDeclaration;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomsDeclaration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomsDeclaration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsDeclarationForArrayConstraintsFromSetCustomsDeclaration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeCustomsDeclarationItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeCustomsDeclarationItem instanceof \Novadan\Uyumsoft\StructType\CustomsDeclarationType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeCustomsDeclarationItem) ? get_class($transportHandlingUnitTypeCustomsDeclarationItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeCustomsDeclarationItem), var_export($transportHandlingUnitTypeCustomsDeclarationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomsDeclaration property can only contain items of type \Novadan\Uyumsoft\StructType\CustomsDeclarationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomsDeclaration value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\CustomsDeclarationType[] $customsDeclaration
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function setCustomsDeclaration(array $customsDeclaration = array())
    {
        // validation for constraint: array
        if ('' !== ($customsDeclarationArrayErrorMessage = self::validateCustomsDeclarationForArrayConstraintsFromSetCustomsDeclaration($customsDeclaration))) {
            throw new \InvalidArgumentException($customsDeclarationArrayErrorMessage, __LINE__);
        }
        $this->CustomsDeclaration = $customsDeclaration;
        return $this;
    }
    /**
     * Add item to CustomsDeclaration value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\CustomsDeclarationType $item
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType
     */
    public function addToCustomsDeclaration(\Novadan\Uyumsoft\StructType\CustomsDeclarationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\CustomsDeclarationType) {
            throw new \InvalidArgumentException(sprintf('The CustomsDeclaration property can only contain items of type \Novadan\Uyumsoft\StructType\CustomsDeclarationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomsDeclaration[] = $item;
        return $this;
    }
}
