<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsMessageInformation StructType
 * @subpackage Structs
 */
class SmsMessageInformation extends AbstractStructBase
{
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The To
     * @var string
     */
    public $To;
    /**
     * The BodyXsltIdentifier
     * @var string
     */
    public $BodyXsltIdentifier;
    /**
     * The SmsAccountIdentifier
     * @var string
     */
    public $SmsAccountIdentifier;
    /**
     * Constructor method for SmsMessageInformation
     * @uses SmsMessageInformation::setSubject()
     * @uses SmsMessageInformation::setTo()
     * @uses SmsMessageInformation::setBodyXsltIdentifier()
     * @uses SmsMessageInformation::setSmsAccountIdentifier()
     * @param string $subject
     * @param string $to
     * @param string $bodyXsltIdentifier
     * @param string $smsAccountIdentifier
     */
    public function __construct($subject = null, $to = null, $bodyXsltIdentifier = null, $smsAccountIdentifier = null)
    {
        $this
            ->setSubject($subject)
            ->setTo($to)
            ->setBodyXsltIdentifier($bodyXsltIdentifier)
            ->setSmsAccountIdentifier($smsAccountIdentifier);
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \Novadan\Uyumsoft\StructType\SmsMessageInformation
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \Novadan\Uyumsoft\StructType\SmsMessageInformation
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Get BodyXsltIdentifier value
     * @return string|null
     */
    public function getBodyXsltIdentifier()
    {
        return $this->BodyXsltIdentifier;
    }
    /**
     * Set BodyXsltIdentifier value
     * @param string $bodyXsltIdentifier
     * @return \Novadan\Uyumsoft\StructType\SmsMessageInformation
     */
    public function setBodyXsltIdentifier($bodyXsltIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($bodyXsltIdentifier) && !is_string($bodyXsltIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bodyXsltIdentifier, true), gettype($bodyXsltIdentifier)), __LINE__);
        }
        $this->BodyXsltIdentifier = $bodyXsltIdentifier;
        return $this;
    }
    /**
     * Get SmsAccountIdentifier value
     * @return string|null
     */
    public function getSmsAccountIdentifier()
    {
        return $this->SmsAccountIdentifier;
    }
    /**
     * Set SmsAccountIdentifier value
     * @param string $smsAccountIdentifier
     * @return \Novadan\Uyumsoft\StructType\SmsMessageInformation
     */
    public function setSmsAccountIdentifier($smsAccountIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($smsAccountIdentifier) && !is_string($smsAccountIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smsAccountIdentifier, true), gettype($smsAccountIdentifier)), __LINE__);
        }
        $this->SmsAccountIdentifier = $smsAccountIdentifier;
        return $this;
    }
}
