<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType StructType
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q96:ID
     * @var \Novadan\Uyumsoft\StructType\IDType
     */
    public $ID;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q97:HandlingCode
     * @var \Novadan\Uyumsoft\StructType\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q98:HandlingInstructions
     * @var \Novadan\Uyumsoft\StructType\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q99:GrossWeightMeasure
     * @var \Novadan\Uyumsoft\StructType\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q100:NetWeightMeasure
     * @var \Novadan\Uyumsoft\StructType\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q101:GrossVolumeMeasure
     * @var \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q102:NetVolumeMeasure
     * @var \Novadan\Uyumsoft\StructType\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q103:TotalGoodsItemQuantity
     * @var \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalTransportHandlingUnitQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q104:TotalTransportHandlingUnitQuantity
     * @var \Novadan\Uyumsoft\StructType\TotalTransportHandlingUnitQuantityType
     */
    public $TotalTransportHandlingUnitQuantity;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q105:InsuranceValueAmount
     * @var \Novadan\Uyumsoft\StructType\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q106:DeclaredCustomsValueAmount
     * @var \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q107:DeclaredForCarriageValueAmount
     * @var \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q108:DeclaredStatisticsValueAmount
     * @var \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q109:FreeOnBoardValueAmount
     * @var \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The SpecialInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q110:SpecialInstructions
     * @var \Novadan\Uyumsoft\StructType\SpecialInstructionsType[]
     */
    public $SpecialInstructions;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The ShipmentStage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ShipmentStageType[]
     */
    public $ShipmentStage;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public $Delivery;
    /**
     * The TransportHandlingUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\TransportHandlingUnitType[]
     */
    public $TransportHandlingUnit;
    /**
     * The ReturnAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\AddressType
     */
    public $ReturnAddress;
    /**
     * The FirstArrivalPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\LocationType
     */
    public $FirstArrivalPortLocation;
    /**
     * The LastExitPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\LocationType
     */
    public $LastExitPortLocation;
    /**
     * Constructor method for ShipmentType
     * @uses ShipmentType::setID()
     * @uses ShipmentType::setHandlingCode()
     * @uses ShipmentType::setHandlingInstructions()
     * @uses ShipmentType::setGrossWeightMeasure()
     * @uses ShipmentType::setNetWeightMeasure()
     * @uses ShipmentType::setGrossVolumeMeasure()
     * @uses ShipmentType::setNetVolumeMeasure()
     * @uses ShipmentType::setTotalGoodsItemQuantity()
     * @uses ShipmentType::setTotalTransportHandlingUnitQuantity()
     * @uses ShipmentType::setInsuranceValueAmount()
     * @uses ShipmentType::setDeclaredCustomsValueAmount()
     * @uses ShipmentType::setDeclaredForCarriageValueAmount()
     * @uses ShipmentType::setDeclaredStatisticsValueAmount()
     * @uses ShipmentType::setFreeOnBoardValueAmount()
     * @uses ShipmentType::setSpecialInstructions()
     * @uses ShipmentType::setGoodsItem()
     * @uses ShipmentType::setShipmentStage()
     * @uses ShipmentType::setDelivery()
     * @uses ShipmentType::setTransportHandlingUnit()
     * @uses ShipmentType::setReturnAddress()
     * @uses ShipmentType::setFirstArrivalPortLocation()
     * @uses ShipmentType::setLastExitPortLocation()
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @param \Novadan\Uyumsoft\StructType\HandlingCodeType $handlingCode
     * @param \Novadan\Uyumsoft\StructType\HandlingInstructionsType $handlingInstructions
     * @param \Novadan\Uyumsoft\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @param \Novadan\Uyumsoft\StructType\NetWeightMeasureType $netWeightMeasure
     * @param \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \Novadan\Uyumsoft\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @param \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \Novadan\Uyumsoft\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @param \Novadan\Uyumsoft\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @param \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \Novadan\Uyumsoft\StructType\SpecialInstructionsType[] $specialInstructions
     * @param \Novadan\Uyumsoft\StructType\GoodsItemType[] $goodsItem
     * @param \Novadan\Uyumsoft\StructType\ShipmentStageType[] $shipmentStage
     * @param \Novadan\Uyumsoft\StructType\DeliveryType $delivery
     * @param \Novadan\Uyumsoft\StructType\TransportHandlingUnitType[] $transportHandlingUnit
     * @param \Novadan\Uyumsoft\StructType\AddressType $returnAddress
     * @param \Novadan\Uyumsoft\StructType\LocationType $firstArrivalPortLocation
     * @param \Novadan\Uyumsoft\StructType\LocationType $lastExitPortLocation
     */
    public function __construct(\Novadan\Uyumsoft\StructType\IDType $iD = null, \Novadan\Uyumsoft\StructType\HandlingCodeType $handlingCode = null, \Novadan\Uyumsoft\StructType\HandlingInstructionsType $handlingInstructions = null, \Novadan\Uyumsoft\StructType\GrossWeightMeasureType $grossWeightMeasure = null, \Novadan\Uyumsoft\StructType\NetWeightMeasureType $netWeightMeasure = null, \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null, \Novadan\Uyumsoft\StructType\NetVolumeMeasureType $netVolumeMeasure = null, \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \Novadan\Uyumsoft\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null, \Novadan\Uyumsoft\StructType\InsuranceValueAmountType $insuranceValueAmount = null, \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, array $specialInstructions = array(), array $goodsItem = array(), array $shipmentStage = array(), \Novadan\Uyumsoft\StructType\DeliveryType $delivery = null, array $transportHandlingUnit = array(), \Novadan\Uyumsoft\StructType\AddressType $returnAddress = null, \Novadan\Uyumsoft\StructType\LocationType $firstArrivalPortLocation = null, \Novadan\Uyumsoft\StructType\LocationType $lastExitPortLocation = null)
    {
        $this
            ->setID($iD)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalTransportHandlingUnitQuantity($totalTransportHandlingUnitQuantity)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setSpecialInstructions($specialInstructions)
            ->setGoodsItem($goodsItem)
            ->setShipmentStage($shipmentStage)
            ->setDelivery($delivery)
            ->setTransportHandlingUnit($transportHandlingUnit)
            ->setReturnAddress($returnAddress)
            ->setFirstArrivalPortLocation($firstArrivalPortLocation)
            ->setLastExitPortLocation($lastExitPortLocation);
    }
    /**
     * Get ID value
     * @return \Novadan\Uyumsoft\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setID(\Novadan\Uyumsoft\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \Novadan\Uyumsoft\StructType\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \Novadan\Uyumsoft\StructType\HandlingCodeType $handlingCode
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setHandlingCode(\Novadan\Uyumsoft\StructType\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \Novadan\Uyumsoft\StructType\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \Novadan\Uyumsoft\StructType\HandlingInstructionsType $handlingInstructions
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setHandlingInstructions(\Novadan\Uyumsoft\StructType\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \Novadan\Uyumsoft\StructType\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \Novadan\Uyumsoft\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setGrossWeightMeasure(\Novadan\Uyumsoft\StructType\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \Novadan\Uyumsoft\StructType\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \Novadan\Uyumsoft\StructType\NetWeightMeasureType $netWeightMeasure
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setNetWeightMeasure(\Novadan\Uyumsoft\StructType\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setGrossVolumeMeasure(\Novadan\Uyumsoft\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \Novadan\Uyumsoft\StructType\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \Novadan\Uyumsoft\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setNetVolumeMeasure(\Novadan\Uyumsoft\StructType\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setTotalGoodsItemQuantity(\Novadan\Uyumsoft\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalTransportHandlingUnitQuantity value
     * @return \Novadan\Uyumsoft\StructType\TotalTransportHandlingUnitQuantityType|null
     */
    public function getTotalTransportHandlingUnitQuantity()
    {
        return $this->TotalTransportHandlingUnitQuantity;
    }
    /**
     * Set TotalTransportHandlingUnitQuantity value
     * @param \Novadan\Uyumsoft\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setTotalTransportHandlingUnitQuantity(\Novadan\Uyumsoft\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null)
    {
        $this->TotalTransportHandlingUnitQuantity = $totalTransportHandlingUnitQuantity;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \Novadan\Uyumsoft\StructType\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \Novadan\Uyumsoft\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setInsuranceValueAmount(\Novadan\Uyumsoft\StructType\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setDeclaredCustomsValueAmount(\Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setDeclaredForCarriageValueAmount(\Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setDeclaredStatisticsValueAmount(\Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setFreeOnBoardValueAmount(\Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * @return \Novadan\Uyumsoft\StructType\SpecialInstructionsType[]|null
     */
    public function getSpecialInstructions()
    {
        return $this->SpecialInstructions;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeSpecialInstructionsItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeSpecialInstructionsItem instanceof \Novadan\Uyumsoft\StructType\SpecialInstructionsType) {
                $invalidValues[] = is_object($shipmentTypeSpecialInstructionsItem) ? get_class($shipmentTypeSpecialInstructionsItem) : sprintf('%s(%s)', gettype($shipmentTypeSpecialInstructionsItem), var_export($shipmentTypeSpecialInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialInstructions property can only contain items of type \Novadan\Uyumsoft\StructType\SpecialInstructionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SpecialInstructionsType[] $specialInstructions
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setSpecialInstructions(array $specialInstructions = array())
    {
        // validation for constraint: array
        if ('' !== ($specialInstructionsArrayErrorMessage = self::validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions($specialInstructions))) {
            throw new \InvalidArgumentException($specialInstructionsArrayErrorMessage, __LINE__);
        }
        $this->SpecialInstructions = $specialInstructions;
        return $this;
    }
    /**
     * Add item to SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SpecialInstructionsType $item
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function addToSpecialInstructions(\Novadan\Uyumsoft\StructType\SpecialInstructionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\SpecialInstructionsType) {
            throw new \InvalidArgumentException(sprintf('The SpecialInstructions property can only contain items of type \Novadan\Uyumsoft\StructType\SpecialInstructionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialInstructions[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeGoodsItemItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeGoodsItemItem instanceof \Novadan\Uyumsoft\StructType\GoodsItemType) {
                $invalidValues[] = is_object($shipmentTypeGoodsItemItem) ? get_class($shipmentTypeGoodsItemItem) : sprintf('%s(%s)', gettype($shipmentTypeGoodsItemItem), var_export($shipmentTypeGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \Novadan\Uyumsoft\StructType\GoodsItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\GoodsItemType[] $goodsItem
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new \InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\GoodsItemType $item
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function addToGoodsItem(\Novadan\Uyumsoft\StructType\GoodsItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\GoodsItemType) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \Novadan\Uyumsoft\StructType\GoodsItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get ShipmentStage value
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType[]|null
     */
    public function getShipmentStage()
    {
        return $this->ShipmentStage;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentStage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentStage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentStageForArrayConstraintsFromSetShipmentStage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentStageItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentStageItem instanceof \Novadan\Uyumsoft\StructType\ShipmentStageType) {
                $invalidValues[] = is_object($shipmentTypeShipmentStageItem) ? get_class($shipmentTypeShipmentStageItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentStageItem), var_export($shipmentTypeShipmentStageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentStage property can only contain items of type \Novadan\Uyumsoft\StructType\ShipmentStageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentStage value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ShipmentStageType[] $shipmentStage
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setShipmentStage(array $shipmentStage = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentStageArrayErrorMessage = self::validateShipmentStageForArrayConstraintsFromSetShipmentStage($shipmentStage))) {
            throw new \InvalidArgumentException($shipmentStageArrayErrorMessage, __LINE__);
        }
        $this->ShipmentStage = $shipmentStage;
        return $this;
    }
    /**
     * Add item to ShipmentStage value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ShipmentStageType $item
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function addToShipmentStage(\Novadan\Uyumsoft\StructType\ShipmentStageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\ShipmentStageType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentStage property can only contain items of type \Novadan\Uyumsoft\StructType\ShipmentStageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentStage[] = $item;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Novadan\Uyumsoft\StructType\DeliveryType|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \Novadan\Uyumsoft\StructType\DeliveryType $delivery
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setDelivery(\Novadan\Uyumsoft\StructType\DeliveryType $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get TransportHandlingUnit value
     * @return \Novadan\Uyumsoft\StructType\TransportHandlingUnitType[]|null
     */
    public function getTransportHandlingUnit()
    {
        return $this->TransportHandlingUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportHandlingUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportHandlingUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportHandlingUnitForArrayConstraintsFromSetTransportHandlingUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeTransportHandlingUnitItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeTransportHandlingUnitItem instanceof \Novadan\Uyumsoft\StructType\TransportHandlingUnitType) {
                $invalidValues[] = is_object($shipmentTypeTransportHandlingUnitItem) ? get_class($shipmentTypeTransportHandlingUnitItem) : sprintf('%s(%s)', gettype($shipmentTypeTransportHandlingUnitItem), var_export($shipmentTypeTransportHandlingUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportHandlingUnit property can only contain items of type \Novadan\Uyumsoft\StructType\TransportHandlingUnitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportHandlingUnit value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TransportHandlingUnitType[] $transportHandlingUnit
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setTransportHandlingUnit(array $transportHandlingUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($transportHandlingUnitArrayErrorMessage = self::validateTransportHandlingUnitForArrayConstraintsFromSetTransportHandlingUnit($transportHandlingUnit))) {
            throw new \InvalidArgumentException($transportHandlingUnitArrayErrorMessage, __LINE__);
        }
        $this->TransportHandlingUnit = $transportHandlingUnit;
        return $this;
    }
    /**
     * Add item to TransportHandlingUnit value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TransportHandlingUnitType $item
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function addToTransportHandlingUnit(\Novadan\Uyumsoft\StructType\TransportHandlingUnitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\TransportHandlingUnitType) {
            throw new \InvalidArgumentException(sprintf('The TransportHandlingUnit property can only contain items of type \Novadan\Uyumsoft\StructType\TransportHandlingUnitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportHandlingUnit[] = $item;
        return $this;
    }
    /**
     * Get ReturnAddress value
     * @return \Novadan\Uyumsoft\StructType\AddressType|null
     */
    public function getReturnAddress()
    {
        return $this->ReturnAddress;
    }
    /**
     * Set ReturnAddress value
     * @param \Novadan\Uyumsoft\StructType\AddressType $returnAddress
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setReturnAddress(\Novadan\Uyumsoft\StructType\AddressType $returnAddress = null)
    {
        $this->ReturnAddress = $returnAddress;
        return $this;
    }
    /**
     * Get FirstArrivalPortLocation value
     * @return \Novadan\Uyumsoft\StructType\LocationType|null
     */
    public function getFirstArrivalPortLocation()
    {
        return $this->FirstArrivalPortLocation;
    }
    /**
     * Set FirstArrivalPortLocation value
     * @param \Novadan\Uyumsoft\StructType\LocationType $firstArrivalPortLocation
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setFirstArrivalPortLocation(\Novadan\Uyumsoft\StructType\LocationType $firstArrivalPortLocation = null)
    {
        $this->FirstArrivalPortLocation = $firstArrivalPortLocation;
        return $this;
    }
    /**
     * Get LastExitPortLocation value
     * @return \Novadan\Uyumsoft\StructType\LocationType|null
     */
    public function getLastExitPortLocation()
    {
        return $this->LastExitPortLocation;
    }
    /**
     * Set LastExitPortLocation value
     * @param \Novadan\Uyumsoft\StructType\LocationType $lastExitPortLocation
     * @return \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public function setLastExitPortLocation(\Novadan\Uyumsoft\StructType\LocationType $lastExitPortLocation = null)
    {
        $this->LastExitPortLocation = $lastExitPortLocation;
        return $this;
    }
}
