<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentStageType StructType
 * @subpackage Structs
 */
class ShipmentStageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q192:ID
     * @var \Novadan\Uyumsoft\StructType\IDType
     */
    public $ID;
    /**
     * The TransportModeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q193:TransportModeCode
     * @var \Novadan\Uyumsoft\StructType\TransportModeCodeType
     */
    public $TransportModeCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q194:TransportMeansTypeCode
     * @var \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TransitDirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q195:TransitDirectionCode
     * @var \Novadan\Uyumsoft\StructType\TransitDirectionCodeType
     */
    public $TransitDirectionCode;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q196:Instructions
     * @var \Novadan\Uyumsoft\StructType\InstructionsType[]
     */
    public $Instructions;
    /**
     * The TransitPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PeriodType
     */
    public $TransitPeriod;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\TransportMeansType
     */
    public $TransportMeans;
    /**
     * The DriverPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PersonType[]
     */
    public $DriverPerson;
    /**
     * Constructor method for ShipmentStageType
     * @uses ShipmentStageType::setID()
     * @uses ShipmentStageType::setTransportModeCode()
     * @uses ShipmentStageType::setTransportMeansTypeCode()
     * @uses ShipmentStageType::setTransitDirectionCode()
     * @uses ShipmentStageType::setInstructions()
     * @uses ShipmentStageType::setTransitPeriod()
     * @uses ShipmentStageType::setTransportMeans()
     * @uses ShipmentStageType::setDriverPerson()
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @param \Novadan\Uyumsoft\StructType\TransportModeCodeType $transportModeCode
     * @param \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @param \Novadan\Uyumsoft\StructType\TransitDirectionCodeType $transitDirectionCode
     * @param \Novadan\Uyumsoft\StructType\InstructionsType[] $instructions
     * @param \Novadan\Uyumsoft\StructType\PeriodType $transitPeriod
     * @param \Novadan\Uyumsoft\StructType\TransportMeansType $transportMeans
     * @param \Novadan\Uyumsoft\StructType\PersonType[] $driverPerson
     */
    public function __construct(\Novadan\Uyumsoft\StructType\IDType $iD = null, \Novadan\Uyumsoft\StructType\TransportModeCodeType $transportModeCode = null, \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null, \Novadan\Uyumsoft\StructType\TransitDirectionCodeType $transitDirectionCode = null, array $instructions = array(), \Novadan\Uyumsoft\StructType\PeriodType $transitPeriod = null, \Novadan\Uyumsoft\StructType\TransportMeansType $transportMeans = null, array $driverPerson = array())
    {
        $this
            ->setID($iD)
            ->setTransportModeCode($transportModeCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTransitDirectionCode($transitDirectionCode)
            ->setInstructions($instructions)
            ->setTransitPeriod($transitPeriod)
            ->setTransportMeans($transportMeans)
            ->setDriverPerson($driverPerson);
    }
    /**
     * Get ID value
     * @return \Novadan\Uyumsoft\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function setID(\Novadan\Uyumsoft\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportModeCode value
     * @return \Novadan\Uyumsoft\StructType\TransportModeCodeType|null
     */
    public function getTransportModeCode()
    {
        return $this->TransportModeCode;
    }
    /**
     * Set TransportModeCode value
     * @param \Novadan\Uyumsoft\StructType\TransportModeCodeType $transportModeCode
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function setTransportModeCode(\Novadan\Uyumsoft\StructType\TransportModeCodeType $transportModeCode = null)
    {
        $this->TransportModeCode = $transportModeCode;
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * @return \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }
    /**
     * Set TransportMeansTypeCode value
     * @param \Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function setTransportMeansTypeCode(\Novadan\Uyumsoft\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }
    /**
     * Get TransitDirectionCode value
     * @return \Novadan\Uyumsoft\StructType\TransitDirectionCodeType|null
     */
    public function getTransitDirectionCode()
    {
        return $this->TransitDirectionCode;
    }
    /**
     * Set TransitDirectionCode value
     * @param \Novadan\Uyumsoft\StructType\TransitDirectionCodeType $transitDirectionCode
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function setTransitDirectionCode(\Novadan\Uyumsoft\StructType\TransitDirectionCodeType $transitDirectionCode = null)
    {
        $this->TransitDirectionCode = $transitDirectionCode;
        return $this;
    }
    /**
     * Get Instructions value
     * @return \Novadan\Uyumsoft\StructType\InstructionsType[]|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }
    /**
     * This method is responsible for validating the values passed to the setInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionsForArrayConstraintsFromSetInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentStageTypeInstructionsItem) {
            // validation for constraint: itemType
            if (!$shipmentStageTypeInstructionsItem instanceof \Novadan\Uyumsoft\StructType\InstructionsType) {
                $invalidValues[] = is_object($shipmentStageTypeInstructionsItem) ? get_class($shipmentStageTypeInstructionsItem) : sprintf('%s(%s)', gettype($shipmentStageTypeInstructionsItem), var_export($shipmentStageTypeInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Instructions property can only contain items of type \Novadan\Uyumsoft\StructType\InstructionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Instructions value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\InstructionsType[] $instructions
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function setInstructions(array $instructions = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionsArrayErrorMessage = self::validateInstructionsForArrayConstraintsFromSetInstructions($instructions))) {
            throw new \InvalidArgumentException($instructionsArrayErrorMessage, __LINE__);
        }
        $this->Instructions = $instructions;
        return $this;
    }
    /**
     * Add item to Instructions value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\InstructionsType $item
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function addToInstructions(\Novadan\Uyumsoft\StructType\InstructionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\InstructionsType) {
            throw new \InvalidArgumentException(sprintf('The Instructions property can only contain items of type \Novadan\Uyumsoft\StructType\InstructionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Instructions[] = $item;
        return $this;
    }
    /**
     * Get TransitPeriod value
     * @return \Novadan\Uyumsoft\StructType\PeriodType|null
     */
    public function getTransitPeriod()
    {
        return $this->TransitPeriod;
    }
    /**
     * Set TransitPeriod value
     * @param \Novadan\Uyumsoft\StructType\PeriodType $transitPeriod
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function setTransitPeriod(\Novadan\Uyumsoft\StructType\PeriodType $transitPeriod = null)
    {
        $this->TransitPeriod = $transitPeriod;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \Novadan\Uyumsoft\StructType\TransportMeansType|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * Set TransportMeans value
     * @param \Novadan\Uyumsoft\StructType\TransportMeansType $transportMeans
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function setTransportMeans(\Novadan\Uyumsoft\StructType\TransportMeansType $transportMeans = null)
    {
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Get DriverPerson value
     * @return \Novadan\Uyumsoft\StructType\PersonType[]|null
     */
    public function getDriverPerson()
    {
        return $this->DriverPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setDriverPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDriverPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDriverPersonForArrayConstraintsFromSetDriverPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentStageTypeDriverPersonItem) {
            // validation for constraint: itemType
            if (!$shipmentStageTypeDriverPersonItem instanceof \Novadan\Uyumsoft\StructType\PersonType) {
                $invalidValues[] = is_object($shipmentStageTypeDriverPersonItem) ? get_class($shipmentStageTypeDriverPersonItem) : sprintf('%s(%s)', gettype($shipmentStageTypeDriverPersonItem), var_export($shipmentStageTypeDriverPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DriverPerson property can only contain items of type \Novadan\Uyumsoft\StructType\PersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DriverPerson value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PersonType[] $driverPerson
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function setDriverPerson(array $driverPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($driverPersonArrayErrorMessage = self::validateDriverPersonForArrayConstraintsFromSetDriverPerson($driverPerson))) {
            throw new \InvalidArgumentException($driverPersonArrayErrorMessage, __LINE__);
        }
        $this->DriverPerson = $driverPerson;
        return $this;
    }
    /**
     * Add item to DriverPerson value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PersonType $item
     * @return \Novadan\Uyumsoft\StructType\ShipmentStageType
     */
    public function addToDriverPerson(\Novadan\Uyumsoft\StructType\PersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\PersonType) {
            throw new \InvalidArgumentException(sprintf('The DriverPerson property can only contain items of type \Novadan\Uyumsoft\StructType\PersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DriverPerson[] = $item;
        return $this;
    }
}
