<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * @subpackage Structs
 */
class Response extends AbstractStructBase
{
    /**
     * The IsSucceded
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsSucceded;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * Constructor method for Response
     * @uses Response::setIsSucceded()
     * @uses Response::setMessage()
     * @param bool $isSucceded
     * @param string $message
     */
    public function __construct($isSucceded = null, $message = null)
    {
        $this
            ->setIsSucceded($isSucceded)
            ->setMessage($message);
    }
    /**
     * Get IsSucceded value
     * @return bool
     */
    public function getIsSucceded()
    {
        return $this->IsSucceded;
    }
    /**
     * Set IsSucceded value
     * @param bool $isSucceded
     * @return \Novadan\Uyumsoft\StructType\Response
     */
    public function setIsSucceded($isSucceded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSucceded) && !is_bool($isSucceded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSucceded, true), gettype($isSucceded)), __LINE__);
        }
        $this->IsSucceded = $isSucceded;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Novadan\Uyumsoft\StructType\Response
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
