<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType StructType
 * @subpackage Structs
 */
class PackageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q224:ID
     * @var \Novadan\Uyumsoft\StructType\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q225:Quantity
     * @var \Novadan\Uyumsoft\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The ReturnableMaterialIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q226:ReturnableMaterialIndicator
     * @var \Novadan\Uyumsoft\StructType\ReturnableMaterialIndicatorType
     */
    public $ReturnableMaterialIndicator;
    /**
     * The PackageLevelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q227:PackageLevelCode
     * @var \Novadan\Uyumsoft\StructType\PackageLevelCodeType
     */
    public $PackageLevelCode;
    /**
     * The PackagingTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q228:PackagingTypeCode
     * @var \Novadan\Uyumsoft\StructType\PackagingTypeCodeType
     */
    public $PackagingTypeCode;
    /**
     * The PackingMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q229:PackingMaterial
     * @var \Novadan\Uyumsoft\StructType\PackingMaterialType[]
     */
    public $PackingMaterial;
    /**
     * The ContainedPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PackageType[]
     */
    public $ContainedPackage;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for PackageType
     * @uses PackageType::setID()
     * @uses PackageType::setQuantity()
     * @uses PackageType::setReturnableMaterialIndicator()
     * @uses PackageType::setPackageLevelCode()
     * @uses PackageType::setPackagingTypeCode()
     * @uses PackageType::setPackingMaterial()
     * @uses PackageType::setContainedPackage()
     * @uses PackageType::setGoodsItem()
     * @uses PackageType::setMeasurementDimension()
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @param \Novadan\Uyumsoft\StructType\QuantityType $quantity
     * @param \Novadan\Uyumsoft\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @param \Novadan\Uyumsoft\StructType\PackageLevelCodeType $packageLevelCode
     * @param \Novadan\Uyumsoft\StructType\PackagingTypeCodeType $packagingTypeCode
     * @param \Novadan\Uyumsoft\StructType\PackingMaterialType[] $packingMaterial
     * @param \Novadan\Uyumsoft\StructType\PackageType[] $containedPackage
     * @param \Novadan\Uyumsoft\StructType\GoodsItemType[] $goodsItem
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Novadan\Uyumsoft\StructType\IDType $iD = null, \Novadan\Uyumsoft\StructType\QuantityType $quantity = null, \Novadan\Uyumsoft\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null, \Novadan\Uyumsoft\StructType\PackageLevelCodeType $packageLevelCode = null, \Novadan\Uyumsoft\StructType\PackagingTypeCodeType $packagingTypeCode = null, array $packingMaterial = array(), array $containedPackage = array(), array $goodsItem = array(), array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setReturnableMaterialIndicator($returnableMaterialIndicator)
            ->setPackageLevelCode($packageLevelCode)
            ->setPackagingTypeCode($packagingTypeCode)
            ->setPackingMaterial($packingMaterial)
            ->setContainedPackage($containedPackage)
            ->setGoodsItem($goodsItem)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \Novadan\Uyumsoft\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function setID(\Novadan\Uyumsoft\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Novadan\Uyumsoft\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Novadan\Uyumsoft\StructType\QuantityType $quantity
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function setQuantity(\Novadan\Uyumsoft\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ReturnableMaterialIndicator value
     * @return \Novadan\Uyumsoft\StructType\ReturnableMaterialIndicatorType|null
     */
    public function getReturnableMaterialIndicator()
    {
        return $this->ReturnableMaterialIndicator;
    }
    /**
     * Set ReturnableMaterialIndicator value
     * @param \Novadan\Uyumsoft\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function setReturnableMaterialIndicator(\Novadan\Uyumsoft\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null)
    {
        $this->ReturnableMaterialIndicator = $returnableMaterialIndicator;
        return $this;
    }
    /**
     * Get PackageLevelCode value
     * @return \Novadan\Uyumsoft\StructType\PackageLevelCodeType|null
     */
    public function getPackageLevelCode()
    {
        return $this->PackageLevelCode;
    }
    /**
     * Set PackageLevelCode value
     * @param \Novadan\Uyumsoft\StructType\PackageLevelCodeType $packageLevelCode
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function setPackageLevelCode(\Novadan\Uyumsoft\StructType\PackageLevelCodeType $packageLevelCode = null)
    {
        $this->PackageLevelCode = $packageLevelCode;
        return $this;
    }
    /**
     * Get PackagingTypeCode value
     * @return \Novadan\Uyumsoft\StructType\PackagingTypeCodeType|null
     */
    public function getPackagingTypeCode()
    {
        return $this->PackagingTypeCode;
    }
    /**
     * Set PackagingTypeCode value
     * @param \Novadan\Uyumsoft\StructType\PackagingTypeCodeType $packagingTypeCode
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function setPackagingTypeCode(\Novadan\Uyumsoft\StructType\PackagingTypeCodeType $packagingTypeCode = null)
    {
        $this->PackagingTypeCode = $packagingTypeCode;
        return $this;
    }
    /**
     * Get PackingMaterial value
     * @return \Novadan\Uyumsoft\StructType\PackingMaterialType[]|null
     */
    public function getPackingMaterial()
    {
        return $this->PackingMaterial;
    }
    /**
     * This method is responsible for validating the values passed to the setPackingMaterial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackingMaterial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackingMaterialForArrayConstraintsFromSetPackingMaterial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypePackingMaterialItem) {
            // validation for constraint: itemType
            if (!$packageTypePackingMaterialItem instanceof \Novadan\Uyumsoft\StructType\PackingMaterialType) {
                $invalidValues[] = is_object($packageTypePackingMaterialItem) ? get_class($packageTypePackingMaterialItem) : sprintf('%s(%s)', gettype($packageTypePackingMaterialItem), var_export($packageTypePackingMaterialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackingMaterial property can only contain items of type \Novadan\Uyumsoft\StructType\PackingMaterialType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackingMaterial value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PackingMaterialType[] $packingMaterial
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function setPackingMaterial(array $packingMaterial = array())
    {
        // validation for constraint: array
        if ('' !== ($packingMaterialArrayErrorMessage = self::validatePackingMaterialForArrayConstraintsFromSetPackingMaterial($packingMaterial))) {
            throw new \InvalidArgumentException($packingMaterialArrayErrorMessage, __LINE__);
        }
        $this->PackingMaterial = $packingMaterial;
        return $this;
    }
    /**
     * Add item to PackingMaterial value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PackingMaterialType $item
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function addToPackingMaterial(\Novadan\Uyumsoft\StructType\PackingMaterialType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\PackingMaterialType) {
            throw new \InvalidArgumentException(sprintf('The PackingMaterial property can only contain items of type \Novadan\Uyumsoft\StructType\PackingMaterialType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackingMaterial[] = $item;
        return $this;
    }
    /**
     * Get ContainedPackage value
     * @return \Novadan\Uyumsoft\StructType\PackageType[]|null
     */
    public function getContainedPackage()
    {
        return $this->ContainedPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setContainedPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContainedPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContainedPackageForArrayConstraintsFromSetContainedPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeContainedPackageItem) {
            // validation for constraint: itemType
            if (!$packageTypeContainedPackageItem instanceof \Novadan\Uyumsoft\StructType\PackageType) {
                $invalidValues[] = is_object($packageTypeContainedPackageItem) ? get_class($packageTypeContainedPackageItem) : sprintf('%s(%s)', gettype($packageTypeContainedPackageItem), var_export($packageTypeContainedPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContainedPackage property can only contain items of type \Novadan\Uyumsoft\StructType\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContainedPackage value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PackageType[] $containedPackage
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function setContainedPackage(array $containedPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($containedPackageArrayErrorMessage = self::validateContainedPackageForArrayConstraintsFromSetContainedPackage($containedPackage))) {
            throw new \InvalidArgumentException($containedPackageArrayErrorMessage, __LINE__);
        }
        $this->ContainedPackage = $containedPackage;
        return $this;
    }
    /**
     * Add item to ContainedPackage value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PackageType $item
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function addToContainedPackage(\Novadan\Uyumsoft\StructType\PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\PackageType) {
            throw new \InvalidArgumentException(sprintf('The ContainedPackage property can only contain items of type \Novadan\Uyumsoft\StructType\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContainedPackage[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeGoodsItemItem) {
            // validation for constraint: itemType
            if (!$packageTypeGoodsItemItem instanceof \Novadan\Uyumsoft\StructType\GoodsItemType) {
                $invalidValues[] = is_object($packageTypeGoodsItemItem) ? get_class($packageTypeGoodsItemItem) : sprintf('%s(%s)', gettype($packageTypeGoodsItemItem), var_export($packageTypeGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \Novadan\Uyumsoft\StructType\GoodsItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\GoodsItemType[] $goodsItem
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new \InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\GoodsItemType $item
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function addToGoodsItem(\Novadan\Uyumsoft\StructType\GoodsItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\GoodsItemType) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \Novadan\Uyumsoft\StructType\GoodsItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Novadan\Uyumsoft\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$packageTypeMeasurementDimensionItem instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
                $invalidValues[] = is_object($packageTypeMeasurementDimensionItem) ? get_class($packageTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($packageTypeMeasurementDimensionItem), var_export($packageTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType $item
     * @return \Novadan\Uyumsoft\StructType\PackageType
     */
    public function addToMeasurementDimension(\Novadan\Uyumsoft\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
