<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceStatusWithLogInfo StructType
 * @subpackage Structs
 */
class InvoiceStatusWithLogInfo extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $StatusCode;
    /**
     * The EnvelopeStatusCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $EnvelopeStatusCode;
    /**
     * The LocalDocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalDocumentId;
    /**
     * The Logs
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\InvoiceLogItem[]
     */
    public $Logs;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * Constructor method for InvoiceStatusWithLogInfo
     * @uses InvoiceStatusWithLogInfo::setStatus()
     * @uses InvoiceStatusWithLogInfo::setStatusCode()
     * @uses InvoiceStatusWithLogInfo::setEnvelopeStatusCode()
     * @uses InvoiceStatusWithLogInfo::setLocalDocumentId()
     * @uses InvoiceStatusWithLogInfo::setLogs()
     * @uses InvoiceStatusWithLogInfo::setInvoiceId()
     * @uses InvoiceStatusWithLogInfo::setMessage()
     * @param string $status
     * @param int $statusCode
     * @param int $envelopeStatusCode
     * @param string $localDocumentId
     * @param \Novadan\Uyumsoft\StructType\InvoiceLogItem[] $logs
     * @param string $invoiceId
     * @param string $message
     */
    public function __construct($status = null, $statusCode = null, $envelopeStatusCode = null, $localDocumentId = null, array $logs = array(), $invoiceId = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setEnvelopeStatusCode($envelopeStatusCode)
            ->setLocalDocumentId($localDocumentId)
            ->setLogs($logs)
            ->setInvoiceId($invoiceId)
            ->setMessage($message);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Novadan\Uyumsoft\StructType\InvoiceStatusWithLogInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\InvoiceStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \Novadan\Uyumsoft\StructType\InvoiceStatusWithLogInfo
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get EnvelopeStatusCode value
     * @return int
     */
    public function getEnvelopeStatusCode()
    {
        return $this->EnvelopeStatusCode;
    }
    /**
     * Set EnvelopeStatusCode value
     * @param int $envelopeStatusCode
     * @return \Novadan\Uyumsoft\StructType\InvoiceStatusWithLogInfo
     */
    public function setEnvelopeStatusCode($envelopeStatusCode = null)
    {
        // validation for constraint: int
        if (!is_null($envelopeStatusCode) && !(is_int($envelopeStatusCode) || ctype_digit($envelopeStatusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($envelopeStatusCode, true), gettype($envelopeStatusCode)), __LINE__);
        }
        $this->EnvelopeStatusCode = $envelopeStatusCode;
        return $this;
    }
    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }
    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return \Novadan\Uyumsoft\StructType\InvoiceStatusWithLogInfo
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($localDocumentId) && !is_string($localDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDocumentId, true), gettype($localDocumentId)), __LINE__);
        }
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
    /**
     * Get Logs value
     * @return \Novadan\Uyumsoft\StructType\InvoiceLogItem[]|null
     */
    public function getLogs()
    {
        return $this->Logs;
    }
    /**
     * This method is responsible for validating the values passed to the setLogs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLogs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLogsForArrayConstraintsFromSetLogs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceStatusWithLogInfoLogsItem) {
            // validation for constraint: itemType
            if (!$invoiceStatusWithLogInfoLogsItem instanceof \Novadan\Uyumsoft\StructType\InvoiceLogItem) {
                $invalidValues[] = is_object($invoiceStatusWithLogInfoLogsItem) ? get_class($invoiceStatusWithLogInfoLogsItem) : sprintf('%s(%s)', gettype($invoiceStatusWithLogInfoLogsItem), var_export($invoiceStatusWithLogInfoLogsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Logs property can only contain items of type \Novadan\Uyumsoft\StructType\InvoiceLogItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Logs value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\InvoiceLogItem[] $logs
     * @return \Novadan\Uyumsoft\StructType\InvoiceStatusWithLogInfo
     */
    public function setLogs(array $logs = array())
    {
        // validation for constraint: array
        if ('' !== ($logsArrayErrorMessage = self::validateLogsForArrayConstraintsFromSetLogs($logs))) {
            throw new \InvalidArgumentException($logsArrayErrorMessage, __LINE__);
        }
        $this->Logs = $logs;
        return $this;
    }
    /**
     * Add item to Logs value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\InvoiceLogItem $item
     * @return \Novadan\Uyumsoft\StructType\InvoiceStatusWithLogInfo
     */
    public function addToLogs(\Novadan\Uyumsoft\StructType\InvoiceLogItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\InvoiceLogItem) {
            throw new \InvalidArgumentException(sprintf('The Logs property can only contain items of type \Novadan\Uyumsoft\StructType\InvoiceLogItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Logs[] = $item;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Novadan\Uyumsoft\StructType\InvoiceStatusWithLogInfo
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Novadan\Uyumsoft\StructType\InvoiceStatusWithLogInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
